/*
 * UndoInsert.java
 *
 * Created on January 19, 2010, 1:39 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.undo;

import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.gdesupport.canvas.textarea.GDETextArea;
import org.biolegato.gdesupport.canvas.textarea.UndoableGDETextArea;

/**
 * This object handles undoing text deletion within a GDETextArea
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class UndoDelete implements Undoable {
    
    /**
     * The X-coordinate of the deletion
     */
    private int x;
    /**
     * The Y-coordinate of the deletion
     */
    private int y;
    /**
     * The deleted text
     */
    private String data;
    /**
     * The source of the deletion
     */
    private UndoableGDETextArea source;
    
    /** Creates a new instance of UndoInsert */
    public UndoDelete(final UndoableGDETextArea source, final int x, final int y, final String data) {
	this.x = x;
	this.y = y;
	this.data = data;
	this.source = source;
    }

    /**
     * Undoes a deletion
     *
     * @return an object which can redo the undone operation.
     */
    public Undoable undo() {
	return source.uinsert(x, y, data);
    }
    
}
