/*
 * UndoMulti.java
 *
 * Created on January 19, 2010, 1:32 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.biolegato.gdesupport.canvas.undo;

import java.util.LinkedList;

/**
 * This object contains a linked list of related undoable objects.  This is used to amalgomate
 * undoable objects together to provide undo support for complex operations.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public class UndoMulti implements Undoable {
    /**
     * The list conaining all undoable objects represented by the undo multi
     */
    LinkedList<Undoable> undoList;
    
    /**
     * Creates a new instance of UndoMulti
     */
    public UndoMulti() {
	 undoList = new LinkedList<Undoable>();
    }

    /**
     * Creates a new instance of UndoMulti from a linked list
     *
     * @param list the list to create the UndoMulti from.
     */
    public UndoMulti(LinkedList<Undoable> list) {
	 undoList = list;
    }

    /**
     * Adds an undoable to the undo multi
     *
     * @param object the undoable object to add.
     */
    public void addUndo(Undoable object) {
	if (object != null && ! (object instanceof UndoMulti && ((UndoMulti) object).isEmpty())) {
	    undoList.add(object);
	}
    }
    
    /**
     * Undoes a multitude of undoable objects
     *
     * @return an object which can redo the undone operation.
     */
    public Undoable undo() {
	LinkedList<Undoable> redoList = new LinkedList<Undoable>();
	
	for (Undoable object : undoList) {
	    redoList.add(object.undo());
	}
	return new UndoMulti(redoList);
    }

    /**
     * Checks if the undo multi contains any undoable objects
     *
     * @return true if the undo multi list contains any undoable objects
     */
    public boolean isEmpty() {
	return undoList.isEmpty();
    }
    
}
