package org.biolegato.ezmenu.variables;

/*
 * BLVariable.java
 *
 * Created on June 12, 2008, 3:26 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
import javax.swing.Box;
import javax.swing.BoxLayout;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.plugintypes.MenuType;
import org.biolegato.core.plugins.PluginLoader;
import org.biolegato.core.plugins.PluginWrapper;

/**
 * A superclass used to abstract variables for creating command windows.
 *
 * @author Graham Alvare
 * @author Brian Fristensky
 */
public abstract class GDEWidgetVariable extends Box implements GDEVariable {

    /**
     * the name of the widget
     */
    private String name;

    /**
     * Creates a new instance of GDEVariable (used to add the name to the variable).
     *
     * @param data the data to construct the variable with
     */
    public GDEWidgetVariable (java.util.Map data) {
	super(BoxLayout.LINE_AXIS);
	
        if (data.containsKey("name")) {
            name = data.get("name").toString().trim();
        } else {
            BLMain.error("Field is missing a variable name", "BLVariable constructor");
            name = "";
        }
    }

    /**
     * Returns the name of the variable.
     *
     * @return the name of the variable
     */
    public String getName () {
        return name;
    }

    /**
     * Returns the value of the variable.
     *
     * @return the value of the variable
     */
    public abstract Object getValue ();

    /**
     * Returns the name of this type of variable.
     *
     * @return the name of the variable type
     */
    public static String getType () {
        return "none";
    }

}
