//=====================================================================
// File:    AnalysisMgr.java
// Class:   AnalysisMgr
// Package: AFLPcore
//
// Author:  James J. Benham
// Date:    August 6, 1998
// Contact: james_benham@hmc.edu
// 
// Genographer v1.0 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPcore;

/**
 * This class contains a list of <code>AnalysisOp</code>s which can be used
 * to read in different files. Each filter is associated with a 
 * <code>String</code>, which represents its name. These features are 
 * inherited from the <code>Manager</code> class.
 *
 * <p>The filters can be retrieved based on their name, and a lists of
 * names can be obtained from the AnalysisMgr. The AnalysisOp will contain
 * addtional information about the what it does and what options are available.
 *
 * @see AnalysisOp
 * @see Manager
 *
 * @author James J. Benham
 * @version 1.0.0
 * @date August 6, 1998
 */

public class AnalysisMgr extends Manager
{
  /**
   * Creates a new AnalysisMgr, with a default capacity of 4 and a 
   * loadFactor of 1.0. Sets up the Hashtable for the String/AnalysisOp
   * pairs.
   */
  public AnalysisMgr()
  {
    super();
  }

  /**
   * Creates a new AnalysisMgr with the specified values.
   *
   * @param capacity  the initial number of filters that can be stored.
   * @param loadFactor controls memory efficiency vs. lookup speed, it
   *  must be between 0.0 and 1.0, where 1.0 has the greatest memory efficiency
   *
   * @exception IllegalArgumentException when <code>capacitly</code> is less
   *    than zero or the <code>loadFactor</code> is out of bounds.
   */
  public AnalysisMgr(int capacity, float loadFactor)
       throws IllegalArgumentException
  {
    super(capacity, loadFactor);
  }

  /**
   * Checks to see if the specified operation is an <code>AnalysisOp</code>.
   * 
   * @return <code>true</code> if it is, <code>false</code> if 
   *      it is not.
   *
   * @see AnalysisOp
   */
  public boolean classTypeOk(Operation op)
  {
    return(op instanceof AnalysisOp);
  }

}
