//=====================================================================
// File:    RawView.java
// Class:   RawView
// Package: AFLPcore
//
// Author:  James J. Benham
// Date:    January 4, 1999
// Contact: james_benham@hmc.edu
//
// Genographer v1.0 - Computer assisted scoring of gels.
// Copyright (C) 1998  Montana State University
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; version 2
// of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The GNU General Public License is distributed in the file GPL
//=====================================================================

package AFLPcore;

/**
 * This class resets the display so that the original data is used instead
 * of normalized data. It is done by simply switching the trace used by
 * all of the lanes.
 *
 * @author James J. Benham
 * @version 1.0.0
 * @date January 4, 1999
 */

public class RawView extends GelOperation
{
  /**
   * Creates a new RawView object.
   */
  public RawView()
  {
    name = "Show Un-normalized Data";
    descript = "Shows the data before any normalizing was performed.";
    helpFile = "rawview.html"; 
  }

  /**
   * This normalizes all of the lanes in the Gel based on the signal
   * stength of each lane.
   *
   * @param gel  the gel to normalize.
   */
  public void doGelOp(Gel gel)
    {
      DataList lanes = gel.getLanes();
      
      for(int i=1; i < lanes.size(); i++)
	((Lane) lanes.dataAt(i)).useTrace(Lane.ORIGINAL);
    }

  /**
   * No options for this operation, so <code>null</code> is returned.
   *
   * @return <code>null</code>
   */
  public Option[] getOptions()
  {
    return null;
  }

  /**
   * Since there are no options for this operation, this method will
   * do absolutely nothing.
   */
  public void setOptions(Option[] opts)
  {
    // nothing to set.
  }

  /**
   * Gives the name of this gel operation
   *
   * @return the name.
   */
  public String getName()
  {
    return name;
  }

  /**
   * Gives a one sentence description of this gel operation.
   *
   * @return the description
   */
  public String getDescription()
  {
    return descript;
  }

  /**
   * Gives a file that is the help file for this gel operation
   *
   * @return a plaintext of html file containing help information
   */
  public String getHelpFile()
  {
    return helpFile;
  }
}
