.TH MRTRANS 1 local
.SH NAME
.B mrtrans
\- produce align cDNA sequences from aligned protein sequences

.SH SYNOPSIS
.B mrtrans
protein-sequence-library cDNA-sequence-library > aligned-cDNA-sequences

.SH DESCRIPTION
.B mrtrans
is a simple program that allows you to produce aligned cDNA sequences from
aligned protein sequences.  This can be very useful for phylogeny programs,
e.g. in PHYLIP \- dnadist, dnapars, dnaml, etc.  In general, it is
better to use protein sequences for multiple alignments, but to use
DNA sequences for phylogeny.  This can be time consuming when there
are gaps in the aligned protein sequences.
.PP
.B mrtrans
takes a protein sequence library and a DNA sequence library.  It reads
the first protein sequence and the first DNA sequence, translates the
DNA sequence in each of the three frames, compares the protein
sequence to the translated DNA sequence to find the protein coding
region, and then writes out the DNA sequence that encoded the protein.
Both libraries should be in Pearson/FASTA format. The sequences must
be in the same order in both libraries.  The protein library may
include '-' characters to specify alignments.  Each '-' character in
the protein library is ignored during the sequence comparison but
replaced by '---' in the DNA sequence output.
.PP
.B
mrtrans
finds the coding regions for contiguous sequences only.  It will not
splice together different exons to produce a coding sequence.
.SH AUTHOR
Bill Pearson
.br
wrp@virginia.EDU
