#!/bin/sh

# Top directory for your lab database
ACEDB=$BIRCH/public_html/birchdb
export ACEDB
#ACEDB_COMMON=$ACEDB
export ACEDB_COMMON

# Directory to contain the binary database file
DBDIR=$ACEDB/database
export DBDIR

# Directory for executable code specific for your database
# eg. this script
BINDIR=$ACEDB/bin
export BINDIR

# Run xace, and call cleanup.csh to make sure all files
# have correct group membership and permissions.
#path="$BINDIR $BIRCH/acedb/bin $PATH"
path="$BINDIR:$PATH"

ACE_FILE_LAUNCHER=$BINDIR/chooseviewer
export ACE_FILE_LAUNCHER

# Use this for a more diverse server cluster
# Platform-specific setup commands
BIRCHLIBS=""
export BIRCHLIBS
case $BIRCH_PLATFORM in
  "solaris-sparc")
    BIRCHLIBS=/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-sparc:$BIRCH/local/lib-solaris-sparc
    ;; 
  "solaris-amd64")
    BIRCHLIBS=/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-amd64:$BIRCH/local/lib-solaris-amd64
    ;;   
  "linux-intel")
    BIRCHLIBS=$BIRCH/lib-linux-intel:$BIRCH/lib-linux-intel/openwin/lib:$BIRCH/local/lib-linux-intel
    ;;
  "linux-x86_64")
    BIRCHLIBS=$BIRCH/lib-linux-x86_64:$BIRCH/lib-linux-x86_64/openwin/lib:$BIRCH/local/lib-linux-x86_64
    ;;
  "osx-x86_64")
    BIRCHLIBS=$BIRCH/lib-osx-x86_64:$BIRCH/local/lib-osx-x86_64
    ;;
#  "AIX")
#    ;;
#  "HP")
#    ;;
  *)
    ;;
esac
export BIRCHLIBS
echo checkpoint 1

echo BIRCHLIBS $BIRCHLIBS
if [ ! -z  ${BIRCHLIBS} ]
   then
   echo checkpoint 4
   if [ "$LD_LIBRARY_PATH" != "" ]
      then
      echo checkpoint5
      LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$BIRCHLIBS
   else
      echo checkpoint 6
      LD_LIBRARY_PATH=$BIRCHLIBS
   fi
   export LD_LIBRARY_PATH   
fi

echo checkpoint 2
if [ $BIRCH_PLATFORM = "osx-x86_64" ]
   then
   DYLD_LIBRARY_PATH=$LD_LIBRARY_PATH
   export DYLD_LIBRARY_PATH
   echo DYLD_LIBRARY_PATH $DYLD_LIBRARY_PATH
fi


#echo LD_LIBRARY_PATH $LD_LIBRARY_PATH

(xace; $BINDIR/cleanup.sh)&
