#!/bin/csh
# Write out the contents of a file, starting at line $1
# This command replaces 'tail +number', which is no longer
# supported in Linux

set STARTINGLINE = $1
set INFILE = $2
set OUTFILE = $3
@ NUMLINES = (`wc -l $INFILE | sed -e "s/^[ ]*//" | cut -f1 -d" "`)
@ TAILLINES = ( $NUMLINES - ($STARTINGLINE - 1) )
tail -$TAILLINES < $INFILE > $OUTFILE

