#!/bin/csh

#Version   1/ 6/2005
# Run dnapars as a command
#Synopsis: dnapars.csh infile soption method bseed replicates percent blocksize
#            jumble jseed numjum outgroup parstype threshold transversion termout printdata outfile treefile

#Convert arguments to variables
set INFILE        = $1
set SOPTION       = $2
set METHOD        = $3
set BSEED         = $4
set REPLICATES    = $5
set PERCENT       = $6
set BLOCKSIZE     = $7
set JUMBLE        = $8
set JSEED         = $9
set NUMJUM        = $10
set OUTGROUP      = $11
set PARSTYPE      = $12
set THRESHOLD     = $13
set TRANSVERSION  = $14
set TERMOUT       = $15
set PRINTDATA     = $16
set OUTFILE       = $17
set TREEFILE      = $18


# Percent of characters to sample
if ( ( $PERCENT < 5 ) || ( $PERCENT > 100 ) ) set PERCENT = 100

# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif


# Make a temporary directory to run the program in 
set TEMPDIR = DNAPARS.$$
mkdir $TEMPDIR
cp $INFILE $TEMPDIR/infile.temp
cd $TEMPDIR

#----------------- generate keyboard input to send to program -----

echo 'DNAPARS' > MSGFILE
echo ' ' >> MSGFILE

# Search option
switch ($SOPTION)
  case "m" :
    echo 'Search option: THOROUGH' >> MSGFILE
    breaksw
  case "l" :
    echo 'Search option: LESS THOROUGH ' >> MSGFILE
    echo s >> PARAMFILE
    echo n >> PARAMFILE
    breaksw
  case "r" :
    echo 'Search option: REARRANGE ON JUST ONE BEST TREE' >> MSGFILE
    echo s >> PARAMFILE
    echo y >> PARAMFILE  
    breaksw
endsw

# Random seeds, odd, of the form 4n + 1
@ tempbseed = ( ( ( $BSEED / 4 ) * 4 ) + 1 )
@ tempjseed = ( ( ( $JSEED / 4 ) * 4 ) + 1 )

# Choose resampling method
switch ($METHOD)
  case "n":
    echo " " >> MSGFILE
    cp infile.temp infile
    breaksw
  case "b":
    echo RESAMPLING\: Bootstrap,  $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    if ( $BLOCKSIZE > 1 ) echo 'Resampling in blocks of ' $BLOCKSIZE >> MSGFILE
    if ( $PERCENT < 100 ) echo 'Partial Resampling: ' $PERCENT  'percent of sites sampled' >> MSGFILE
    cp infile.temp infile
    seqboot.csh infile.temp s $tempbseed b $REPLICATES $PERCENT $BLOCKSIZE yes 0 weights
    echo m >> PARAMFILE
    echo w >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw
  case "d" :
    echo RESAMPLING\: Delete-half Jacknifing, $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    if ( $PERCENT < 100 ) echo 'Partial Resampling: ' $PERCENT  'percent of sites sampled' >> MSGFILE
    cp infile.temp infile
    seqboot.csh infile.temp s $tempbseed d $REPLICATES $PERCENT $BLOCKSIZE yes 0 weights
    echo m >> PARAMFILE
    echo w >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw
  case "ps":
    echo RESAMPLING\: Permute species for each character, $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    seqboot.csh infile.temp s $tempbseed ps $REPLICATES $PERCENT $BLOCKSIZE no 0 infile
    echo m >> PARAMFILE
    echo d >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw
  case "po":
    echo RESAMPLING\: Permute character order, $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    seqboot.csh infile.temp s $tempbseed po $REPLICATES $PERCENT $BLOCKSIZE no 0 infile
    echo m >> PARAMFILE
    echo d >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw
  case "pw":
    echo RESAMPLING\: Permute within species, $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    seqboot.csh infile.temp s $tempbseed pw $REPLICATES $PERCENT $BLOCKSIZE no 0 infile
    echo m >> PARAMFILE
    echo d >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw        
endsw


# Jumble - When multiple datasets are analyzed, DNAPARS automatically
# jumbles, and prompts for a random number seed for jumbling. Othersise,
# jumbling must be explicitly set.
if ($METHOD == "n") then
   if ($JUMBLE == J) then 
      echo JUMBLING SEQUENCE ORDER $NUMJUM ITERATIONS, SEED\=$tempjseed >> MSGFILE
      echo  j >> PARAMFILE
      echo $tempjseed  >> PARAMFILE
      echo $NUMJUM >> PARAMFILE
   endif
else
   echo JUMBLING SEQUENCE ORDER $NUMJUM ITERATIONS, SEED\=$tempjseed >> MSGFILE
   echo $tempjseed  >> PARAMFILE
   echo $NUMJUM >> PARAMFILE
endif

# Outgroup
set FIRSTLINE = `head -1 infile`
set NUMSEQ = $FIRSTLINE[1]
if ($OUTGROUP > 1 && $OUTGROUP <= $NUMSEQ) then
   echo o >> PARAMFILE
   echo $OUTGROUP >> PARAMFILE
else
   set OUTGROUP = 1
endif

# Threshold or ordinary parsimony
if ($PARSTYPE ==  t) then
   echo 'Using threshold parsimony, THRESHOLD= ' $THRESHOLD >> MSGFILE
   if ($THRESHOLD < 2 ) set THRESHOLD = 2
   echo $PARSTYPE >> PARAMFILE
   echo $THRESHOLD >> PARAMFILE
endif

# Count all steps: a; Count only transversions: t
if ($TRANSVERSION == t) then
   echo n >> PARAMFILE
endif


# Should sequence data be printed?
if ($PRINTDATA ==  y) echo 1 >> PARAMFILE


# When resampling or jumbling, turn off printing trees to outfile
if (($METHOD == 'b') || ($METHOD == 'd') || ($METHOD == 'ps') || ($METHOD == 'po') || ($METHOD == 'pw')) then
   echo 3 >> PARAMFILE
endif

#accept current settings and do the analysis
echo y  >> PARAMFILE


#-------- Run dnapars -----------
echo `time nice +8 dnapars < PARAMFILE > $TERMOUT` > TIMEFILE


echo Execution times on `hostname`\: `cat TIMEFILE` >> outfile


#----------- Return results to calling directory----------------
# When using resampling or jumbling, filter the outtree through
# consense to generate an unrooted consensus tree.
if (($METHOD == 'b') || ($METHOD == 'd') || ($METHOD == 'ps') || ($METHOD == 'po') || ($METHOD == 'pw')) then
	echo " " >> outfile
	echo '-------------------------------------------' >> outfile
	consense.csh outtree e 1 $OUTGROUP n outfile.consense ../$TREEFILE
	cat MSGFILE outfile outfile.consense  > ../$OUTFILE
        echo '' >> ../$OUTFILE
        echo '' >> ../$OUTFILE
        echo '>>>> THIS TREEFILE IS A CONSENSUS TREE' >> ../$OUTFILE
        echo '>>>> TO GENERATE BRANCH LENGTHS' >> ../$OUTFILE
        echo '>>>> USE TREE FILE AS INPUT FOR DNAML OR OTHER PROGRAM' >> ../$OUTFILE
        echo '>>>> USING THE USERTREE OPTION' >> ../$OUTFILE

else
        mv outtree ../$TREEFILE
	cat MSGFILE outfile > ../$OUTFILE
endif


cd ..
$RM_CMD -rf $TEMPDIR

echo 'DNAPARS Completed'







