#!/bin/csh

#Version   8/27/07
# Launch viewers for phylogenetic tree data or send output to files
# For use by programs that generate tree output eg. GDE, tGDE, mGDE
#
#Synopsis: gde.treeoutput.csh [-e|-d|-f] outtree outfile outname 


#Convert arguments to variables
set WHATTODO       = $1
set OUTTREE        = $2
set OUTFILE        = $3
set OUTNAME        = $4
set JOBID          = $$


# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif

# Special code for text editors used by GDE and scripts called by GDE
# Nedit crashes in some Linux systems due to libraries set in BIRCHLIBS.
# nedit_wrapper unsets LD_LIBRARY_PATH before calling nedit.
# gedit opens all files in a single window. gedit_wrapper.sh forces
# gedit to open each file in different window.
# choose_edit_wrapper.sh returns the name of the wrapper to use
# for each editor, or just returns GDE_TEXTEDIT if there is no
# wrapper.
setenv GDE_TEXTEDIT `choose_edit_wrapper.sh`
 
switch ($WHATTODO)
   case "-e" # output to tree editor
      ($GDE_TEXTEDIT $OUTFILE; $RM_CMD $OUTFILE)&
      (atv $OUTTREE)&
      ($GDE_TEXTEDIT $OUTTREE)& 
      (python $birch/script/tree2flat.py $OUTTREE $JOBID.flat; tgde $JOBID.flat; $RM_CMD $OUTTREE $JOBID.flat)& 
        if ( -e $OUTTREE.alltrees) then
	(python $birch/script/tree2flat.py $OUTTREE.alltrees $JOBID.alltrees.flat; tgde $JOBID.alltrees.flat; $RM_CMD $JOBID.alltrees.flat)& 	
	($GDE_TEXTEDIT $OUTTREE.alltrees; $RM_CMD $OUTTREE.alltrees)&
        endif
      breaksw
   case "-d" # output to drawing program
      ($GDE_TEXTEDIT $OUTFILE; $RM_CMD $OUTFILE)&
      (drawtree.csh $OUTTREE yes f 0 360 IE 360 reg $DAT/Phylip/font1 0.333 l $JOBID.plotfile; $GDE_PSVIEW $JOBID.plotfile; $RM_CMD $JOBID.plotfile)&
      ($GDE_TEXTEDIT $OUTTREE) &
      (python $birch/script/tree2flat.py $OUTTREE $JOBID.flat; tgde $JOBID.flat; $RM_CMD $OUTTREE $JOBID.flat)& 
        if ( -e $OUTTREE.alltrees) then
	(python $birch/script/tree2flat.py $OUTTREE.alltrees $JOBID.alltrees.flat; tgde $JOBID.alltrees.flat; $RM_CMD $JOBID.alltrees.flat)& 
	($GDE_TEXTEDIT $OUTTREE.alltrees; $RM_CMD $OUTTREE.alltrees)&
        endif
      breaksw
   case "-f" #output to files
      mv $OUTFILE $OUTNAME.outfile
      mv $OUTTREE $OUTNAME.treefile 
        if ( -e $OUTTREE.alltrees) mv $OUTTREE.alltrees $OUTNAME.alltrees.treefile
      breaksw
endsw
