#!/bin/csh

#Version  5/15/2007
# Run distance programs as a command
#Synopsis: genericdist.csh matfile tconmeth power subrep global negbranch outgroup jumble jseed numjum\
#             termout printdata outfile treefile

#Convert arguments to variables
set MATFILE       = $1
set NUMMAT        = $2
set TCONMETH      = $3
set POWER         = $4
set SUBREP        = $5
set GLOBAL        = $6
set NEGBRANCH     = $7
set OUTGROUP      = $8
set JUMBLE        = $9
set JSEED         = $10
set NUMJUM        = $11
set TERMOUT       = $12
set PRINTDATA     = $13
set OUTFILE       = $14
set TREEFILE      = $15

# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif

# On some systems, mv is aliased to mv -i. We need to get around this
# so that the script won't try to prompt the user when overwriting a file.
if ( ! ${?MV_CMD} ) then
   if (-e /usr/bin/mv) then
      set MV_CMD = /usr/bin/mv
   else
      if (-e /bin/mv) then
	 set MV_CMD = /bin/mv
      else
	 set MV_CMD = mv
      endif
   endif
endif


# Make a temporary directory in which to run the program
set TEMPDIR = GENERICDIST.$$
mkdir $TEMPDIR
cp $MATFILE $TEMPDIR/infile
cd $TEMPDIR

#----------------- generate keyboard input to send to GENERICDIST -----

echo "Generic Distance Matrix Phylogeny Methods" > MSGFILE


echo "---------------------  CONSTRUCTING TREE(S) ---------------------" >> MSGFILE
echo "" >> MSGFILE

#----------------- generate keyboard input to send to distance tree program -----

# Choose method for constructing distance matrix
switch ($TCONMETH)
  case "F": # FITCH, Fitch-Margoliash method
    set PROGRAM = fitch
    breaksw
  case "f": # FITCH, Minimum evolution
    set PROGRAM = fitch
    echo d >> TREEPARAMFILE
    breaksw
  case "K": # KITSCH, Fitch-Margoliash method
    set PROGRAM = kitsch
    breaksw
  case "k": # KITSCH, Minimum evolution method
    set PROGRAM = kitsch
    echo d >> TREEPARAMFILE
    breaksw
  case "N": # Neighbor-joining
    set PROGRAM = neighbor
    breaksw
  case "U": # Neighbor-joining
    set PROGRAM = neighbor
    echo n >> TREEPARAMFILE
    breaksw
  default : # FITCH, Fitch-Margoliash method
    set PROGRAM = fitch
    breaksw
endsw


if ($PROGRAM == "weighbor") then
    echo 'Please cite:' >> MSGFILE
    echo 'WEIGHBOR - Weighted Neighbor Joining.'  >> MSGFILE
    echo 'William J. Bruno, Nicholas D. Socci, and Aaron L. Halpern'  >> MSGFILE
    echo 'Weighted Neighbor Joining: A Likelihood-Based Approach to'  >> MSGFILE
    echo 'Distance-Based Phylogeny Reconstruction,'   >> MSGFILE
    echo 'Mol. Biol. Evol. 17 (1): 189-197 (2000).' >> MSGFILE
    echo " " >> MSGFILE
    
    
    #Read length of sequence alignment from $INFILE
    set FIRSTLINE = `cat infile.temp | head -1`
    set SEQLENGTH = $FIRSTLINE[2]
    echo SEQLENGTH = $SEQLENGTH
   


    echo `time nice +8 $PROGRAM -L $SEQLENGTH -b 4 -i infile -o outtree -v > $TERMOUT` > TIMEFILE
    $MV_CMD weighbor.out outfile
    echo Execution times on `hostname`\: `cat TIMEFILE` >> outfile
    
else
    #----------------- Run FITCH, KITCH or NEIGHBOR   -----
    switch ($METHOD)
      case "n":
	breaksw
      case "b":
	echo m >> TREEPARAMFILE
	echo w >> TREEPARAMFILE
	echo $REPLICATES >> TREEPARAMFILE
	breaksw
      case "d" :
	echo m >> TREEPARAMFILE
	echo w >> TREEPARAMFILE
	echo $REPLICATES >> TREEPARAMFILE
	breaksw
      case "ps":
	echo m >> TREEPARAMFILE
	echo d >> TREEPARAMFILE
	echo $REPLICATES >> TREEPARAMFILE
	breaksw
      case "po":
	echo m >> TREEPARAMFILE
	echo d >> TREEPARAMFILE
	echo $REPLICATES >> TREEPARAMFILE
	breaksw
      case "pw":
	echo m >> TREEPARAMFILE
	echo d >> TREEPARAMFILE
	echo $REPLICATES >> TREEPARAMFILE
	breaksw        
    endsw


    # Jumble - When multiple datasets are analyzed, DNAPARS automatically
    # jumbles, and prompts for a random number seed for jumbling. Othersise,
    # jumbling must be explicitly set.

    # Random seed, odd, of the form 4n + 1
    @ tempjseed = ( ( ( $JSEED / 4 ) * 4 ) + 1 )

    if ($METHOD == "n") then
       if ($JUMBLE == J) then 
	  echo JUMBLING SEQUENCE ORDER $NUMJUM ITERATIONS, SEED\=$tempjseed >> MSGFILE
	  echo  j >> TREEPARAMFILE
	  echo $tempjseed  >> TREEPARAMFILE
	  echo $NUMJUM >> TREEPARAMFILE
       endif
    else
       echo JUMBLING SEQUENCE ORDER $NUMJUM ITERATIONS, SEED\=$tempjseed >> MSGFILE
       echo $tempjseed  >> TREEPARAMFILE
       echo $NUMJUM >> TREEPARAMFILE
    endif

    # Subreplicates
    if ($SUBREP == 'n') echo 's' >> TREEPARAMFILE

    # Global rearrangements
    if ($GLOBAL == 'y') echo 'g' >> TREEPARAMFILE

    # Negative branch lengths
    if ($NEGBRANCH == 'y') echo '-' >> TREEPARAMFILE

    # Outgroup
    set FIRSTLINE = `head -1 infile`
    set NUMSEQ = $FIRSTLINE[1]
    if (($OUTGROUP > 1) && ($OUTGROUP <= $NUMSEQ)) then
       echo o >> TREEPARAMFILE
       echo $OUTGROUP >> TREEPARAMFILE
    else
       set OUTGROUP = 1
    endif


    # Should sequence data be printed?
    if ($PRINTDATA ==  y) echo 1 >> TREEPARAMFILE


    #accept current settings and do the analysis
    echo y  >> TREEPARAMFILE


    #----------------- Run FITCH, KITCH or NEIGHBOR   -----

    echo `time nice +8 $PROGRAM < TREEPARAMFILE > $TERMOUT` > TIMEFILE
    echo Execution times on `hostname`\: `cat TIMEFILE` >> outfile

endif

#----------- Return results to calling directory----------------

$MV_CMD outtree ../$TREEFILE
cat MSGFILE outfile > ../$OUTFILE


cd ..
$RM_CMD -rf $TEMPDIR

echo $PROGRAM completed.





