#!/bin/csh
# Wrapper for GDE 

# Use this for a more diverse server cluster
# Platform-specific setup commands
# GDE requires the obsolete xview libraries, which are probably available by default on
# Solaris systems in /usr/openwin, but we put this here just to make sure.
# Linux systems almost never have /usr/openwin, so we need to supply that in lib-linux-intel/openwin/lib.
# We put /usr/dt/lib in in case someone is using CDE, and the other libraries are there just as additional
# fallbacks. For example, if /usr/openwin/lib wasn't on your Solaris system, you could install it in 
# $BIRCH/local/lib-solaris-sparc.
setenv BIRCHLIBS  ""
switch ($BIRCH_PLATFORM)
  case "solaris-sparc":
    setenv BIRCHLIBS "/usr/openwin/lib:/usr/dt/lib:$BIRCH/lib-solaris-sparc:$BIRCH/local/lib-solaris-sparc"
    breaksw 
  case "solaris-amd64":
    setenv BIRCHLIBS "/usr/openwin/lib:/usr/lib:/usr/lib/X11:/usr/dt/lib:$BIRCH/lib-solaris-amd64:$BIRCH/local/lib-solaris-amd64"
    breaksw   
  case "linux-intel":
    setenv BIRCHLIBS $BIRCH/local/lib-linux-intel:$BIRCH/lib-linux-intel:$BIRCH/lib-linux-intel/openwin/lib:$BIRCH/lib-linux-intel/fc4libs
    set GDEFONTS = "$BIRCH/lib-linux-intel/gde.fonts/100dpi"
    set GDEFONTS = $GDEFONTS','$BIRCH/lib-linux-intel/gde.fonts/misc
    set GDEFONTS = $GDEFONTS','$BIRCH/lib-linux-intel/gde.fonts/75dpi
    breaksw
  case "linux-x86_64":
    setenv BIRCHLIBS $BIRCH/local/lib-linux-x86_64:$BIRCH/lib-linux-x86_64:$BIRCH/lib-linux-x86_64/openwin/lib:$BIRCH/lib-linux-x86_64/fc4libs
    set GDEFONTS = "$BIRCH/lib-linux-x86_64/gde.fonts/100dpi"
    set GDEFONTS = $GDEFONTS','$BIRCH/lib-linux-x86_64/gde.fonts/misc
    set GDEFONTS = $GDEFONTS','$BIRCH/lib-linux-x86_64/gde.fonts/75dpi
    breaksw
  case "AIX":
    breaksw
  case "HP":
    breaksw
  default:
    breaksw
endsw

if ${?LD_LIBRARY_PATH} then
   setenv LD_LIBRARY_PATH "$BIRCHLIBS":"$LD_LIBRARY_PATH"
else
   setenv LD_LIBRARY_PATH "$BIRCHLIBS"
endif

# ------------------------ FONTS ------------------------------
# See $BIRCH/local/lib-linux-intel/README.fonts

if ${?GDEFONTS} then
#   echo GDEFONTS "$GDEFONTS"
   
   # FOR TESTING PURPOSES ONLY:
   # Remove all fonts from fontpath, and set ONLY the fonts we think we need
   #xset fp- /home/psgendb/.gnome2/share/cursor-fonts,tcp/localhost:7100,/home/psgendb/.gnome2/share/fonts
   # Set $GDEFONTS to fontpath
   #xset fp= $GDEFONTS

   # Append $GDEFONTS to fontpath. Probably the safest choice.
   xset +fp $GDEFONTS
   # Prepend $GDEFONTS to fontpath
   #xset fp+ $GDEFONTS
   
   # Show current X settings, including fontpath
   #xset -q   
endif


setenv GDE_HELP_DIR  $MGDE_HELP_DIR
gde.bin $argv 
