#!/bin/csh

#Version 11/25/06
# Creates an input file form primer3
#Synopsis: primer.csh infile maxprimers optlen minlen maxlen opttemp mintemp
#  maxtemp mingc maxgc saltconc dnaconc minunk maxself max3pself gcclamp
#  minprod maxprod intoligo iopttemp imintemp
#  imaxtemp imingc imaxgc isaltconc idnaconc iminunk imaxself imax3pself

#Convert arguments to variables
set INFILE     = $1
set MAXPRIMERS = $2
set OPTLEN     = $3
set MINLEN     = $4
set MAXLEN     = $5
set OPTTEMP    = $6
set MINTEMP    = $7
set MAXTEMP    = $8
set MINGC      = $9 
set MAXGC      = $10
set SALTCONC   = $11
set DNACONC    = $12
set MAXUNK     = $13
set MAXSELF    = $14
set MAX3PSELF  = $15
set GCCLAMP    = $16
set MINPROD    = $17
set MAXPROD    = $18
set intoligo   = $19
set ioptlen    = $20
set iminlen    = $21
set imaxlen    = $22
set iopttemp   = $23
set imintemp   = $24
set imaxtemp   = $25
set imingc     = $26
set imaxgc     = $27
set isaltconc  = $28
set idnaconc   = $29
set imaxunk    = $30
set imaxself   = $31
set imax3pself = $32


set PID = $$ #process id

# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif


# Determine the size of seq.
@ NUMLINES = (`wc -l $INFILE | sed -e "s/^[ ]*//" | cut -f1 -d" "`)
@ TAILLINES = ( $NUMLINES - 1 )
tail -$TAILLINES $INFILE > TEMP.$PID
@ SEQLENGTH = (`wc -c < TEMP.$PID` - `wc -l < TEMP.$PID`) - 1

#Write the sequence name
#set NAME = `head -1 $INFILE |tr -d '#'`
echo PRIMER_SEQUENCE_ID=$INFILE

#Write the sequence one one long line
# Incredibly, PRIMER3 can't handle RNA, so we change U's to T's.
#echo SEQUENCE=`tail +2 $INFILE | tr -d "[\n]"`
echo 'SEQUENCE=' >TEMPSEQ.$PID
tail -$TAILLINES $INFILE | tr "U" "T" | tr "u" "t" >> TEMPSEQ.$PID
tr -d "\n" < TEMPSEQ.$PID
#Make sure sequence ends with a \n
echo ""

# Make sure parameters are reasonable
if ($MINPROD > $MAXPROD) set MINPROD = $MAXPROD
if ($MINPROD > $SEQLENGTH) set MINPROD = $SEQLENGTH
if ($MAXPROD < $MINPROD) set MAXPROD = $MINPROD
if ($MAXPROD > $SEQLENGTH) set MAXPROD = $SEQLENGTH

# Write parameters

   # Global parameters
   echo PRIMER_NUM_RETURN=$MAXPRIMERS
   echo PRIMER_OPT_SIZE=$OPTLEN
   echo PRIMER_MIN_SIZE=$MINLEN
   echo PRIMER_MAX_SIZE=$MAXLEN
   echo PRIMER_OPT_TM=$OPTTEMP
   echo PRIMER_MIN_TM=$MINTEMP
   echo PRIMER_MAX_TM=$MAXTEMP
   echo PRIMER_MIN_GC=$MINGC
   echo PRIMER_MAX_GC=$MAXGC
   echo PRIMER_SALT_CONC=$SALTCONC
   echo PRIMER_DNA_CONC=$DNACONC
   echo PRIMER_NUM_NS_ACCEPTED=$MAXUNK
   echo PRIMER_SELF_ANY=$MAXSELF
   echo PRIMER_SELF_END=$MAX3PSELF
   echo PRIMER_GC_CLAMP=$GCCLAMP
   echo PRIMER_DEFAULT_PRODUCT=$MINPROD-$MAXPROD
   echo PRIMER_LIBERAL_BASE=1
   echo PRIMER_FILE_FLAG=1
   echo PRIMER_EXPLAIN_FLAG=1

   # Internal oligo parameters
   if ($intoligo != 0) then
      echo PRIMER_PICK_INTERNAL_OLIGO=$intoligo
      echo PRIMER_INTERNAL_OLIGO_OPT_SIZE=$ioptlen
      echo PRIMER_INTERNAL_OLIGO_MIN_SIZE=$iminlen
      echo PRIMER_INTERNAL_OLIGO_MAX_SIZE=$imaxlen
      echo PRIMER_INTERNAL_OLIGO_OPT_TM=$iopttemp
      echo PRIMER_INTERNAL_OLIGO_MIN_TM=$imintemp
      echo PRIMER_INTERNAL_OLIGO_MAX_TM=$imaxtemp
      echo PRIMER_INTERNAL_OLIGO_MIN_GC=$imingc
      echo PRIMER_INTERNAL_OLIGO_MAX_GC=$imaxgc
      echo PRIMER_INTERNAL_OLIGO_SALT_CONC=$isaltconc
      echo PRIMER_INTERNAL_OLIGO_DNA_CONC=$idnaconc
      echo PRIMER_INTERNAL_OLIGO_NUM_NS_ACCEPTED=$imaxunk
      echo PRIMER_INTERNAL_OLIGO_SELF_ANY=$imaxself
      echo PRIMER_INTERNAL_OLIGO_SELF_END=$imax3pself
   endif

# Terminate record
echo '='

# Delete temporary files
$RM_CMD -f *.$PID $INFILE

