#!/bin/csh

#Version  11/ 1/2009
# Run proml as a command
#Synopsis: proml.csh infile utree_ufn program pmodel speedy global method bseed\
#                  replicates blocksize percent jumble jseed numjum outgroup termout printdata\
#                  outfile treefile

#Convert arguments to variables
set INFILE        = $1
# biolegato: If no file has been chosen for UFN, UFN will be blank.
# Simply substituting $UFN into the command for dnaml.csh would
# therefore result in a missing parameter. Here we concatenate
# UTREE and UFN in the form UTREE_UFN. dnaml.csh has been
# modified to read both parameters from the UTREE variable,
# and UFN is no longer passed as a separate variable.  
set UTREE         = `echo $2 | cut -c1`
set UFN           = `echo $2 | cut -c3-`

set PROGRAM       = $3
set PMODEL        = $4
set SPEEDY        = $5
set GLOBAL        = $6
set METHOD        = $7
set BSEED         = $8
set REPLICATES    = $9
set BLOCKSIZE     = $10
set PERCENT       = $11
set JUMBLE        = $12
set JSEED         = $13
set NUMJUM        = $14
set OUTGROUP      = $15
set TERMOUT       = $16
set PRINTDATA     = $17
set OUTFILE       = $18
set TREEFILE      = $19


# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif


# Make a temporary directory in which to run the program
set TEMPDIR = PROML.$$
mkdir $TEMPDIR
cp $INFILE $TEMPDIR/infile.temp
if ($UTREE == 'y') then
   # Turn off bootstrapping when evaluating a user tree.
   # If bootstrapping is on, an empty file may be generated
   # which could cause drawtree or drawgram to loop infinitely
   set METHOD = n
   
   # Make sure that treefile begins with number of trees on first
   # line of file. If first line in file has parentheses, the
   # number must be added.
   if (`head -1 $UFN | grep '('` != "" ) then
      grep ';' $UFN | wc -l >> $TEMPDIR/intree
   endif
   cat $UFN >> $TEMPDIR/intree
endif

cd $TEMPDIR

#----------------- generate keyboard input to send to program -----

if ($PROGRAM == 'proml') then
    echo PROML > MSGFILE
else if ($PROGRAM == 'promlk') then
        echo PROMLK > MSGFILE
else
     set PROGRAM = proml
     echo PROML > MSGFILE
endif
echo " " >> MSGFILE 


if ($UTREE == 'y') then
   echo 'u' >> PARAMFILE
endif

# Speedier but rougher analysis
if ($SPEEDY == 'n') echo 's' >> PARAMFILE

# Global rearrangements
if ($GLOBAL == 'y') echo 'g' >> PARAMFILE

# Random seeds, odd, of the form 4n + 1
@ tempbseed = ( ( ( $BSEED / 4 ) * 4 ) + 1 )
@ tempjseed = ( ( ( $JSEED / 4 ) * 4 ) + 1 )

# Choose resampling method
switch ($METHOD)
  case "n":
    echo " " >> MSGFILE
    cp infile.temp infile
    breaksw
  case "b":
    echo RESAMPLING\: Bootstrap,  $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    if ( $BLOCKSIZE > 1 ) echo 'Resampling in blocks of ' $BLOCKSIZE >> MSGFILE
    if ( $PERCENT < 100 ) echo 'Partial Resampling: ' $PERCENT  'percent of sites sampled' >> MSGFILE
    cp infile.temp infile
    seqboot.csh infile.temp s $tempbseed b $REPLICATES $PERCENT $BLOCKSIZE yes 0 weights
    echo m >> PARAMFILE
    echo w >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw
  case "d" :
    echo RESAMPLING\: Delete-half Jacknifing, $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    if ( $PERCENT < 100 ) echo 'Partial Resampling: ' $PERCENT  'percent of sites sampled' >> MSGFILE
    cp infile.temp infile
    seqboot.csh infile.temp s $tempbseed d $REPLICATES $PERCENT $BLOCKSIZE yes 0 weights
    echo m >> PARAMFILE
    echo w >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw
  case "ps":
    echo RESAMPLING\: Permute species for each character, $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    seqboot.csh infile.temp s $tempbseed ps $REPLICATES $PERCENT $BLOCKSIZE no 0 infile
    echo m >> PARAMFILE
    echo d >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw
  case "po":
    echo RESAMPLING\: Permute character order, $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    seqboot.csh infile.temp s $tempbseed po $REPLICATES $PERCENT $BLOCKSIZE no 0 infile
    echo m >> PARAMFILE
    echo d >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw
  case "pw":
    echo RESAMPLING\: Permute within species, $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    seqboot.csh infile.temp s $tempbseed pw $REPLICATES $PERCENT $BLOCKSIZE no 0 infile
    echo m >> PARAMFILE
    echo d >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw        
endsw


# Jumble - When multiple datasets are analyzed, DNAPARS automatically
# jumbles, and prompts for a random number seed for jumbling. Othersise,
# jumbling must be explicitly set.
if ($METHOD == "n") then
   if ($JUMBLE == J) then 
      echo JUMBLING SEQUENCE ORDER $NUMJUM ITERATIONS, SEED\=$tempjseed >> MSGFILE
      echo  j >> PARAMFILE
      echo $tempjseed  >> PARAMFILE
      echo $NUMJUM >> PARAMFILE
   endif
else
   echo JUMBLING SEQUENCE ORDER $NUMJUM ITERATIONS, SEED\=$tempjseed >> MSGFILE
   echo $tempjseed  >> PARAMFILE
   echo $NUMJUM >> PARAMFILE
endif
	
# Outgroup
set FIRSTLINE = `head -1 infile`
set NUMSEQ = $FIRSTLINE[1]

if (($OUTGROUP > 1) && ($OUTGROUP <= $NUMSEQ)) then
   echo o >> PARAMFILE
   echo $OUTGROUP >> PARAMFILE
else
   set OUTGROUP = 1
endif

# Genetic code
switch ($PMODEL)
  case "j" :
#    echo 'Using Jones-Taylor-Thornton probability model' >> MSGFILE
    breaksw
  case "h" :
#    echo 'Using Henikoff/Tiller PMG model' >> MSGFILE
    echo p >> PARAMFILE    
    breaksw
  case "d" :
#    echo 'Using Dayoff PAM model' >> MSGFILE
    echo p >> PARAMFILE    
    echo p >> PARAMFILE
    breaksw
  default :
#    echo 'Using Jones-Taylor-Thornton probability model' >> MSGFILE
    breaksw
endsw

# Should sequence data be printed?
if ($PRINTDATA ==  y) echo 1 >> PARAMFILE

# When resampling or jumbling, turn off printing trees to outfile

if (($METHOD == 'b') || ($METHOD == 'd') || ($METHOD == 'ps') || ($METHOD == 'po') || ($METHOD == 'pw')) then
   echo 3 >> PARAMFILE
endif

#accept current settings and do the analysis
echo y  >> PARAMFILE

#-------- Run proml -----------
echo `time nice +8 $PROGRAM < PARAMFILE > $TERMOUT` > TIMEFILE
echo Execution times on `hostname`\: `cat TIMEFILE` >> outfile


#----------- Return results to calling directory----------------
# When using resampling or jumbling, filter the treefile through
# consense to generate an unrooted consensus tree.
if (($METHOD == 'b') || ($METHOD == 'd') || ($METHOD == 'ps') || ($METHOD == 'po') || ($METHOD == 'pw')) then
	echo " " >> outfile
	echo '-------------------------------------------' >> outfile
	consense.csh outtree e 1 $OUTGROUP n outfile.consense ../$TREEFILE
	cat MSGFILE outfile outfile.consense  > ../$OUTFILE
        echo '' >> ../$OUTFILE
        echo '' >> ../$OUTFILE
        echo '>>>> THIS TREEFILE IS A CONSENSUS TREE' >> ../$OUTFILE
        echo '>>>> TO GENERATE BRANCH LENGTHS' >> ../$OUTFILE
        echo '>>>> USE TREE FILE AS INPUT FOR PROML OR OTHER PROGRAM' >> ../$OUTFILE
        echo '>>>> USING THE USERTREE OPTION' >> ../$OUTFILE
else
        mv outtree ../$TREEFILE
	cat MSGFILE outfile > ../$OUTFILE
endif

cd ..
$RM_CMD -rf $TEMPDIR

echo PROML completed.





