#!/bin/csh

#Version   1/ 6/2005
# Run protpars as a command
#Synopsis: protpars.csh infile method bseed replicates percent blocksize
#            jumble jseed numjum outgroup parstype threshold gc termout printdata outfile treefile

#Convert arguments to variables
set INFILE        = $1
set METHOD        = $2
set BSEED         = $3
set REPLICATES    = $4
set PERCENT       = $5
set BLOCKSIZE     = $6
set JUMBLE        = $7
set JSEED         = $8
set NUMJUM        = $9
set OUTGROUP      = $10
set PARSTYPE      = $11
set THRESHOLD     = $12
set GC            = $13
set TERMOUT       = $14
set PRINTDATA     = $15
set OUTFILE       = $16
set TREEFILE      = $17


# Percent of characters to sample
if ( ( $PERCENT < 5 ) || ( $PERCENT > 100 ) ) set PERCENT = 100

# RM_CMD - command to be used for removing files and directories
if (-e /usr/bin/rm) then
   set RM_CMD = /usr/bin/rm
else
   if (-e /bin/rm) then
      set RM_CMD = /bin/rm
   else
      set RM_CMD = rm
   endif
endif


# Make a temporary directory to run the program in 
set TEMPDIR = protpars.$$
mkdir $TEMPDIR
cp $INFILE $TEMPDIR/infile.temp
cd $TEMPDIR

#----------------- generate keyboard input to send to program -----

echo 'PROTPARS' > MSGFILE
echo ' ' >> MSGFILE


# Random seeds, odd, of the form 4n + 1
@ tempbseed = ( ( ( $BSEED / 4 ) * 4 ) + 1 )
@ tempjseed = ( ( ( $JSEED / 4 ) * 4 ) + 1 )

# Choose resampling method
switch ($METHOD)
  case "n":
    echo " " >> MSGFILE
    cp infile.temp infile
    breaksw
  case "b":
    echo RESAMPLING\: Bootstrap,  $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    if ( $BLOCKSIZE > 1 ) echo 'Resampling in blocks of ' $BLOCKSIZE >> MSGFILE
    if ( $PERCENT < 100 ) echo 'Partial Resampling: ' $PERCENT  'percent of sites sampled' >> MSGFILE
    cp infile.temp infile
    seqboot.csh infile.temp s $tempbseed b $REPLICATES $PERCENT $BLOCKSIZE yes 0 weights
    echo m >> PARAMFILE
    echo w >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw
  case "d" :
    echo RESAMPLING\: Delete-half Jacknifing, $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    if ( $PERCENT < 100 ) echo 'Partial Resampling: ' $PERCENT  'percent of sites sampled' >> MSGFILE
    cp infile.temp infile
    seqboot.csh infile.temp s $tempbseed d $REPLICATES $PERCENT $BLOCKSIZE yes 0 weights
    echo m >> PARAMFILE
    echo w >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw
  case "ps":
    echo RESAMPLING\: Permute species for each character, $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    seqboot.csh infile.temp s $tempbseed ps $REPLICATES $PERCENT $BLOCKSIZE no 0 infile
    echo m >> PARAMFILE
    echo d >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw
  case "po":
    echo RESAMPLING\: Permute character order, $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    seqboot.csh infile.temp s $tempbseed po $REPLICATES $PERCENT $BLOCKSIZE no 0 infile
    echo m >> PARAMFILE
    echo d >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw
  case "pw":
    echo RESAMPLING\: Permute within species, $REPLICATES REPLICATES, SEED\=$BSEED >>MSGFILE
    seqboot.csh infile.temp s $tempbseed pw $REPLICATES $PERCENT $BLOCKSIZE no 0 infile
    echo m >> PARAMFILE
    echo d >> PARAMFILE
    echo $REPLICATES >> PARAMFILE
    breaksw        
endsw


# Jumble - When multiple datasets are analyzed, protpars automatically
# jumbles, and prompts for a random number seed for jumbling. Othersise,
# jumbling must be explicitly set.
if ($METHOD == "n") then
   if ($JUMBLE == J) then 
      echo JUMBLING SEQUENCE ORDER $NUMJUM ITERATIONS, SEED\=$tempjseed >> MSGFILE
      echo  j >> PARAMFILE
      echo $tempjseed  >> PARAMFILE
      echo $NUMJUM >> PARAMFILE
   endif
else
   echo JUMBLING SEQUENCE ORDER $NUMJUM ITERATIONS, SEED\=$tempjseed >> MSGFILE
   echo $tempjseed  >> PARAMFILE
   echo $NUMJUM >> PARAMFILE
endif

# Outgroup
set FIRSTLINE = `head -1 infile`
set NUMSEQ = $FIRSTLINE[1]
if ($OUTGROUP > 1 && $OUTGROUP <= $NUMSEQ) then
   echo o >> PARAMFILE
   echo $OUTGROUP >> PARAMFILE
else
   set OUTGROUP = 1
endif

# Threshold or ordinary parsimony
if ($PARSTYPE ==  t) then
   echo 'Using threshold parsimony, THRESHOLD= ' $THRESHOLD >> MSGFILE
   echo $PARSTYPE >> PARAMFILE
   if ($THRESHOLD < 2 ) set THRESHOLD = 2
   echo $THRESHOLD >> PARAMFILE
endif


# Genetic code
switch ($GC)
  case "u" :
    echo 'Using Genetic Code: UNIVERSAL' >> MSGFILE
    breaksw
  case "m" :
    echo 'Using Genetic Code: MITOCHONDRIAL' >> MSGFILE
    echo c >> PARAMFILE    
    echo m >> PARAMFILE
    breaksw
  case "v" :
    echo 'Using Genetic Code: VERTEBRATE MITOCHONDRIAL' >> MSGFILE
    echo c >> PARAMFILE    
    echo v >> PARAMFILE
    breaksw
  case "f" :
    echo 'Using Genetic Code: FLY MITOCHONDRIAL' >> MSGFILE
    echo c >> PARAMFILE    
    echo f >> PARAMFILE
    breaksw
  case "y" :
    echo 'Using Genetic Code: YEAST MITOCHONDRIAL' >> MSGFILE
    echo c >> PARAMFILE    
    echo y >> PARAMFILE
    breaksw
  default :
    echo 'Using Genetic Code: UNIVERSAL' >> MSGFILE  
    breaksw
endsw

# Should sequence data be printed?
if ($PRINTDATA ==  y) echo 1 >> PARAMFILE


# When resampling or jumbling, turn off printing trees to outfile
if (($METHOD == 'b') || ($METHOD == 'd') || ($METHOD == 'ps') || ($METHOD == 'po') || ($METHOD == 'pw')) then
   echo 3 >> PARAMFILE
endif

#accept current settings and do the analysis
echo y  >> PARAMFILE


#-------- Run protpars -----------
echo `time nice +8 protpars < PARAMFILE > $TERMOUT` > TIMEFILE


echo Execution times on `hostname`\: `cat TIMEFILE` >> outfile


#----------- Return results to calling directory----------------
# When using resampling or jumbling, filter the outtree through
# consense to generate an unrooted consensus tree.
if (($METHOD == 'b') || ($METHOD == 'd') || ($METHOD == 'ps') || ($METHOD == 'po') || ($METHOD == 'pw')) then
	echo " " >> outfile
	echo '-------------------------------------------' >> outfile
	consense.csh outtree e 1 $OUTGROUP n outfile.consense ../$TREEFILE
	cat MSGFILE outfile outfile.consense  > ../$OUTFILE
        echo '' >> ../$OUTFILE
        echo '' >> ../$OUTFILE
        echo '>>>> THIS TREEFILE IS A CONSENSUS TREE' >> ../$OUTFILE
        echo '>>>> TO GENERATE BRANCH LENGTHS' >> ../$OUTFILE
        echo '>>>> USE TREE FILE AS INPUT FOR PROTML OR OTHER PROGRAM' >> ../$OUTFILE
        echo '>>>> USING THE USERTREE OPTION' >> ../$OUTFILE

else
        mv outtree ../$TREEFILE
	cat MSGFILE outfile > ../$OUTFILE
endif


cd ..
$RM_CMD -rf $TEMPDIR

echo 'protpars Completed'







