#!/bin/csh

#Version 4/ 9/94
# Set up makelogo parameter file
#Synopsis: makelogop.csh seqfile rotation charwidth barheight barbits stacksperline 
#                        linesperpage shrinking title1

#------ Convert arguments to variables   -------
set SEQFILE       = $1
set ROTATION      = $2
set CHARWIDTH     = $3
set BARHEIGHT     = $4
set BARBITS       = $5
set STACKSPERLINE = $6
set LINESPERPAGE  = $7
set SHRINKING     = $8
set TITLE1        = $9

set PID = $$ #process id

#------ Determine the size of seq. in seqfile ------ 
readseq  -i1 -f8  -o=$SEQFILE.$PID $SEQFILE
tail +2 $SEQFILE.$PID > TEMP.$PID
@ SEQLENGTH = (`wc -c < TEMP.$PID` - `wc -l < TEMP.$PID`) - 1
set FINISH = $SEQLENGTH

# --------- Set parameters  ---------------

#FROM to TO range to make the logo over
echo 1 $FINISH

#sequence coordinate before which to put a bar on the logo
echo 1 

#(xcorner, ycorner) lower left hand corner of the logo (in cm)           
echo 4 26

#rotation: angle to rotate the graph
echo $ROTATION

#charwidth: (real, > 0) the width of the logo characters, in cm
echo $CHARWIDTH

#barheight, barwidth: (real, > 0) height of vertical bar, in cm
echo $BARHEIGHT 0.1

#barbits: (real) height of the vertical bar, in bits; < 0: no I-beam
echo 4

#bars    no barends: if 'b' put bars before and after each line
echo bars

#show    no showingbox: if 's' show a dashed box around each character
echo show

#no outline outline: if 'o' make each character as an outline
echo no outline

#caps    no caps: if 'c', alphabetic characters are converted to caps
echo caps

#stacksperline: number of character stacks per line output
echo $STACKSPERLINE

#linesperpage: number of lines per page output
echo $LINESPERPAGE

#linemove: line separation relative to the barheight
echo 1.5

#numbering: if the first letter is 'n' then each stack is numbered
echo numbers

#shrinking: factor by which to shrink characters inside dashed box
echo $SHRINKING

#strings: the number of user defined strings to follow
echo 1

#coordinates (in cm) and scale of the first stringecho
echo 0 16 1

# 
cat $TITLE1

#------------ Clean up ------------------------
/usr/bin/rm *.$PID
