/*
 * Decompiled with CFR 0.152.
 */
package forester.datastructures;

public class BasketDataStructure {
    private int[] link;
    int[] rank;
    private static final int DEFAULT_RANK = 0;

    public BasketDataStructure(int n) {
        this.link = new int[n];
        this.rank = new int[n];
    }

    public void createBasket(int n, int n2) {
        this.link[n2] = this.link[n] = n2;
        this.rank[n] = 0;
        this.rank[n2] = 0;
    }

    public int findBasket(int n) {
        if (this.link[n] == n) {
            return n;
        }
        this.link[n] = this.findBasket(this.link[n]);
        return this.link[n];
    }

    public void insertIntoBasket(int n, int n2) {
        this.link[n] = n2;
    }

    public void mergeBasket(int n, int n2) {
        this.link[n] = n2;
        if (this.rank[n] == this.rank[n2]) {
            int n3 = n2;
            this.rank[n3] = this.rank[n3] + 1;
        }
    }

    public void moveBasket(int n, int n2) {
        this.link[n2] = this.link[n] = n2;
    }

    public String toString() {
        String string = new String();
        int n = 0;
        while (n < this.link.length) {
            string = String.valueOf(string) + n + ":   ";
            string = String.valueOf(string) + "Link : " + this.link[n] + "    ";
            string = String.valueOf(string) + "Rank : " + this.rank[n] + "\n";
            ++n;
        }
        return string;
    }
}

