/*
 * Decompiled with CFR 0.152.
 */
package forester.tools;

import forester.atv.ATVjframe;
import forester.tools.OE;
import forester.tools.SDIse;
import forester.tree.Node;
import forester.tree.Tree;
import forester.tree.TreeHelper;
import java.io.File;
import java.util.HashMap;

public abstract class SDI {
    private Tree genetree_;
    private Tree speciestree_;
    private int duplications_;
    private int c_;

    public SDI(Tree tree, Tree tree2) throws Exception {
        if (!tree.isRooted()) {
            String string = "SDI: gene tree must be rooted.";
            throw new Exception(string);
        }
        if (!tree2.isRooted()) {
            String string = "SDI: species tree must be rooted.";
            throw new Exception(string);
        }
        this.genetree_ = tree;
        this.speciestree_ = tree2;
        this.duplications_ = 0;
        this.c_ = 0;
    }

    public int computeMappingCost() throws Exception {
        this.speciestree_.levelOrderReID(0);
        this.c_ = 0;
        this.computeMappingCostHelper(this.genetree_.getRoot());
        return this.c_;
    }

    private void computeMappingCostHelper(Node node) {
        if (!node.isExternal()) {
            this.computeMappingCostHelper(node.getChild1());
            this.computeMappingCostHelper(node.getChild2());
            this.c_ = node.getLink() != node.getChild1().getLink() && node.getLink() != node.getChild2().getLink() ? (this.c_ += node.getChild1().getLink().getID() + node.getChild2().getLink().getID() - 2 * node.getLink().getID() - 2) : (node.getLink() != node.getChild1().getLink() && node.getLink() == node.getChild2().getLink() ? (this.c_ += node.getChild1().getLink().getID() - node.getLink().getID() + 1) : (node.getLink() == node.getChild1().getLink() && node.getLink() != node.getChild2().getLink() ? (this.c_ += node.getChild2().getLink().getID() - node.getLink().getID() + 1) : ++this.c_));
        }
    }

    void decreaseDuplications() {
        --this.duplications_;
    }

    private static void errorInCommandLine() {
        System.out.println("\nSDI: Error in command line.\n");
        System.out.println("Usage: \"SDI  [-options] <species tree file name> <gene tree file name> [outfile name]\"");
        System.out.println("\nOptions:");
        System.out.println(" -e to use Eulenstein's algorithm instead of SDIse");
        System.out.println(" -n input trees are in New Hampshire format instead of NHX -- or");
        System.out.println("    the gene tree is in NHX, but species information is");
        System.out.println("    only present in the form of SWISS-PROT sequence names");
        System.out.println("\nSpecies tree file");
        System.out.println(" In NHX format, with species names in species name fields unless -n option");
        System.out.println(" is used.");
        System.out.println("\nGene tree file");
        System.out.println(" In NHX format, with species names in species name fields and sequence names");
        System.out.println(" in sequence name fields unless -n option is used.");
        System.out.println("");
        System.exit(-1);
    }

    public int getDuplications() {
        return this.duplications_;
    }

    public Tree getGeneTree() {
        return this.genetree_;
    }

    public int getMappingCost() {
        return this.c_;
    }

    public Tree getSpeciesTree() {
        return this.speciestree_;
    }

    void increaseDuplications() {
        ++this.duplications_;
    }

    public abstract int infer(boolean var1) throws Exception;

    void linkExtNodesOfG() throws Exception {
        Node node = this.genetree_.getExtNode0();
        Node node2 = this.speciestree_.getExtNode0();
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        while (node2 != null) {
            hashMap.put(node2.getSpecies(), node2);
            node2 = node2.getNextExtNode();
        }
        while (node != null) {
            node2 = (Node)hashMap.get(node.getSpecies());
            if (node2 == null) {
                String string = "SDI: species \"" + node.getSpecies();
                string = String.valueOf(string) + "\" not present in species tree.";
                throw new Exception(string);
            }
            node.setLink(node2);
            node = node.getNextExtNode();
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = true;
        SDI sDI = null;
        Tree tree = null;
        Tree tree2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        File file = null;
        File file2 = null;
        File file3 = new File("sdi_out.nhx");
        int n = 0;
        if (stringArray.length < 2 || stringArray.length > 4) {
            SDI.errorInCommandLine();
        }
        if (stringArray[0].startsWith("-")) {
            if (stringArray.length < 3) {
                SDI.errorInCommandLine();
            }
            if (stringArray[0].toLowerCase().indexOf("e") != -1) {
                bl2 = true;
            }
            if (stringArray[0].toLowerCase().indexOf("n") != -1) {
                bl3 = true;
            }
            file = new File(stringArray[1]);
            file2 = new File(stringArray[2]);
            if (stringArray.length == 4) {
                file3 = new File(stringArray[3]);
            }
        } else {
            file = new File(stringArray[0]);
            file2 = new File(stringArray[1]);
            if (stringArray.length == 3) {
                file3 = new File(stringArray[2]);
            }
        }
        try {
            tree = TreeHelper.readNHtree(file);
        }
        catch (Exception exception) {
            System.err.println("Could not read " + file + ". Terminating.");
            System.exit(-1);
        }
        try {
            tree2 = TreeHelper.readNHtree(file2);
        }
        catch (Exception exception) {
            System.err.println("Could not read " + file2 + ". Terminating.");
            System.exit(-1);
        }
        if (bl3) {
            TreeHelper.extractSpeciesNameFromSeqName(tree);
            TreeHelper.extractSpeciesNameFromSeqName(tree2);
        }
        TreeHelper.cleanSpeciesNamesInExtNodes(tree);
        try {
            if (bl2) {
                sDI = new OE(tree2, tree);
                System.out.println("\nUsing Eulenstein's algorithm.");
            } else {
                sDI = new SDIse(tree2, tree);
            }
        }
        catch (Exception exception) {
            System.err.println("Unexpected error during creation of SDI object: " + exception);
            System.exit(-1);
        }
        try {
            n = sDI.infer(true);
        }
        catch (Exception exception) {
            System.err.println("Unexpected error during calculation of duplications.");
            System.err.println("Stack trace: ");
            exception.printStackTrace();
            System.exit(-1);
        }
        try {
            TreeHelper.writeNHtree(tree2, file3, true, true, true);
        }
        catch (Exception exception) {
            System.err.println("Could not write " + file3 + ". Terminating.");
            System.exit(-1);
        }
        System.out.println("\nNumber of duplications: " + n);
        System.out.flush();
        ATVjframe aTVjframe = new ATVjframe(tree);
        aTVjframe.setTitle("species tree");
        aTVjframe.showWhole();
        ATVjframe aTVjframe2 = new ATVjframe(tree2);
        aTVjframe2.setTitle("gene tree");
        aTVjframe2.showWhole();
    }

    void setDuplicationsToZero() {
        this.duplications_ = 0;
    }

    public static int stripTree(Tree tree, Tree tree2) {
        Node node = tree.getExtNode0();
        Node node2 = tree2.getExtNode0();
        Node node3 = null;
        int n = 0;
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        while (node != null) {
            hashMap.put(node.getSpecies(), node);
            node = node.getNextExtNode();
        }
        while (node2 != null) {
            node3 = node2.getNextExtNode();
            if (!hashMap.containsKey(node2.getSpecies())) {
                tree2.removeExtNode(node2);
                ++n;
                node2 = null;
            }
            node2 = node3;
        }
        return n;
    }
}

