/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.microarray.mev.DetectionFilter;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class SetDetectionFilterDialog
extends AlgorithmDialog {
    private GroupExperimentsPanel gPanel;
    private JButton filter;
    private JButton cancel;
    private JLabel msg1Label;
    private JLabel msg2Label;
    private JLabel msg3Label;
    private JLabel tail1Label;
    private JLabel tail2Label;
    private int result;
    private DetectionFilter df;
    protected boolean use_filter;

    public SetDetectionFilterDialog(JFrame jFrame, String[] stringArray) {
        super(jFrame, "Set Detection Filter", true);
        int n;
        this.setBounds(0, 0, 800, 500);
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.setLayout(new BorderLayout(2, 2));
        Listener listener = new Listener();
        String string = "Group A: Gene must be called (P)resent in:";
        String string2 = "Group B: Gene must be called (P)resent in:";
        String string3 = "Select one of the following: ";
        String string4 = "out of the total in Group A";
        String string5 = "out of the total in Group B";
        String[] stringArray2 = new String[]{"OR", "AND"};
        this.msg1Label = new JLabel(string);
        this.msg2Label = new JLabel(string2);
        this.msg3Label = new JLabel(string3);
        this.tail1Label = new JLabel(string4);
        this.tail2Label = new JLabel(string5);
        JTextField jTextField = new JTextField("1", 2);
        JTextField jTextField2 = new JTextField("1", 2);
        jTextField.addKeyListener(new VoteKeyListener());
        jTextField2.addKeyListener(new VoteKeyListener());
        jTextField.addFocusListener(new VoteFocusListener(0, 1));
        jTextField2.addFocusListener(new VoteFocusListener(1, 1));
        JList<String> jList = new JList<String>(stringArray2);
        jList.setBorder(BorderFactory.createLineBorder(Color.black));
        jList.setBackground(Color.lightGray);
        jList.setVisibleRowCount(2);
        jList.addListSelectionListener(new SelectionListener());
        this.gPanel = new GroupExperimentsPanel(stringArray);
        this.gPanel.setBackground(Color.white);
        this.df = new DetectionFilter(stringArray);
        for (n = 0; n < this.gPanel.groupARadioButtons.length; ++n) {
            this.gPanel.groupARadioButtons[n].addActionListener(new GroupListener(0, n));
        }
        for (n = 0; n < this.gPanel.groupBRadioButtons.length; ++n) {
            this.gPanel.groupBRadioButtons[n].addActionListener(new GroupListener(1, n));
        }
        jPanel.add((Component)this.gPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.white);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(Color.white);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBackground(Color.white);
        jPanel3.setLayout(new FlowLayout(0));
        jPanel4.setLayout(new FlowLayout(0));
        jPanel5.setLayout(new FlowLayout(0));
        jPanel3.add(this.msg1Label);
        jPanel3.add(jTextField);
        jPanel3.add(this.tail1Label);
        jPanel4.add(this.msg3Label);
        jPanel4.add(jList);
        jPanel5.add(this.msg2Label);
        jPanel5.add(jTextField2);
        jPanel5.add(this.tail2Label);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel2.add(jPanel5);
        jPanel.add((Component)jPanel2, "South");
        this.addContent(jPanel);
        this.setActionListeners(listener);
        this.addWindowListener(listener);
        this.pack();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[40];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = "name" + Integer.toString(i);
        }
        SetDetectionFilterDialog setDetectionFilterDialog = new SetDetectionFilterDialog(new JFrame(), stringArray2);
        setDetectionFilterDialog.showModal();
    }

    public SetDetectionFilterDialog(JFrame jFrame, String[] stringArray, DetectionFilter detectionFilter) {
        this(jFrame, stringArray);
        this.df = detectionFilter;
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public DetectionFilter getDetectionFilter() {
        return this.df;
    }

    class GroupExperimentsPanel
    extends JPanel {
        JRadioButton[] groupARadioButtons;
        JRadioButton[] groupBRadioButtons;

        GroupExperimentsPanel(String[] stringArray) {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            JPanel jPanel = new JPanel();
            JLabel[] jLabelArray = new JLabel[stringArray.length];
            this.groupARadioButtons = new JRadioButton[stringArray.length];
            this.groupBRadioButtons = new JRadioButton[stringArray.length];
            ButtonGroup[] buttonGroupArray = new ButtonGroup[stringArray.length];
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout2);
            jPanel.setLayout(gridBagLayout);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                jLabelArray[i] = new JLabel(string);
                buttonGroupArray[i] = new ButtonGroup();
                this.groupARadioButtons[i] = new JRadioButton("Group A", true);
                buttonGroupArray[i].add(this.groupARadioButtons[i]);
                this.groupBRadioButtons[i] = new JRadioButton("Group B", false);
                buttonGroupArray[i].add(this.groupBRadioButtons[i]);
                this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(jLabelArray[i], gridBagConstraints);
                jPanel.add(jLabelArray[i]);
                this.buildConstraints(gridBagConstraints, 1, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.groupARadioButtons[i], gridBagConstraints);
                jPanel.add(this.groupARadioButtons[i]);
                this.buildConstraints(gridBagConstraints, 2, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.groupBRadioButtons[i], gridBagConstraints);
                jPanel.add(this.groupBRadioButtons[i]);
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setPreferredSize(new Dimension(400, 300));
            this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 90);
            gridBagConstraints.fill = 1;
            gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
        }

        void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            gridBagConstraints.weightx = n5;
            gridBagConstraints.weighty = n6;
        }
    }

    class GroupListener
    implements ActionListener {
        int file_index;
        int group;

        GroupListener(int n, int n2) {
            this.group = n;
            this.file_index = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SetDetectionFilterDialog.this.df.get_group_membership(this.file_index) != this.group) {
                SetDetectionFilterDialog.this.df.set_group_membership(this.group, this.file_index);
            }
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                JList jList = (JList)listSelectionEvent.getSource();
                String string = (String)jList.getSelectedValue();
                if (string.equals("AND")) {
                    SetDetectionFilterDialog.this.df.set_both(true);
                } else {
                    SetDetectionFilterDialog.this.df.set_both(false);
                }
            }
        }
    }

    class VoteFocusListener
    extends FocusAdapter {
        private int required;
        private int group_index;

        VoteFocusListener(int n, int n2) {
            this.required = n2;
            this.group_index = n;
        }

        public void focusLost(FocusEvent focusEvent) {
            JTextField jTextField = (JTextField)focusEvent.getSource();
            String string = jTextField.getText();
            SetDetectionFilterDialog.this.df.set_num_required(this.group_index, Integer.parseInt(string));
        }
    }

    class VoteKeyListener
    extends KeyAdapter {
        VoteKeyListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                SetDetectionFilterDialog.this.getToolkit().beep();
                keyEvent.consume();
            }
        }
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener,
    ItemListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                this.onOk();
            } else if (string.equals("cancel-command")) {
                SetDetectionFilterDialog.this.result = 2;
                SetDetectionFilterDialog.this.dispose();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                this.onOk();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SetDetectionFilterDialog.this.result = -1;
            SetDetectionFilterDialog.this.dispose();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            SetDetectionFilterDialog.this.use_filter = itemEvent.getStateChange() == 1;
        }

        private void onOk() {
            try {
                SetDetectionFilterDialog.this.getDetectionFilter();
                SetDetectionFilterDialog.this.result = 0;
            }
            catch (Exception exception) {
                SetDetectionFilterDialog.this.result = 2;
            }
            SetDetectionFilterDialog.this.dispose();
        }
    }
}

