/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.SpotInformationData;
import org.tigr.midas.engine.IterativeLinReg;
import org.tigr.midas.engine.IterativeLogMean;
import org.tigr.midas.engine.RatioStats;
import org.tigr.midas.engine.TotInt;
import org.tigr.midas.util.ColumnWorker;
import org.tigr.util.Xcon;
import org.tigr.util.math.LinearEquation;

public class SlideData
extends Vector
implements ISlideData,
ISlideMetaData,
Serializable {
    public static final long serialVersionUID = 100010201050001L;
    private String slideDataName;
    private String slideFileName;
    private SpotInformationData spotInfoData;
    private int normalizedState = 0;
    private int sortState = 0;
    private int rows;
    private int columns;
    private boolean isNonZero = true;
    private boolean abbrName = false;
    private int dataType = 0;
    private String sampleLabelKey = "Default Slide Name";
    private Hashtable sampleLabels;
    private Vector sampleLabelKeys;

    public SlideData(ISlideData iSlideData) {
        this.rows = iSlideData.getSlideMetaData().getRows();
        this.columns = iSlideData.getSlideMetaData().getColumns();
        this.sortState = iSlideData.getSortState();
        this.normalizedState = iSlideData.getNormalizedState();
        this.slideDataName = iSlideData.getSlideDataName();
        for (int i = 0; i < iSlideData.getSize(); ++i) {
            this.addElement(iSlideData.getSlideDataElement(i).copy());
        }
        this.sampleLabelKey = "Default Slide Name";
        this.sampleLabelKeys = iSlideData.getSlideDataKeys();
        this.sampleLabels = iSlideData.getSlideDataLabels();
    }

    public SlideData(int n, int n2) {
        super(n * n2);
        this.rows = n;
        this.columns = n2;
        this.sampleLabelKey = "Default Slide Name";
        this.sampleLabelKeys = new Vector();
        this.sampleLabels = new Hashtable();
    }

    public SlideData(int n) {
        super(n);
        this.rows = -1;
        this.columns = -1;
        this.sampleLabelKey = "Default Slide Name";
        this.sampleLabelKeys = new Vector();
        this.sampleLabels = new Hashtable();
    }

    public SlideData() {
    }

    public void setDataType(int n) {
        this.dataType = n;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setSpotInformationData(String[] stringArray, String[][] stringArray2) {
        this.spotInfoData = new SpotInformationData(stringArray, stringArray2);
    }

    public void setSpotInformationData(SpotInformationData spotInformationData) {
        this.spotInfoData = spotInformationData;
    }

    public SpotInformationData getSpotInformationData() {
        return this.spotInfoData;
    }

    public ISlideDataElement getSlideDataElement(int n) {
        return (ISlideDataElement)this.elementAt(n);
    }

    public boolean hasNoZeros(int n) {
        ISlideDataElement iSlideDataElement = (ISlideDataElement)this.elementAt(n);
        return iSlideDataElement.hasNoZeros();
    }

    public ISlideDataElement toSlideDataElement(int n) {
        return ((ISlideDataElement)this.elementAt(n)).copy();
    }

    public float getCY3(int n) {
        ISlideDataElement iSlideDataElement = (ISlideDataElement)this.elementAt(n);
        if (this.normalizedState == 0) {
            return iSlideDataElement.getTrueIntensity(0);
        }
        return iSlideDataElement.getIntensity(0);
    }

    public float getCY5(int n) {
        ISlideDataElement iSlideDataElement = (ISlideDataElement)this.elementAt(n);
        if (this.normalizedState == 0) {
            return iSlideDataElement.getTrueIntensity(1);
        }
        return iSlideDataElement.getIntensity(1);
    }

    public void setIntensities(int n, float f, float f2) {
        ISlideDataElement iSlideDataElement = (ISlideDataElement)this.elementAt(n);
        iSlideDataElement.setTrueIntensity(0, f);
        iSlideDataElement.setTrueIntensity(1, f2);
    }

    public float getRatio(int n, int n2) {
        return this.getRatio(this.getCY5(n), this.getCY3(n), n2);
    }

    public final float getRatio(float f, float f2, int n) {
        float f3;
        if (this.dataType == 1) {
            return f;
        }
        if (f2 < 0.0f || f < 0.0f) {
            return Float.NaN;
        }
        if (this.isNonZero) {
            if (f2 == 0.0f && f == 0.0f) {
                return Float.NaN;
            }
            f3 = f == 0.0f ? 1.0f / f2 : (f2 == 0.0f ? f : f / f2);
        } else {
            if (f2 <= 0.0f) {
                return Float.NaN;
            }
            if (f <= 0.0f) {
                return Float.NaN;
            }
            f3 = f / f2;
        }
        if (n == 1) {
            f3 = (float)(Math.log(f3) / Math.log(2.0));
        }
        return f3;
    }

    public ISlideMetaData getSlideMetaData() {
        return this;
    }

    public void addSlideDataElement(ISlideDataElement iSlideDataElement) {
        this.addElement(iSlideDataElement);
    }

    public String getValueAt(int n, int n2) {
        ISlideDataElement iSlideDataElement = (ISlideDataElement)this.elementAt(n);
        return iSlideDataElement.getFieldAt(n2);
    }

    public int getSize() {
        return this.size();
    }

    public void setNonZero(boolean bl) {
        this.isNonZero = bl;
    }

    public int getRow(int n) {
        return this.getSlideDataElement(n).getRow(0);
    }

    public int getColumn(int n) {
        return this.getSlideDataElement(n).getColumn(0);
    }

    public boolean isNonZero() {
        return this.isNonZero;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setSlideDataName(String string) {
        String string2;
        this.slideDataName = string;
        this.sampleLabelKey = string2 = "Default Slide Name";
        this.sampleLabelKeys.addElement(string2);
        this.sampleLabels.put(string2, string);
    }

    public void setSlideDataLabels(Vector vector, Hashtable hashtable) {
        this.sampleLabelKeys = vector;
        this.sampleLabels = hashtable;
    }

    public void toggleNameLength() {
        this.abbrName = !this.abbrName;
    }

    public String getSlideDataName() {
        String string;
        if (this.sampleLabelKey == null) {
            System.out.println("NULLLLL SAMPLE LABEL KEY");
        }
        if ((string = (String)this.sampleLabels.get(this.sampleLabelKey)) == null) {
            return " ";
        }
        if (!this.abbrName) {
            return string;
        }
        if (string.length() < 26) {
            return string;
        }
        return string.substring(0, 25) + "...";
    }

    public String getFullSlideDataName() {
        String string = (String)this.sampleLabels.get(this.sampleLabelKey);
        if (string == null) {
            return " ";
        }
        return string;
    }

    public void setSlideFileName(String string) {
        this.slideFileName = string;
    }

    public String getSlideFileName() {
        if (!this.abbrName) {
            return this.slideFileName;
        }
        if (this.slideFileName.length() < 26) {
            return this.slideFileName;
        }
        return this.slideFileName.substring(0, 25) + "...";
    }

    public void setNormalizedState(int n) {
        this.normalizedState = n;
    }

    public int getNormalizedState() {
        return this.normalizedState;
    }

    public void setSortState(int n) {
        this.sortState = n;
    }

    public int getSortState() {
        return this.sortState;
    }

    public String getNormalizationString() {
        return SlideData.normalizationString(this.normalizedState);
    }

    public static String normalizationString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "No Normalization";
                break;
            }
            case 1: {
                string = "Total Intensity";
                break;
            }
            case 2: {
                string = "Least Squares";
                break;
            }
            case 3: {
                string = "Linear Regression";
                break;
            }
            case 4: {
                string = "Ratio Statistics";
                break;
            }
            case 5: {
                string = "Ratio Statistics";
                break;
            }
            case 6: {
                string = "Iterative Log";
                break;
            }
            case 7: {
                string = "Lowess";
                break;
            }
            case 101: {
                string = "Total Intensity (list)";
                break;
            }
            case 102: {
                string = "Least Squares (list)";
                break;
            }
            case 103: {
                string = "Linear Regression (list)";
                break;
            }
            case 104: {
                string = "Ratio Statistics - 95% CI (list)";
                break;
            }
            case 105: {
                string = "Ratio Statistics - 99% CI (list)";
                break;
            }
            case 106: {
                string = "Iterative Log (list)";
                break;
            }
            case 107: {
                string = "Lowess (list)";
                break;
            }
            default: {
                string = "No Normalization";
            }
        }
        return string;
    }

    public float getMaxCY3() {
        return this.getMaxIntensity(0);
    }

    public float getMaxCY5() {
        return this.getMaxIntensity(1);
    }

    public float getMaxIntensity(int n) {
        float f = 0.0f;
        for (int i = 0; i < this.size(); ++i) {
            float f2 = this.normalizedState == 0 ? this.getSlideDataElement(i).getTrueIntensity(n) : this.getSlideDataElement(i).getIntensity(n);
            f = Math.max(f, f2);
        }
        return f;
    }

    public float getMinIntensity(int n) {
        return this.getMinIntensity(n, true);
    }

    public float getMinIntensity(int n, boolean bl) {
        float f = Float.MAX_VALUE;
        for (int i = 0; i < this.size(); ++i) {
            float f2 = this.normalizedState == 0 ? this.getSlideDataElement(i).getTrueIntensity(n) : this.getSlideDataElement(i).getIntensity(n);
            if (!bl) {
                if (!(f2 < f) || f2 == 0.0f) continue;
                f = f2;
                continue;
            }
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public float getMaxRatio() {
        return this.getMaxRatio(0);
    }

    public float getMinRatio() {
        return this.getMinRatio(0);
    }

    public float getMaxRatio(int n) {
        return this.getMaxRatio(1, 0, n);
    }

    public float getMinRatio(int n) {
        return this.getMinRatio(1, 0, n);
    }

    public float getMaxRatio(int n, int n2, int n3) {
        float f = Float.MIN_VALUE;
        for (int i = 0; i < this.size(); ++i) {
            float f2 = this.getSlideDataElement(i).getRatio(n, n2, n3);
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public float getMinRatio(int n, int n2, int n3) {
        float f = Float.MAX_VALUE;
        for (int i = 0; i < this.size(); ++i) {
            float f2 = this.getSlideDataElement(i).getRatio(n, n2, n3);
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public float getMaxProduct(int n, int n2) {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.size(); ++i) {
            ISlideDataElement iSlideDataElement = this.getSlideDataElement(i);
            f = iSlideDataElement.getIntensity(n) * iSlideDataElement.getIntensity(n2);
            if (!(f > f2)) continue;
            f2 = f;
        }
        return f2;
    }

    public float getMinProduct(int n, int n2, boolean bl) {
        return this.getMinProduct(n, n2, bl, 0);
    }

    public float getMinProduct(int n, int n2, boolean bl, int n3) {
        float f = 0.0f;
        float f2 = Float.MAX_VALUE;
        for (int i = 0; i < this.size(); ++i) {
            ISlideDataElement iSlideDataElement = this.getSlideDataElement(i);
            f = iSlideDataElement.getIntensity(n) * iSlideDataElement.getIntensity(n2);
            if (!(f >= (float)n3)) continue;
            if (!bl) {
                if (!(f < f2) || f == 0.0f) continue;
                f2 = f;
                continue;
            }
            if (!(f < f2)) continue;
            f2 = f;
        }
        return f2;
    }

    public long getSumIntensity(int n) {
        long l = 0L;
        for (int i = 0; i < this.size(); ++i) {
            l = (long)((float)l + this.getSlideDataElement(i).getIntensity(n));
        }
        return l;
    }

    public long getSumNonZeroIntensity(int n) {
        long l = 0L;
        for (int i = 0; i < this.size(); ++i) {
            try {
                ISlideDataElement iSlideDataElement = this.getSlideDataElement(i);
                if (!iSlideDataElement.hasNoZeros()) continue;
                l = (long)((float)l + iSlideDataElement.getIntensity(n));
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return l;
    }

    public LinearEquation getRegressionEquation(boolean bl) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 1.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 1.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            ISlideDataElement iSlideDataElement = this.getSlideDataElement(i);
            if (iSlideDataElement == null) continue;
            if (bl) {
                d = iSlideDataElement.getTrueIntensity(0);
                d2 = iSlideDataElement.getTrueIntensity(1);
            } else {
                d = iSlideDataElement.getIntensity(0);
                d2 = iSlideDataElement.getIntensity(1);
            }
            if (d == 0.0 || d2 == 0.0) continue;
            d3 += d9;
            d4 += d9 * d;
            d5 += d9 * d2;
            d6 += d9 * d * d;
            d7 += d9 * d2 * d2;
            d8 += d9 * d * d2;
        }
        d10 = d3 * d6 - d4 * d4;
        d11 = (d6 * d5 - d4 * d8) / d10;
        d12 = (d8 * d3 - d4 * d5) / d10;
        d15 = Math.sqrt(d13 * d6 / d10);
        d16 = Math.sqrt(d13 * d3 / d10);
        d14 = (d3 * d8 - d4 * d5) / Math.sqrt(d10 * (d3 * d7) - d5 * d5);
        LinearEquation linearEquation = new LinearEquation(d12, d11, d14);
        return linearEquation;
    }

    public void applyNormalization(int n, Properties properties) {
        switch (n) {
            case 0: {
                this.applyNoNormalization();
                break;
            }
            case 1: {
                this.applyTotalIntensity();
                break;
            }
            case 2: {
                this.applyLeastSquares();
                break;
            }
            case 3: {
                this.applyLinearRegression(properties);
                break;
            }
            case 4: {
                this.applyRatioStatistics(properties);
                break;
            }
            case 5: {
                this.applyRatioStatistics(properties);
                break;
            }
            case 6: {
                this.applyIterativeLog(properties);
                break;
            }
            case 7: {
                this.applyLowess(10);
            }
        }
    }

    public void applyNormalizationList(int n) {
        switch (n) {
            case 101: {
                this.applyTotalIntensity();
                break;
            }
            case 102: {
                this.applyLeastSquares();
                break;
            }
            case 103: {
                this.applyLinearRegression(new Properties());
                break;
            }
            case 104: {
                this.applyRatioStatistics(new Properties());
                break;
            }
            case 105: {
                this.applyRatioStatistics(new Properties());
                break;
            }
            case 106: {
                this.applyIterativeLog(new Properties());
                break;
            }
            case 107: {
                this.applyLowess(10);
            }
        }
    }

    public void applyNoNormalization() {
        if (this.normalizedState != 0) {
            for (int i = 0; i < this.size(); ++i) {
                ISlideDataElement iSlideDataElement = this.getSlideDataElement(i);
                iSlideDataElement.setIntensity(0, iSlideDataElement.getTrueIntensity(0));
                iSlideDataElement.setIntensity(1, iSlideDataElement.getTrueIntensity(1));
            }
            this.normalizedState = 0;
        }
    }

    public void applyTotalIntensity() {
        ISlideDataElement iSlideDataElement = this.getSlideDataElement(10);
        boolean[] blArray = new boolean[this.getSize()];
        ColumnWorker columnWorker = this.constructColumnWorker(blArray);
        columnWorker = new TotInt(columnWorker, "Cy3", false).getFileTotIntColumnWorker();
        this.setNormalizedIntensities(columnWorker, blArray);
        this.normalizedState = 1;
    }

    public void applyLinearRegression(Properties properties) {
        boolean[] blArray = new boolean[this.getSize()];
        ColumnWorker columnWorker = this.constructColumnWorker(blArray);
        try {
            String string = (String)properties.get("mode");
            float f = Float.parseFloat((String)properties.get("standard-deviation"));
            columnWorker = new IterativeLinReg(columnWorker, f, string, "Cy3").getIterLinRegColumnWorker();
            this.setNormalizedIntensities(columnWorker, blArray);
            this.normalizedState = 3;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), "Error Performing Normalization: Data Unchanged", "Normalization Error : Aborted", 2);
            this.normalizedState = 0;
        }
    }

    public void applyRatioStatistics(Properties properties) {
        boolean[] blArray = new boolean[this.getSize()];
        ColumnWorker columnWorker = this.constructColumnWorker(blArray);
        try {
            int n = Integer.parseInt((String)properties.get("confidence-interval"));
            columnWorker = new RatioStats(columnWorker, true, n, "Cy3").getRatioStatsColumnWorker();
            this.setNormalizedIntensities(columnWorker, blArray);
            this.normalizedState = 3;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), "Error Performing Normalization: Data Unchanged", "Normalization Error : Aborted", 2);
            this.normalizedState = 0;
            exception.printStackTrace();
        }
    }

    public void applyIterativeLog(Properties properties) {
        boolean[] blArray = new boolean[this.getSize()];
        ColumnWorker columnWorker = this.constructColumnWorker(blArray);
        try {
            float f = Float.parseFloat((String)properties.get("standard-deviation"));
            columnWorker = new IterativeLogMean(columnWorker, f, "Cy3").getIterLogMeanColumnWorker();
            this.setNormalizedIntensities(columnWorker, blArray);
            this.normalizedState = 6;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new JFrame(), "Error Performing Normalization: Data Unchanged", "Normalization Error : Aborted", 2);
            this.normalizedState = 0;
        }
    }

    private ColumnWorker constructColumnWorker(boolean[] blArray) {
        int n;
        int n2 = n = this.getSize();
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        String[] stringArray = new String[n];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getSlideDataElement(i).getRow(1);
            int n4 = this.getSlideDataElement(i).getColumn(1);
            float f = this.getSlideDataElement(i).getTrueIntensity(0);
            float f2 = this.getSlideDataElement(i).getTrueIntensity(1);
            if (this.dataType == 1) {
                f = 100000.0f;
                if ((f2 = (float)(100000.0 * Math.pow(2.0, f2))) == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
                    f2 = 0.0f;
                    f = 0.0f;
                }
            }
            if (f == 0.0f || f2 == 0.0f) continue;
            blArray[i] = true;
            fArray[n] = f;
            fArray2[n] = f2;
            stringArray[n] = Integer.toString(n3) + "_" + Integer.toString(n4);
            ++n;
        }
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        System.arraycopy(fArray, 0, fArray3, 0, n);
        System.arraycopy(fArray2, 0, fArray4, 0, n);
        System.arraycopy(stringArray, 0, stringArray, 0, n);
        return new ColumnWorker(fArray3, fArray4, stringArray);
    }

    private void setNormalizedIntensities(ColumnWorker columnWorker, boolean[] blArray) {
        float[] fArray = columnWorker.getColumnOneArray();
        float[] fArray2 = columnWorker.getColumnTwoArray();
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            ISlideDataElement iSlideDataElement = this.getSlideDataElement(i);
            if (blArray[i]) {
                if (this.dataType == 1) {
                    iSlideDataElement.setIntensity(0, 1.0f);
                    iSlideDataElement.setIntensity(1, (float)(Math.log(fArray2[n] / fArray[n]) / Math.log(2.0)));
                } else {
                    iSlideDataElement.setIntensity(0, fArray[n]);
                    iSlideDataElement.setIntensity(1, fArray2[n]);
                }
                ++n;
                continue;
            }
            iSlideDataElement.setIntensity(0, iSlideDataElement.getTrueIntensity(0));
            iSlideDataElement.setIntensity(1, iSlideDataElement.getTrueIntensity(1));
        }
    }

    public void applyLowess(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        Vector vector = new Vector();
        ISlideDataElement[] iSlideDataElementArray = new ISlideDataElement[this.size()];
        float[] fArray = new float[this.size()];
        float[] fArray2 = new float[this.size()];
        int[] nArray = new int[this.size()];
        int n6 = this.size() / n + 1;
        for (n5 = 0; n5 < n; ++n5) {
            vector.addElement(new Vector());
        }
        for (n5 = 0; n5 < this.size(); ++n5) {
            iSlideDataElementArray[n5] = this.getSlideDataElement(n5);
            fArray[n5] = (float)Xcon.log2((double)iSlideDataElementArray[n5].getRatio(1, 0, 0));
            fArray2[n5] = (float)Xcon.log10((double)(iSlideDataElementArray[n5].getIntensity(0) * iSlideDataElementArray[n5].getIntensity(1)));
        }
        double d = 0.0;
        int n7 = 0;
        for (n4 = 0; n4 < this.size(); ++n4) {
            block3: for (n3 = 0; n3 < this.size(); ++n3) {
                if (!(d < (double)fArray2[n3])) continue;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (n3 == nArray[n2]) continue block3;
                }
                d = fArray2[n3];
                n7 = n3;
            }
            nArray[n4] = n7;
        }
        for (n4 = 0; n4 < this.size(); ++n4) {
            System.out.println("Rank: " + n4 + ", Element: " + nArray[n4]);
        }
        n4 = 0;
        n3 = 0;
        n2 = 0;
        while (n2 < this.size()) {
            ((Vector)vector.elementAt(n3)).addElement(iSlideDataElementArray[nArray[n2]]);
            if (n4 == n6) {
                n4 = 0;
                ++n3;
            }
            ++n2;
            ++n4;
        }
        System.out.println(vector.size() + " bins created");
        for (n2 = 0; n2 < vector.size(); ++n2) {
            System.out.println("Bin " + n2 + " has " + ((Vector)vector.elementAt(n2)).size() + " elements");
        }
        for (int i = 0; i < vector.size(); ++i) {
            int n8;
            Vector vector2 = (Vector)vector.elementAt(i);
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            for (int j = 0; j < vector2.size(); ++j) {
                ISlideDataElement iSlideDataElement = (ISlideDataElement)vector2.elementAt(j);
                l = (long)((float)l + iSlideDataElement.getIntensity(1));
                l2 = (long)((float)l2 + iSlideDataElement.getIntensity(0));
                if (!iSlideDataElement.hasNoZeros()) continue;
                l3 = (long)((float)l3 + iSlideDataElement.getIntensity(1));
                l4 = (long)((float)l4 + iSlideDataElement.getIntensity(0));
            }
            double d2 = (double)l2 / (double)l;
            double d3 = (double)l4 / (double)l3;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            int n9 = 0;
            double[] dArray = new double[this.size()];
            System.out.println(i + " - All: " + l2 + "\t" + l + "\t" + d2);
            System.out.println(i + " - Use: " + l4 + "\t" + l3 + "\t" + d3);
            for (n8 = 0; n8 < vector2.size(); ++n8) {
                ISlideDataElement iSlideDataElement = (ISlideDataElement)vector2.elementAt(n8);
                iSlideDataElement.setIntensity(1, (long)((double)iSlideDataElement.getIntensity(1) * d3));
                d5 = Xcon.log2((double)((double)iSlideDataElement.getRatio(0, 1, 0) / d3));
                if (iSlideDataElement.hasNoZeros()) {
                    d4 += d5;
                    ++n9;
                }
                double d7 = Math.log(1.0);
                double d8 = Math.log(1.0);
            }
            d6 = d4 / (double)n9;
            System.out.println(i + " - Mean log ratio: " + d6);
            d4 = 0.0;
            n9 = 0;
            double d9 = Math.pow(Math.E, d6);
            System.out.println(i + " - Scale: " + d9);
            for (n8 = 0; n8 < vector2.size(); ++n8) {
                ISlideDataElement iSlideDataElement = (ISlideDataElement)vector2.elementAt(n8);
                iSlideDataElement.setIntensity(1, (long)((double)iSlideDataElement.getIntensity(1) * d9));
                d5 = Xcon.log2((double)((double)iSlideDataElement.getRatio(0, 1, 0) / d9));
            }
            for (n8 = 0; n8 < vector2.size(); ++n8) {
                ISlideDataElement iSlideDataElement = (ISlideDataElement)vector2.elementAt(n8);
                dArray[n8] = iSlideDataElement.hasNoZeros() ? (double)iSlideDataElement.getRatio(0, 1, 0) / d3 / d9 : (double)iSlideDataElement.getRatio(0, 1, 0);
            }
            double d10 = 0.0;
            int n10 = 0;
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = 0.0;
            for (int j = 0; j <= 10; ++j) {
                int n11;
                for (n11 = 0; n11 < vector2.size(); ++n11) {
                    ISlideDataElement iSlideDataElement = (ISlideDataElement)vector2.elementAt(n11);
                    if (!iSlideDataElement.hasNoZeros() || !((d11 = Xcon.log2((double)dArray[n11])) <= 1.0) || !(d11 >= -1.0)) continue;
                    d10 += d11;
                    ++n10;
                }
                d12 = d10 / (double)n10;
                d13 = Math.pow(Math.E, d12);
                System.out.println(i + " - Iteration " + j + "\tMean Log Ratio: " + d12 + "\t" + d13);
                for (n11 = 0; n11 < vector2.size(); ++n11) {
                    ISlideDataElement iSlideDataElement = (ISlideDataElement)vector2.elementAt(n11);
                    if (iSlideDataElement.hasNoZeros()) {
                        dArray[n11] = dArray[n11] / d13;
                    }
                    iSlideDataElement.setIntensity(1, (long)((double)iSlideDataElement.getIntensity(1) * d13));
                }
            }
        }
        this.normalizedState = 7;
    }

    public void applyLeastSquares() {
        LinearEquation linearEquation = this.getRegressionEquation(true);
        if (this.normalizedState != 2) {
            for (int i = 0; i < this.size(); ++i) {
                ISlideDataElement iSlideDataElement = this.getSlideDataElement(i);
                if (iSlideDataElement == null) continue;
                iSlideDataElement.setIntensity(1, this.applyLeastSquares(iSlideDataElement.getTrueIntensity(1), linearEquation));
            }
            this.normalizedState = 2;
        }
    }

    public float applyLeastSquares(float f, LinearEquation linearEquation) {
        if (f > 0.0f) {
            return (float)(((double)f - linearEquation.getYIntercept()) * (1.0 / linearEquation.getSlope()));
        }
        return 0.0f;
    }

    public void output() {
        String string = "";
        try {
            string = "\n\n\n***SlideData***\n\n";
            for (int i = 0; i < this.size(); ++i) {
                string = string + this.getSlideDataElement(i).toString() + "\n";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(string);
    }

    public Vector getSlideDataKeys() {
        return this.sampleLabelKeys;
    }

    public Hashtable getSlideDataLabels() {
        return this.sampleLabels;
    }

    public void setDataLabelKey(String string) {
        this.sampleLabelKey = string;
    }

    public void addNewSampleLabel(String string, String string2) {
        if (!this.sampleLabelKeys.contains(string)) {
            this.sampleLabelKeys.addElement(string);
        }
        this.sampleLabels.put(string, string2);
    }

    public String getDetection(int n) {
        return this.getSlideDataElement(n).getDetection();
    }
}

