/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class VarianceFilterDialog
extends AlgorithmDialog {
    private int result;
    private JCheckBox enableFilterBox;
    private JTextField valueField;
    private JRadioButton percentButton;
    private JRadioButton numberButton;
    private JRadioButton sdValueButton;
    private JLabel valueLabel;

    public VarianceFilterDialog(JFrame jFrame) {
        super(jFrame, "Variance Filter", true);
        Listener listener = new Listener();
        ParameterPanel parameterPanel = new ParameterPanel("Filter Settings");
        parameterPanel.setLayout((LayoutManager)new GridBagLayout());
        this.enableFilterBox = new JCheckBox("Enable Variance Filter", true);
        this.enableFilterBox.setOpaque(false);
        this.enableFilterBox.setFocusPainted(false);
        this.enableFilterBox.setActionCommand("enable-box-command");
        this.enableFilterBox.addActionListener(listener);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.percentButton = new JRadioButton("Percentage of Highest SD Genes (1-100)", true);
        this.percentButton.setFocusPainted(false);
        this.percentButton.setOpaque(false);
        buttonGroup.add(this.percentButton);
        this.numberButton = new JRadioButton("Number of Desired High SD Genes");
        this.numberButton.setFocusPainted(false);
        this.numberButton.setOpaque(false);
        buttonGroup.add(this.numberButton);
        this.sdValueButton = new JRadioButton("SD Cutoff Value", true);
        this.sdValueButton.setFocusPainted(false);
        this.sdValueButton.setOpaque(false);
        buttonGroup.add(this.sdValueButton);
        this.valueLabel = new JLabel("Value: ");
        this.valueField = new JTextField("50", 10);
        this.valueField.selectAll();
        parameterPanel.add((Component)this.enableFilterBox, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 20, 0), 0, 0));
        parameterPanel.add((Component)this.percentButton, (Object)new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameterPanel.add((Component)this.numberButton, (Object)new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameterPanel.add((Component)this.sdValueButton, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameterPanel.add((Component)this.valueLabel, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 30, 0), 0, 0));
        parameterPanel.add((Component)this.valueField, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 3, new Insets(20, 10, 30, 0), 0, 0));
        this.addContent((Component)parameterPanel);
        this.setActionListeners(listener);
        this.addWindowListener(listener);
        this.pack();
        this.setResizable(false);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void enableControls(boolean bl) {
        this.percentButton.setEnabled(bl);
        this.numberButton.setEnabled(bl);
        this.sdValueButton.setEnabled(bl);
        this.valueField.setEnabled(bl);
        this.valueLabel.setEnabled(bl);
    }

    private void resetControls() {
        this.enableFilterBox.setSelected(true);
        this.percentButton.setSelected(true);
        this.valueField.setText("50");
        this.valueField.selectAll();
        this.enableControls(true);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        if (this.enableFilterBox.isSelected()) {
            properties.setProperty("Filter Enabled", "true");
            if (this.percentButton.isSelected()) {
                properties.setProperty("Filter Mode", "percent mode");
            } else if (this.numberButton.isSelected()) {
                properties.setProperty("Filter Mode", "number of genes mode");
            } else {
                properties.setProperty("Filter Mode", "sd value mode");
            }
            properties.setProperty("Value", this.valueField.getText());
        } else {
            properties.setProperty("Filter Enabled", "false");
        }
        return properties;
    }

    private boolean validateValues() {
        boolean bl = true;
        if (this.percentButton.isSelected()) {
            float f;
            try {
                Float.parseFloat(this.valueField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                JOptionPane.showMessageDialog((Component)((Object)this), "Improper input format.", "Input Format Error", 0);
            }
            if (bl && ((f = Float.parseFloat(this.valueField.getText())) <= 0.0f || f > 100.0f)) {
                bl = false;
                JOptionPane.showMessageDialog((Component)((Object)this), "Improper value range. (valid range is 0 < x <= 100)", "Input Format Error", 0);
            }
        } else if (this.numberButton.isSelected()) {
            int n;
            try {
                Integer.parseInt(this.valueField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                JOptionPane.showMessageDialog((Component)((Object)this), "Improper input format. Value should be an integer.", "Input Format Error", 0);
            }
            if (bl && (n = Integer.parseInt(this.valueField.getText())) <= 0) {
                bl = false;
                JOptionPane.showMessageDialog((Component)((Object)this), "Improper value range. (valid range is x > 0)", "Input Format Error", 0);
            }
        } else {
            float f;
            try {
                Float.parseFloat(this.valueField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                JOptionPane.showMessageDialog((Component)((Object)this), "Improper input format.", "Input Format Error", 0);
            }
            if (bl && (f = Float.parseFloat(this.valueField.getText())) < 0.0f) {
                bl = false;
                JOptionPane.showMessageDialog((Component)((Object)this), "Improper value range. (valid range is x >= 0)", "Input Format Error", 0);
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        VarianceFilterDialog varianceFilterDialog = new VarianceFilterDialog(new JFrame());
        varianceFilterDialog.showModal();
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                if (!VarianceFilterDialog.this.validateValues()) {
                    return;
                }
                this.onOk();
            } else if (string.equals("cancel-command")) {
                VarianceFilterDialog.this.result = 2;
                VarianceFilterDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                VarianceFilterDialog.this.resetControls();
            } else if (string.equals("enable-box-command")) {
                VarianceFilterDialog.this.enableControls(VarianceFilterDialog.this.enableFilterBox.isSelected());
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow((JDialog)((Object)VarianceFilterDialog.this), "Variance Filter Dialog");
                VarianceFilterDialog.this.result = 2;
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(550, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                    return;
                }
                helpWindow.setVisible(false);
                helpWindow.dispose();
                return;
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                this.onOk();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            VarianceFilterDialog.this.result = -1;
            VarianceFilterDialog.this.dispose();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        private void onOk() {
            try {
                VarianceFilterDialog.this.result = 0;
            }
            catch (Exception exception) {
                VarianceFilterDialog.this.result = 2;
            }
            VarianceFilterDialog.this.dispose();
        }
    }
}

