/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.AffySlideDataElement;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.FileTreePane;
import org.tigr.microarray.mev.file.FileTreePaneEvent;
import org.tigr.microarray.mev.file.FileTreePaneListener;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;

public class AffymetrixFileLoader
extends ExpressionFileLoader {
    private GBA gba = new GBA();
    private AffymetrixFileLoaderPanel aflp = new AffymetrixFileLoaderPanel();
    private boolean loadEnabled = false;
    private File refChipFile;
    private String mode = "";
    private File[] files;
    private int affyDataType = 2;

    public AffymetrixFileLoader(SuperExpressionFileLoader superExpressionFileLoader) {
        super(superExpressionFileLoader);
    }

    public Vector loadExpressionFiles() throws IOException {
        Object[] objectArray = this.aflp.getAffymetrixSelectedListModel().toArray();
        Object[] objectArray2 = this.aflp.getRefSelectedListModel().toArray();
        String[] stringArray = new String[]{"Affy_ID", "Detection", "Description"};
        TMEV.setFieldNames(stringArray);
        ISlideData[] iSlideDataArray = null;
        this.files = new File[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.files[i] = (File)objectArray[i];
        }
        if (this.aflp.absoluteRadioButton.isSelected()) {
            iSlideDataArray = this.loadAffyAbsolute(this.files);
            this.affyDataType = 2;
        } else if (this.aflp.absMeanRadioButton.isSelected()) {
            iSlideDataArray = this.loadAffyAbsMean(this.files);
            this.affyDataType = 4;
        } else if (this.aflp.referenceRadioButton.isSelected()) {
            DefaultListModel defaultListModel = this.aflp.getRefSelectedListModel();
            DefaultListModel defaultListModel2 = this.aflp.getAffymetrixSelectedListModel();
            if (defaultListModel.getSize() < 1) {
                return null;
            }
            if (defaultListModel.getSize() >= 1) {
                if (defaultListModel2.size() < 1) {
                    return null;
                }
                File file = (File)defaultListModel.get(0);
                File[] fileArray = this.toFileArray(defaultListModel2.toArray());
                iSlideDataArray = this.loadAffyReference(file, fileArray);
                this.affyDataType = 3;
            }
        }
        Vector<ISlideData> vector = new Vector<ISlideData>();
        if (iSlideDataArray != null) {
            TMEV.setDataType(2);
            for (int i = 0; i < iSlideDataArray.length; ++i) {
                vector.add(iSlideDataArray[i]);
            }
        }
        return vector;
    }

    private File[] toFileArray(Object[] objectArray) {
        File[] fileArray = new File[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            fileArray[i] = (File)objectArray[i];
        }
        return fileArray;
    }

    public ISlideData loadExpressionFile(File file) throws IOException {
        return null;
    }

    public Vector loadReferenceFile(File file) throws IOException {
        return new Vector();
    }

    private void setAffyDataType(int n) {
        this.affyDataType = n;
    }

    public int getAffyDataType() {
        return this.affyDataType;
    }

    private ISlideData[] loadAffyReference(File file, File[] fileArray) throws IOException {
        int n;
        String string;
        if (fileArray.length < 1) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        boolean bl = false;
        StringSplitter stringSplitter = new StringSplitter('\t');
        int n2 = this.getCountOfLines(file);
        float[] fArray = new float[n2];
        int n3 = 0;
        int n4 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (n3 < 1) {
                ++n3;
                continue;
            }
            stringSplitter.init(string);
            stringSplitter.passTokens(1);
            fArray[n4] = stringSplitter.nextFloatToken(0.0f);
            ++n4;
        }
        bufferedReader.close();
        ISlideData[] iSlideDataArray = new ISlideData[fileArray.length];
        n2 = 0;
        int n5 = 0;
        this.setFilesCount(fileArray.length);
        for (n = 0; n < fileArray.length; ++n) {
            if (this.stop) {
                return null;
            }
            this.setFilesProgress(n);
            this.setRemain(fileArray.length - n);
            this.setFileName(fileArray[n].getPath());
            if (n == 0) {
                n2 = this.getCountOfLines(fileArray[n]);
                this.setLinesCount(n2);
                n5 = n2 - 1;
            }
            if (this.meta == null) {
                iSlideDataArray[n] = this.loadAffySlideData(fileArray[n]);
                this.meta = iSlideDataArray[n].getSlideMetaData();
                continue;
            }
            iSlideDataArray[n] = this.loadAffyFloatSlideData(fileArray[n], n5, this.meta);
        }
        for (n = 0; n < fileArray.length; ++n) {
            for (int i = 0; i < n5; ++i) {
                iSlideDataArray[n].setIntensities(i, fArray[i], iSlideDataArray[n].getCY5(i));
            }
        }
        return iSlideDataArray;
    }

    private ISlideData[] loadAffyAbsMean(File[] fileArray) throws IOException {
        int n;
        int n2;
        if (fileArray.length < 1) {
            return null;
        }
        float f = 0.0f;
        float[] fArray = new float[fileArray.length];
        float f2 = 0.0f;
        ISlideData[] iSlideDataArray = new ISlideData[fileArray.length];
        int n3 = 0;
        int n4 = 0;
        this.setFilesCount(fileArray.length);
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            if (this.stop) {
                return null;
            }
            fArray[n2] = 0.0f;
            f = 0.0f;
            this.setFilesProgress(n2);
            this.setRemain(fileArray.length - n2);
            this.setFileName(fileArray[n2].getPath());
            if (n2 == 0) {
                n3 = this.getCountOfLines(fileArray[n2]);
                this.setLinesCount(n3);
                n4 = n3 - 1;
            }
            if (this.meta == null) {
                iSlideDataArray[n2] = this.loadAffySlideData(fileArray[n2]);
                this.meta = iSlideDataArray[n2].getSlideMetaData();
                for (n = 0; n < n4; ++n) {
                    f += iSlideDataArray[n2].getCY5(n);
                }
            } else {
                iSlideDataArray[n2] = this.loadAffyFloatSlideData(fileArray[n2], n4, this.meta);
                for (n = 0; n < n4; ++n) {
                    f += iSlideDataArray[n2].getCY5(n);
                }
            }
            fArray[n2] = f / (float)n4;
        }
        for (n2 = 0; n2 < fArray.length; ++n2) {
            f2 += fArray[n2];
        }
        f2 /= (float)fArray.length;
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            for (n = 0; n < n4; ++n) {
                iSlideDataArray[n2].setIntensities(n, f2, iSlideDataArray[n2].getCY5(n));
            }
        }
        return iSlideDataArray;
    }

    private ISlideData[] loadAffyAbsolute(File[] fileArray) throws IOException {
        if (fileArray.length < 1) {
            return null;
        }
        ISlideData[] iSlideDataArray = new ISlideData[fileArray.length];
        int n = 0;
        int n2 = 0;
        this.setFilesCount(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            if (this.stop) {
                return null;
            }
            this.setFilesProgress(i);
            this.setRemain(fileArray.length - i);
            this.setFileName(fileArray[i].getPath());
            if (i == 0) {
                n = this.getCountOfLines(fileArray[i]);
                this.setLinesCount(n);
                n2 = n - 1;
            }
            if (this.meta == null) {
                iSlideDataArray[i] = this.loadAffySlideData(fileArray[i]);
                this.meta = iSlideDataArray[i].getSlideMetaData();
                continue;
            }
            iSlideDataArray[i] = this.loadAffyFloatSlideData(fileArray[i], n2, this.meta);
        }
        return iSlideDataArray;
    }

    private ISlideData loadAffySlideData(File file) throws IOException {
        String string;
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(0);
            TMEV.setNameIndex(3);
            TMEV.setIndicesAdjusted(true);
        }
        int[] nArray = new int[]{0, 1, 0};
        int[] nArray2 = new int[]{0, 1, 0};
        String[] stringArray = new String[5];
        float[] fArray = new float[2];
        int n = this.getCountOfLines(this.files[0]);
        int n2 = 1;
        SlideData slideData = new SlideData(n, n2);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        int n6 = 1;
        stringArray[4] = "na";
        stringArray[3] = "na";
        stringArray[2] = "na";
        int n7 = 0;
        StringSplitter stringSplitter = new StringSplitter('\t');
        while ((string = bufferedReader.readLine()) != null) {
            if (n3 < 1) {
                ++n3;
                continue;
            }
            this.setFileProgress(n4++);
            stringSplitter.init(string);
            n7 = stringSplitter.countTokens() + 1;
            stringArray = new String[n7];
            nArray[2] = n5++;
            nArray[0] = nArray[2];
            nArray2[0] = nArray2[2] = n6;
            stringArray[0] = stringSplitter.nextToken();
            fArray[0] = 1.0f;
            fArray[1] = stringSplitter.nextFloatToken(0.0f);
            String string2 = stringArray[1] = stringSplitter.nextToken();
            if (n7 > 3) {
                int n8 = 2;
                while (stringSplitter.hasMoreTokens()) {
                    String string3 = stringSplitter.nextToken();
                    if ((string3 = string3.trim()).length() == 0) continue;
                    stringArray[n8] = string3;
                    ++n8;
                }
            }
            AffySlideDataElement affySlideDataElement = new AffySlideDataElement(String.valueOf(n4), nArray, nArray2, fArray, stringArray);
            affySlideDataElement.setDetection(string2);
            slideData.addSlideDataElement(affySlideDataElement);
        }
        bufferedReader.close();
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        return slideData;
    }

    private ISlideData loadAffyFloatSlideData(File file, int n, ISlideMetaData iSlideMetaData) throws IOException {
        String string;
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(0);
            TMEV.setNameIndex(3);
            TMEV.setIndicesAdjusted(true);
        }
        FloatSlideData floatSlideData = new FloatSlideData(iSlideMetaData);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter stringSplitter = new StringSplitter('\t');
        float[] fArray = new float[2];
        int n2 = 0;
        int n3 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (n2 < 1) {
                ++n2;
                continue;
            }
            this.setFileProgress(n3);
            stringSplitter.init(string);
            stringSplitter.passTokens(1);
            fArray[0] = 1.0f;
            fArray[1] = stringSplitter.nextFloatToken(0.0f);
            String string2 = stringSplitter.nextToken();
            floatSlideData.setIntensities(n3, fArray[0], fArray[1]);
            floatSlideData.setDetection(n3, string2);
            ++n3;
        }
        bufferedReader.close();
        floatSlideData.setSlideDataName(file.getName());
        floatSlideData.setSlideFileName(file.getPath());
        return floatSlideData;
    }

    public float get_Median(ArrayList arrayList) {
        Float f;
        Collections.sort(arrayList);
        if (arrayList.size() == 1) {
            return ((Float)arrayList.get(0)).floatValue();
        }
        int n = arrayList.size() / 2;
        if (arrayList.size() % 2 == 0) {
            Float f2 = (Float)arrayList.get(n);
            Float f3 = (Float)arrayList.get(n - 1);
            f = new Float((f2.floatValue() + f3.floatValue()) / 2.0f);
        } else {
            f = (Float)arrayList.get(n);
        }
        return f.floatValue();
    }

    public FileFilter getFileFilter() {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".txt") || file.getName().endsWith(".TXT");
            }

            public String getDescription() {
                return "Affymetrix Data Files (*.txt)";
            }
        };
        return fileFilter;
    }

    public boolean checkLoadEnable() {
        this.setLoadEnabled(this.loadEnabled);
        return this.loadEnabled;
    }

    public void markLoadEnabled(boolean bl) {
        this.loadEnabled = bl;
        this.setLoadEnabled(this.loadEnabled);
    }

    public JPanel getFileLoaderPanel() {
        return this.aflp;
    }

    public void processFileList(String string, Vector vector) {
        this.aflp.setPath(string);
        if (vector == null) {
            return;
        }
        FileFilter fileFilter = this.getFileFilter();
        this.aflp.getAffymetrixAvailableListModel().clear();
        this.aflp.getRefAvailableListModel().clear();
        for (int i = 0; i < vector.size(); ++i) {
            File file = new File((String)vector.elementAt(i));
            if (!fileFilter.accept(file)) continue;
            this.aflp.getAffymetrixAvailableListModel().addElement(new File((String)vector.elementAt(i)));
            this.aflp.getRefAvailableListModel().addElement(new File((String)vector.elementAt(i)));
        }
    }

    public String getFilePath() {
        if (this.aflp.getAffymetrixSelectedListModel().getSize() < 1) {
            return null;
        }
        return ((File)this.aflp.getAffymetrixSelectedListModel().getElementAt(0)).getAbsolutePath();
    }

    public void openDataPath() {
        this.aflp.openDataPath();
    }

    private class AffymetrixFileLoaderPanel
    extends JPanel {
        FileTreePane fileTreePane;
        JTextField pathTextField;
        JPanel affymetrixSelectionPanel;
        JPanel affymetrixListPanel;
        JLabel affymetrixAvailableLabel;
        JLabel affymetrixSelectedLabel;
        JList affymetrixAvailableList;
        JList affymetrixSelectedList;
        JScrollPane affymetrixAvailableScrollPane;
        JScrollPane affymetrixSelectedScrollPane;
        JButton affymetrixAddButton;
        JButton affymetrixAddAllButton;
        JButton affymetrixRemoveButton;
        JButton affymetrixRemoveAllButton;
        JPanel affymetrixButtonPanel;
        JPanel refSelectionPanel;
        ButtonGroup optionsButtonGroup;
        JRadioButton absoluteRadioButton;
        JRadioButton absMeanRadioButton;
        JRadioButton referenceRadioButton;
        JPanel refListPanel;
        JLabel refAvailableLabel;
        JLabel refSelectedLabel;
        JList refAvailableList;
        JList refSelectedList;
        JScrollPane refAvailableScrollPane;
        JScrollPane refSelectedScrollPane;
        JButton refAddButton;
        JButton refAddAllButton;
        JButton refRemoveButton;
        JButton refRemoveAllButton;
        JPanel refButtonPanel;
        JTextField refFieldsTextField;
        JPanel selectionPanel;
        JSplitPane splitPane;
        JPanel fileLoaderPanel;

        public AffymetrixFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.fileTreePane = new FileTreePane(SuperExpressionFileLoader.DATA_PATH);
            this.fileTreePane.addFileTreePaneListener(new FileTreePaneEventHandler());
            this.fileTreePane.setPreferredSize(new Dimension(200, 50));
            this.pathTextField = new JTextField();
            this.pathTextField.setEditable(false);
            this.pathTextField.setBorder(new TitledBorder(new EtchedBorder(), "Selected Path"));
            this.pathTextField.setForeground(Color.black);
            this.pathTextField.setFont(new Font("monospaced", 1, 12));
            this.affymetrixSelectionPanel = new JPanel();
            this.affymetrixSelectionPanel.setLayout(new GridBagLayout());
            this.affymetrixSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), AffymetrixFileLoader.this.getFileFilter().getDescription()));
            this.affymetrixAvailableLabel = new JLabel("Available");
            this.affymetrixSelectedLabel = new JLabel("Selected");
            this.affymetrixAvailableList = new JList(new DefaultListModel());
            this.affymetrixAvailableList.setCellRenderer(new ListRenderer());
            this.affymetrixSelectedList = new JList(new DefaultListModel());
            this.affymetrixSelectedList.setCellRenderer(new ListRenderer());
            this.affymetrixAvailableScrollPane = new JScrollPane(this.affymetrixAvailableList);
            this.affymetrixSelectedScrollPane = new JScrollPane(this.affymetrixSelectedList);
            this.affymetrixAddButton = new JButton("Add");
            this.affymetrixAddButton.addActionListener(new EventHandler());
            this.affymetrixAddAllButton = new JButton("Add All");
            this.affymetrixAddAllButton.addActionListener(new EventHandler());
            this.affymetrixRemoveButton = new JButton("Remove");
            this.affymetrixRemoveButton.addActionListener(new EventHandler());
            this.affymetrixRemoveAllButton = new JButton("Remove All");
            this.affymetrixRemoveAllButton.addActionListener(new EventHandler());
            Dimension dimension = this.affymetrixRemoveAllButton.getPreferredSize();
            this.affymetrixAddButton.setPreferredSize(dimension);
            this.affymetrixAddAllButton.setPreferredSize(dimension);
            this.affymetrixRemoveButton.setPreferredSize(dimension);
            this.affymetrixRemoveAllButton.setPreferredSize(dimension);
            this.affymetrixButtonPanel = new JPanel();
            this.affymetrixButtonPanel.setLayout(new GridBagLayout());
            AffymetrixFileLoader.this.gba.add(this.affymetrixButtonPanel, this.affymetrixAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.affymetrixButtonPanel, this.affymetrixAddAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.affymetrixButtonPanel, this.affymetrixRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.affymetrixButtonPanel, this.affymetrixRemoveAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.affymetrixListPanel = new JPanel();
            this.affymetrixListPanel.setLayout(new GridBagLayout());
            AffymetrixFileLoader.this.gba.add(this.affymetrixListPanel, this.affymetrixAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.affymetrixListPanel, this.affymetrixSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.affymetrixListPanel, this.affymetrixAvailableScrollPane, 0, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.affymetrixListPanel, this.affymetrixButtonPanel, 1, 1, 1, 4, 0, 1, 3, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.affymetrixListPanel, this.affymetrixSelectedScrollPane, 2, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.affymetrixSelectionPanel, this.affymetrixListPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.refSelectionPanel = new JPanel();
            this.refSelectionPanel.setLayout(new GridBagLayout());
            this.refSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "Affymetrix Data Options"));
            this.optionsButtonGroup = new ButtonGroup();
            this.absoluteRadioButton = new JRadioButton("Absolute", true);
            this.absoluteRadioButton.addActionListener(new EventHandler());
            this.optionsButtonGroup.add(this.absoluteRadioButton);
            this.absMeanRadioButton = new JRadioButton("Absolute/Mean Intensity");
            this.absMeanRadioButton.addActionListener(new EventHandler());
            this.optionsButtonGroup.add(this.absMeanRadioButton);
            this.referenceRadioButton = new JRadioButton("Reference (Select reference files below)");
            this.referenceRadioButton.addActionListener(new EventHandler());
            this.optionsButtonGroup.add(this.referenceRadioButton);
            this.refAvailableLabel = new JLabel("Available");
            this.refSelectedLabel = new JLabel("Selected");
            this.refAvailableList = new JList(new DefaultListModel());
            this.refAvailableList.setCellRenderer(new ListRenderer());
            this.refSelectedList = new JList(new DefaultListModel());
            this.refSelectedList.setCellRenderer(new ListRenderer());
            this.refAvailableScrollPane = new JScrollPane(this.refAvailableList);
            this.refSelectedScrollPane = new JScrollPane(this.refSelectedList);
            this.refAddButton = new JButton("Add");
            this.refAddButton.addActionListener(new EventHandler());
            this.refAddAllButton = new JButton("Add All");
            this.refAddAllButton.addActionListener(new EventHandler());
            this.refRemoveButton = new JButton("Remove");
            this.refRemoveButton.addActionListener(new EventHandler());
            this.refRemoveAllButton = new JButton("Remove All");
            this.refRemoveAllButton.addActionListener(new EventHandler());
            Dimension dimension2 = this.refRemoveAllButton.getPreferredSize();
            this.refAddButton.setPreferredSize(dimension2);
            this.refAddAllButton.setPreferredSize(dimension2);
            this.refRemoveButton.setPreferredSize(dimension2);
            this.refRemoveAllButton.setPreferredSize(dimension2);
            this.refButtonPanel = new JPanel();
            this.refButtonPanel.setLayout(new GridBagLayout());
            this.affymetrixAddAllButton.setFocusPainted(false);
            this.affymetrixAddButton.setFocusPainted(false);
            this.affymetrixRemoveAllButton.setFocusPainted(false);
            this.affymetrixRemoveButton.setFocusPainted(false);
            this.refAddAllButton.setFocusPainted(false);
            this.refAddButton.setFocusPainted(false);
            this.refRemoveAllButton.setFocusPainted(false);
            this.refRemoveButton.setFocusPainted(false);
            this.referenceRadioButton.setFocusPainted(false);
            this.absoluteRadioButton.setFocusPainted(false);
            this.absMeanRadioButton.setFocusPainted(false);
            AffymetrixFileLoader.this.gba.add(this.refButtonPanel, this.refAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.refButtonPanel, this.refAddAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.refButtonPanel, this.refRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.refButtonPanel, this.refRemoveAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.refListPanel = new JPanel();
            this.refListPanel.setLayout(new GridBagLayout());
            this.refListPanel.setBorder(new TitledBorder(new EtchedBorder(), "Select Reference Files"));
            AffymetrixFileLoader.this.gba.add(this.refListPanel, this.refAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.refListPanel, this.refSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.refListPanel, this.refAvailableScrollPane, 0, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.refListPanel, this.refButtonPanel, 1, 1, 1, 4, 0, 1, 3, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.refListPanel, this.refSelectedScrollPane, 2, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.refSelectionPanel, this.absoluteRadioButton, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 50, 0, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.refSelectionPanel, this.referenceRadioButton, 0, 1, 1, 1, 1, 0, 2, 10, new Insets(5, 50, 0, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.refSelectionPanel, this.absMeanRadioButton, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 0, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.refSelectionPanel, this.refListPanel, 0, 4, 2, 2, 1, 1, 1, 10, new Insets(5, 5, 0, 5), 0, 0);
            this.selectionPanel = new JPanel();
            this.selectionPanel.setLayout(new GridBagLayout());
            AffymetrixFileLoader.this.gba.add(this.selectionPanel, this.pathTextField, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.selectionPanel, this.affymetrixSelectionPanel, 0, 1, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this.selectionPanel, this.refSelectionPanel, 0, 3, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.splitPane = new JSplitPane(1, this.fileTreePane, this.selectionPanel);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            AffymetrixFileLoader.this.gba.add(this.fileLoaderPanel, this.splitPane, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AffymetrixFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        }

        public void setPath(String string) {
            this.pathTextField.setText(string);
        }

        public void openDataPath() {
            this.fileTreePane.openDataPath();
        }

        public void validateLists() {
            if (((DefaultListModel)this.affymetrixSelectedList.getModel()).size() > 0) {
                if (this.referenceRadioButton.isSelected()) {
                    if (((DefaultListModel)this.refSelectedList.getModel()).size() > 0) {
                        AffymetrixFileLoader.this.markLoadEnabled(true);
                    } else {
                        AffymetrixFileLoader.this.markLoadEnabled(false);
                    }
                } else {
                    AffymetrixFileLoader.this.markLoadEnabled(true);
                }
            } else {
                AffymetrixFileLoader.this.markLoadEnabled(false);
            }
        }

        public void onAffymetrixAdd() {
            int n;
            int[] nArray = this.affymetrixAvailableList.getSelectedIndices();
            Object[] objectArray = new Object[nArray.length];
            for (n = nArray.length - 1; n >= 0; --n) {
                Object e = ((DefaultListModel)this.affymetrixAvailableList.getModel()).getElementAt(nArray[n]);
                objectArray[n] = e;
            }
            for (n = 0; n < nArray.length; ++n) {
                ((DefaultListModel)this.affymetrixSelectedList.getModel()).addElement(objectArray[n]);
            }
            this.validateLists();
        }

        public void onAffymetrixAddAll() {
            int n = ((DefaultListModel)this.affymetrixAvailableList.getModel()).size();
            for (int i = 0; i < n; ++i) {
                Object e = ((DefaultListModel)this.affymetrixAvailableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.affymetrixSelectedList.getModel()).addElement(e);
            }
            this.validateLists();
        }

        public void onAffymetrixRemove() {
            int[] nArray = this.affymetrixSelectedList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.affymetrixSelectedList.getModel()).remove(nArray[i]);
            }
            this.validateLists();
        }

        public void onAffymetrixRemoveAll() {
            ((DefaultListModel)this.affymetrixSelectedList.getModel()).removeAllElements();
            this.validateLists();
        }

        public void onRefAdd() {
            int n;
            int[] nArray = this.refAvailableList.getSelectedIndices();
            Object[] objectArray = new Object[nArray.length];
            for (n = nArray.length - 1; n >= 0; --n) {
                Object e = ((DefaultListModel)this.refAvailableList.getModel()).getElementAt(nArray[n]);
                objectArray[n] = e;
            }
            for (n = 0; n < nArray.length; ++n) {
                ((DefaultListModel)this.refSelectedList.getModel()).addElement(objectArray[n]);
            }
            this.validateLists();
        }

        public void onRefAddAll() {
            int n = ((DefaultListModel)this.refAvailableList.getModel()).size();
            for (int i = 0; i < n; ++i) {
                Object e = ((DefaultListModel)this.refAvailableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.refSelectedList.getModel()).addElement(e);
            }
            this.validateLists();
        }

        public void onRefRemove() {
            int[] nArray = this.refSelectedList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.refSelectedList.getModel()).remove(nArray[i]);
            }
            this.validateLists();
        }

        public void onRefRemoveAll() {
            ((DefaultListModel)this.refSelectedList.getModel()).removeAllElements();
            this.validateLists();
        }

        public DefaultListModel getAffymetrixAvailableListModel() {
            return (DefaultListModel)this.affymetrixAvailableList.getModel();
        }

        public DefaultListModel getRefAvailableListModel() {
            return (DefaultListModel)this.refAvailableList.getModel();
        }

        public DefaultListModel getAffymetrixSelectedListModel() {
            return (DefaultListModel)this.affymetrixSelectedList.getModel();
        }

        public DefaultListModel getRefSelectedListModel() {
            return (DefaultListModel)this.refSelectedList.getModel();
        }

        private class FileTreePaneEventHandler
        implements FileTreePaneListener {
            private FileTreePaneEventHandler() {
            }

            public void nodeSelected(FileTreePaneEvent fileTreePaneEvent) {
                String string = (String)fileTreePaneEvent.getValue("Path");
                Vector vector = (Vector)fileTreePaneEvent.getValue("Filenames");
                AffymetrixFileLoader.this.processFileList(string, vector);
            }

            public void nodeCollapsed(FileTreePaneEvent fileTreePaneEvent) {
            }

            public void nodeExpanded(FileTreePaneEvent fileTreePaneEvent) {
            }
        }

        private class EventHandler
        implements ActionListener {
            private EventHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == AffymetrixFileLoaderPanel.this.affymetrixAddButton) {
                    AffymetrixFileLoaderPanel.this.onAffymetrixAdd();
                } else if (object == AffymetrixFileLoaderPanel.this.affymetrixAddAllButton) {
                    AffymetrixFileLoaderPanel.this.onAffymetrixAddAll();
                } else if (object == AffymetrixFileLoaderPanel.this.affymetrixRemoveButton) {
                    AffymetrixFileLoaderPanel.this.onAffymetrixRemove();
                } else if (object == AffymetrixFileLoaderPanel.this.affymetrixRemoveAllButton) {
                    AffymetrixFileLoaderPanel.this.onAffymetrixRemoveAll();
                } else if (object == AffymetrixFileLoaderPanel.this.refAddButton) {
                    AffymetrixFileLoaderPanel.this.onRefAdd();
                } else if (object == AffymetrixFileLoaderPanel.this.refAddAllButton) {
                    AffymetrixFileLoaderPanel.this.onRefAddAll();
                } else if (object == AffymetrixFileLoaderPanel.this.refRemoveButton) {
                    AffymetrixFileLoaderPanel.this.onRefRemove();
                } else if (object == AffymetrixFileLoaderPanel.this.refRemoveAllButton) {
                    AffymetrixFileLoaderPanel.this.onRefRemoveAll();
                } else if (object instanceof JRadioButton) {
                    AffymetrixFileLoader.this.aflp.validateLists();
                }
            }
        }

        private class ListRenderer
        extends DefaultListCellRenderer {
            private ListRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                File file = (File)object;
                this.setText(file.getName());
                return this;
            }
        }
    }
}

