/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.microarray.mev.script.ScriptDocument;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.mev.script.event.ScriptDocumentEvent;
import org.tigr.microarray.mev.script.event.ScriptEventListener;
import org.tigr.microarray.mev.script.scriptGUI.ScriptValueChangeDialog;
import org.tigr.microarray.mev.script.util.AlgorithmNode;

public class ScriptXMLViewer
extends ViewerAdapter {
    private ScriptDocument doc;
    private ScriptManager manager;
    private JTextArea pane;
    private HighlightPanel highlightPanel;
    private LineNumberPanel numPanel;
    private JPopupMenu popup;
    private Font vFont;
    int numLines;
    int prevNumLines;
    private boolean editOnly;
    private File scriptFile;
    private IFramework framework;

    public ScriptXMLViewer(ScriptManager scriptManager) {
        this.manager = scriptManager;
        this.editOnly = false;
        PaneListener paneListener = new PaneListener();
        this.pane = new JTextArea();
        this.pane.setEditable(false);
        this.pane.setSelectedTextColor(Color.red);
        this.pane.setSelectionColor(Color.blue);
        this.pane.setOpaque(false);
        this.pane.setMargin(new Insets(0, 10, 5, 10));
        this.vFont = new Font("Monospaced", 0, 12);
        this.pane.setFont(this.vFont);
        this.numPanel = new LineNumberPanel();
        this.numPanel.addMouseListener(paneListener);
        this.highlightPanel = new HighlightPanel();
        this.highlightPanel.setLayout(new GridBagLayout());
        this.highlightPanel.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pane.addMouseListener(paneListener);
        this.popup = this.createPopupMenu(new MenuListener());
        this.updateSize();
    }

    public ScriptXMLViewer(ScriptDocument scriptDocument, ScriptManager scriptManager) {
        this.doc = scriptDocument;
        this.manager = scriptManager;
        this.doc.addDocumentListener(new ScriptListener());
        this.editOnly = false;
        this.pane = new JTextArea();
        this.pane.setText(this.doc.toString());
        this.pane.setEditable(false);
        this.pane.setLineWrap(false);
        this.pane.setSelectionColor(new Color(120, 160, 210));
        this.pane.setOpaque(false);
        this.pane.setMargin(new Insets(0, 0, 5, 10));
        this.vFont = new Font("Monospaced", 0, 12);
        this.pane.setFont(this.vFont);
        this.numPanel = new LineNumberPanel();
        this.highlightPanel = new HighlightPanel();
        this.highlightPanel.setLayout(new GridBagLayout());
        this.highlightPanel.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pane.addMouseListener(new PaneListener());
        this.popup = this.createPopupMenu(new MenuListener());
        this.updateSize();
    }

    public ScriptXMLViewer(File file) {
        this.editOnly = true;
        this.scriptFile = file;
        this.pane = new JTextArea();
        try {
            String string = this.readScript(file);
            this.pane.setText(string);
        }
        catch (IOException iOException) {
            this.pane.setText(" ");
        }
        this.pane.setCaretPosition(0);
        this.pane.setLineWrap(false);
        this.pane.setSelectionColor(new Color(120, 160, 210));
        this.pane.setOpaque(false);
        this.pane.setMargin(new Insets(0, 0, 5, 10));
        this.vFont = new Font("Monospaced", 0, 12);
        this.pane.setFont(this.vFont);
        this.numPanel = new LineNumberPanel();
        this.numPanel.setHeight(this.pane.getLineCount());
        this.highlightPanel = new HighlightPanel();
        this.highlightPanel.setLayout(new GridBagLayout());
        this.highlightPanel.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pane.addKeyListener(new PaneEditorListener());
        this.pane.addMouseListener(new PaneListener());
        this.popup = this.createPopupMenu(new MenuListener());
        this.updateSize();
    }

    public void setDoc(ScriptDocument scriptDocument) {
        this.doc = scriptDocument;
        this.doc.addDocumentListener(new ScriptListener());
        this.updateSize();
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.doc.updateScript();
        this.numPanel.clearSelection();
        this.updateSize();
    }

    private void updateSize() {
        if (this.doc == null) {
            return;
        }
        this.pane.setText(this.doc.toString());
        String string = " ";
        try {
            string = this.pane.getDocument().getText(0, this.pane.getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.prevNumLines = this.numLines;
        this.numLines = this.pane.getLineCount();
        this.numPanel.setHeight(this.numLines);
        this.prevNumLines = this.numLines;
        this.pane.setCaretPosition(0);
    }

    public String getText() {
        return this.pane.getText();
    }

    public void update() {
        this.updateSize();
    }

    public JComponent getContentComponent() {
        return this.highlightPanel;
    }

    public JComponent getRowHeaderComponent() {
        return this.numPanel;
    }

    public void highlightAlgorithmNode(AlgorithmNode algorithmNode) {
        String string = algorithmNode.getAlgorithmName();
        String string2 = String.valueOf(algorithmNode.getID());
        String string3 = String.valueOf(algorithmNode.getDataNodeRef());
        int n = this.getAlgMatch(string, string2, string3);
        int n2 = this.pane.getLineCount();
        int n3 = -1;
        for (int i = n; i < n2; ++i) {
            String string4;
            try {
                int n4 = this.pane.getLineStartOffset(i);
                int n5 = this.pane.getLineEndOffset(i);
                string4 = this.pane.getText(n4, n5 - n4);
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            if (string4.indexOf("/algorithm") == -1) continue;
            n3 = i + 1;
            break;
        }
        if (n3 > n) {
            this.mark(n, n3);
        }
    }

    private int getAlgMatch(String string, String string2, String string3) {
        int n = this.pane.getLineCount();
        Document document = this.pane.getDocument();
        Vector vector = new Vector();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            String string4;
            try {
                int n2 = this.pane.getLineStartOffset(i);
                int n3 = this.pane.getLineEndOffset(i);
                string4 = this.pane.getText(n2, n3 - n2);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
            bl = false;
            if (string4.indexOf(string) != -1 && string4.indexOf("algorithm") != -1) {
                bl = true;
                int n4 = string4.indexOf("alg_id");
                String string5 = string4.substring(n4, string4.length() - 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string5, "\"");
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                }
                if (bl = string5.equals(string2)) {
                    n4 = string4.indexOf("data_ref");
                    string5 = string4.substring(n4, string4.length() - 1);
                    stringTokenizer = new StringTokenizer(string5, "\"");
                    if (stringTokenizer.hasMoreTokens()) {
                        stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string5 = stringTokenizer.nextToken();
                    }
                    bl = string5.equals(string3);
                }
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    private void mark(int n, int n2) {
        this.highlightPanel.setSelection(n, n2);
        this.highlightPanel.repaint();
        if (n2 > n) {
            this.setEnableMenuItem("Clear Overlay", true);
        } else {
            this.setEnableMenuItem("Clear Overlay", false);
        }
    }

    private JPopupMenu createPopupMenu(MenuListener menuListener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (!this.editOnly) {
            jPopupMenu.add(this.createItem("Edit", "edit-cmd", "Enabled when parameter key/value or algorithm is selected", menuListener, false));
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.createItem("Clear Overlay", "clear-overlay-cmd", "Clears the algorithm overlay area if present", menuListener, false));
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(this.createItem("Save Script", "save-cmd", "Save script to file", menuListener, true));
        return jPopupMenu;
    }

    private JMenuItem createItem(String string, String string2, String string3, MenuListener menuListener, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setEnabled(bl);
        jMenuItem.setFocusPainted(false);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(menuListener);
        return jMenuItem;
    }

    private void setEnableMenuItem(String string, boolean bl) {
        int n = this.popup.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.popup.getComponent(i);
            if (!(component instanceof JMenuItem) || !((JMenuItem)component).getText().equals(string)) continue;
            ((JMenuItem)component).setEnabled(bl);
            break;
        }
    }

    private String readScript(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = new String();
        String string2 = new String();
        while ((string2 = bufferedReader.readLine()) != null) {
            string = string + string2 + "\n";
        }
        return string;
    }

    private void saveScript() {
        JFileChooser jFileChooser = this.scriptFile != null ? new JFileChooser(this.scriptFile.getPath()) : new JFileChooser(TMEV.getFile("/data/scripts/"));
        if (jFileChooser.showSaveDialog(new JPanel()) == 0) {
            try {
                this.writeScript(jFileChooser.getSelectedFile());
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.pane, "An error occured while saving the script to file", "Save Error", 2);
            }
        }
    }

    private void writeScript(File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(this.pane.getText());
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    private Hashtable getAlgorithmAttributes(int n) {
        int n2;
        String string = this.pane.getText();
        string = string.substring(0, n);
        n = string.lastIndexOf("algorithm");
        Hashtable hashtable = null;
        if (n > -1 && (n2 = (string = string.substring(n)).indexOf(">")) != -1) {
            string = string.substring(0, n2);
            hashtable = this.getAlgorithmAttributes(string);
        }
        return hashtable;
    }

    private Hashtable getAlgorithmAttributes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("alg_id") != -1) {
                hashtable.put("alg_id", stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : " ");
                continue;
            }
            if (string2.indexOf("alg_name") != -1) {
                hashtable.put("alg_name", stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : " ");
                continue;
            }
            if (string2.indexOf("input_data_ref") != -1) {
                hashtable.put("input_data_ref", stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : " ");
                continue;
            }
            if (string2.indexOf("alg_type") == -1) continue;
            hashtable.put("alg_type", stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : " ");
        }
        return hashtable;
    }

    public class ScriptListener
    implements ScriptEventListener {
        public void documentChanged(ScriptDocumentEvent scriptDocumentEvent) {
            ScriptXMLViewer.this.updateSize();
        }
    }

    public class HighlightPanel
    extends JPanel {
        int start;
        int end;
        int top;
        int bottom;
        boolean algOverlay;

        public HighlightPanel() {
            super.setBackground(Color.white);
            this.setBackground(Color.white);
            this.algOverlay = false;
            this.end = -1;
            this.start = -1;
        }

        public void setSelection(int n, int n2) {
            this.start = n;
            this.end = n2;
            this.algOverlay = n2 > n;
        }

        public boolean haveOverlay() {
            return this.algOverlay;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.start > 0) {
                Color color = graphics.getColor();
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.2f));
                graphics.setColor(Color.green);
                graphics.fillRect(0, this.start * ((ScriptXMLViewer)ScriptXMLViewer.this).numPanel.lineHeight, this.getWidth(), (this.end - this.start) * ((ScriptXMLViewer)ScriptXMLViewer.this).numPanel.lineHeight);
                graphics.setColor(color);
                graphics2D.setComposite(composite);
            }
        }
    }

    public class LineNumberPanel
    extends JPanel {
        boolean newHeight = false;
        JList list = new JList();
        DefaultListModel model;
        int lineHeight;

        public LineNumberPanel() {
            super(new GridBagLayout());
            this.list.setAlignmentX(1.0f);
            this.model = new DefaultListModel();
            this.list.setModel(this.model);
            this.list.setCellRenderer(new NumberPanelCellRenderer());
            this.list.setForeground(Color.red);
            this.list.setFont(ScriptXMLViewer.this.vFont);
            this.setFont(ScriptXMLViewer.this.vFont);
            this.list.setBackground(Color.lightGray);
            this.list.setVisibleRowCount(0);
            this.list.setVisible(true);
            FontMetrics fontMetrics = ScriptXMLViewer.this.pane.getFontMetrics(ScriptXMLViewer.this.pane.getFont());
            this.list.setFixedCellHeight(fontMetrics.getHeight());
            this.lineHeight = this.list.getFixedCellHeight();
            this.setPreferredSize(new Dimension(10, 10));
            this.add((Component)this.list, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (!ScriptXMLViewer.this.editOnly) {
                this.list.addMouseListener(new LineNumberListener());
                this.addMouseListener(new LineNumberListener());
            }
        }

        public void setHeight(int n) {
            boolean bl = false;
            this.newHeight = true;
            if (n > this.model.size() + 1) {
                bl = true;
                this.newHeight = true;
                for (int i = this.model.size() + 1; i < n; ++i) {
                    JLabel jLabel = new JLabel(String.valueOf(i));
                    jLabel.setFont(ScriptXMLViewer.this.vFont);
                    jLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
                    jLabel.setHorizontalAlignment(4);
                    jLabel.setHorizontalTextPosition(4);
                    this.model.addElement(jLabel);
                }
            }
            this.list.setVisibleRowCount(n);
        }

        public void clearSelection() {
            this.list.clearSelection();
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.newHeight) {
                this.newHeight = false;
                String string = ((JLabel)this.model.elementAt(this.model.size() - 1)).getText();
                int n = 8;
                if (graphics != null) {
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    fontMetrics.stringWidth(string);
                    this.list.setSize(fontMetrics.stringWidth(string) + n, ScriptXMLViewer.this.pane.getHeight());
                    this.list.setPreferredSize(new Dimension(fontMetrics.stringWidth(string) + n, ScriptXMLViewer.this.pane.getHeight()));
                    this.setSize(fontMetrics.stringWidth(string) + n, ScriptXMLViewer.this.pane.getHeight());
                    this.setPreferredSize(new Dimension(fontMetrics.stringWidth(string) + n, ScriptXMLViewer.this.pane.getHeight()));
                }
            }
        }

        public class LineNumberListener
        extends MouseAdapter {
            public void mouseClicked(MouseEvent mouseEvent) {
                int[] nArray = LineNumberPanel.this.list.getSelectedIndices();
                if (nArray != null) {
                    int n;
                    int n2;
                    try {
                        n2 = ScriptXMLViewer.this.pane.getLineStartOffset(nArray[0]);
                        n = ScriptXMLViewer.this.pane.getLineEndOffset(nArray[nArray.length - 1]);
                        ScriptXMLViewer.this.pane.getHighlighter().removeAllHighlights();
                        ScriptXMLViewer.this.pane.getHighlighter().addHighlight(n2, n, new DefaultHighlighter.DefaultHighlightPainter(new Color(120, 160, 210)));
                    }
                    catch (BadLocationException badLocationException) {
                        return;
                    }
                    ScriptXMLViewer.this.pane.select(n2, n);
                    ScriptXMLViewer.this.pane.repaint();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                int[] nArray = LineNumberPanel.this.list.getSelectedIndices();
                if (nArray != null) {
                    int n;
                    int n2;
                    try {
                        n2 = ScriptXMLViewer.this.pane.getLineStartOffset(nArray[0]);
                        n = ScriptXMLViewer.this.pane.getLineEndOffset(nArray[nArray.length - 1]);
                        ScriptXMLViewer.this.pane.getHighlighter().removeAllHighlights();
                        ScriptXMLViewer.this.pane.getHighlighter().addHighlight(n2, n, new DefaultHighlighter.DefaultHighlightPainter(new Color(120, 160, 210)));
                    }
                    catch (BadLocationException badLocationException) {
                        return;
                    }
                    ScriptXMLViewer.this.pane.select(n2, n);
                    ScriptXMLViewer.this.pane.repaint();
                }
            }
        }

        public class NumberPanelCellRenderer
        implements ListCellRenderer {
            Icon selIcon = GUIFactory.getIcon((String)"TreeBallLeaf.gif");
            JLabel selectedLabel = new JLabel(this.selIcon);

            public NumberPanelCellRenderer() {
                this.selectedLabel.setBackground(Color.gray);
                this.selectedLabel.setOpaque(true);
                this.selectedLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
                this.selectedLabel.setIconTextGap(0);
                this.selectedLabel.setHorizontalAlignment(4);
                this.selectedLabel.setHorizontalTextPosition(4);
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (bl && !ScriptXMLViewer.this.editOnly) {
                    return this.selectedLabel;
                }
                return (JLabel)object;
            }
        }
    }

    private class MenuListener
    implements ActionListener {
        private MenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("edit-cmd")) {
                String string2 = ScriptXMLViewer.this.pane.getSelectedText();
                if (string2 == null) {
                    return;
                }
                String string3 = new String(string2);
                int n = ScriptXMLViewer.this.pane.getSelectionStart();
                Hashtable hashtable = ScriptXMLViewer.this.getAlgorithmAttributes(n);
                String string4 = (String)hashtable.get("alg_name");
                ScriptValueChangeDialog scriptValueChangeDialog = new ScriptValueChangeDialog(string3, string4, ScriptXMLViewer.this.manager);
                if (scriptValueChangeDialog.showModal() == 0) {
                    string3 = scriptValueChangeDialog.getLine();
                    String string5 = scriptValueChangeDialog.getValue();
                    if (string5 != null && ScriptXMLViewer.this.doc.modifyParameter(hashtable, scriptValueChangeDialog.getLine(), scriptValueChangeDialog.getValue())) {
                        ScriptXMLViewer.this.doc.updateScript();
                        ScriptXMLViewer.this.pane.setText(ScriptXMLViewer.this.doc.toString());
                        ScriptXMLViewer.this.pane.setCaretPosition(n);
                    }
                    try {
                        ScriptXMLViewer.this.pane.getHighlighter().addHighlight(n, n + string3.length(), new DefaultHighlighter.DefaultHighlightPainter(new Color(120, 160, 210)));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    ScriptXMLViewer.this.pane.select(n, n + string3.length());
                }
            } else if (string.equals("clear-overlay-cmd")) {
                ScriptXMLViewer.this.mark(-1, -1);
            } else if (!string.equals("mark-algorithm-cmd") && string.equals("save-cmd")) {
                ScriptXMLViewer.this.saveScript();
            }
        }
    }

    public class PaneListener
    extends MouseAdapter {
        int start;
        int end;
        String text;

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16) {
                if (!ScriptXMLViewer.this.editOnly) {
                    ((ScriptXMLViewer)ScriptXMLViewer.this).numPanel.list.clearSelection();
                    ScriptXMLViewer.this.pane.getHighlighter().removeAllHighlights();
                }
            } else if (mouseEvent.isPopupTrigger()) {
                this.start = ScriptXMLViewer.this.pane.getSelectionStart();
                this.end = ScriptXMLViewer.this.pane.getSelectionEnd();
                if (this.end > this.start) {
                    this.text = ScriptXMLViewer.this.pane.getSelectedText();
                    ScriptXMLViewer.this.setEnableMenuItem("Edit", this.text.indexOf("value") != -1);
                } else {
                    ScriptXMLViewer.this.setEnableMenuItem("Edit", false);
                }
                ScriptXMLViewer.this.setEnableMenuItem("Clear Overlay", ScriptXMLViewer.this.highlightPanel.haveOverlay());
                ScriptXMLViewer.this.popup.show(ScriptXMLViewer.this.pane, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16) {
                if (!ScriptXMLViewer.this.editOnly) {
                    ((ScriptXMLViewer)ScriptXMLViewer.this).numPanel.list.clearSelection();
                    ScriptXMLViewer.this.pane.getHighlighter().removeAllHighlights();
                }
            } else if (mouseEvent.isPopupTrigger()) {
                this.start = ScriptXMLViewer.this.pane.getSelectionStart();
                this.end = ScriptXMLViewer.this.pane.getSelectionEnd();
                if (this.end > this.start) {
                    this.text = ScriptXMLViewer.this.pane.getSelectedText();
                    ScriptXMLViewer.this.setEnableMenuItem("Edit", this.text.indexOf("value") != -1);
                } else {
                    ScriptXMLViewer.this.setEnableMenuItem("Edit", false);
                }
                ScriptXMLViewer.this.setEnableMenuItem("Clear Overlay", ScriptXMLViewer.this.highlightPanel.haveOverlay());
                ScriptXMLViewer.this.popup.show(ScriptXMLViewer.this.pane, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16) {
                if (!ScriptXMLViewer.this.editOnly) {
                    ((ScriptXMLViewer)ScriptXMLViewer.this).numPanel.list.clearSelection();
                    ScriptXMLViewer.this.pane.getHighlighter().removeAllHighlights();
                }
            } else if (mouseEvent.isPopupTrigger()) {
                this.start = ScriptXMLViewer.this.pane.getSelectionStart();
                this.end = ScriptXMLViewer.this.pane.getSelectionEnd();
                if (this.end > this.start) {
                    this.text = ScriptXMLViewer.this.pane.getSelectedText();
                    ScriptXMLViewer.this.setEnableMenuItem("Edit", this.text.indexOf("value") != -1);
                } else {
                    ScriptXMLViewer.this.setEnableMenuItem("Edit", false);
                }
                ScriptXMLViewer.this.setEnableMenuItem("Clear Overlay", ScriptXMLViewer.this.highlightPanel.haveOverlay());
                ScriptXMLViewer.this.popup.show(ScriptXMLViewer.this.pane, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public class PaneEditorListener
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                ScriptXMLViewer.this.numPanel.setHeight(ScriptXMLViewer.this.pane.getLineCount());
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                ScriptXMLViewer.this.numPanel.setHeight(ScriptXMLViewer.this.pane.getLineCount());
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                ScriptXMLViewer.this.numPanel.setHeight(ScriptXMLViewer.this.pane.getLineCount());
            }
        }
    }
}

