/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote;

import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.remote.RemoteException;
import org.tigr.remote.communication.ClientCommunicator;
import org.tigr.remote.communication.CommunicatorFactory;
import org.tigr.remote.communication.JobControl;
import org.tigr.remote.protocol.ExecutedJob;
import org.tigr.remote.protocol.FailedJob;
import org.tigr.remote.protocol.FinishedJob;
import org.tigr.remote.protocol.JobData;
import org.tigr.remote.protocol.JobVisitor;
import org.tigr.remote.protocol.StartJob;
import org.tigr.remote.protocol.SuccessfulJob;

public class RemoteAlgorithm
extends AbstractAlgorithm {
    private String name;
    private JobControl control;

    public RemoteAlgorithm(String string) {
        this.name = string;
    }

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        try {
            ClientCommunicator clientCommunicator = CommunicatorFactory.getCommunicator();
            StartJob startJob = new StartJob(clientCommunicator.getNewJobId(), new JobData(algorithmData), this.name);
            this.control = clientCommunicator.postJob(startJob);
            JobExecution jobExecution = new JobExecution(this);
            do {
                FinishedJob finishedJob = this.control.getResult();
                finishedJob.accept(jobExecution);
            } while (jobExecution.getResult() == null);
            return jobExecution.getResult();
        }
        catch (Exception exception) {
            throw new AlgorithmException(exception);
        }
    }

    public void abort() {
        if (this.control == null) {
            throw new RuntimeException("Not started yet");
        }
        try {
            this.control.terminate();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Abort error");
        }
    }

    public class JobExecution
    implements JobVisitor {
        private RemoteAlgorithm ra;
        private AlgorithmData result;

        public JobExecution(RemoteAlgorithm remoteAlgorithm2) {
            this.ra = remoteAlgorithm2;
        }

        public AlgorithmData getResult() {
            return this.result;
        }

        public void visitSuccessfulJob(SuccessfulJob successfulJob) {
            this.result = successfulJob.getData().getData();
        }

        public void visitFailedJob(FailedJob failedJob) {
            throw new RuntimeException("Server error: " + failedJob.getFail().getDescription());
        }

        public void visitExecutedJob(ExecutedJob executedJob) {
            AlgorithmEvent algorithmEvent = executedJob.getEvent();
            this.ra.fireValueChanged(new AlgorithmEvent((Object)this, algorithmEvent.getId(), algorithmEvent.getIntValue(), algorithmEvent.getFloatValue(), algorithmEvent.getDescription()));
        }
    }
}

