/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.stat;

import drasys.or.matrix.VectorI;
import drasys.or.prob.NormalDistribution;
import drasys.or.prob.StudentsTDistribution;
import drasys.or.stat.StatError;

public class PopulationMean {
    static final int _smallSampleSize = 100;
    static NormalDistribution _z = new NormalDistribution();
    StudentsTDistribution _st;
    int _n;
    double _std;
    double _mean;
    double _ci;
    double _lastCl = Double.NEGATIVE_INFINITY;

    public PopulationMean(int n, double d, double d2) {
        this._n = n;
        if (this._n < 2) {
            throw new StatError("The sample size can't be less than '2'.");
        }
        this._mean = d;
        this._std = d2;
    }

    public PopulationMean(VectorI vectorI) {
        this._n = vectorI.size();
        if (this._n < 2) {
            throw new StatError("The sample size can't be less than '2'.");
        }
        this._mean = vectorI.sum() / (double)this._n;
        this._std = Math.sqrt(vectorI.sumOfSquaredDifferences(this._mean) / ((double)this._n - 1.0));
    }

    private void getCi(double d) {
        if (this._n <= 100) {
            if (this._st == null) {
                this._st = new StudentsTDistribution((double)(this._n - 1));
            }
            this._ci = this._st.inverseCdf(1.0 - 0.5 * (1.0 - d)) * this._std / Math.sqrt(this._n);
        } else {
            this._ci = _z.inverseCdf(1.0 - 0.5 * (1.0 - d)) * this._std / Math.sqrt(this._n);
        }
        this._lastCl = d;
    }

    public double getLowerBound(double d) {
        if (this._lastCl != d) {
            this.getCi(d);
        }
        return this._mean - this._ci;
    }

    public double getMean() {
        return this._mean;
    }

    public double getStd() {
        return this._std;
    }

    public double getUpperBound(double d) {
        if (this._lastCl != d) {
            this.getCi(d);
        }
        return this._mean + this._ci;
    }

    public static int sampleSize(double d, double d2, double d3) {
        if (d < 0.0) {
            throw new StatError("The 'std' must be positive");
        }
        if (d2 < 0.0) {
            throw new StatError("The 'confidenceLevel' must be >= 0.0");
        }
        if (d2 > 1.0) {
            throw new StatError("The 'confidenceLevel' must be <= 1.0");
        }
        double d4 = 1.0 - 0.5 * (1.0 - d2);
        double d5 = _z.inverseCdf(d4) * d / d3;
        return (int)Math.ceil(d5 * d5);
    }

    public double size() {
        return this._n;
    }
}

