/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.stat.model;

import drasys.or.linear.algebra.AlgebraException;
import drasys.or.linear.algebra.QRIteration;
import drasys.or.matrix.DenseMatrix;
import drasys.or.matrix.DenseVector;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.VectorI;
import drasys.or.stat.model.GeneralLinearModelI;

public class GeneralLinearModel
implements GeneralLinearModelI {
    private int _ns;
    private int _nvd;
    private int _nvi;
    private int[] _select;
    private MatrixI _a;
    private MatrixI _invXX;
    private VectorI _y;
    private double _eps;
    private double _esq;
    private double _msq;
    private double _tsq;
    private double _mean;
    private double[] _w;
    private VectorI _rhs;
    private VectorI _coef;
    private VectorI _stdv;
    private double[][] _u;
    private double[][] _v;
    private QRIteration _svd = new QRIteration();
    private boolean _solved;
    private boolean _zeroIntercept;

    public GeneralLinearModel(VectorI vectorI, MatrixI matrixI) {
        this._y = vectorI;
        this._a = matrixI;
        if (vectorI.size() != matrixI.sizeOfRows()) {
            throw new Error("The dependent vector size must match the row size of the independent matrix.");
        }
        this._ns = vectorI.size();
        this._eps = this._a.getEpsilon();
        this._mean = vectorI.sum() / (double)this._ns;
        this._tsq = vectorI.sumOfSquaredDifferences(this._mean);
    }

    private void _fill() {
        if (this._w == null || this._w.length < this._nvi) {
            this._w = new double[this._nvi];
            this._coef = new DenseVector(this._nvi);
            this._u = new double[this._ns][this._nvi];
            this._v = new double[this._nvi][this._nvi];
        }
        int n = 0;
        while (n < this._ns) {
            double[] dArray = this._u[n];
            int n2 = 0;
            while (n2 < this._nvd) {
                dArray[n2] = this._a.elementAt(n, this._select[n2]);
                ++n2;
            }
            if (!this._zeroIntercept) {
                dArray[this._nvd] = 1.0;
            }
            ++n;
        }
    }

    private void _solve() {
        this._solved = false;
        this._stdv = null;
        this._invXX = null;
        this._nvd = this._select.length;
        this._nvi = this._zeroIntercept ? this._nvd : this._nvd + 1;
        this._fill();
        try {
            this._svd.decompose(this._ns, this._nvi, this._u, this._w, this._v, this._eps);
            double d = 0.0;
            int n = 0;
            while (n < this._nvi) {
                d = Math.max(d, this._w[n]);
                ++n;
            }
            double d2 = d * this._eps;
            int n2 = 0;
            while (n2 < this._nvi) {
                if (this._w[n2] < d2) {
                    this._w[n2] = 0.0;
                }
                ++n2;
            }
            this._svd.solveEquations(this._y, this._coef);
        }
        catch (AlgebraException algebraException) {
            throw new Error("Got Algebra Exception" + algebraException.getMessage());
        }
        this._esq = 0.0;
        this._msq = 0.0;
        int n = 0;
        while (n < this._ns) {
            double d = this._zeroIntercept ? 0.0 : this._coef.elementAt(this._nvd);
            int n3 = 0;
            while (n3 < this._nvd) {
                d += this._coef.elementAt(n3) * this._a.elementAt(n, this._select[n3]);
                ++n3;
            }
            double d3 = this._y.elementAt(n) - d;
            this._esq += d3 * d3;
            d3 = this._mean - d;
            this._msq += d3 * d3;
            ++n;
        }
        this._solved = true;
    }

    public VectorI getCoefficients() {
        if (!this._solved) {
            throw new Error("The GLM is not solved.");
        }
        return new DenseVector(this._coef);
    }

    public int getDFE() {
        return this.getDFT() - this.getDFR();
    }

    public int getDFR() {
        return this._nvd;
    }

    public int getDFT() {
        return this._ns - 1;
    }

    public VectorI getDependent() {
        return this._y;
    }

    public MatrixI getIndependent() {
        return this._a;
    }

    public MatrixI getInverseXX() {
        if (!this._solved) {
            throw new Error("The GLM is not solved.");
        }
        if (this._invXX != null) {
            return this._invXX;
        }
        this._invXX = new DenseMatrix(this._nvi, this._nvi);
        double[] dArray = new double[this._nvi];
        int n = 0;
        while (n < this._nvi) {
            if (this._w[n] != 0.0) {
                dArray[n] = 1.0 / (this._w[n] * this._w[n]);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this._nvi) {
            int n3 = 0;
            while (n3 <= n2) {
                double d = 0.0;
                int n4 = 0;
                while (n4 < this._nvi) {
                    d += this._v[n2][n4] * this._v[n3][n4] * dArray[n4];
                    ++n4;
                }
                this._invXX.setElementAt(n3, n2, d);
                this._invXX.setElementAt(n2, n3, d);
                ++n3;
            }
            ++n2;
        }
        return this._invXX;
    }

    public double getMSE() {
        return this.getSSE() / (double)this.getDFE();
    }

    public double getMSR() {
        return this.getSSR() / (double)this.getDFR();
    }

    public double getMST() {
        return this.getSST() / (double)this.getDFT();
    }

    public double getRSquared() {
        return this._msq / this._tsq;
    }

    public double getSSE() {
        return this._esq;
    }

    public double getSSR() {
        return this._msq;
    }

    public double getSST() {
        return this._tsq;
    }

    public VectorI getStandardErrors() {
        if (!this._solved) {
            throw new Error("The GLM is not solved.");
        }
        if (this._stdv != null) {
            return this._stdv;
        }
        this._stdv = new DenseVector(this._nvi);
        double[] dArray = new double[this._nvi];
        int n = 0;
        while (n < this._nvi) {
            if (this._w[n] != 0.0) {
                dArray[n] = 1.0 / (this._w[n] * this._w[n]);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this._nvi) {
            double d = 0.0;
            int n3 = 0;
            while (n3 < this._nvi) {
                double d2 = this._v[n2][n3];
                d += d2 * d2 * dArray[n3];
                ++n3;
            }
            this._stdv.setElementAt(n2, Math.sqrt(this.getMSE() * d));
            ++n2;
        }
        return this._stdv;
    }

    public VectorI solve() {
        return this.solve(false, null);
    }

    public VectorI solve(boolean bl) {
        return this.solve(bl, null);
    }

    public VectorI solve(boolean bl, int[] nArray) {
        if (nArray == null) {
            this._select = new int[this._a.sizeOfColumns()];
            int n = 0;
            while (n < this._select.length) {
                this._select[n] = n;
                ++n;
            }
        } else {
            this._select = nArray;
            int n = 0;
            while (n < this._select.length) {
                int n2 = this._a.sizeOfColumns();
                if (this._select[n] >= n2) {
                    throw new Error("columnSelection[" + n + "] = " + this._select[n] + " too large for the independent columns (" + n2 + ").");
                }
                ++n;
            }
        }
        this._zeroIntercept = bl;
        this._solve();
        return this.getCoefficients();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(4096);
        stringBuffer.append("------------------------------\n");
        stringBuffer.append("---- General Linear Model ----\n");
        stringBuffer.append("------------------------------\n");
        if (!this._solved) {
            stringBuffer.append("NO SOLUTION\n");
            return stringBuffer.toString();
        }
        stringBuffer.append("\n");
        stringBuffer.append("R-Squared        = " + this.getRSquared() + "\n");
        stringBuffer.append("\n");
        stringBuffer.append("REGRESSION\n");
        stringBuffer.append("  Degrees of freedom (DFR) = ").append(this.getDFR()).append("\n");
        stringBuffer.append("  Sum of squares     (SSR) = ").append(this.getSSR()).append("\n");
        stringBuffer.append("  Mean squared       (MSR) = ").append(this.getMSR()).append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("ERROR\n");
        stringBuffer.append("  Degrees of freedom (DFE) = ").append(this.getDFE()).append("\n");
        stringBuffer.append("  Sum of squares     (SSE) = ").append(this.getSSE()).append("\n");
        stringBuffer.append("  Mean squared       (MSE) = ").append(this.getMSE()).append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("TOTAL\n");
        stringBuffer.append("  Degrees of freedom (DFT) = ").append(this.getDFT()).append("\n");
        stringBuffer.append("  Sum of squares     (SST) = ").append(this.getSST()).append("\n");
        stringBuffer.append("  Mean squared       (MST) = ").append(this.getMST()).append("\n");
        stringBuffer.append("\n");
        int n = this._nvd;
        if (!this._zeroIntercept) {
            stringBuffer.append("INTERCEPT\n");
            stringBuffer.append("  Coefficient    = ").append(this._coef.elementAt(n)).append("\n");
            stringBuffer.append("  Standard Error = ").append(this._stdv.elementAt(n)).append("\n");
            stringBuffer.append("\n");
        }
        this.getStandardErrors();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this._select[n2];
            stringBuffer.append("COLUMN-").append(n3).append("\n");
            stringBuffer.append("  Coefficient    = ").append(this._coef.elementAt(n2)).append("\n");
            stringBuffer.append("  Standard Error = ").append(this._stdv.elementAt(n2)).append("\n");
            stringBuffer.append("\n");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

