/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.io.DataOutputStream;
import java.io.OutputStream;
import javax.media.j3d.J3dNodeTable;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;

class J3dDataOutputStream
extends DataOutputStream {
    J3dNodeTable nodeTable = new J3dNodeTable();

    J3dDataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    int getNodeValue(Object object) {
        return this.nodeTable.getNodeValue(object);
    }

    Object getObject(int n) {
        return this.nodeTable.getObject(n);
    }

    void writeArray(Object object) {
        if (object instanceof byte[]) {
            this.writeByteArray((byte[])object);
        } else if (object instanceof int[]) {
            this.writeIntArray((int[])object);
        } else if (object instanceof float[]) {
            this.writeFloatArray((float[])object);
        } else if (object instanceof double[]) {
            this.writeDoubleArray((double[])object);
        } else if (object instanceof short[]) {
            this.writeShortArray((short[])object);
        }
    }

    void writeByteArray(byte[] byArray) {
        try {
            if (byArray != null) {
                this.write(byArray);
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in writeDoubleArray: " + exception);
        }
    }

    void writeColor3f(Color3f color3f) {
        try {
            this.writeFloat(color3f.x);
            this.writeFloat(color3f.y);
            this.writeFloat(color3f.z);
        }
        catch (Exception exception) {
            System.err.println("Exception in writeColor3f: " + exception);
        }
    }

    void writeColor4f(Color4f color4f) {
        try {
            this.writeFloat(color4f.x);
            this.writeFloat(color4f.y);
            this.writeFloat(color4f.z);
            this.writeFloat(color4f.w);
        }
        catch (Exception exception) {
            System.err.println("Exception in writeColor3f: " + exception);
        }
    }

    void writeDoubleArray(double[] dArray) {
        try {
            if (dArray != null) {
                int n = 0;
                while (n < dArray.length) {
                    this.writeDouble(dArray[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in writeDoubleArray: " + exception);
        }
    }

    void writeFloatArray(float[] fArray) {
        try {
            if (fArray != null) {
                int n = 0;
                while (n < fArray.length) {
                    this.writeFloat(fArray[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in writeFloatArray: " + exception);
        }
    }

    void writeIntArray(int[] nArray) {
        try {
            if (nArray != null) {
                int n = 0;
                while (n < nArray.length) {
                    this.writeInt(nArray[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in writeIntArray: " + exception);
        }
    }

    void writeShortArray(short[] sArray) {
        try {
            if (sArray != null) {
                int n = 0;
                while (n < sArray.length) {
                    this.writeShort(sArray[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in writeDoubleArray: " + exception);
        }
    }

    void writeTuple3d(Tuple3d tuple3d) {
        try {
            this.writeDouble(tuple3d.x);
            this.writeDouble(tuple3d.y);
            this.writeDouble(tuple3d.z);
        }
        catch (Exception exception) {
            System.err.println("Exception in writeTuple3d: " + exception);
        }
    }

    void writeTuple3f(Tuple3f tuple3f) {
        try {
            this.writeFloat(tuple3f.x);
            this.writeFloat(tuple3f.y);
            this.writeFloat(tuple3f.z);
        }
        catch (Exception exception) {
            System.err.println("Exception in writeTuple3f: " + exception);
        }
    }
}

