/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Canvas3D;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

class OrientedShape3DRetained
extends Shape3DRetained {
    int mode = 0;
    Vector3f axis = new Vector3f(0.0f, 1.0f, 0.0f);
    Point3f rotationPoint = new Point3f(0.0f, 0.0f, 1.0f);
    private Vector3d nAxis = new Vector3d(0.0, 1.0, 0.0);
    private Point3d viewPosition = new Point3d();
    private Point3d yUpPoint = new Point3d();
    private Vector3d eyeVec = new Vector3d();
    private Vector3d yUp = new Vector3d();
    private Vector3d zAxis = new Vector3d();
    private Vector3d yAxis = new Vector3d();
    private Vector3d vector = new Vector3d();
    private AxisAngle4d aa = new AxisAngle4d();
    private Transform3D xform = new Transform3D();
    Transform3D orientedTransform = new Transform3D();
    private Transform3D zRotate = new Transform3D();
    boolean orientedTransformDirty = true;

    public OrientedShape3DRetained() {
        this.nodeType = 28;
    }

    void getAlignmentAxis(Vector3f vector3f) {
        vector3f.set((Tuple3f)this.axis);
    }

    int getAlignmentMode() {
        return this.mode;
    }

    void getRotationPoint(Point3f point3f) {
        point3f.set((Tuple3f)this.rotationPoint);
    }

    void initAlignmentAxis(float f, float f2, float f3) {
        this.axis.set(f, f2, f3);
        double d = 1.0 / Math.sqrt(this.axis.x * this.axis.x + this.axis.y * this.axis.y + this.axis.z * this.axis.z);
        this.nAxis.x = (double)this.axis.x * d;
        this.nAxis.y = (double)this.axis.y * d;
        this.nAxis.z = (double)this.axis.z * d;
    }

    void initAlignmentAxis(Vector3f vector3f) {
        this.initAlignmentAxis(vector3f.x, vector3f.y, vector3f.z);
    }

    void initAlignmentMode(int n) {
        this.mode = n;
    }

    void initRotationPoint(float f, float f2, float f3) {
        this.rotationPoint.set(f, f2, f3);
    }

    void initRotationPoint(Point3f point3f) {
        this.rotationPoint.set((Tuple3f)point3f);
    }

    private void projectToPlane(Vector3d vector3d, Vector3d vector3d2) {
        double d = vector3d2.dot(vector3d);
        vector3d.x -= vector3d2.x * d;
        vector3d.y -= vector3d2.y * d;
        vector3d.z -= vector3d2.z * d;
        double d2 = vector3d.length();
        if (d2 < 1.0E-4) {
            vector3d.x = -vector3d2.y;
            vector3d.y = vector3d2.z;
            vector3d.z = vector3d2.x;
            vector3d.cross(vector3d2, vector3d2);
            d2 = vector3d.length();
        }
        vector3d.scale(1.0 / d2);
    }

    void sendChangedMessage() {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.type = 46;
        j3dMessage.threads = 128;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = Shape3DRetained.getGeomAtomsList(this.mirrorShape3D).toArray();
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void setAlignmentAxis(float f, float f2, float f3) {
        this.initAlignmentAxis(f, f2, f3);
        int n = 0;
        while (n < this.mirrorShape3D.size()) {
            OrientedShape3DRetained orientedShape3DRetained = (OrientedShape3DRetained)this.mirrorShape3D.get(n);
            orientedShape3DRetained.initAlignmentAxis(f, f2, f3);
            ++n;
        }
        if (this.mode == 0) {
            this.sendChangedMessage();
        }
    }

    void setAlignmentAxis(Vector3f vector3f) {
        this.setAlignmentAxis(vector3f.x, vector3f.y, vector3f.z);
    }

    void setAlignmentMode(int n) {
        if (this.mode != n) {
            this.initAlignmentMode(n);
            int n2 = 0;
            while (n2 < this.mirrorShape3D.size()) {
                OrientedShape3DRetained orientedShape3DRetained = (OrientedShape3DRetained)this.mirrorShape3D.get(n2);
                orientedShape3DRetained.initAlignmentMode(n);
                ++n2;
            }
            this.sendChangedMessage();
        }
    }

    void setRotationPoint(float f, float f2, float f3) {
        this.initRotationPoint(f, f2, f3);
        int n = 0;
        while (n < this.mirrorShape3D.size()) {
            OrientedShape3DRetained orientedShape3DRetained = (OrientedShape3DRetained)this.mirrorShape3D.get(n);
            orientedShape3DRetained.initRotationPoint(f, f2, f3);
            ++n;
        }
        if (this.mode == 1) {
            this.sendChangedMessage();
        }
    }

    void setRotationPoint(Point3f point3f) {
        this.setRotationPoint(point3f.x, point3f.y, point3f.z);
    }

    void updateOrientedTransform(Canvas3D canvas3D) {
        double d = 0.0;
        if (this.mode == 0) {
            canvas3D.getCenterEyeInImagePlate(this.viewPosition);
            canvas3D.getImagePlateToVworld(this.xform);
            this.xform.transform(this.viewPosition);
            this.xform.set(this.getCurrentLocalToVworld(null));
            this.xform.invert();
            this.xform.transform(this.viewPosition);
            this.eyeVec.set((Tuple3d)this.viewPosition);
            this.eyeVec.normalize();
            this.projectToPlane(this.eyeVec, this.nAxis);
            this.zAxis.x = 0.0;
            this.zAxis.y = 0.0;
            this.zAxis.z = 1.0;
            this.projectToPlane(this.zAxis, this.nAxis);
            this.vector.cross(this.eyeVec, this.zAxis);
            double d2 = this.vector.dot(this.nAxis) > 0.0 ? 1.0 : -1.0;
            d = d2 * Math.acos(this.eyeVec.dot(this.zAxis));
            this.aa.x = this.nAxis.x;
            this.aa.y = this.nAxis.y;
            this.aa.z = this.nAxis.z;
            this.aa.angle = -d;
            this.orientedTransform.set(this.aa);
        } else {
            double d3;
            canvas3D.getCenterEyeInImagePlate(this.viewPosition);
            this.yUpPoint.set((Tuple3d)this.viewPosition);
            this.yUpPoint.y += 0.01;
            canvas3D.getImagePlateToVworld(this.xform);
            this.xform.transform(this.viewPosition);
            this.xform.transform(this.yUpPoint);
            this.xform.set(this.getCurrentLocalToVworld(null));
            this.xform.invert();
            this.xform.transform(this.viewPosition);
            this.xform.transform(this.yUpPoint);
            this.eyeVec.set((Tuple3d)this.viewPosition);
            this.eyeVec.normalize();
            this.yUp.set((Tuple3d)this.yUpPoint);
            this.yUp.sub((Tuple3d)this.viewPosition);
            this.yUp.normalize();
            this.zAxis.x = 0.0;
            this.zAxis.y = 0.0;
            this.zAxis.z = 1.0;
            this.vector.cross(this.eyeVec, this.zAxis);
            double d4 = this.vector.length();
            if (d4 > 1.0E-4) {
                d3 = this.eyeVec.dot(this.zAxis);
                d = Math.acos(d3);
                this.aa.x = this.vector.x;
                this.aa.y = this.vector.y;
                this.aa.z = this.vector.z;
                this.aa.angle = -d;
                this.zRotate.set(this.aa);
            } else {
                this.zRotate.set(1.0);
            }
            this.yAxis.x = 0.0;
            this.yAxis.y = 1.0;
            this.yAxis.z = 0.0;
            this.zRotate.transform(this.yAxis);
            this.projectToPlane(this.yAxis, this.eyeVec);
            this.projectToPlane(this.yUp, this.eyeVec);
            d3 = this.yUp.dot(this.yAxis);
            d = Math.acos(d3);
            this.vector.cross(this.yUp, this.yAxis);
            if (this.eyeVec.dot(this.vector) < 0.0) {
                d *= -1.0;
            }
            this.aa.x = this.eyeVec.x;
            this.aa.y = this.eyeVec.y;
            this.aa.z = this.eyeVec.z;
            this.aa.angle = -d;
            this.xform.set(this.aa);
            this.vector.x = this.rotationPoint.x;
            this.vector.y = this.rotationPoint.y;
            this.vector.z = this.rotationPoint.z;
            this.orientedTransform.set(this.vector);
            this.orientedTransform.mul(this.xform);
            this.orientedTransform.mul(this.zRotate);
            this.vector.scale(-1.0);
            this.xform.set(this.vector);
            this.orientedTransform.mul(this.xform);
        }
    }
}

