/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Interpolator;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;

public class PositionInterpolator
extends Interpolator {
    TransformGroup target;
    Transform3D axis = new Transform3D();
    Transform3D axisInverse = new Transform3D();
    Transform3D translation = new Transform3D();
    Transform3D temp = new Transform3D();
    Vector3d transv = new Vector3d();
    float startPosition;
    float endPosition;

    PositionInterpolator() {
    }

    public PositionInterpolator(Alpha alpha, TransformGroup transformGroup) {
        super(alpha);
        this.target = transformGroup;
        this.axis.setIdentity();
        this.axisInverse.setIdentity();
        this.startPosition = 0.0f;
        this.endPosition = 1.0f;
    }

    public PositionInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float f, float f2) {
        super(alpha);
        this.target = transformGroup;
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
        this.startPosition = f;
        this.endPosition = f2;
    }

    public Node cloneNode(boolean bl) {
        PositionInterpolator positionInterpolator = new PositionInterpolator();
        positionInterpolator.duplicateNode(this, bl);
        return positionInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        PositionInterpolator positionInterpolator = (PositionInterpolator)node;
        this.setAxisOfTranslation(positionInterpolator.getAxisOfTranslation());
        this.setStartPosition(positionInterpolator.getStartPosition());
        this.setEndPosition(positionInterpolator.getEndPosition());
        this.setTarget(positionInterpolator.getTarget());
    }

    public Transform3D getAxisOfTranslation() {
        return this.axis;
    }

    public float getEndPosition() {
        return this.endPosition;
    }

    public float getStartPosition() {
        return this.startPosition;
    }

    public TransformGroup getTarget() {
        return this.target;
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.alpha != null) {
            float f = this.alpha.value();
            double d = (1.0 - (double)f) * (double)this.startPosition + (double)(f * this.endPosition);
            this.transv.set(d, 0.0, 0.0);
            this.translation.setTranslation(this.transv);
            this.temp.mul(this.axis, this.translation);
            this.temp.mul(this.temp, this.axisInverse);
            this.target.setTransform(this.temp);
        }
        this.wakeupOn(this.defaultWakeupCriterion);
    }

    public void setAxisOfTranslation(Transform3D transform3D) {
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
    }

    public void setEndPosition(float f) {
        this.endPosition = f;
    }

    public void setStartPosition(float f) {
        this.startPosition = f;
    }

    public void setTarget(TransformGroup transformGroup) {
        this.target = transformGroup;
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        TransformGroup transformGroup = this.getTarget();
        if (transformGroup != null) {
            this.setTarget((TransformGroup)nodeReferenceTable.getNewObjectReference(transformGroup));
        }
    }
}

