/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.InputDevice;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.GMatrix;
import javax.vecmath.GVector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Tuple3d;

public class Sensor {
    public static final int PREDICT_NONE = 1;
    public static final int PREDICT_NEXT_FRAME_TIME = 2;
    public static final int NO_PREDICTOR = 16;
    public static final int HEAD_PREDICTOR = 32;
    public static final int HAND_PREDICTOR = 64;
    public static final int DEFAULT_SENSOR_READ_COUNT = 30;
    static final int SENSOR_READ_COUNT_BUFFER = 15;
    static int num_reads_so_far = 0;
    boolean demand_driven = false;
    int sensorReadCount;
    int predictionPolicy = 16;
    int predictorType = 1;
    InputDevice device;
    SensorRead[] readings;
    int currentIndex;
    int lastIndex;
    Point3d hotspot;
    Transform3D hotspotTrans;
    int MaxSensorReadIndex;
    int sensorButtonCount;
    Matrix3d orig_rot = new Matrix3d();
    Matrix3d orig_rot_transpose = new Matrix3d();
    Matrix3d temp_rot = new Matrix3d();
    Matrix3d local_svd = new Matrix3d();
    static int MAX_PREDICTION_LENGTH = 20;
    Transform3D[] previousReads = new Transform3D[MAX_PREDICTION_LENGTH];
    long[] times = new long[MAX_PREDICTION_LENGTH];

    public Sensor(InputDevice inputDevice) {
        this(inputDevice, 30, 0, new Point3d(0.0, 0.0, 0.0));
    }

    public Sensor(InputDevice inputDevice, int n) {
        this(inputDevice, n, 0, new Point3d(0.0, 0.0, 0.0));
    }

    public Sensor(InputDevice inputDevice, int n, int n2) {
        this(inputDevice, n, n2, new Point3d(0.0, 0.0, 0.0));
    }

    public Sensor(InputDevice inputDevice, int n, int n2, Point3d point3d) {
        this.device = inputDevice;
        this.sensorReadCount = n;
        this.MaxSensorReadIndex = n + 15 - 1;
        this.sensorButtonCount = n2;
        this.readings = new SensorRead[this.MaxSensorReadIndex + 1];
        int n3 = 0;
        while (n3 < this.MaxSensorReadIndex + 1) {
            this.readings[n3] = new SensorRead(n2);
            ++n3;
        }
        this.currentIndex = 0;
        this.hotspot = new Point3d(point3d);
        double[] dArray = new double[16];
        dArray[3] = point3d.x;
        dArray[7] = point3d.y;
        dArray[11] = point3d.z;
        double[] dArray2 = dArray;
        this.hotspotTrans = new Transform3D(dArray2);
        int n4 = 0;
        while (n4 < MAX_PREDICTION_LENGTH) {
            this.previousReads[n4] = new Transform3D();
            ++n4;
        }
    }

    public Sensor(InputDevice inputDevice, int n, Point3d point3d) {
        this(inputDevice, n, 0, point3d);
    }

    public Sensor(InputDevice inputDevice, Point3d point3d) {
        this(inputDevice, 30, 0, point3d);
    }

    public SensorRead getCurrentSensorRead() {
        SensorRead sensorRead = new SensorRead(this.sensorButtonCount);
        sensorRead.set(this.readings[this.currentIndex]);
        return sensorRead;
    }

    public InputDevice getDevice() {
        return this.device;
    }

    public void getHotspot(Point3d point3d) {
        point3d.set((Tuple3d)this.hotspot);
    }

    void getPredictedRead(Transform3D transform3D, long l, int n, int n2) {
        int n3 = this.currentIndex;
        long l2 = this.readings[n3].time;
        l -= l2;
        GMatrix gMatrix = new GMatrix(n, n2 + 1);
        int n4 = 0;
        while (n4 < n) {
            gMatrix.setElement(n4, 0, 1.0);
            long l3 = this.lastTimeRelative(n - n4 - 1, n3, l2);
            gMatrix.setElement(n4, 1, (double)l3);
            int n5 = 2;
            while (n5 <= n2) {
                gMatrix.setElement(n4, n5, this.powerAndDiv(l3, n5));
                ++n5;
            }
            ++n4;
        }
        GMatrix gMatrix2 = new GMatrix(gMatrix);
        gMatrix2.transpose();
        GMatrix gMatrix3 = new GMatrix(n2 + 1, n2 + 1);
        gMatrix3.mul(gMatrix2, gMatrix);
        try {
            gMatrix3.invert();
        }
        catch (SingularMatrixException singularMatrixException) {
            System.out.println("SINGULAR MATRIX EXCEPTION in prediction");
            System.out.println(gMatrix3);
        }
        double[] dArray = new double[16];
        GMatrix gMatrix4 = new GMatrix(n2 + 1, n);
        gMatrix4.mul(gMatrix3, gMatrix2);
        GVector gVector = new GVector(n2 + 1);
        GVector gVector2 = new GVector(n2 + 1);
        gVector2.setElement(0, 1.0);
        gVector2.setElement(1, (double)l);
        int n6 = 2;
        while (n6 <= n2) {
            gVector2.setElement(n6, this.powerAndDiv(l, n6));
            ++n6;
        }
        GVector gVector3 = new GVector(n);
        int n7 = 0;
        while (n7 < 16) {
            int n8 = 0;
            while (n8 < n) {
                gVector3.setElement(n8, this.lastReadRelative(n - n8 - 1, n3, n7));
                ++n8;
            }
            gVector.mul(gMatrix4, gVector3);
            dArray[n7] = gVector.dot(gVector2);
            ++n7;
        }
        transform3D.set(dArray);
        transform3D.normalize();
    }

    public int getPredictionPolicy() {
        return this.predictionPolicy;
    }

    public int getPredictor() {
        return this.predictorType;
    }

    public void getRead(Transform3D transform3D) {
        if (this.demand_driven) {
            this.device.pollAndProcessInput();
        }
        long l = System.currentTimeMillis();
        if (num_reads_so_far < 600) {
            ++num_reads_so_far;
            transform3D.set(this.readings[this.currentIndex].read);
            return;
        }
        switch (this.predictionPolicy) {
            case 16: {
                transform3D.set(this.readings[this.currentIndex].read);
                break;
            }
            case 64: {
                transform3D.set(this.readings[this.currentIndex].read);
                break;
            }
            case 32: {
                transform3D.set(this.readings[this.currentIndex].read);
                break;
            }
        }
    }

    public void getRead(Transform3D transform3D, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor2"));
        }
        if (this.demand_driven) {
            this.device.pollAndProcessInput();
        }
        long l2 = System.currentTimeMillis();
        switch (this.predictionPolicy) {
            case 16: {
                transform3D.set(this.readings[this.currentIndex].read);
                break;
            }
            case 64: {
                transform3D.set(this.readings[this.currentIndex].read);
                break;
            }
            case 32: {
                transform3D.set(this.readings[this.currentIndex].read);
                break;
            }
        }
    }

    public int getSensorButtonCount() {
        return this.sensorButtonCount;
    }

    public int getSensorReadCount() {
        return this.sensorReadCount;
    }

    public void lastButtons(int n, int[] nArray) {
        if (n >= this.sensorReadCount) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor5"));
        }
        System.arraycopy(this.readings[this.previousIndex((int)n)].buttonValues, 0, nArray, 0, this.sensorButtonCount);
    }

    public void lastButtons(int[] nArray) {
        System.arraycopy(this.readings[this.currentIndex].buttonValues, 0, nArray, 0, this.sensorButtonCount);
    }

    public void lastRead(Transform3D transform3D) {
        transform3D.set(this.readings[this.currentIndex].read);
    }

    public void lastRead(Transform3D transform3D, int n) {
        if (n >= this.sensorReadCount) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor3"));
        }
        transform3D.set(this.readings[this.previousIndex((int)n)].read);
    }

    double lastReadRelative(int n, int n2, int n3) {
        return this.readings[this.previousIndexRelative((int)n, (int)n2)].read.mat[n3];
    }

    public long lastTime() {
        return this.readings[this.currentIndex].time;
    }

    public long lastTime(int n) {
        if (n >= this.sensorReadCount) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor4"));
        }
        return this.readings[this.previousIndex((int)n)].time;
    }

    long lastTimeRelative(int n, int n2, long l) {
        long l2 = l - this.readings[this.previousIndexRelative((int)n, (int)n2)].time;
        return l2;
    }

    double powerAndDiv(double d, int n) {
        if (n == 0) {
            return 1.0;
        }
        if (n == 1) {
            return d;
        }
        double d2 = 1.0;
        int n2 = 0;
        while (n2 < n) {
            d2 *= d;
            ++n2;
        }
        return d2 /= (double)n;
    }

    int previousIndex(int n) {
        int n2 = this.currentIndex - n;
        return n2 >= 0 ? n2 : this.MaxSensorReadIndex + n2 + 1;
    }

    int previousIndexRelative(int n, int n2) {
        int n3 = n2 - n;
        return n3 >= 0 ? n3 : this.MaxSensorReadIndex + n3 + 1;
    }

    public void setDevice(InputDevice inputDevice) {
        this.device = inputDevice;
    }

    public void setHotspot(Point3d point3d) {
        this.hotspot.set((Tuple3d)point3d);
        double[] dArray = new double[16];
        dArray[3] = point3d.x;
        dArray[7] = point3d.y;
        dArray[11] = point3d.z;
        double[] dArray2 = dArray;
        this.hotspotTrans.set(dArray2);
    }

    public void setNextSensorRead(long l, Transform3D transform3D, int[] nArray) {
        int n = this.currentIndex + 1;
        if (n > this.MaxSensorReadIndex) {
            n = 0;
        }
        this.readings[n].setTime(l);
        this.readings[n].set(transform3D);
        this.readings[n].read.sub(this.hotspotTrans);
        if (this.sensorButtonCount > 0) {
            this.readings[n].setButtons(nArray);
        }
        this.currentIndex = n;
    }

    public void setNextSensorRead(SensorRead sensorRead) {
        int n = this.currentIndex + 1;
        if (n > this.MaxSensorReadIndex) {
            n = 0;
        }
        this.readings[n].set(sensorRead);
        this.readings[n].read.sub(this.hotspotTrans);
        this.currentIndex = n;
    }

    public void setPredictionPolicy(int n) {
        if (n != 16 && n != 32 && n != 64) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor1"));
        }
        this.predictionPolicy = n;
    }

    public void setPredictor(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException(J3dI18N.getString("Sensor0"));
        }
        this.predictorType = n;
    }

    public void setSensorReadCount(int n) {
        this.sensorReadCount = n;
        this.MaxSensorReadIndex = this.sensorReadCount + 15 - 1;
        this.readings = new SensorRead[this.MaxSensorReadIndex + 1];
        int n2 = 0;
        while (n2 < this.MaxSensorReadIndex + 1) {
            this.readings[n2] = new SensorRead(this.sensorButtonCount);
            ++n2;
        }
        this.currentIndex = 0;
    }
}

