/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.J3dMessage;
import javax.media.j3d.LightRetained;
import javax.media.j3d.PointLightRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

class SpotLightRetained
extends PointLightRetained {
    static final int DIRECTION_CHANGED = 128;
    static final int ANGLE_CHANGED = 256;
    static final int CONCENTRATION_CHANGED = 512;
    Vector3f direction = new Vector3f(0.0f, 0.0f, -1.0f);
    Vector3f xformDirection = new Vector3f(0.0f, 0.0f, -1.0f);
    float spreadAngle = (float)Math.PI;
    float concentration = 0.0f;

    SpotLightRetained() {
        this.nodeType = 8;
        this.lightType = 4;
    }

    protected Object clone() {
        SpotLightRetained spotLightRetained = (SpotLightRetained)super.clone();
        spotLightRetained.direction = new Vector3f(this.direction);
        spotLightRetained.xformDirection = new Vector3f();
        return spotLightRetained;
    }

    float getConcentration() {
        return this.concentration;
    }

    void getDirection(Vector3f vector3f) {
        vector3f.set((Tuple3f)this.direction);
    }

    float getSpreadAngle() {
        return this.spreadAngle;
    }

    void initConcentration(float f) {
        this.concentration = f;
    }

    void initDirection(float f, float f2, float f3) {
        this.direction.x = f;
        this.direction.y = f2;
        this.direction.z = f3;
    }

    void initDirection(Vector3f vector3f) {
        this.direction.set((Tuple3f)vector3f);
    }

    synchronized void initMirrorObject(LightRetained lightRetained) {
        super.initMirrorObject(lightRetained);
        SpotLightRetained spotLightRetained = (SpotLightRetained)lightRetained;
        spotLightRetained.direction = new Vector3f(this.direction);
        spotLightRetained.lastLocalToVworld[0].transform(spotLightRetained.direction, spotLightRetained.xformDirection);
        spotLightRetained.xformDirection.normalize();
        spotLightRetained.spreadAngle = this.spreadAngle;
        spotLightRetained.concentration = this.concentration;
    }

    void initSpreadAngle(float f) {
        this.spreadAngle = (double)f < 0.0 ? 0.0f : (f > 1.5707964f ? (float)Math.PI : f);
    }

    final void sendMessage(int n, Object object) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.universe = this.universe;
        j3dMessage.type = 19;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorLights) : new Integer(1);
        j3dMessage.args[3] = this.mirrorLights.clone();
        j3dMessage.args[4] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void setConcentration(float f) {
        this.initConcentration(f);
        this.sendMessage(512, new Float(f));
    }

    void setDirection(float f, float f2, float f3) {
        this.setDirection(new Vector3f(f, f2, f3));
    }

    void setDirection(Vector3f vector3f) {
        this.initDirection(vector3f);
        this.sendMessage(128, new Vector3f(vector3f));
    }

    void setSpreadAngle(float f) {
        this.initSpreadAngle(f);
        this.sendMessage(256, new Float(this.spreadAngle));
    }

    void update(int n, int n2, double d) {
        this.validateAttenuationInEc(d);
        this.updateLight(n, n2, this.color.x, this.color.y, this.color.z, this.attenuation.x, this.linearAttenuationInEc, this.quadraticAttenuationInEc, this.xformPosition.x, this.xformPosition.y, this.xformPosition.z, this.spreadAngle, this.concentration, this.xformDirection.x, this.xformDirection.y, this.xformDirection.z);
    }

    native void updateLight(int var1, int var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16);

    synchronized void updateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        int n2 = (Integer)objectArray[2];
        LightRetained[] lightRetainedArray = (LightRetained[])objectArray[3];
        if ((n & 0x80) != 0) {
            int n3 = 0;
            while (n3 < n2) {
                if (lightRetainedArray[n3].nodeType == 8) {
                    SpotLightRetained spotLightRetained = (SpotLightRetained)lightRetainedArray[n3];
                    spotLightRetained.direction = (Vector3f)objectArray[4];
                    spotLightRetained.lastLocalToVworld[0].transform(spotLightRetained.direction, spotLightRetained.xformDirection);
                    spotLightRetained.xformDirection.normalize();
                }
                ++n3;
            }
        } else if ((n & 0x100) != 0) {
            int n4 = 0;
            while (n4 < n2) {
                if (lightRetainedArray[n4].nodeType == 8) {
                    SpotLightRetained spotLightRetained = (SpotLightRetained)lightRetainedArray[n4];
                    spotLightRetained.spreadAngle = ((Float)objectArray[4]).floatValue();
                }
                ++n4;
            }
        } else if ((n & 0x200) != 0) {
            int n5 = 0;
            while (n5 < n2) {
                if (lightRetainedArray[n5].nodeType == 8) {
                    SpotLightRetained spotLightRetained = (SpotLightRetained)lightRetainedArray[n5];
                    spotLightRetained.concentration = ((Float)objectArray[4]).floatValue();
                }
                ++n5;
            }
        }
        super.updateMirrorObject(objectArray);
    }

    void updateTransformChange() {
        super.updateTransformChange();
        this.lastLocalToVworld[0].transform(this.direction, this.xformDirection);
        this.xformDirection.normalize();
    }
}

