/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.InputDeviceScheduler;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.media.j3d.WakeupOnElapsedTimeHeap;

class TimerThread
extends Thread {
    private static final int WAIT = 0;
    private static final int NOTIFY = 1;
    private static final int STOP = 2;
    private WakeupOnElapsedTimeHeap heap = new WakeupOnElapsedTimeHeap();
    private WakeupOnElapsedTime inputDeviceSchedCond = new WakeupOnElapsedTime(InputDeviceScheduler.samplingTime);
    private WakeupOnElapsedTime soundSchedCond = new WakeupOnElapsedTime(120000L);
    private boolean running = true;
    private boolean waiting = false;

    TimerThread(ThreadGroup threadGroup) {
        super(threadGroup, "J3D-TimerThread");
    }

    void add(WakeupOnElapsedTime wakeupOnElapsedTime) {
        WakeupOnElapsedTimeHeap wakeupOnElapsedTimeHeap = this.heap;
        synchronized (wakeupOnElapsedTimeHeap) {
            this.heap.insert(wakeupOnElapsedTime);
        }
        this.runMonitor(1, 0L);
    }

    void addInputDeviceSchedCond() {
        this.inputDeviceSchedCond.triggeredTime = (long)InputDeviceScheduler.samplingTime + System.currentTimeMillis();
        this.add(this.inputDeviceSchedCond);
    }

    void addSoundSchedCond(long l) {
        this.soundSchedCond.triggeredTime = l;
        this.add(this.soundSchedCond);
    }

    void finish() {
        while (!this.waiting) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.runMonitor(2, 0L);
    }

    void removeTimer(BehaviorRetained behaviorRetained) {
        WakeupOnElapsedTimeHeap wakeupOnElapsedTimeHeap = this.heap;
        synchronized (wakeupOnElapsedTimeHeap) {
            this.heap.extract(behaviorRetained);
        }
    }

    public void run() {
        long l = -1L;
        while (this.running) {
            this.runMonitor(0, l);
            long l2 = System.currentTimeMillis();
            WakeupOnElapsedTimeHeap wakeupOnElapsedTimeHeap = this.heap;
            synchronized (wakeupOnElapsedTimeHeap) {
                l = -1L;
                while (!this.heap.isEmpty()) {
                    l = this.heap.getMin().triggeredTime - l2;
                    if (l > 0L) break;
                    WakeupOnElapsedTime wakeupOnElapsedTime = this.heap.extractMin();
                    if (wakeupOnElapsedTime == this.inputDeviceSchedCond) {
                        VirtualUniverse.mc.sendRunMessage(4);
                        continue;
                    }
                    if (wakeupOnElapsedTime == this.soundSchedCond) {
                        VirtualUniverse.mc.sendRunMessage(2);
                        continue;
                    }
                    wakeupOnElapsedTime.setTriggered();
                }
            }
        }
    }

    synchronized void runMonitor(int n, long l) {
        switch (n) {
            case 0: {
                try {
                    this.waiting = true;
                    if (l < 0L) {
                        this.wait();
                    } else {
                        this.wait(l);
                    }
                }
                catch (InterruptedException interruptedException) {}
                this.waiting = false;
                break;
            }
            case 1: {
                this.notify();
                break;
            }
            case 2: {
                this.running = false;
                this.notify();
                break;
            }
        }
    }
}

