/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.Locale;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;

class TransformStructure
extends J3dStructure
implements ObjectUpdate {
    ArrayList traverseList = new ArrayList();
    ArrayList transformList = new ArrayList();
    ArrayList objectList = new ArrayList();
    ArrayList collisionObjectList = new ArrayList();
    HashKey key = new HashKey(250);
    ArrayList dirtyTransformGroups = new ArrayList();
    ArrayList keySet = new ArrayList();
    Locale locale = null;
    Transform3D currentTrans = new Transform3D();
    ArrayList updateList = new ArrayList(1);

    TransformStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 8192);
    }

    void processBoundsAutoComputeChanged(J3dMessage j3dMessage) {
        boolean bl = (Boolean)j3dMessage.args[1];
        Bounds bounds = (Bounds)j3dMessage.args[2];
        Object[] objectArray = (Object[])j3dMessage.args[0];
        int n = 0;
        while (n < objectArray.length) {
            ((GeometryAtom)objectArray[n]).bounds = bl ? ((GeometryAtom)objectArray[n]).geometry.geoBounds : bounds;
            ++n;
        }
        this.objectList.add(objectArray);
    }

    void processCollisionBoundChanged(J3dMessage j3dMessage) {
        Bounds bounds = (Bounds)j3dMessage.args[1];
        if (j3dMessage.args[0] instanceof GroupRetained) {
            GroupRetained groupRetained = (GroupRetained)j3dMessage.args[0];
            if (groupRetained.mirrorGroup != null) {
                this.objectList.add(groupRetained.mirrorGroup);
            }
        } else {
            Object[] objectArray = (Object[])j3dMessage.args[0];
            this.collisionObjectList.add(objectArray);
        }
    }

    void processCurrentLocalToVworld() {
        TransformGroupRetained transformGroupRetained;
        if (this.transformList.size() <= 0) {
            return;
        }
        VirtualUniverse.mc.addMirrorObject(this);
        int n = this.transformList.size();
        int n2 = 0;
        while (n2 < n) {
            transformGroupRetained = (TransformGroupRetained)this.traverseList.get(n2);
            Transform3D transform3D = (Transform3D)this.transformList.get(n2);
            transformGroupRetained.currentTransform.set(transform3D);
            VirtualUniverse.mc.addToTransformFreeList(transform3D);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            transformGroupRetained = (TransformGroupRetained)this.traverseList.get(n2);
            transformGroupRetained.updateChildLocalToVworld(this.dirtyTransformGroups, this.keySet);
            ++n2;
        }
        this.transformList.clear();
        this.traverseList.clear();
    }

    void processGeometryAtomVwcBounds() {
        Object object;
        Shape3DRetained shape3DRetained;
        GeometryAtom geometryAtom;
        Object[] objectArray;
        int n;
        int n2 = this.universe.listOfLocales.size();
        int n3 = this.objectList.size();
        int n4 = 0;
        while (n4 < n3) {
            Object[] objectArray2 = (Object[])this.objectList.get(n4);
            n = 0;
            while (n < objectArray2.length) {
                objectArray = objectArray2[n];
                synchronized (objectArray) {
                    if (objectArray2[n] instanceof GeometryAtom) {
                        geometryAtom = (GeometryAtom)objectArray2[n];
                        shape3DRetained = geometryAtom.source;
                        if (geometryAtom.geometry != null) {
                            if (geometryAtom.bounds != null) {
                                object = geometryAtom.bounds;
                                synchronized (object) {
                                    geometryAtom.vwcBounds.transform(geometryAtom.bounds, shape3DRetained.cachedLocalToVworld);
                                }
                            } else {
                                geometryAtom.vwcBounds.transform(geometryAtom.bounds, shape3DRetained.cachedLocalToVworld);
                            }
                            if (geometryAtom.source.collisionBound == null) {
                                geometryAtom.collisionBound = geometryAtom.vwcBounds;
                            } else {
                                geometryAtom.collisionBound.transform(shape3DRetained.collisionBound, shape3DRetained.cachedLocalToVworld);
                            }
                            if (n2 > 1) {
                                geometryAtom.updateLocaleBounds();
                            }
                        }
                        if (shape3DRetained.vwcBounds != null && !shape3DRetained.onUpdateList) {
                            shape3DRetained.vwcBounds.transform(shape3DRetained.bounds, shape3DRetained.cachedLocalToVworld);
                            shape3DRetained.onUpdateList = true;
                            this.updateList.add(shape3DRetained);
                        }
                    } else if (objectArray2[n] instanceof GroupRetained) {
                        object = (GroupRetained)objectArray2[n];
                        Bounds bounds = ((GroupRetained)object).sourceNode.collisionBound != null ? ((GroupRetained)object).sourceNode.collisionBound : ((GroupRetained)object).sourceNode.getBounds();
                        ((GroupRetained)object).vwcBounds.transform(bounds, ((NodeRetained)object).currentLocalToVworld[0]);
                    }
                }
                ++n;
            }
            ++n4;
        }
        this.objectList.clear();
        int n5 = 0;
        while (n5 < this.updateList.size()) {
            shape3DRetained = (Shape3DRetained)this.updateList.get(n5);
            shape3DRetained.onUpdateList = false;
            ++n5;
        }
        this.updateList.clear();
        n = 0;
        while (n < this.collisionObjectList.size()) {
            objectArray = (Object[])this.objectList.get(n);
            int n6 = 0;
            while (n6 < objectArray.length) {
                object = objectArray[n6];
                synchronized (object) {
                    if (objectArray[n6] instanceof GeometryAtom) {
                        geometryAtom = (GeometryAtom)objectArray[n6];
                        if (geometryAtom.source.collisionBound == null) {
                            geometryAtom.collisionBound = geometryAtom.vwcBounds;
                        } else {
                            geometryAtom.collisionBound.transform(geometryAtom.source.collisionBound, geometryAtom.source.cachedLocalToVworld);
                        }
                    }
                }
                ++n6;
            }
            ++n;
        }
        this.collisionObjectList.clear();
    }

    void processLastLocalToVworld() {
        int n = this.dirtyTransformGroups.size();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            TransformGroupRetained transformGroupRetained;
            TransformGroupRetained transformGroupRetained2 = transformGroupRetained = (TransformGroupRetained)this.dirtyTransformGroups.get(n2);
            synchronized (transformGroupRetained2) {
                if (transformGroupRetained.currentChildLocalToVworld != null) {
                    Transform3D transform3D;
                    Transform3D transform3D2;
                    if (transformGroupRetained.inSharedGroup) {
                        HashKey hashKey = (HashKey)this.keySet.get(n3++);
                        int n4 = 0;
                        while (n4 < transformGroupRetained.localToVworldKeys.length) {
                            if (transformGroupRetained.localToVworldKeys[n4].equals(hashKey)) break;
                            ++n4;
                        }
                        if (n4 < transformGroupRetained.localToVworldKeys.length) {
                            transform3D2 = transformGroupRetained.currentChildLocalToVworld[n4];
                            transform3D = transformGroupRetained.lastChildLocalToVworld[n4];
                            transform3D.set(transform3D2);
                        }
                    } else {
                        transform3D2 = transformGroupRetained.currentChildLocalToVworld[0];
                        transform3D = transformGroupRetained.lastChildLocalToVworld[0];
                        transform3D.set(transform3D2);
                    }
                }
            }
            ++n2;
        }
        this.dirtyTransformGroups.clear();
        this.keySet.clear();
    }

    void processMessages(long l) {
        J3dMessage[] j3dMessageArray = this.getMessages(l);
        if (j3dMessageArray != null) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                int n = 0;
                while (n < j3dMessageArray.length) {
                    J3dMessage j3dMessage = j3dMessageArray[n];
                    if (j3dMessage.type == 3) {
                        this.objectList.add(j3dMessage.args[0]);
                        int n2 = this.traverseList.indexOf(j3dMessage.args[1]);
                        if (n2 == -1) {
                            this.traverseList.add(j3dMessage.args[1]);
                            this.transformList.add(j3dMessage.args[2]);
                        } else {
                            Transform3D transform3D = (Transform3D)this.transformList.get(n2);
                            VirtualUniverse.mc.addToTransformFreeList(transform3D);
                            this.transformList.set(n2, j3dMessage.args[2]);
                        }
                    } else if (j3dMessage.type == 24) {
                        this.objectList.add(j3dMessage.args[3]);
                    } else if (j3dMessage.type == 17) {
                        this.objectList.add(j3dMessage.args[0]);
                    } else if (j3dMessage.type == 16) {
                        this.objectList.add(j3dMessage.args[3]);
                    } else if (j3dMessage.type == 26) {
                        this.objectList.add(j3dMessage.args[1]);
                    } else if (j3dMessage.type == 25) {
                        this.objectList.add(j3dMessage.args[0]);
                    } else if (j3dMessage.type == 35) {
                        this.processRegionBoundChanged(j3dMessage);
                    } else if (j3dMessage.type == 37) {
                        this.processBoundsAutoComputeChanged(j3dMessage);
                    } else if (j3dMessage.type == 34) {
                        this.processCollisionBoundChanged(j3dMessage);
                    }
                    j3dMessage.decRefcount();
                    ++n;
                }
                this.processCurrentLocalToVworld();
                this.processGeometryAtomVwcBounds();
            }
        }
    }

    void processRegionBoundChanged(J3dMessage j3dMessage) {
        Shape3DRetained shape3DRetained;
        Bounds bounds = (Bounds)j3dMessage.args[1];
        Object[] objectArray = (Object[])j3dMessage.args[0];
        int n = 0;
        while (n < objectArray.length) {
            GeometryAtom geometryAtom = (GeometryAtom)objectArray[n];
            shape3DRetained = geometryAtom.source;
            geometryAtom.bounds = bounds;
            if (bounds != null && !shape3DRetained.onUpdateList) {
                shape3DRetained.onUpdateList = true;
                this.updateList.add(shape3DRetained);
            }
            ((GeometryAtom)objectArray[n]).bounds = bounds;
            ++n;
        }
        this.objectList.add(objectArray);
        n = 0;
        while (n < this.updateList.size()) {
            shape3DRetained = (Shape3DRetained)this.updateList.get(n);
            shape3DRetained.bounds = bounds;
            shape3DRetained.vwcBounds = (Bounds)bounds.clone();
            shape3DRetained.onUpdateList = false;
            ++n;
        }
        this.updateList.clear();
    }

    public void updateObject() {
        this.processLastLocalToVworld();
    }
}

