/*
 * Decompiled with CFR 0.152.
 */
package forester.tree;

import forester.tree.Node;
import forester.tree.PreorderTreeIterator;
import forester.tree.Tree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Random;
import java.util.Vector;

public class TreeHelper {
    public static double[] calculateMeanBoostrapValue(Tree tree) {
        int n = 0;
        int n2 = 0;
        long l = 0L;
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = new double[2];
        Vector<Integer> vector = new Vector<Integer>();
        Node node = null;
        PreorderTreeIterator preorderTreeIterator = null;
        try {
            preorderTreeIterator = new PreorderTreeIterator(tree);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("TreeHelper: Unexpected failure.");
            System.exit(-1);
        }
        while (!preorderTreeIterator.isDone()) {
            node = preorderTreeIterator.currentNode();
            if (!(node.getParent() != null && node.getParent().isRoot() && node.getParent().getChild1().getBootstrap() > 0 && node.getParent().getChild2().getBootstrap() > 0 && node.getParent().getChild2() == node || (n = node.getBootstrap()) <= 0)) {
                l += (long)n;
                vector.addElement(new Integer(n));
                ++n2;
            }
            preorderTreeIterator.next();
        }
        if (n2 < 2) {
            return null;
        }
        d2 = (double)l / (double)n2;
        l = 0L;
        int n3 = 0;
        while (n3 < n2) {
            n = (Integer)vector.elementAt(n3);
            d = (double)n - d2;
            l = (long)((double)l + d * d);
            ++n3;
        }
        dArray[0] = d2;
        dArray[1] = Math.sqrt((double)l / ((double)n2 - 1.0));
        return dArray;
    }

    public static boolean checkCommas(String string) {
        int n = 0;
        while (n <= string.length() - 2) {
            if (string.charAt(n) == '(' && string.charAt(n + 1) == ')' || string.charAt(n) != ',' && string.charAt(n) != '(' && string.charAt(n + 1) == '(' || string.charAt(n) == ',' && string.charAt(n + 1) == ',' || string.charAt(n) == '(' && string.charAt(n + 1) == ',' || string.charAt(n) == ',' && string.charAt(n + 1) == ')') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void cleanSpeciesNamesInExtNodes(Tree tree) {
        Node node = tree.getExtNode0();
        String string = "";
        int n = 0;
        while (node != null) {
            string = node.getSpecies().trim();
            if (string.length() > 0) {
                n = string.indexOf("/");
                if (n >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf("_")) >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf("-")) >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf("\\")) >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf(";")) >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf(".")) >= 0) {
                    string = string.substring(0, n);
                }
                node.setSpecies(string);
            }
            node = node.getNextExtNode();
        }
    }

    public static int countAndCheckParantheses(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 <= string.length() - 1) {
            if (string.charAt(n3) == '(') {
                ++n;
            }
            if (string.charAt(n3) == ')') {
                ++n2;
            }
            ++n3;
        }
        if (n2 != n) {
            return -1;
        }
        return n;
    }

    public static Tree createUnbalancedTree(int n) {
        Tree tree = null;
        try {
            tree = new Tree(":S=");
            tree.setRooted(true);
            int n2 = 1;
            while (n2 < n) {
                tree.addNodeAndConnect("", "");
                ++n2;
            }
            tree.setRoot(tree.getExtNode0().getRoot());
            tree.calculateRealHeight();
        }
        catch (Exception exception) {
            System.err.println("Unexpected exception during \"createUnbalancedTree\":");
            System.err.println(exception.toString());
            System.exit(-1);
        }
        return tree;
    }

    public static void extractSpeciesNameFromSeqName(Tree tree) {
        PreorderTreeIterator preorderTreeIterator = null;
        int n = 0;
        try {
            preorderTreeIterator = new PreorderTreeIterator(tree);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Unexpected Error: Could not create iterator. Terminating.");
            System.exit(-1);
        }
        String string = "";
        while (!preorderTreeIterator.isDone()) {
            if (preorderTreeIterator.currentNode().getSpecies().length() < 1) {
                string = preorderTreeIterator.currentNode().getSeqName();
                n = string.lastIndexOf("_");
                if (n >= 0) {
                    string.trim();
                    string = string.substring(n + 1);
                    n = string.indexOf("/");
                    if (n >= 0) {
                        string = string.substring(0, n);
                    }
                    if ((n = string.indexOf("-")) >= 0) {
                        string = string.substring(0, n);
                    }
                    if ((n = string.indexOf("\\")) >= 0) {
                        string = string.substring(0, n);
                    }
                    if ((n = string.indexOf(";")) >= 0) {
                        string = string.substring(0, n);
                    }
                    if ((n = string.indexOf(".")) >= 0) {
                        string = string.substring(0, n);
                    }
                    preorderTreeIterator.currentNode().setSpecies(string);
                } else {
                    preorderTreeIterator.currentNode().setSpecies(string);
                }
            }
            preorderTreeIterator.next();
        }
    }

    public static void intervalNumberSpecies(Tree tree, int n) {
        if (tree == null || tree.isEmpty()) {
            return;
        }
        Node node = tree.getExtNode0();
        int n2 = 1;
        boolean bl = true;
        while (node != null) {
            if (bl) {
                node.setSpecies(String.valueOf(n2));
            } else {
                node.setSpecies(String.valueOf(n2 + n));
                ++n2;
            }
            bl ^= true;
            node = node.getNextExtNode();
        }
    }

    public static boolean isEmpty(String string) {
        return string.length() < 1;
    }

    public static void numberSpeciesInDescOrder(Tree tree) {
        if (tree == null || tree.isEmpty()) {
            return;
        }
        Node node = tree.getExtNode0();
        int n = tree.getRoot().getSumExtNodes();
        while (node != null) {
            node.setSpecies(String.valueOf(n));
            --n;
            node = node.getNextExtNode();
        }
    }

    public static void numberSpeciesInOrder(Tree tree) {
        if (tree == null || tree.isEmpty()) {
            return;
        }
        Node node = tree.getExtNode0();
        int n = 1;
        while (node != null) {
            node.setSpecies(String.valueOf(n));
            ++n;
            node = node.getNextExtNode();
        }
    }

    public static void randomizeSpecies(int n, int n2, Tree tree) {
        if (tree == null || tree.isEmpty()) {
            return;
        }
        int n3 = Math.abs(n);
        int n4 = Math.abs(n2);
        Random random = new Random();
        Node node = tree.getExtNode0();
        while (node != null) {
            node.setSpecies(String.valueOf(Math.abs(random.nextInt()) % (n4 - n3 + 1) + n3));
            node = node.getNextExtNode();
        }
    }

    public static Tree[] readMultipleNHTrees(File file) throws Exception {
        String string = "";
        StringBuffer stringBuffer = null;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Tree[] treeArray = null;
        if (!file.exists()) {
            throw new Exception(String.valueOf(file.getAbsolutePath()) + " does not exist.");
        }
        if (!file.isFile()) {
            throw new Exception(String.valueOf(file.getAbsolutePath()) + " is not a file.");
        }
        bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.indexOf(";") == -1) continue;
            ++n;
        }
        bufferedReader.close();
        treeArray = new Tree[n];
        n3 = (int)(file.length() / (long)n) + 1;
        stringBuffer = new StringBuffer(n3);
        string = "";
        bufferedReader2 = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader2.readLine()) != null) {
            stringBuffer.append(string);
            if (string.indexOf(";") == -1) continue;
            treeArray[n2++] = new Tree(stringBuffer.toString());
            stringBuffer = new StringBuffer(n3);
        }
        bufferedReader2.close();
        return treeArray;
    }

    public static Tree readNHtree(File file) throws Exception {
        String string = "";
        StringBuffer stringBuffer = null;
        BufferedReader bufferedReader = null;
        if (!file.exists()) {
            throw new Exception(String.valueOf(file.getAbsolutePath()) + " does not exist.");
        }
        if (!file.isFile()) {
            throw new Exception(String.valueOf(file.getAbsolutePath()) + " is not a file.");
        }
        stringBuffer = new StringBuffer((int)file.length());
        bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
        }
        bufferedReader.close();
        return new Tree(stringBuffer.toString());
    }

    public static Tree readNHtree(URL uRL) throws Exception {
        String string = "";
        StringBuffer stringBuffer = null;
        BufferedReader bufferedReader = null;
        stringBuffer = new StringBuffer(10000);
        bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
        }
        bufferedReader.close();
        return new Tree(stringBuffer.toString());
    }

    public static String removeComments(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        n = 0;
        while (n < string.length() - 1) {
            if (string.charAt(n) == '[' && (n > string.length() - 3 || string.charAt(n + 1) != '&' || string.charAt(n + 2) != '&' || string.charAt(n + 3) != 'N' || string.charAt(n + 4) != 'H' || string.charAt(n + 5) != 'X')) {
                n2 = n++;
                bl = false;
                while (n < string.length() && !bl) {
                    if (string.charAt(n) == '[') {
                        ++n3;
                    } else if (string.charAt(n) == ']') {
                        if (n3 == 0) {
                            string = String.valueOf(string.substring(0, n2)) + string.substring(n + 1);
                            n = n2 - 2;
                            bl = true;
                        } else {
                            --n3;
                        }
                    }
                    ++n;
                }
            }
            ++n;
        }
        return string;
    }

    public static String removeWhiteSpace(String string) {
        int n = 0;
        while (n <= string.length() - 1) {
            if (string.charAt(n) == ' ' || string.charAt(n) == '\t' || string.charAt(n) == '\n' || string.charAt(n) == '\r') {
                string = String.valueOf(string.substring(0, n)) + string.substring(n + 1);
                --n;
            }
            ++n;
        }
        return string;
    }

    public static int roundToInt(double d) {
        return (int)(d + 0.5);
    }

    public static void writeNHtree(Tree tree, File file, boolean bl, boolean bl2, boolean bl3) throws Exception {
        if (tree.isEmpty()) {
            String string = "writeNHtree( Tree, File, boolean, boolean,";
            string = String.valueOf(string) + " boolean ): Tree must not be empty.";
            throw new Exception(string);
        }
        if (!(!file.exists() || bl2 && bl3)) {
            throw new Exception(String.valueOf(file.getAbsolutePath()) + " does already exist and is not allowed to be overwritten.");
        }
        if (file.exists() && !file.isFile()) {
            throw new Exception(String.valueOf(file.getAbsolutePath()) + " is not a file. Cannot be overwritten.");
        }
        String string = bl ? tree.toNewHampshireX() : tree.toNewHampshire(false);
        try {
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(file), true);
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            throw new Exception("writeNHtree( Tree, File, boolean, boolean, boolean ): " + exception);
        }
    }
}

