/*
 * Decompiled with CFR 0.152.
 */
package forester.atv_awt;

import forester.atv_awt.ATVnodeFrame;
import forester.tree.Node;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class ATVnodePanel
extends Panel
implements ActionListener {
    private Node node;
    private ATVnodeFrame atvnodeframe;
    private boolean editable = false;
    private Label title;
    private Label seq_name_label;
    private Label Species_label;
    private Label EC_label;
    private Label Distance_parent_label;
    private Label Bootstrap_label;
    private Label LnL_label;
    private Label Sum_ext_nodes_label;
    private Label taxo_id_label;
    private Label orthologous_label;
    private Label super_orthologous_label;
    private Label message_label;
    private TextField Seq_name_tf;
    private TextField Species_tf;
    private TextField EC_tf;
    private TextField Distance_parent_tf;
    private TextField taxo_id_tf;
    private TextField Bootstrap_tf;
    private TextField LnL_tf;
    private TextField Sum_ext_nodes_tf;
    private TextField orthologous_tf;
    private TextField super_orthologous_tf;
    private Checkbox Duplication_rb;
    private Checkbox Speciation_rb;
    private Checkbox NA_rb;
    private Panel buttonjpanel;
    private Panel radiobuttonjpanel;
    private CheckboxGroup radiobuttongroup;
    private Button close_button;
    private Button reset_button;
    private Button write_button;
    private static final Font label_font = new Font("SansSerif", 0, 9);
    private static final Font tf_font = new Font("SansSerif", 0, 9);
    private static final Font button_font = new Font("SansSerif", 0, 9);
    private static final Font message_font = new Font("SansSerif", 1, 10);
    private static final Color background_color = new Color(215, 215, 215);
    private static final Color label_text_color = new Color(0, 0, 0);
    private static final Color tf_text_color = new Color(0, 0, 0);
    private static final Color tf_background_color = new Color(250, 250, 250);
    private static final Color button_background_color = new Color(165, 165, 165);
    private static final Color button_text_color = new Color(0, 0, 0);
    private static final Color message_color = new Color(0, 0, 255);
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private String message = " ";

    ATVnodePanel(Node node, ATVnodeFrame aTVnodeFrame) {
        this.node = node;
        this.atvnodeframe = aTVnodeFrame;
        String string = "ATV";
        string = this.node.isExternal() ? String.valueOf(string) + ": External Node " + this.node.getID() : String.valueOf(string) + ": Internal Node " + this.node.getID();
        this.atvnodeframe.setTitle(string);
        this.editable = this.atvnodeframe.getATVgraphic().isEditable();
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.gbc.anchor = 17;
        this.setBackground(background_color);
        this.setLayout(this.gbl);
        this.seq_name_label = new Label("Seq name");
        this.addJLabel(this.seq_name_label);
        this.Seq_name_tf = new TextField(25);
        this.addJTF(this.Seq_name_tf);
        this.Species_label = new Label("Species");
        this.addJLabel(this.Species_label);
        this.Species_tf = new TextField(25);
        this.addJTF(this.Species_tf);
        this.taxo_id_label = new Label("Taxonomy ID");
        this.addJLabel(this.taxo_id_label);
        this.taxo_id_tf = new TextField(25);
        this.addJTF(this.taxo_id_tf);
        this.EC_label = new Label("EC number");
        this.addJLabel(this.EC_label);
        this.EC_tf = new TextField(25);
        this.addJTF(this.EC_tf);
        this.Distance_parent_label = new Label("Distance to parent");
        this.addJLabel(this.Distance_parent_label);
        this.Distance_parent_tf = new TextField(25);
        this.addJTF(this.Distance_parent_tf);
        if (!this.node.isExternal()) {
            this.Bootstrap_label = new Label("Bootstrap value");
            this.addJLabel(this.Bootstrap_label);
            this.Bootstrap_tf = new TextField(25);
            this.addJTF(this.Bootstrap_tf);
        }
        if (this.node.isExternal()) {
            this.orthologous_label = new Label("Orthologous to X");
            this.addJLabel(this.orthologous_label);
            this.orthologous_tf = new TextField(25);
            this.addJTF(this.orthologous_tf);
            this.super_orthologous_label = new Label("S-Orthologous to X");
            this.addJLabel(this.super_orthologous_label);
            this.super_orthologous_tf = new TextField(25);
            this.addJTF(this.super_orthologous_tf);
        }
        this.LnL_label = new Label("log L on parent branch");
        this.addJLabel(this.LnL_label);
        this.LnL_tf = new TextField(25);
        this.addJTF(this.LnL_tf);
        if (!this.node.isExternal()) {
            this.Sum_ext_nodes_label = new Label("Sum of ext nodes");
            this.addJLabel(this.Sum_ext_nodes_label);
            this.Sum_ext_nodes_tf = new TextField(25);
            this.addJTF(this.Sum_ext_nodes_tf);
            this.Sum_ext_nodes_tf.setEditable(false);
        }
        if (!this.node.isExternal()) {
            this.radiobuttonjpanel = new Panel();
            this.radiobuttongroup = new CheckboxGroup();
            this.radiobuttonjpanel.setLayout(new GridLayout(1, 3, 0, 0));
            this.radiobuttonjpanel.setBackground(background_color);
            this.Duplication_rb = new Checkbox("Duplication", this.radiobuttongroup, false);
            this.Speciation_rb = new Checkbox("Speciation", this.radiobuttongroup, false);
            this.NA_rb = new Checkbox("Not assigned", this.radiobuttongroup, true);
            this.Duplication_rb.setEnabled(this.editable);
            this.Duplication_rb.setFont(label_font);
            this.Duplication_rb.setForeground(label_text_color);
            this.Duplication_rb.setBackground(background_color);
            this.radiobuttonjpanel.add(this.Duplication_rb);
            this.Speciation_rb.setEnabled(this.editable);
            this.Speciation_rb.setFont(label_font);
            this.Speciation_rb.setForeground(label_text_color);
            this.Speciation_rb.setBackground(background_color);
            this.radiobuttonjpanel.add(this.Speciation_rb);
            this.NA_rb.setEnabled(this.editable);
            this.NA_rb.setFont(label_font);
            this.NA_rb.setForeground(label_text_color);
            this.NA_rb.setBackground(background_color);
            this.radiobuttonjpanel.add(this.NA_rb);
            this.gbc.gridwidth = 0;
            this.gbc.fill = 2;
            this.add((Component)this.radiobuttonjpanel, this.gbc);
            this.gbc.fill = 0;
        }
        this.buttonjpanel = new Panel();
        this.buttonjpanel.setLayout(new GridLayout(1, 0, 20, 40));
        this.buttonjpanel.setBackground(background_color);
        this.close_button = new Button("Close");
        this.close_button.setFont(button_font);
        this.close_button.setForeground(button_text_color);
        this.close_button.setBackground(button_background_color);
        this.close_button.addActionListener(this);
        this.buttonjpanel.add(this.close_button);
        if (this.editable) {
            this.reset_button = new Button("Reset");
            this.reset_button.setFont(button_font);
            this.reset_button.setForeground(button_text_color);
            this.reset_button.setBackground(button_background_color);
            this.reset_button.addActionListener(this);
            this.buttonjpanel.add(this.reset_button);
            this.write_button = new Button("Write to tree");
            this.write_button.setFont(button_font);
            this.write_button.setForeground(button_text_color);
            this.write_button.setBackground(button_background_color);
            this.write_button.addActionListener(this);
            this.gbc.gridwidth = 0;
            this.buttonjpanel.add(this.write_button);
        }
        this.gbc.anchor = 10;
        this.add((Component)this.buttonjpanel, this.gbc);
        this.message_label = new Label("                                               ");
        this.message_label.setFont(message_font);
        this.message_label.setForeground(message_color);
        this.gbc.insets = new Insets(14, 0, 0, 0);
        this.gbc.anchor = 10;
        this.add((Component)this.message_label, this.gbc);
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.reset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.close_button) {
            this.close();
        } else {
            if (this.editable && actionEvent.getSource() == this.reset_button) {
                this.reset();
            }
            if (this.editable && actionEvent.getSource() == this.write_button) {
                this.writeToTree();
            }
            this.atvnodeframe.getATVgraphic().getTree().recalculateAndReset();
            this.atvnodeframe.getATVgraphic().repaint();
        }
    }

    private void addJLabel(Label label) {
        this.gbc.weightx = 0.3;
        label.setFont(label_font);
        label.setForeground(label_text_color);
        this.gbc.gridwidth = 1;
        this.add((Component)label, this.gbc);
    }

    private void addJTF(TextField textField) {
        this.gbc.weightx = 0.7;
        textField.setFont(tf_font);
        textField.setForeground(tf_text_color);
        textField.setBackground(tf_background_color);
        textField.setEditable(this.editable);
        this.gbc.gridwidth = 0;
        this.add((Component)textField, this.gbc);
    }

    void close() {
        this.atvnodeframe.remove();
        this.atvnodeframe.dispose();
        this.atvnodeframe = null;
    }

    private String replaceInappropriateChars(String string) {
        string = string.replace('[', '{');
        string = string.replace(']', '}');
        string = string.replace('(', '{');
        string = string.replace(')', '}');
        string = string.replace(':', '|');
        string = string.replace(',', '|');
        string = string.replace(' ', '_');
        return string;
    }

    void reset() {
        this.message_label.setText("                                                   ");
        this.message = " ";
        if (!this.node.isPseudoNode()) {
            this.Seq_name_tf.setText(this.node.getSeqName());
        } else {
            this.Seq_name_tf.setText("*pseudo node*");
        }
        this.Species_tf.setText(this.node.getSpecies());
        if (this.node.getTaxonomyID() != -99) {
            this.taxo_id_tf.setText(String.valueOf(this.node.getTaxonomyID()));
        }
        this.EC_tf.setText(this.node.getECnumber());
        if (!this.node.isPseudoNode() && this.node.getDistanceToParent() != -99.0) {
            this.Distance_parent_tf.setText(String.valueOf(this.node.getDistanceToParent()));
        } else {
            this.Distance_parent_tf.setText("");
        }
        if (this.node.isLnLonParentBranchAssigned()) {
            this.LnL_tf.setText(String.valueOf(this.node.getLnLonParentBranch()));
        } else {
            this.LnL_tf.setText("");
        }
        if (!this.node.isExternal()) {
            if (this.node.getBootstrap() != -99) {
                this.Bootstrap_tf.setText(String.valueOf(this.node.getBootstrap()));
            } else {
                this.Bootstrap_tf.setText("");
            }
            this.Sum_ext_nodes_tf.setText(String.valueOf(this.node.getSumExtNodes()));
            if (!this.node.isDuplicationOrSpecAssigned()) {
                this.NA_rb.setState(true);
            } else if (this.node.isDuplication()) {
                this.Duplication_rb.setState(true);
            } else {
                this.Speciation_rb.setState(true);
            }
        }
        if (this.node.isExternal()) {
            if (this.node.getOrthologous() != 0 && this.node.getOrthologous() != -11) {
                this.orthologous_tf.setText(String.valueOf(this.node.getOrthologous()));
            } else {
                this.orthologous_tf.setText("");
            }
            if (this.node.getSuperOrthologous() != 0 && this.node.getSuperOrthologous() != -11) {
                this.super_orthologous_tf.setText(String.valueOf(this.node.getSuperOrthologous()));
            } else {
                this.super_orthologous_tf.setText("");
            }
        }
    }

    void writeToTree() {
        boolean bl = false;
        double d = 0.0;
        float f = 0.0f;
        int n = 0;
        this.message = " ";
        this.message_label.setText(" ");
        this.node.setSeqName(this.replaceInappropriateChars(this.Seq_name_tf.getText().trim()));
        this.node.setSpecies(this.replaceInappropriateChars(this.Species_tf.getText().trim()));
        this.node.setECnumber(this.replaceInappropriateChars(this.EC_tf.getText().trim()));
        if (this.taxo_id_tf.getText().trim().length() > 0) {
            bl = false;
            try {
                n = Integer.parseInt(this.taxo_id_tf.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
                this.message = "NumberFormatException. ";
            }
            if (!bl) {
                this.node.setTaxonomyID(n);
            }
        }
        if (this.Distance_parent_tf.getText().trim().length() > 0) {
            bl = false;
            try {
                d = Double.valueOf(this.Distance_parent_tf.getText().trim());
                if (d < 0.0) {
                    d = 0.0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
                this.message = "NumberFormatException. ";
            }
            if (!bl) {
                this.node.setDistanceToParent(d);
            }
        } else {
            this.node.setDistanceToParent(-99.0);
        }
        if (this.LnL_tf.getText().trim().length() > 0) {
            bl = false;
            try {
                f = Float.valueOf(this.LnL_tf.getText().trim()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
                this.message = "NumberFormatException. ";
            }
            if (!bl) {
                this.node.setLnLonParentBranch(f);
            }
        } else {
            this.node.setLnLonParentBranch(0.0f);
            this.node.setLnLonParentBranchAssigned(false);
        }
        if (!this.node.isExternal()) {
            if (this.Bootstrap_tf.getText().trim().length() > 0) {
                bl = false;
                try {
                    n = Integer.parseInt(this.Bootstrap_tf.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                    this.message = "NumberFormatException. ";
                }
                if (!bl) {
                    this.node.setBootstrap(n);
                }
            } else {
                this.node.setBootstrap(-99);
            }
            if (this.Duplication_rb.getState()) {
                this.node.setDuplication(true);
            } else if (this.Speciation_rb.getState()) {
                this.node.setDuplication(false);
            } else {
                this.node.setDuplicationOrSpecAssigned(false);
            }
        }
        if (this.node.isExternal()) {
            if (this.orthologous_tf.getText().trim().length() > 0) {
                bl = false;
                try {
                    n = Integer.parseInt(this.orthologous_tf.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                    this.message = "NumberFormatException. ";
                }
                if (!bl) {
                    if (n > 0) {
                        this.node.setOrthologous(n);
                    } else {
                        this.node.setOrthologous(0);
                    }
                }
            } else {
                this.node.setOrthologous(0);
            }
            if (this.super_orthologous_tf.getText().trim().length() > 0) {
                bl = false;
                try {
                    n = Integer.parseInt(this.super_orthologous_tf.getText().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                    this.message = "NumberFormatException. ";
                }
                if (!bl) {
                    if (n > 0) {
                        this.node.setSuperOrthologous(n);
                    } else {
                        this.node.setSuperOrthologous(0);
                    }
                }
            } else {
                this.node.setSuperOrthologous(0);
            }
        }
        if (this.message.length() > 1) {
            Toolkit.getDefaultToolkit().beep();
            this.message_label.setText(this.message);
            this.message = " ";
        } else {
            this.reset();
        }
    }
}

