/*
 * Decompiled with CFR 0.152.
 */
package forester.tree;

import forester.tree.Branch;
import forester.tree.Node;
import forester.tree.PreorderTreeIterator;
import forester.tree.TreeHelper;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class Tree
implements Serializable {
    static final int MAX_LENGTH = 10;
    static final long serialVersionUID = -6847390332113L;
    private Node ext_node0_;
    private Node root_;
    private double highest_lnL_;
    private double lowest_lnL_;
    private double real_height_;
    private int external_nodes_;
    private int number_of_duplications_;
    private boolean rooted_;
    private boolean more_than_bin_nodes_in_NH_;
    private String name_;
    private Hashtable idhash_;
    private int j_;

    public Tree() {
        this.delete();
    }

    public Tree(String string) throws Exception {
        this.delete();
        boolean bl = true;
        int n = 0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        StringBuffer stringBuffer = null;
        Stack<String> stack = null;
        String string6 = new String(":" + -100.0);
        string = TreeHelper.removeWhiteSpace(string);
        string = TreeHelper.removeComments(string);
        if (!TreeHelper.isEmpty(string) && string.charAt(0) != '(' && string.indexOf("(") != -1) {
            int n2 = string.indexOf("(");
            string = string.substring(n2);
        }
        if (!TreeHelper.isEmpty(string) && string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        if (TreeHelper.countAndCheckParantheses(string) <= -1) {
            String string7 = "Tree: Tree( String ): Error in NHX format: ";
            string7 = String.valueOf(string7) + "open parantheses != close parantheses.";
            throw new Exception(string7);
        }
        if (!TreeHelper.checkCommas(string)) {
            String string8 = "Tree: Tree( String ): Error in NHX format: ";
            string8 = String.valueOf(string8) + "Commas not properly set.";
            throw new Exception(string8);
        }
        if (string.length() < 1) {
            this.setExtNode0(null);
            this.setRoot(null);
        } else if (string.indexOf("(") != -1) {
            string5 = "";
            string4 = "";
            string3 = "";
            stack = new Stack<String>();
            n = 0;
            while (n <= string.length() - 1) {
                block39: {
                    if (string.charAt(n) == ',') {
                        stack.push(",");
                    }
                    if (string.charAt(n) == '(') {
                        stack.push("(");
                    }
                    if (string.charAt(n) != ',' && string.charAt(n) != '(' && string.charAt(n) != ')') {
                        stringBuffer = new StringBuffer("");
                        while (n <= string.length() - 1 && string.charAt(n) != ')' && string.charAt(n) != ',') {
                            stringBuffer.append(string.charAt(n));
                            ++n;
                        }
                        --n;
                        stack.push(stringBuffer.toString());
                    }
                    if (string.charAt(n) == ')') {
                        string2 = "";
                        if (n <= string.length() - 2 && string.charAt(n + 1) != ')' && string.charAt(n + 1) != ',') {
                            ++n;
                            stringBuffer = new StringBuffer("");
                            while (n <= string.length() - 1 && string.charAt(n) != ')' && string.charAt(n) != ',') {
                                stringBuffer.append(string.charAt(n));
                                ++n;
                            }
                            --n;
                            string2 = stringBuffer.toString();
                        }
                        bl = true;
                        while (true) {
                            string3 = stack.pop().toString();
                            if (stack.empty()) {
                                this.connectInternal(string2);
                                break block39;
                            }
                            string4 = stack.pop().toString();
                            if (stack.empty()) {
                                if (string3.equals("(")) {
                                    this.connectInternal(string2);
                                    stack.push("(");
                                    continue;
                                }
                                if (string3.equals(",")) {
                                    this.connectInternal(string2);
                                } else {
                                    this.addNodeAndConnect(string3, string2);
                                }
                                break block39;
                            }
                            string5 = stack.peek().toString();
                            if (!string5.equals("(") && string4.equals(",") && !string3.equals(",")) {
                                if (bl && !string5.equals(",")) {
                                    this.addNode(string3);
                                    stack.push(",");
                                } else {
                                    this.addNodeAndConnect(string3, string6);
                                }
                                bl = false;
                                continue;
                            }
                            bl = false;
                            if (string5.equals(",") && !string4.equals(",") && !string4.equals("(") && string3.equals(",")) {
                                this.addNodeAndConnect(string4, string6);
                                continue;
                            }
                            if (!string5.equals("(") && string4.equals(",") && string3.equals(",")) {
                                this.connectInternal(string6);
                                stack.push(",");
                                continue;
                            }
                            if (string5.equals("(") && string4.equals(",") && !string3.equals("(") && !string3.equals(",")) {
                                this.addNodeAndConnect(string3, string2);
                                stack.pop();
                                break block39;
                            }
                            if (string5.equals("(") && !string4.equals("(") && !string4.equals(",") && string3.equals(",")) {
                                this.addNodeAndConnect(string4, string2);
                                stack.pop();
                                break block39;
                            }
                            if (string5.equals("(") && string4.equals(",") && string3.equals(",")) {
                                this.connectInternal(string6);
                                this.connectInternal(string2);
                                stack.pop();
                                break block39;
                            }
                            if (string5.equals(",") && string4.equals("(") && !string3.equals("(") && !string3.equals(",")) {
                                this.addNodeAndConnect(string3, string2);
                                break block39;
                            }
                            if (string5.equals(",") && string4.equals("(") && string3.equals(",")) {
                                this.connectInternal(string2);
                                break block39;
                            }
                            if (string5.equals("(") && string4.equals("(") && !string3.equals("(")) {
                                if (string3.equals(",")) {
                                    this.connectInternal(string2);
                                } else {
                                    this.addNodeAndConnect(string3, string2);
                                }
                                break block39;
                            }
                            if (string3.equals("(") && (string5.equals("(") && string4.equals(",") || string5.equals(",") && string4.equals("(") || string5.equals("(") && string4.equals("("))) break;
                        }
                        this.connectInternal(string2);
                        stack.push("(");
                    }
                }
                ++n;
            }
            if (!this.getExtNode0().getRoot().getChild1().isPseudoNode() && !this.getExtNode0().getRoot().getChild2().isPseudoNode()) {
                this.setRooted(true);
            }
        } else {
            this.addNode(string);
            this.setRooted(true);
        }
        if (!this.isEmpty()) {
            this.setRoot(this.getExtNode0().getRoot());
            if (!this.isRooted()) {
                this.getRoot().deleteData();
            }
            this.findExtremeLnL();
            this.calculateRealHeight();
            if (this.areBranchLenghtsBootstraps()) {
                this.moveBranchLenghtsToBootstrap();
            }
        }
    }

    private double addDist(double d, double d2) {
        if (d >= 0.0 && d2 >= 0.0) {
            return d + d2;
        }
        if (d >= 0.0) {
            return d;
        }
        if (d2 >= 0.0) {
            return d2;
        }
        if (d == -100.0 && d2 == -100.0) {
            return -100.0;
        }
        return -99.0;
    }

    private void addIntoVector(Vector vector, Vector vector2) {
        int n = 0;
        while (n < vector.size()) {
            vector2.addElement(vector.elementAt(n));
            ++n;
        }
    }

    private void addNode(String string) throws Exception {
        if (this.getExtNode0() == null) {
            this.setExtNode0(new Node(string));
        } else {
            this.getExtNode0().addExtNode(string);
        }
        ++this.external_nodes_;
    }

    void addNodeAndConnect(String string, String string2) throws Exception {
        if (this.getExtNode0() == null) {
            System.err.println("addNodeAndConnect( String, String ): Error: Cannot add and connect one node to empty tree.");
            System.exit(-1);
        }
        this.getExtNode0().addExtNode(string);
        this.getExtNode0().connect(string2);
        ++this.external_nodes_;
    }

    /*
     * Unable to fully structure code
     */
    private void adjustExtNode0() {
        var1_1 = this.getRoot();
        if (var1_1 != null) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getChild1();
lbl5:
            // 2 sources

            ** while (!var1_1.isExternal())
        }
lbl6:
        // 1 sources

        this.setExtNode0(var1_1);
    }

    public void adjustNodeCount(boolean bl) {
        Node node = null;
        Node node2 = null;
        if (this.isEmpty()) {
            return;
        }
        this.adjustNodeCountHelper(this.getRoot());
        node2 = this.getExtNode0();
        block0: do {
            node = node2;
            do {
                if (bl && node.collapse()) {
                    if (node.getIndicator() != 1) {
                        node.setIndicator(1);
                    } else {
                        node2 = node2.getNextExtNode();
                        continue block0;
                    }
                }
                node.setSumExtNodes(node.getSumExtNodes() + 1);
            } while ((node = node.getParent()) != null);
            node2 = node2.getNextExtNode();
        } while (node2 != null);
    }

    private void adjustNodeCountHelper(Node node) {
        if (node == null) {
            return;
        }
        node.setSumExtNodes(0);
        node.setIndicator(0);
        this.adjustNodeCountHelper(node.getChild1());
        this.adjustNodeCountHelper(node.getChild2());
    }

    private void adjustReferencesInExtNodes() {
        Node node = null;
        Node node2 = null;
        if (this.isEmpty()) {
            return;
        }
        this.getRoot().setIndicatorsToZero();
        node = this.getRoot();
        if (this.getNumberOfExtNodes() <= 1) {
            return;
        }
        do {
            if (node.getIndicator() == 0 && !node.isExternal()) {
                node.setIndicator(1);
                node = node.getChild1();
            }
            if (node.getIndicator() == 1 && !node.isExternal()) {
                node.setIndicator(2);
                node = node.getChild2();
            }
            if (node.isExternal()) {
                node.setNextExtNode(null);
                node.setPrevExtNode(node2);
                if (node2 != null) {
                    node2.setNextExtNode(node);
                }
                node2 = node;
                node.setIndicator(2);
            }
            if (node.getIndicator() != 2) continue;
            node = node.getParent();
        } while (!node.isRoot() || node.getIndicator() != 2);
    }

    private boolean allowMoreThanBinaryNodesInNHoutput() {
        return this.more_than_bin_nodes_in_NH_;
    }

    public void allowMoreThanBinaryNodesInNHoutput(boolean bl) {
        this.more_than_bin_nodes_in_NH_ = bl;
    }

    public boolean areBranchLenghtsBootstraps() {
        Node node = null;
        double d = 0.0;
        double d2 = 0.0;
        if (this.isEmpty()) {
            return false;
        }
        if (this.getNumberOfExtNodes() <= 1) {
            return false;
        }
        if (this.getRoot().getBootstrap() != -99) {
            return false;
        }
        node = this.getExtNode0();
        while (node != null) {
            d = node.getDistanceToParent();
            if (d <= 0.0 || d % 10.0 != 0.0) {
                return false;
            }
            if ((node = node.getNextExtNode()) == null) continue;
            d2 = node.getDistanceToParent();
            if (d2 <= 0.0 || d2 % 10.0 != 0.0) {
                return false;
            }
            if (d == d2) continue;
            return false;
        }
        return true;
    }

    public double calculateRealHeight() {
        Node node = null;
        Node node2 = null;
        Node node3 = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (this.isEmpty()) {
            this.setRealHeight(0.0);
            return 0.0;
        }
        node = this.getRoot();
        node2 = node.getChild1();
        node3 = node.getChild2();
        if (this.isRooted() && (d = node.getDistanceToParent()) < 0.0) {
            d = 0.0;
        }
        if (node2 != null && node3 != null) {
            d3 = this.calculateRealHeightHelper(node2);
            d4 = this.calculateRealHeightHelper(node3);
            d5 = d3 - d4;
            d2 = d3 > d4 ? d3 : d4;
        }
        this.setRealHeight(d2 + d);
        return d5;
    }

    private double calculateRealHeightHelper(Node node) {
        if (node == null) {
            return 0.0;
        }
        if (node.collapse()) {
            double d = node.getDistanceToParent();
            if (d < 0.0) {
                d = 0.0;
            }
            return d;
        }
        double d = this.calculateRealHeightHelper(node.getChild1());
        double d2 = this.calculateRealHeightHelper(node.getChild2());
        double d3 = node.getDistanceToParent();
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        return d3 + (d > d2 ? d : d2);
    }

    public void collapseToDeepestAnotNodes() {
        if (this.isEmpty()) {
            return;
        }
        this.setAllNodesToNotCollapse();
        this.collapseToDeepestAnotNodesHelper(this.getRoot());
        this.adjustNodeCount(true);
        this.recalculateAndReset();
    }

    private void collapseToDeepestAnotNodesHelper(Node node) {
        if (node.isExternal()) {
            return;
        }
        if (!(node.isPseudoNode() || node.getSpecies().equals("") && node.getSeqName().equals(""))) {
            node.setCollapse(true);
            return;
        }
        this.collapseToDeepestAnotNodesHelper(node.getChild1());
        this.collapseToDeepestAnotNodesHelper(node.getChild2());
    }

    private void connectInternal(String string) throws Exception {
        if (this.isEmpty()) {
            return;
        }
        this.getExtNode0().connect(string);
    }

    public void copyBranchLengthValuesFrom(Tree tree) throws Exception {
        Node node;
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        Node[] nodeArray = null;
        Node[] nodeArray2 = null;
        int n = 0;
        if (this.isEmpty() || tree.isEmpty()) {
            return;
        }
        this.setIndicatorsToZero();
        tree.setIndicatorsToZero();
        Node node5 = this.getExtNode0();
        while (node5 != null) {
            node = node5;
            while (node != null) {
                if (!node.isExternal()) {
                    node.setDistanceToParent(0.0);
                }
                node = node.getParent();
            }
            node5 = node5.getNextExtNode();
        }
        node5 = tree.getExtNode0();
        while (node5 != null) {
            node = node5;
            while (node != null) {
                if (node.getIndicator() == 0 && !node.isPseudoNode()) {
                    node.setIndicator(1);
                    nodeArray2 = node.copyAllExtChildren();
                    node2 = nodeArray2[0];
                    ++n;
                    node4 = this.getExtNode0();
                    while (node4 != null) {
                        node3 = node4;
                        if (node2.equals(node4)) {
                            while (node3 != null) {
                                if (node3.getIndicator() != n && node3.getIndicator() != -1) {
                                    node3.setIndicator(n);
                                    if (nodeArray2.length == node3.getSumExtNodes()) {
                                        nodeArray = node3.copyAllExtChildren();
                                        if (Node.compareArraysOfNodes(nodeArray2, nodeArray)) {
                                            node3.setIndicator(-1);
                                            node3.setDistanceToParent(node.getDistanceToParent());
                                        } else {
                                            String string = "Trees were ";
                                            string = String.valueOf(string) + "not identical.";
                                            throw new Exception(string);
                                        }
                                    }
                                }
                                node3 = node3.getParent();
                            }
                        }
                        node4 = node4.getNextExtNode();
                    }
                }
                node = node.getParent();
            }
            node5 = node5.getNextExtNode();
        }
        if (!tree.isRooted()) {
            this.setRooted(false);
        } else {
            this.setRooted(true);
        }
        this.recalculateAndReset();
        this.reassignIDs();
    }

    public Tree copyTree() {
        Tree tree = new Tree();
        if (this.isEmpty()) {
            tree.delete();
            return tree;
        }
        tree.rooted_ = this.rooted_;
        tree.highest_lnL_ = this.highest_lnL_;
        tree.lowest_lnL_ = this.lowest_lnL_;
        tree.real_height_ = this.real_height_;
        tree.external_nodes_ = this.external_nodes_;
        tree.number_of_duplications_ = this.number_of_duplications_;
        tree.more_than_bin_nodes_in_NH_ = this.more_than_bin_nodes_in_NH_;
        tree.name_ = new String(this.name_);
        tree.idhash_ = this.idhash_;
        tree.root_ = Node.copyTree(this.root_);
        tree.getRoot().setParents();
        tree.adjustExtNode0();
        tree.adjustReferencesInExtNodes();
        return tree;
    }

    public void delete() {
        this.ext_node0_ = null;
        this.root_ = null;
        this.rooted_ = false;
        this.more_than_bin_nodes_in_NH_ = true;
        this.highest_lnL_ = 0.0;
        this.lowest_lnL_ = 0.0;
        this.real_height_ = 0.0;
        this.external_nodes_ = 0;
        this.number_of_duplications_ = -1;
        this.name_ = "";
        this.idhash_ = null;
        this.j_ = 0;
    }

    public Vector find(String string, String string2, String string3, int n) throws Exception {
        Vector<Node> vector = new Vector<Node>();
        PreorderTreeIterator preorderTreeIterator = null;
        Node node = null;
        Node node2 = null;
        boolean bl = false;
        if (this.isEmpty()) {
            return null;
        }
        string = string.toLowerCase().trim();
        string2 = string2.toLowerCase().trim();
        string3 = string3.toLowerCase().trim();
        preorderTreeIterator = new PreorderTreeIterator(this);
        while (!preorderTreeIterator.isDone()) {
            node = preorderTreeIterator.currentNode();
            if (string != null && !string.equals("")) {
                if (node.getSeqName().toLowerCase().equals(string)) {
                    node2 = node;
                } else {
                    bl = true;
                }
            }
            if (!bl && string2 != null && !string2.equals("")) {
                if (node.getSpecies().toLowerCase().equals(string2)) {
                    node2 = node;
                } else {
                    bl = true;
                }
            }
            if (!bl && string3 != null && !string3.equals("")) {
                if (node.getECnumber().toLowerCase().equals(string3)) {
                    node2 = node;
                } else {
                    bl = true;
                }
            }
            if (!bl && n != -99) {
                if (node.getTaxonomyID() == n) {
                    node2 = node;
                } else {
                    bl = true;
                }
            }
            if (!bl) {
                vector.addElement(node2);
            }
            preorderTreeIterator.next();
        }
        vector.trimToSize();
        return vector;
    }

    public void findExtremeLnL() {
        if (this.isEmpty()) {
            return;
        }
        this.lowest_lnL_ = Double.MAX_VALUE;
        this.highest_lnL_ = -1.7976931348623157E308;
        this.findExtremeLnLHelper(this.getRoot());
    }

    private void findExtremeLnLHelper(Node node) {
        if (node == null) {
            return;
        }
        if (node.isLnLonParentBranchAssigned() && !node.isPseudoNode()) {
            if ((double)node.getLnLonParentBranch() > this.highest_lnL_) {
                this.highest_lnL_ = node.getLnLonParentBranch();
            }
            if ((double)node.getLnLonParentBranch() < this.lowest_lnL_) {
                this.lowest_lnL_ = node.getLnLonParentBranch();
            }
        }
        this.findExtremeLnLHelper(node.getChild1());
        this.findExtremeLnLHelper(node.getChild2());
    }

    public Vector findInNameSpecECid(String string) throws Exception {
        Vector<Node> vector = new Vector<Node>();
        PreorderTreeIterator preorderTreeIterator = null;
        Node node = null;
        if (this.isEmpty()) {
            return null;
        }
        if ((string = string.toLowerCase().trim()).equals("")) {
            return null;
        }
        preorderTreeIterator = new PreorderTreeIterator(this);
        while (!preorderTreeIterator.isDone()) {
            node = preorderTreeIterator.currentNode();
            if (node.getSeqName().toLowerCase().indexOf(string) >= 0) {
                vector.addElement(node);
            } else if (node.getSpecies().toLowerCase().indexOf(string) >= 0) {
                vector.addElement(node);
            } else if (node.getECnumber().toLowerCase().indexOf(string) >= 0) {
                vector.addElement(node);
            } else {
                String string2 = new Integer(node.getTaxonomyID()).toString();
                if (string2 != null && string2.equals(string)) {
                    vector.addElement(node);
                }
            }
            preorderTreeIterator.next();
        }
        vector.trimToSize();
        return vector;
    }

    public String[] getAllExternalSeqNames() {
        int n = 0;
        if (this.isEmpty()) {
            return null;
        }
        String[] stringArray = new String[this.getNumberOfExtNodes()];
        Node node = this.getExtNode0();
        while (node != null) {
            stringArray[n++] = new String(node.getSeqName());
            node = node.getNextExtNode();
        }
        return stringArray;
    }

    /*
     * Unable to fully structure code
     */
    public Vector getExtDescendantsOfDeepestSrelatedNode(Node var1_1) {
        var2_2 = var1_1;
        var3_3 = new Vector();
        if (var2_2.isExternal() && !this.isEmpty()) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            var2_2 = var2_2.getParent();
lbl6:
            // 2 sources

            ** while (!var2_2.isRoot() && !var2_2.getParent().isDuplication())
        }
lbl7:
        // 1 sources

        var3_3 = var2_2.getAllExternalChildren();
        var3_3.removeElement(var1_1);
        var3_3.trimToSize();
        return var3_3;
    }

    public Node getExtNode0() {
        return this.ext_node0_;
    }

    public double getHighestLnL() {
        return this.highest_lnL_;
    }

    public double getLowestLnL() {
        return this.lowest_lnL_;
    }

    public String getName() {
        return this.name_;
    }

    public Node getNode(int n) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.idhash_ != null) {
            return (Node)this.idhash_.get(new Integer(n));
        }
        return this.getNodeHelper(this.getRoot(), n);
    }

    public Node getNode(String string) throws Exception {
        Vector vector = this.getNodes(string);
        if (this.isEmpty()) {
            return null;
        }
        if (vector == null || vector.size() < 1) {
            throw new Exception(String.valueOf(string) + " not found");
        }
        if (vector.size() > 1) {
            throw new Exception(String.valueOf(string) + " not unique");
        }
        return (Node)vector.elementAt(0);
    }

    private Node getNodeHelper(Node node, int n) {
        if (node == null || node.getID() == n) {
            return node;
        }
        Node node2 = this.getNodeHelper(node.getChild1(), n);
        Node node3 = this.getNodeHelper(node.getChild2(), n);
        if (node2 != null) {
            return node2;
        }
        return node3;
    }

    public Vector getNodes(String string) throws Exception {
        Vector<Node> vector = new Vector<Node>();
        PreorderTreeIterator preorderTreeIterator = null;
        if (this.isEmpty()) {
            return null;
        }
        preorderTreeIterator = new PreorderTreeIterator(this);
        while (!preorderTreeIterator.isDone()) {
            if (preorderTreeIterator.currentNode().getSeqName().equals(string)) {
                vector.addElement(preorderTreeIterator.currentNode());
            }
            preorderTreeIterator.next();
        }
        vector.trimToSize();
        return vector;
    }

    public Vector getNodesWithMatchingSpecies(String string) throws Exception {
        Vector<Node> vector = new Vector<Node>();
        PreorderTreeIterator preorderTreeIterator = null;
        if (this.isEmpty()) {
            return null;
        }
        preorderTreeIterator = new PreorderTreeIterator(this);
        while (!preorderTreeIterator.isDone()) {
            if (preorderTreeIterator.currentNode().getSpecies().equals(string)) {
                vector.addElement(preorderTreeIterator.currentNode());
            }
            preorderTreeIterator.next();
        }
        vector.trimToSize();
        return vector;
    }

    public int getNumberOfDuplications() {
        return this.number_of_duplications_;
    }

    public int getNumberOfExtNodes() {
        return this.external_nodes_;
    }

    /*
     * Unable to fully structure code
     */
    public Vector getOrthologs(Node var1_1) {
        var2_2 = var1_1;
        var3_3 = null;
        var4_4 = new Vector<E>();
        if (var2_2.isExternal() && !this.isEmpty()) ** GOTO lbl12
        return null;
lbl-1000:
        // 1 sources

        {
            var3_3 = var2_2;
            if ((var2_2 = var2_2.getParent()).isDuplication()) continue;
            if (var2_2.getChild1() == var3_3) {
                this.addIntoVector(var2_2.getChild2().getAllExternalChildren(), var4_4);
                continue;
            }
            this.addIntoVector(var2_2.getChild1().getAllExternalChildren(), var4_4);
lbl12:
            // 4 sources

            ** while (!var2_2.isRoot())
        }
lbl13:
        // 1 sources

        var4_4.trimToSize();
        return var4_4;
    }

    public double getRealHeight() {
        return this.real_height_;
    }

    public Node getRoot() {
        return this.root_;
    }

    /*
     * Unable to fully structure code
     */
    public Vector getStrictlyDrelatedNodes(Node var1_1) {
        var2_2 = var1_1;
        var3_3 = null;
        var4_4 = new Vector<Node>();
        if (var2_2.isExternal() && !this.isEmpty()) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            var2_2 = var2_2.getParent();
lbl7:
            // 2 sources

            ** while (!var2_2.isRoot() && var2_2.getParent().isDuplication())
        }
lbl8:
        // 1 sources

        var3_3 = var2_2;
        var3_3.setIndicatorsToZero();
        do {
            if (!var2_2.isExternal()) {
                if (var2_2.getIndicator() == 0) {
                    var2_2.setIndicator(1);
                    if (var2_2.isDuplication()) {
                        var2_2 = var2_2.getChild1();
                    }
                }
                if (var2_2.getIndicator() == 1) {
                    var2_2.setIndicator(2);
                    if (var2_2.isDuplication()) {
                        var2_2 = var2_2.getChild2();
                    }
                }
                if (var2_2 == var3_3 || var2_2.getIndicator() != 2) continue;
                var2_2 = var2_2.getParent();
                continue;
            }
            if (var2_2 != var1_1) {
                var4_4.addElement(var2_2);
            }
            if (var2_2 != var3_3) {
                var2_2 = var2_2.getParent();
                continue;
            }
            var2_2.setIndicator(2);
        } while (var2_2 != var3_3 || var3_3.getIndicator() != 2);
        var4_4.trimToSize();
        return var4_4;
    }

    /*
     * Unable to fully structure code
     */
    public Vector getStrictlySrelatedNodes(Node var1_1) {
        var2_2 = var1_1;
        var3_3 = null;
        var4_4 = new Vector<Node>();
        if (var2_2.isExternal() && !this.isEmpty()) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            var2_2 = var2_2.getParent();
lbl7:
            // 2 sources

            ** while (!var2_2.isRoot() && !var2_2.getParent().isDuplication())
        }
lbl8:
        // 1 sources

        var3_3 = var2_2;
        var3_3.setIndicatorsToZero();
        do {
            if (!var2_2.isExternal()) {
                if (var2_2.getIndicator() == 0) {
                    var2_2.setIndicator(1);
                    if (!var2_2.isDuplication()) {
                        var2_2 = var2_2.getChild1();
                    }
                }
                if (var2_2.getIndicator() == 1) {
                    var2_2.setIndicator(2);
                    if (!var2_2.isDuplication()) {
                        var2_2 = var2_2.getChild2();
                    }
                }
                if (var2_2 == var3_3 || var2_2.getIndicator() != 2) continue;
                var2_2 = var2_2.getParent();
                continue;
            }
            if (var2_2 != var1_1) {
                var4_4.addElement(var2_2);
            }
            if (var2_2 != var3_3) {
                var2_2 = var2_2.getParent();
                continue;
            }
            var2_2.setIndicator(2);
        } while (var2_2 != var3_3 || var3_3.getIndicator() != 2);
        var4_4.trimToSize();
        return var4_4;
    }

    public void hashIDs() {
        this.idhash_ = null;
        Stack<Node> stack = null;
        Node node = null;
        if (this.isEmpty()) {
            return;
        }
        this.idhash_ = new Hashtable();
        stack = new Stack<Node>();
        node = this.getRoot();
        stack.push(node);
        while (!stack.empty()) {
            node = (Node)stack.pop();
            this.idhash_.put(new Integer(node.getID()), node);
            if (node.getChild1() != null) {
                stack.push(node.getChild1());
            }
            if (node.getChild2() == null) continue;
            stack.push(node.getChild2());
        }
    }

    public boolean isCompletelyBinary() {
        if (this.isEmpty()) {
            return false;
        }
        return this.isCompletelyBinaryHelper(this.getRoot());
    }

    private boolean isCompletelyBinaryHelper(Node node) {
        if (node == null) {
            return true;
        }
        if (node.isPseudoNode()) {
            return false;
        }
        boolean bl = this.isCompletelyBinaryHelper(node.getChild1());
        boolean bl2 = this.isCompletelyBinaryHelper(node.getChild2());
        return bl && bl2;
    }

    public boolean isEmpty() {
        return this.getExtNode0() == null;
    }

    public boolean isRooted() {
        return this.rooted_;
    }

    public void levelOrderReID(int n) {
        this.idhash_ = null;
        this.levelOrderReIDHelper(this.getRoot(), n);
    }

    private void levelOrderReIDHelper(Node node, int n) {
        node.setID(n);
        ++n;
        if (node.getChild1() != null) {
            this.levelOrderReIDHelper(node.getChild1(), n);
        }
        if (node.getChild2() != null) {
            this.levelOrderReIDHelper(node.getChild2(), n);
        }
    }

    public void moveBranchLenghtsToBootstrap() {
        Node node = null;
        Node node2 = null;
        if (this.isEmpty()) {
            return;
        }
        this.setIndicatorsToZero();
        node = this.getExtNode0();
        while (node != null) {
            node2 = node;
            while (node2 != null) {
                if (node2.getIndicator() == 0) {
                    if (node2.getDistanceToParent() > 0.0) {
                        if (!node2.isExternal()) {
                            node2.setBootstrap((int)node2.getDistanceToParent());
                        }
                        node2.setDistanceToParent(-99.0);
                    } else {
                        node2.setBootstrap(-99);
                    }
                    node2.setIndicator(1);
                }
                node2 = node2.getParent();
            }
            node = node.getNextExtNode();
        }
        this.recalculateAndReset();
    }

    private void moveRootToMiddle() {
        if (this.getRoot().getChild1() != null && this.getRoot().getChild2() != null) {
            double d = this.getRoot().getChild1().getDistanceToParent();
            double d2 = this.getRoot().getChild2().getDistanceToParent();
            double d3 = 0.0;
            if (d < 0.0) {
                d = 0.0;
            }
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            d3 = (d + d2) / 2.0;
            this.getRoot().getChild1().setDistanceToParent(d3);
            this.getRoot().getChild2().setDistanceToParent(d3);
        }
    }

    public void orderAppearance(boolean bl) {
        if (this.isEmpty()) {
            return;
        }
        this.orderAppearanceHelper(this.getRoot(), bl);
        this.adjustExtNode0();
        this.adjustReferencesInExtNodes();
    }

    private void orderAppearanceHelper(Node node, boolean bl) {
        if (node.isExternal()) {
            return;
        }
        Node node2 = null;
        if (node.getChild1().getSumExtNodes() != node.getChild2().getSumExtNodes() && node.getChild1().getSumExtNodes() < node.getChild2().getSumExtNodes() == bl) {
            node2 = node.getChild1();
            node.setChild1(node.getChild2());
            node.setChild2(node2);
        }
        this.orderAppearanceHelper(node.getChild1(), bl);
        this.orderAppearanceHelper(node.getChild2(), bl);
    }

    public int preorderReID(int n) {
        Stack<Node> stack = null;
        Node node = null;
        if (this.isEmpty()) {
            return n;
        }
        stack = new Stack<Node>();
        node = this.getRoot();
        stack.push(node);
        while (!stack.empty()) {
            node = (Node)stack.pop();
            node.setID(n++);
            if (node.getChild2() != null) {
                stack.push(node.getChild2());
            }
            if (node.getChild1() == null) continue;
            stack.push(node.getChild1());
        }
        this.idhash_ = null;
        return n;
    }

    public void printAllNodes() {
        if (this.isEmpty()) {
            return;
        }
        this.getRoot().preorderPrint();
    }

    /*
     * Unable to fully structure code
     */
    public void printExtNodes() {
        var1_1 = this.getExtNode0();
        if (!this.isEmpty()) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            System.out.println(String.valueOf(String.valueOf(var1_1)) + "\n");
            var1_1 = var1_1.getNextExtNode();
lbl6:
            // 2 sources

            ** while (var1_1 != null)
        }
lbl7:
        // 1 sources

    }

    public void reRoot(int n) throws Exception {
        this.reRoot(this.getNode(n));
    }

    public void reRoot(Branch branch) throws Exception {
        Node node = branch.getNode1();
        Node node2 = branch.getNode2();
        if (node2 == node.getChild1() || node2 == node.getChild2()) {
            this.reRoot(node2);
        } else if (node == node2.getChild1() || node == node2.getChild2()) {
            this.reRoot(node);
        } else if (node.getParent() != null && node.getParent().isRoot() && (node.getParent().getChild1() == node2 || node.getParent().getChild2() == node2)) {
            this.reRoot(node);
        } else {
            throw new Exception("reRoot( Branch b ): b is not a branch.");
        }
    }

    public void reRoot(Node node) throws Exception {
        Node node2 = node;
        Node node3 = null;
        Node node4 = null;
        Node node5 = null;
        Node node6 = null;
        double d = 0.0;
        double d2 = 0.0;
        float f = 0.0f;
        float f2 = 0.0f;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        int n2 = 0;
        if (this.isEmpty() || this.getNumberOfExtNodes() < 2) {
            return;
        }
        if (node2.isPseudoNode()) {
            throw new Exception("Tree: reRoot(Node): Can not place root on parent branch of pseudo node.");
        }
        this.setRooted(true);
        if (node2.isRoot()) {
            this.moveRootToMiddle();
            return;
        }
        if (node2.getParent().isRoot()) {
            if (this.getRoot().getChild1().isPseudoNode() || this.getRoot().getChild2().isPseudoNode()) {
                if (this.getRoot().getChild1() == node2 && this.getRoot().getChild2().isPseudoNode()) {
                    node3 = this.getRoot().getChild2();
                }
                if (this.getRoot().getChild2() == node2 && this.getRoot().getChild1().isPseudoNode()) {
                    node3 = this.getRoot().getChild1();
                }
                if (node2.getDistanceToParent() == -99.0) {
                    node3.setDistanceToParent(-99.0);
                } else {
                    double d3 = node2.getDistanceToParent() / 2.0;
                    node3.setDistanceToParent(d3);
                    node2.setDistanceToParent(d3);
                }
                node3.setLnLonParentBranch(node2.getLnLonParentBranch());
                node3.setSignificantlyWorse(node2.significantlyWorse());
                node3.setLnLonParentBranchAssigned(node2.isLnLonParentBranchAssigned());
                node3.setBootstrap(node2.getBootstrap());
            } else {
                this.moveRootToMiddle();
            }
            return;
        }
        node4 = node2.getParent();
        node5 = node4.getParent();
        node6 = new Node();
        if (node4.getChild2() == node2) {
            node6.setChild1(node2);
            node6.setChild2(node4);
        } else {
            node6.setChild1(node4);
            node6.setChild2(node2);
        }
        d = node5.getDistanceToParent();
        f = node5.getLnLonParentBranch();
        bl = node5.significantlyWorse();
        bl3 = node5.isLnLonParentBranchAssigned();
        n = node5.getBootstrap();
        node5.setDistanceToParent(node4.getDistanceToParent());
        node5.setLnLonParentBranch(node4.getLnLonParentBranch());
        node5.setLnLonParentBranchAssigned(node4.isLnLonParentBranchAssigned());
        node5.setSignificantlyWorse(node4.significantlyWorse());
        node5.setBootstrap(node4.getBootstrap());
        node4.setLnLonParentBranch(node2.getLnLonParentBranch());
        node4.setLnLonParentBranchAssigned(node2.isLnLonParentBranchAssigned());
        node4.setSignificantlyWorse(node2.significantlyWorse());
        node4.setBootstrap(node2.getBootstrap());
        if (node2.getDistanceToParent() == -99.0) {
            node4.setDistanceToParent(-99.0);
        } else {
            double d4 = node2.getDistanceToParent() / 2.0;
            node4.setDistanceToParent(d4);
            node2.setDistanceToParent(d4);
        }
        node2.setParent(node6);
        if (node4.getChild1() == node2) {
            node4.setChild1(node5);
        } else {
            node4.setChild2(node5);
        }
        node4.setParent(node6);
        while (!node5.isRoot()) {
            node2 = node4;
            node4 = node5;
            node5 = node5.getParent();
            if (node4.getChild1() == node2) {
                node4.setChild1(node5);
            } else {
                node4.setChild2(node5);
            }
            node4.setParent(node2);
            d2 = node5.getDistanceToParent();
            f2 = node5.getLnLonParentBranch();
            bl2 = node5.significantlyWorse();
            bl4 = node5.isLnLonParentBranchAssigned();
            n2 = node5.getBootstrap();
            node5.setDistanceToParent(d);
            node5.setLnLonParentBranch(f);
            node5.setSignificantlyWorse(bl);
            node5.setLnLonParentBranchAssigned(bl3);
            node5.setBootstrap(n);
            d = d2;
            f = f2;
            bl = bl2;
            bl3 = bl4;
            n = n2;
        }
        node3 = node5.getChild1() == node4 ? node5.getChild2() : node5.getChild1();
        node3.setParent(node4);
        if (node5.getDistanceToParent() == -100.0 && node3.getDistanceToParent() == -100.0) {
            node3.setDistanceToParent(-100.0);
        } else if (!(node5.getDistanceToParent() != -99.0 && node5.getDistanceToParent() != -100.0 || node3.getDistanceToParent() != -99.0 && node3.getDistanceToParent() != -100.0)) {
            node3.setDistanceToParent(-99.0);
        } else {
            node3.setDistanceToParent((node5.getDistanceToParent() >= 0.0 ? node5.getDistanceToParent() : 0.0) + (node3.getDistanceToParent() >= 0.0 ? node3.getDistanceToParent() : 0.0));
        }
        if (node5.getDistanceToParent() != -100.0) {
            node3.setLnLonParentBranch(node5.getLnLonParentBranch());
            node3.setSignificantlyWorse(node5.significantlyWorse());
            node3.setLnLonParentBranchAssigned(node5.isLnLonParentBranchAssigned());
        }
        node3.setBootstrap(node5.getBootstrap());
        if (node4.getChild1() != node5) {
            node4.setChild2(node3);
        } else {
            node4.setChild1(node3);
        }
        this.setRoot(node6);
        this.adjustExtNode0();
        this.adjustReferencesInExtNodes();
    }

    public void reRootSkeleton(Branch branch) throws Exception {
        Node node = branch.getNode1();
        Node node2 = branch.getNode2();
        if (node2 == node.getChild1() || node2 == node.getChild2()) {
            this.reRootSkeleton(node2);
        } else if (node == node2.getChild1() || node == node2.getChild2()) {
            this.reRootSkeleton(node);
        } else if (node.getParent() != null && node.getParent().isRoot() && (node.getParent().getChild1() == node2 || node.getParent().getChild2() == node2)) {
            this.reRootSkeleton(node);
        } else {
            throw new Exception("reRootSkeleton( Branch b ): b is not a branch.");
        }
    }

    public void reRootSkeleton(Node node) throws Exception {
        Node node2 = node;
        Node node3 = null;
        Node node4 = null;
        Node node5 = null;
        Node node6 = null;
        double d = 0.0;
        double d2 = 0.0;
        if (this.isEmpty() || this.getNumberOfExtNodes() < 2) {
            return;
        }
        this.setRooted(true);
        if (node2.isRoot() || node2.getParent().isRoot()) {
            this.moveRootToMiddle();
            return;
        }
        node4 = node2.getParent();
        node5 = node4.getParent();
        node6 = new Node();
        if (node4.getChild2() == node2) {
            node6.setChild1(node2);
            node6.setChild2(node4);
        } else {
            node6.setChild1(node4);
            node6.setChild2(node2);
        }
        d = node5.getDistanceToParent();
        node5.setDistanceToParent(node4.getDistanceToParent());
        if (node2.getDistanceToParent() == -99.0) {
            node4.setDistanceToParent(-99.0);
        } else {
            double d3 = node2.getDistanceToParent() / 2.0;
            node4.setDistanceToParent(d3);
            node2.setDistanceToParent(d3);
        }
        node2.setParent(node6);
        if (node4.getChild1() == node2) {
            node4.setChild1(node5);
        } else {
            node4.setChild2(node5);
        }
        node4.setParent(node6);
        while (!node5.isRoot()) {
            node2 = node4;
            node4 = node5;
            node5 = node5.getParent();
            if (node4.getChild1() == node2) {
                node4.setChild1(node5);
            } else {
                node4.setChild2(node5);
            }
            node4.setParent(node2);
            d2 = node5.getDistanceToParent();
            node5.setDistanceToParent(d);
            d = d2;
        }
        node3 = node5.getChild1() == node4 ? node5.getChild2() : node5.getChild1();
        node3.setParent(node4);
        if (node5.getDistanceToParent() == -99.0 && node3.getDistanceToParent() == -99.0) {
            node3.setDistanceToParent(-99.0);
        } else {
            node3.setDistanceToParent((node5.getDistanceToParent() >= 0.0 ? node5.getDistanceToParent() : 0.0) + (node3.getDistanceToParent() >= 0.0 ? node3.getDistanceToParent() : 0.0));
        }
        if (node4.getChild1() != node5) {
            node4.setChild2(node3);
        } else {
            node4.setChild1(node3);
        }
        this.setRoot(node6);
    }

    private void reassignIDs() {
        PreorderTreeIterator preorderTreeIterator = null;
        if (this.isEmpty()) {
            return;
        }
        try {
            preorderTreeIterator = new PreorderTreeIterator(this);
        }
        catch (Exception exception) {
            System.err.println("Unexpected failure: Could not create Iterator.");
            exception.printStackTrace();
            System.exit(-1);
        }
        while (!preorderTreeIterator.isDone()) {
            Node.setNodeCount(Node.getNodeCount() + 1);
            preorderTreeIterator.currentNode().setID(Node.getNodeCount());
            preorderTreeIterator.next();
        }
        this.idhash_ = null;
    }

    public void recalculateAndReset() {
        if (this.isEmpty()) {
            return;
        }
        this.findExtremeLnL();
        this.calculateRealHeight();
        this.setExtNodes(this.getRoot().getSumExtNodes());
    }

    public void removeExtNode(Node node) {
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        if (this.isEmpty()) {
            return;
        }
        if (this.getNumberOfExtNodes() == 1 && node == this.getExtNode0()) {
            this.delete();
            return;
        }
        node2 = node;
        if (node2 == this.getExtNode0()) {
            this.setExtNode0(node2.getNextExtNode());
            node2.getNextExtNode().setPrevExtNode(null);
        } else if (node2.getNextExtNode() == null) {
            node2.getPrevExtNode().setNextExtNode(null);
        } else {
            node2.getNextExtNode().setPrevExtNode(node2.getPrevExtNode());
            node2.getPrevExtNode().setNextExtNode(node2.getNextExtNode());
        }
        node3 = node2.getParent();
        if (node3.isRoot()) {
            if (node2.isChild1()) {
                this.setRoot(this.getRoot().getChild2());
                this.getRoot().setParent(null);
            } else {
                this.setRoot(this.getRoot().getChild1());
                this.getRoot().setParent(null);
            }
        } else {
            node4 = node2.getParent().getParent();
            if (node3.isChild1()) {
                if (node2.isChild1()) {
                    node3.getChild2().setDistanceToParent(this.addDist(node3.getDistanceToParent(), node3.getChild2().getDistanceToParent()));
                    node4.setChild1(node3.getChild2());
                    node3.getChild2().setParent(node4);
                } else {
                    node3.getChild1().setDistanceToParent(this.addDist(node3.getDistanceToParent(), node3.getChild1().getDistanceToParent()));
                    node4.setChild1(node3.getChild1());
                    node3.getChild1().setParent(node4);
                }
            } else if (node2.isChild1()) {
                node3.getChild2().setDistanceToParent(this.addDist(node3.getDistanceToParent(), node3.getChild2().getDistanceToParent()));
                node4.setChild2(node3.getChild2());
                node3.getChild2().setParent(node4);
            } else {
                node3.getChild1().setDistanceToParent(this.addDist(node3.getDistanceToParent(), node3.getChild1().getDistanceToParent()));
                node4.setChild2(node3.getChild1());
                node3.getChild1().setParent(node4);
            }
            while (node4 != this.getRoot()) {
                node4.setSumExtNodes(node4.getSumExtNodes() - 1);
                node4 = node4.getParent();
            }
            node4.setSumExtNodes(node4.getSumExtNodes() - 1);
        }
        this.setExtNodes(this.getNumberOfExtNodes() - 1);
        this.idhash_ = null;
    }

    public void setAllNodesToNotCollapse() {
        if (this.isEmpty()) {
            return;
        }
        this.setAllNodesToNotCollapseHelper(this.getRoot());
    }

    private void setAllNodesToNotCollapseHelper(Node node) {
        if (node.isExternal()) {
            return;
        }
        node.setCollapse(false);
        this.setAllNodesToNotCollapseHelper(node.getChild1());
        this.setAllNodesToNotCollapseHelper(node.getChild2());
    }

    private void setExtNode0(Node node) {
        this.ext_node0_ = node;
    }

    public void setExtNodes(int n) {
        this.external_nodes_ = n;
    }

    private void setHighestLnL(double d) {
        this.highest_lnL_ = d;
    }

    public void setIndicatorsToZero() {
        if (this.isEmpty()) {
            return;
        }
        this.getRoot().setIndicatorsToZero();
    }

    private void setLowestLnL(double d) {
        this.lowest_lnL_ = d;
    }

    public void setName(String string) {
        this.name_ = string;
    }

    public void setNumberOfDuplications(int n) {
        this.number_of_duplications_ = n < 0 ? -1 : n;
    }

    public void setRealHeight(double d) {
        this.real_height_ = d;
    }

    void setRoot(Node node) {
        this.root_ = node;
    }

    public void setRooted(boolean bl) {
        this.rooted_ = bl;
    }

    private String stackToString(Stack stack) {
        int n = 0;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer(10000);
        if (this.getNumberOfExtNodes() >= 2) {
            stringBuffer.append("(");
        } else {
            stringBuffer.append("");
        }
        while (!stack.empty()) {
            string = stack.pop().toString();
            if (string.startsWith("(") && stringBuffer.charAt(stringBuffer.length() - 1) == ')') {
                stringBuffer.append(",");
                stringBuffer.append(string);
                continue;
            }
            if (string.startsWith("(") && stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '(' && stringBuffer.charAt(stringBuffer.length() - 1) != ',') {
                stringBuffer.append(",");
                stringBuffer.append(string);
                continue;
            }
            if (string.startsWith(",") && stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '(') {
                stringBuffer.append(string.substring(1));
                continue;
            }
            if (string.startsWith(")") && stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                stringBuffer = new StringBuffer(stringBuffer.toString().substring(0, stringBuffer.length() - 1));
                stringBuffer.append(string);
                continue;
            }
            if (string.startsWith(",") && stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                stringBuffer.append(string.substring(1));
                continue;
            }
            stringBuffer.append(string);
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
            stringBuffer = new StringBuffer(stringBuffer.toString().substring(0, stringBuffer.length() - 1));
        }
        if (this.getNumberOfExtNodes() >= 2) {
            stringBuffer.append(");");
        } else {
            stringBuffer.append(";");
        }
        if (stringBuffer.charAt(0) == ',') {
            stringBuffer = new StringBuffer(stringBuffer.toString().substring(1));
        }
        n = 0;
        while (n <= stringBuffer.length() - 1) {
            if (stringBuffer.charAt(n) == '\t') {
                stringBuffer = new StringBuffer(String.valueOf(stringBuffer.toString().substring(0, n)) + stringBuffer.toString().substring(n + 1));
                --n;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public Tree subTree(int n) {
        Tree tree = null;
        Node node = null;
        if (this.isEmpty()) {
            return null;
        }
        tree = this.copyTree();
        node = tree.getNode(n);
        if (node == null || node.isExternal()) {
            return null;
        }
        node.setParent(null);
        node.setDistanceToParent(-99.0);
        tree.setRooted(true);
        tree.setRoot(node);
        tree.adjustExtNode0();
        tree.adjustReferencesInExtNodes();
        tree.adjustNodeCount(true);
        tree.recalculateAndReset();
        tree.setExtNodes(tree.getRoot().getSumExtNodes());
        return tree;
    }

    public void swapChildren(int n) {
        this.swapChildren(this.getNode(n));
    }

    public void swapChildren(Node node) {
        Node node2 = null;
        if (this.isEmpty()) {
            return;
        }
        if (node.isExternal()) {
            return;
        }
        node2 = node.getChild1();
        node.setChild1(node.getChild2());
        node.setChild2(node2);
        this.adjustExtNode0();
        this.adjustReferencesInExtNodes();
    }

    public String toNewHampshire(boolean bl) {
        int n = 0;
        String string = "";
        String string2 = "";
        Stack<String> stack = null;
        Stack stack2 = null;
        Node node = null;
        if (this.isEmpty()) {
            return "";
        }
        stack = new Stack<String>();
        stack2 = new Stack();
        node = this.getRoot();
        this.adjustNodeCount(false);
        this.setIndicatorsToZero();
        do {
            if (!node.isExternal()) {
                if (node.getIndicator() == 0) {
                    node.setIndicator(1);
                    node = node.getChild1();
                }
                if (node.getIndicator() == 1) {
                    node.setIndicator(2);
                    node = node.getChild2();
                }
                if (node.getIndicator() != 2) continue;
                if (!(node.isPseudoNode() && (this.allowMoreThanBinaryNodesInNHoutput() || node.getParent().isRoot() || node.getParent().getChild1().isPseudoNode() && node.getParent().getChild2().isPseudoNode() && node.getParent().getChild1() != node))) {
                    n = 0;
                    while (n < 2 * node.getSumExtNodes() - 2) {
                        stack2.push(stack.pop());
                        if (stack2.peek().toString().equals("(") || stack2.peek().toString().equals(")")) continue;
                        ++n;
                    }
                    stack.push("(");
                    while (!stack2.empty()) {
                        stack.push((String)stack2.pop());
                    }
                    stack.push(")");
                }
                string = node.getDistanceToParent() >= 0.0 && !node.isPseudoNode() ? ":" + node.getDistanceToParent() + "," : (node.isPseudoNode() && !this.allowMoreThanBinaryNodesInNHoutput() && !node.getParent().isRoot() && (!node.getParent().getChild1().isPseudoNode() || !node.getParent().getChild2().isPseudoNode() || node.getParent().getChild1() == node) ? ":0.0," : ",");
                stack.push(string);
                node = node.getParent();
                continue;
            }
            if (bl && !node.getSeqName().equals("")) {
                String string3 = node.getSeqName();
                try {
                    if (string3.length() > 10) {
                        string3 = string3.substring(0, 11);
                    }
                    if (string3.indexOf(47) > 0) {
                        string3 = string3.substring(0, string3.indexOf(47));
                    }
                }
                catch (Exception exception) {
                    System.err.println("\ntoNewHampshire()Unexpected Exception.\n");
                }
                string = "," + string3;
            } else {
                string = !bl && !node.getSeqName().equals("") ? "," + node.getSeqName() : (!bl && !node.getSpecies().equals("") ? "," + node.getSpecies() : (!bl && !node.getECnumber().equals("") ? "," + node.getECnumber() : ",\t"));
            }
            if (node.getDistanceToParent() >= 0.0) {
                string = String.valueOf(string) + ":" + node.getDistanceToParent();
            }
            stack.push(string);
            if (!node.isRoot()) {
                node = node.getParent();
                continue;
            }
            node.setIndicator(2);
        } while (!node.isRoot() || node.getIndicator() != 2);
        while (!stack.empty()) {
            stack2.push(stack.pop());
        }
        string2 = this.stackToString(stack2);
        this.adjustNodeCount(true);
        if (string2.indexOf("(") == -1) {
            return "";
        }
        return string2;
    }

    public String toNewHampshireX() {
        int n = 0;
        String string = "";
        String string2 = "";
        Stack<String> stack = null;
        Stack stack2 = null;
        Node node = null;
        if (this.isEmpty()) {
            return "";
        }
        stack = new Stack<String>();
        stack2 = new Stack();
        node = this.getRoot();
        this.adjustNodeCount(false);
        this.setIndicatorsToZero();
        do {
            if (!node.isExternal()) {
                if (node.getIndicator() == 0) {
                    node.setIndicator(1);
                    node = node.getChild1();
                }
                if (node.getIndicator() == 1) {
                    node.setIndicator(2);
                    node = node.getChild2();
                }
                if (node.getIndicator() != 2) continue;
                if (!(node.isPseudoNode() && (this.allowMoreThanBinaryNodesInNHoutput() || node.getParent().isRoot() || node.getParent().getChild1().isPseudoNode() && node.getParent().getChild2().isPseudoNode() && node.getParent().getChild1() != node))) {
                    n = 0;
                    while (n < 2 * node.getSumExtNodes() - 2) {
                        stack2.push(stack.pop());
                        if (stack2.peek().toString().equals("(") || stack2.peek().toString().equals(")")) continue;
                        ++n;
                    }
                    stack.push("(");
                    while (!stack2.empty()) {
                        stack.push((String)stack2.pop());
                    }
                    stack.push(")");
                }
                string = "";
                if (!node.isPseudoNode()) {
                    string = node.toNewHampshireX();
                } else if (!(!node.isPseudoNode() || this.allowMoreThanBinaryNodesInNHoutput() || node.getParent().isRoot() || node.getParent().getChild1().isPseudoNode() && node.getParent().getChild2().isPseudoNode() && node.getParent().getChild1() != node)) {
                    string = ":0.0";
                }
                if (string.length() >= 1) {
                    string = String.valueOf(string) + ",";
                }
                stack.push(string);
                node = node.getParent();
                continue;
            }
            string = ",";
            string = String.valueOf(string) + node.toNewHampshireX();
            stack.push(string);
            if (!node.isRoot()) {
                node = node.getParent();
                continue;
            }
            node.setIndicator(2);
        } while (!node.isRoot() || node.getIndicator() != 2);
        while (!stack.empty()) {
            stack2.push(stack.pop());
        }
        string2 = this.stackToString(stack2);
        if (!(this.getNumberOfExtNodes() < 2 || this.root_.getSeqName().equals("") && this.root_.getDistanceToParent() == 0.0 && this.root_.getSpecies().equals("") && this.root_.getECnumber().equals("") && !this.root_.isLnLonParentBranchAssigned() && !this.root_.isDuplicationOrSpecAssigned() && this.root_.getBootstrap() == 0)) {
            string2 = string2.substring(0, string2.length() - 1);
            string2 = String.valueOf(string2) + node.toNewHampshireX();
            string2 = String.valueOf(string2) + ";";
        }
        this.adjustNodeCount(true);
        return string2;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        return this.toNewHampshireX();
    }

    public void unRoot() {
        if (this.isEmpty()) {
            return;
        }
        this.setIndicatorsToZero();
        if (!this.isRooted() || this.getNumberOfExtNodes() <= 1) {
            return;
        }
        this.setRooted(false);
        this.recalculateAndReset();
    }

    public void unRootAndTrifurcate() {
        double d = 0.0;
        if (this.isEmpty()) {
            return;
        }
        this.unRoot();
        if (this.getNumberOfExtNodes() <= 2) {
            return;
        }
        d = this.getRoot().getChild2().getDistanceToParent() + this.getRoot().getChild1().getDistanceToParent();
        if (this.getRoot().getChild2().isExternal() || this.getRoot().getChild2().collapse()) {
            if (d >= 0.0) {
                this.getRoot().getChild2().setDistanceToParent(d);
            } else {
                this.getRoot().getChild2().setDistanceToParent(-99.0);
            }
            this.getRoot().getChild1().setDistanceToParent(-100.0);
        } else {
            if (d >= 0.0) {
                this.getRoot().getChild1().setDistanceToParent(d);
            } else {
                this.getRoot().getChild1().setDistanceToParent(-99.0);
            }
            this.getRoot().getChild2().setDistanceToParent(-100.0);
        }
        this.recalculateAndReset();
    }
}

