/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.RawInputStream;
import com.sybase.jdbc2.utils.CacheManager;
import java.io.IOException;
import java.io.InputStream;

public abstract class PadByteInputStream
extends RawInputStream {
    protected int _padByteLengthRemaining;
    protected int[] _bytes = new int[2];
    protected boolean _even;

    public PadByteInputStream(InputStream inputStream, int n, int n2, CacheManager cacheManager) throws IOException {
        super(inputStream, n, n2, cacheManager);
        this._padByteLengthRemaining = n2 * 2;
        this._even = true;
    }

    public int available() throws IOException {
        int n = super.available() * 2;
        return this._even ? n : ++n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this._padByteLengthRemaining == 0) {
            return -1;
        }
        n2 = n2 < this._padByteLengthRemaining ? n2 : this._padByteLengthRemaining;
        int n3 = n;
        while (n3 < n2) {
            byArray[n3] = (byte)this.read();
            ++n3;
        }
        return n2;
    }

    public long skip(long l) throws IOException {
        l = l < (long)this._padByteLengthRemaining ? l : (long)this._padByteLengthRemaining;
        int n = 0;
        while ((long)n < l) {
            this.read();
            ++n;
        }
        return l;
    }
}

