/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.jvm;

import com.zerog.util.jvm.Filter;
import com.zerog.util.jvm.JVMInformationRetriever;
import com.zerog.util.jvm.JVMInformationRetrieverServer;
import com.zerog.util.jvm.ValidatorUtils;
import com.zerog.util.jvm.Version;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Validator {
    private static Hashtable vendorMappings = new Hashtable();
    private Vector filters;

    public Validator() {
        this(new Vector());
    }

    public Validator(Vector vector) {
        this.filters = vector;
    }

    public Vector validate(Collection collection) {
        return this.validateVM(collection, this.filters);
    }

    public synchronized Vector validateVM(Collection collection, Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.validateVM(string, vector)) continue;
            vector2.add(string);
        }
        return vector2;
    }

    public boolean validateVM(String string) {
        return this.validateVM(string, this.filters);
    }

    public synchronized boolean validateVM(String string, Vector vector) {
        return new JVMInformationRetriever().checkFilter(string, vector);
    }

    public boolean checkFilter(String string, String string2, String string3, Filter filter) {
        if (filter != null) {
            if (!ValidatorUtils.isEmpty(filter.getVendor()) && !this.checkVendor(string, filter.getVendor())) {
                return false;
            }
            if (!ValidatorUtils.isEmpty(filter.getType()) && !this.checkType(string2, filter.getType())) {
                return false;
            }
            if (filter.getVersion() != null && !this.checkVersion(string3, filter.getVersion())) {
                return false;
            }
        }
        return true;
    }

    public boolean checkVendor(String string, String string2) {
        if (string.toLowerCase().startsWith(string2.toLowerCase())) {
            return true;
        }
        if (vendorMappings.containsKey(string2.trim().toUpperCase())) {
            string2 = (String)vendorMappings.get(string2.toUpperCase());
            return this.checkVendor(string, string2);
        }
        return false;
    }

    public boolean checkType(String string, String string2) {
        if (string2.equalsIgnoreCase("ALL")) {
            return true;
        }
        return string2.equalsIgnoreCase(string);
    }

    public boolean checkVersion(String string, Version version) {
        return version.match(string);
    }

    public static Hashtable getVendorMappings() {
        return vendorMappings;
    }

    public static void setVendorMappings(Hashtable hashtable) {
        vendorMappings = hashtable;
    }

    public static void main(String[] stringArray) {
        System.exit(new JVMInformationRetrieverServer().execute(stringArray));
    }

    static {
        vendorMappings.put("HP", "Hewlett-Packard");
    }
}

