/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.gui;

import ca.ucalgary.seahawk.gui.MobyContentClipboard;
import ca.ucalgary.seahawk.gui.MobyContentHelpPane;
import ca.ucalgary.seahawk.gui.MobyContentPane;
import ca.ucalgary.seahawk.gui.MobySaveDialog;
import ca.ucalgary.seahawk.gui.MobyServicesGUI;
import ca.ucalgary.seahawk.gui.SeahawkOptionsGUI;
import ca.ucalgary.seahawk.util.DataRecorder;
import ca.ucalgary.seahawk.util.MobyUtils;
import ca.ucalgary.seahawk.util.SeahawkOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.biomoby.client.MobyRequest;
import org.biomoby.client.MobyRequestEvent;
import org.biomoby.client.MobyRequestEventHandler;
import org.biomoby.registry.meta.Registry;
import org.biomoby.registry.meta.RegistryCache;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyServiceType;
import org.biomoby.shared.data.MobyContentInstance;
import org.biomoby.shared.data.MobyDataInstance;
import org.biomoby.shared.data.MobyDataObjectSet;
import org.biomoby.shared.data.MobyDataUtils;

public class MobyContentGUI
extends JFrame
implements ActionListener,
ComponentListener,
KeyListener,
MobyRequestEventHandler,
MouseListener {
    public static final String BACK_BUTTON_NAME = "MCGbackButton";
    public static final String FORWARD_BUTTON_NAME = "MCGforwardButton";
    public static final String OPEN_BUTTON_NAME = "MCGopenButton";
    public static final String SAVE_BUTTON_NAME = "MCGsaveButton";
    public static final String PRINT_BUTTON_NAME = "MCGprintButton";
    public static final String HELP_BUTTON_NAME = "MCGhelpButton";
    public static final String SETTINGS_BUTTON_NAME = "MCGsettingsButton";
    public static final String OPEN_OPTION_NAME = "MCGopenPopup";
    public static final String FILE_OPEN_OPTION_NAME = "MCGopenPopupFileOption";
    public static final String WEB_OPEN_OPTION_NAME = "MCGopenPopupWebOption";
    public static final String TABBED_PANE_NAME = "MCGtabbedPane";
    public static final String FILE_CHOOSER_OPEN_TITLE = "Load data from file";
    public static final String WEB_ADDR_DIALOG_TITLE = "Load Data From A Web Address (URL)";
    public static final String DEFAULT_STATUS_MSG = "Click hyperlink to explore MOBY Web services";
    public static final String RESOURCE_SYSTEM_PROPERTY = "seahawk.stylesheet";
    public static final String DEFAULT_STARTUP_PAGE_RESOURCE = "ca/ucalgary/seahawk/resources/startup.html";
    public static final String DEFAULT_XSLT_CONVERTER_URL = "ca/ucalgary/seahawk/resources/moby2HTML.xsl";
    public static final int MAX_TAB_NAME_LENGTH = 25;
    public static final String CLIPBOARD_TAB_TOOLTIP = "Right-click for clipboard options";
    public static final String TAB_TOOLTIP = "Right-click for tab options, or Ctrl-T for new tab";
    public static final String CLOSE_TAB_OPTION = "Close This Tab";
    public static final String CLOSE_OTHERS_OPTION = "Close Other Tabs";
    public static final String FILE_OPEN_OPTION = "Open File";
    public static final String WEB_OPEN_OPTION = "Open Web Page";
    private int lastClickX = 0;
    private int lastClickY = 0;
    private JTabbedPane tabbedPane;
    private JLabel status;
    private JPanel statusPanel;
    private JButton backwardButton;
    private JButton forwardButton;
    private JButton openButton;
    private JButton saveButton;
    private JButton printButton;
    private JButton helpButton;
    private JButton settingsButton;
    private Transformer moby2HTMLConverter;
    private MobyServicesGUI servicesGUI;
    private DocumentBuilder docBuilder = null;
    private MobyContentClipboard clipboard;
    private MobyContentHelpPane helpPane;
    private DataRecorder dataRecorder;
    private SeahawkOptionsGUI settingsGUI;
    private boolean setup;
    private Map<Integer, MobyContentPane> request2tab;
    private int activeTabIndex = -1;
    private static int defaultCloseOperation = 3;
    private static Logger logger = Logger.getLogger(MobyContentGUI.class);

    public MobyContentGUI(MobyServicesGUI mgui) {
        this.setTitle("Seahawk: MOBY Data Display");
        this.setSize(530, 400);
        this.servicesGUI = mgui;
        this.request2tab = new TreeMap<Integer, MobyContentPane>();
        this.setup = false;
        this.addComponentListener(this);
        this.statusPanel = new JPanel();
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.statusPanel.setLayout(gridbag);
        Dimension buttonSize = new Dimension(20, 20);
        this.backwardButton = new JButton(new ImageIcon(cl.getResource("ca/ucalgary/seahawk/resources/images/back.gif")));
        this.backwardButton.setDisabledIcon(new ImageIcon(cl.getResource("ca/ucalgary/seahawk/resources/images/back_d.gif")));
        this.backwardButton.setToolTipText("Go to previous document in this tab's history");
        this.backwardButton.setPreferredSize(buttonSize);
        this.backwardButton.setEnabled(false);
        this.backwardButton.addActionListener(this);
        this.backwardButton.setName(BACK_BUTTON_NAME);
        gridbag.setConstraints(this.backwardButton, c);
        this.statusPanel.add(this.backwardButton);
        this.forwardButton = new JButton(new ImageIcon(cl.getResource("ca/ucalgary/seahawk/resources/images/forward.gif")));
        this.forwardButton.setDisabledIcon(new ImageIcon(cl.getResource("ca/ucalgary/seahawk/resources/images/forward_d.gif")));
        this.forwardButton.setToolTipText("Go to next document in this tab's history");
        this.forwardButton.setPreferredSize(buttonSize);
        this.forwardButton.setEnabled(false);
        this.forwardButton.addActionListener(this);
        this.forwardButton.setName(FORWARD_BUTTON_NAME);
        gridbag.setConstraints(this.forwardButton, c);
        this.statusPanel.add(this.forwardButton);
        this.openButton = new JButton(new ImageIcon(cl.getResource("ca/ucalgary/seahawk/resources/images/bookmarks.gif")));
        this.openButton.setToolTipText("Open a document from file or the Web");
        this.openButton.setPreferredSize(buttonSize);
        this.openButton.setEnabled(true);
        this.openButton.addActionListener(this);
        this.openButton.addMouseListener(this);
        this.openButton.setName(OPEN_BUTTON_NAME);
        gridbag.setConstraints(this.openButton, c);
        this.statusPanel.add(this.openButton);
        this.saveButton = new JButton(new ImageIcon(cl.getResource("ca/ucalgary/seahawk/resources/images/save.gif")));
        this.saveButton.setDisabledIcon(new ImageIcon(cl.getResource("ca/ucalgary/seahawk/resources/images/save_d.gif")));
        this.saveButton.setToolTipText("Save this tab's document to a file");
        this.saveButton.setPreferredSize(buttonSize);
        this.saveButton.setEnabled(true);
        this.saveButton.addActionListener(this);
        this.saveButton.setName(SAVE_BUTTON_NAME);
        gridbag.setConstraints(this.saveButton, c);
        this.statusPanel.add(this.saveButton);
        this.printButton = new JButton(new ImageIcon(cl.getResource("ca/ucalgary/seahawk/resources/images/print.gif")));
        this.printButton.setToolTipText("Print this tab's document as shown");
        this.printButton.setPreferredSize(buttonSize);
        this.printButton.setEnabled(true);
        this.printButton.addActionListener(this);
        this.printButton.setName(PRINT_BUTTON_NAME);
        gridbag.setConstraints(this.printButton, c);
        this.statusPanel.add(this.printButton);
        this.helpButton = new JButton(new ImageIcon(cl.getResource("ca/ucalgary/seahawk/resources/images/help.gif")));
        this.helpButton.setToolTipText("Show help on using this interface");
        this.helpButton.setPreferredSize(buttonSize);
        this.helpButton.setEnabled(true);
        this.helpButton.addActionListener(this);
        this.helpButton.setName(HELP_BUTTON_NAME);
        gridbag.setConstraints(this.helpButton, c);
        this.statusPanel.add(this.helpButton);
        this.settingsButton = new JButton(new ImageIcon(cl.getResource("ca/ucalgary/seahawk/resources/images/settings.gif")));
        this.settingsButton.setToolTipText("Show program options");
        this.settingsButton.setPreferredSize(buttonSize);
        this.settingsButton.setEnabled(true);
        this.settingsButton.addActionListener(this);
        this.settingsButton.setName(SETTINGS_BUTTON_NAME);
        gridbag.setConstraints(this.settingsButton, c);
        this.statusPanel.add(this.settingsButton);
        this.status = new JLabel(DEFAULT_STATUS_MSG, 2);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BorderLayout());
        labelPanel.setPreferredSize(new Dimension(380, buttonSize.height));
        c.gridwidth = 0;
        gridbag.setConstraints(labelPanel, c);
        labelPanel.add((Component)this.status, "West");
        this.statusPanel.add(labelPanel);
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.setDefaultCloseOperation(1);
        this.tabbedPane = new JTabbedPane(1, 1);
        this.tabbedPane.setName(TABBED_PANE_NAME);
        this.tabbedPane.setUI(new OptionsTabbedPaneUI(this));
        this.tabbedPane.setSize(this.getContentSize());
        this.tabbedPane.setToolTipText("Hit <Control-T> to display a new tab");
        this.tabbedPane.addKeyListener(this);
        try {
            this.dataRecorder = new DataRecorder(this.servicesGUI.getMobyCentralImpl());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clipboard = new MobyContentClipboard(this, this.servicesGUI, this.tabbedPane, this.dataRecorder, this.status);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.tabbedPane.add(this.clipboard);
        this.clipboard.init();
        this.settingsGUI = new SeahawkOptionsGUI(this);
    }

    public boolean allTabsVisible() {
        if (this.tabbedPane.getTabLayoutPolicy() == 0) {
            return true;
        }
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (this.tabbedPane.getBoundsAt(i) != null) continue;
            return false;
        }
        return true;
    }

    public JPanel getToolbar() {
        return this.statusPanel;
    }

    public Transformer getTransformer() {
        if (!this.setup) {
            this.setup();
        }
        return this.moby2HTMLConverter;
    }

    public DocumentBuilder getDocumentBuilder() {
        if (!this.setup) {
            this.setup();
        }
        return this.docBuilder;
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 84 && e.isControlDown()) {
            MobyContentPane tab = this.createTab("New Tab");
            this.tabbedPane.setSelectedComponent(tab);
            tab.getDisplay().setText("Use the file/globe icon at the bottom of this window to load data,or drag'n'drop/paste data from your desktop or Web browser.");
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    protected void setup() {
        String stylesheetResource;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            this.docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            logger.error("Error: Could not find an XML parser, will not be able to query using complex MOBY objects: " + pce);
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if ((stylesheetResource = System.getProperty(RESOURCE_SYSTEM_PROPERTY)) == null) {
            stylesheetResource = DEFAULT_XSLT_CONVERTER_URL;
        }
        StreamSource stylesheet = new StreamSource(cl.getResource(stylesheetResource).toString());
        try {
            this.moby2HTMLConverter = factory.newTransformer(stylesheet);
        }
        catch (TransformerConfigurationException tce) {
            MobyContentPane tab = this.createTab("Initialization Error");
            tab.failed("Initialization Error");
            tab.getDisplay().setText("Cannot continue: could not create XML transformer (either stylesheet has an error, or no JAXT implementation is available\n");
            logger.error("Cannot continue: could not create XML transformer: " + tce);
            tce.printStackTrace();
        }
        this.setVisible(true);
        int clipboardIndex = this.tabbedPane.indexOfComponent(this.clipboard);
        if (clipboardIndex != -1) {
            this.tabbedPane.setToolTipTextAt(clipboardIndex, CLIPBOARD_TAB_TOOLTIP);
        }
        this.clipboard.setPreferredSize(this.getContentSize());
        this.clipboard.init();
        this.setup = true;
    }

    public void start(MobyRequestEvent requestEvent) {
        if (!this.setup) {
            this.setup();
        }
        MobyContentPane tab = this.createTab("New Request");
        this.request2tab.put(new Integer(requestEvent.getID()), tab);
        tab.start(requestEvent);
    }

    protected MobyContentPane createTab(String title) {
        MobyContentPane tab = new MobyContentPane(this, this.servicesGUI, this.tabbedPane, this.dataRecorder, this.status);
        this.setVisible(true);
        tab.setPreferredSize(this.getContentSize());
        this.tabbedPane.addTab(title, tab);
        int tabIndex = this.tabbedPane.indexOfComponent(tab);
        if (tabIndex != -1) {
            this.tabbedPane.setToolTipTextAt(tabIndex, TAB_TOOLTIP);
        }
        return tab;
    }

    public Dimension getContentSize() {
        Dimension insetdims = this.getContentPane().getSize();
        insetdims.width -= 6;
        int tabHeight = 0;
        if (this.tabbedPane != null) {
            this.tabbedPane.setSize(insetdims);
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                Rectangle rect = this.tabbedPane.getBoundsAt(i);
                if (rect == null || rect.getSize().height <= tabHeight) continue;
                tabHeight = rect.getSize().height;
            }
        }
        int statusHeight = 0;
        if (this.status != null) {
            statusHeight = this.status.getSize().height;
        }
        insetdims.height -= statusHeight + tabHeight + 16;
        return insetdims;
    }

    public void setStatus(String msg) {
        this.status.setText(msg);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (this.tabbedPane != null) {
            Dimension insetdims = this.getContentSize();
            this.tabbedPane.setSize(insetdims);
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                ((MobyContentPane)this.tabbedPane.getComponentAt(i)).setPreferredSize(insetdims);
            }
        }
    }

    public void stop(MobyRequest request, int requestID) {
        MobyContentPane tab = this.request2tab.get(new Integer(requestID));
        if (tab == null) {
            logger.warn("Ignoring request to stop response monitoring, because the tab for request " + requestID + " no longer exists");
        } else {
            tab.stop(request, requestID);
        }
    }

    public void processEvent(MobyRequestEvent mre) {
        this.setVisible(true);
        MobyContentPane tab = this.request2tab.get(new Integer(mre.getID()));
        if (tab == null) {
            logger.warn("Ignoring request to display response, because the tab for request " + mre.getID() + " no longer exists");
        } else {
            tab.processEvent(mre);
        }
    }

    private void updateHistoryButtons() {
        MobyContentPane pane = (MobyContentPane)this.tabbedPane.getSelectedComponent();
        if (pane != null) {
            this.backwardButton.setEnabled(pane.canGoBack());
            this.forwardButton.setEnabled(pane.canGoForward());
            this.saveButton.setEnabled(!pane.hasFailure());
        }
    }

    public void updateHistory(MobyContentPane pane) {
        if (pane == this.tabbedPane.getSelectedComponent()) {
            this.updateHistoryButtons();
        }
    }

    public void goBackward() {
        if (this.tabbedPane.getTabCount() != 0) {
            ((MobyContentPane)this.tabbedPane.getSelectedComponent()).goBackward();
        }
    }

    public void goForward() {
        if (this.tabbedPane.getTabCount() != 0) {
            ((MobyContentPane)this.tabbedPane.getSelectedComponent()).goForward();
        }
    }

    public boolean isShowingFailure() {
        MobyContentPane pane = this.getCurrentPane();
        return pane != null && pane.hasFailure();
    }

    public URL getCurrentURL() {
        if (this.tabbedPane.getTabCount() == 0) {
            return null;
        }
        return ((MobyContentPane)this.tabbedPane.getSelectedComponent()).getCurrentURL();
    }

    public MobyContentPane getCurrentPane() {
        if (this.tabbedPane.getTabCount() == 0) {
            return null;
        }
        return (MobyContentPane)this.tabbedPane.getSelectedComponent();
    }

    public void printCurrentPane() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable((Printable)((Object)this.tabbedPane.getSelectedComponent()));
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Cannot print the MOBY document: " + ex, "Error printing", 0);
            }
        }
    }

    public void saveCurrentPane() {
        MobySaveDialog.exportDocument((MobyContentPane)this.tabbedPane.getSelectedComponent());
    }

    public int showHelpTab() {
        if (this.helpPane == null) {
            this.helpPane = new MobyContentHelpPane(this, this.servicesGUI, this.tabbedPane, this.dataRecorder, this.status);
        }
        if (this.tabbedPane.indexOfComponent(this.helpPane) == -1) {
            this.tabbedPane.add(this.helpPane);
            this.helpPane.setPreferredSize(this.getContentSize());
            this.helpPane.init();
        }
        this.tabbedPane.setSelectedComponent(this.helpPane);
        return this.tabbedPane.getSelectedIndex();
    }

    public void openDocument() {
        JPopupMenu fileOrWeb = new JPopupMenu();
        fileOrWeb.setName(OPEN_OPTION_NAME);
        JMenuItem fileOption = new JMenuItem(FILE_OPEN_OPTION);
        fileOption.setName(FILE_OPEN_OPTION_NAME);
        fileOption.addActionListener(this);
        fileOrWeb.add(fileOption);
        JMenuItem webOption = new JMenuItem(WEB_OPEN_OPTION);
        webOption.setName(WEB_OPEN_OPTION_NAME);
        webOption.addActionListener(this);
        fileOrWeb.add(webOption);
        fileOrWeb.show(this.openButton, this.lastClickX, this.lastClickY);
    }

    public void showWebDialog(boolean useDefaultHandler) {
        URL url = null;
        String urlString = "";
        while (url == null) {
            urlString = (String)JOptionPane.showInputDialog(this, "Please enter a valid Web address:\n", WEB_ADDR_DIALOG_TITLE, -1, null, null, urlString);
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException murle) {
                Object[] options = new Object[]{"Try again", "Cancel"};
                int response = JOptionPane.showOptionDialog(this, "Sorry, the provided address couldn't be used.\n(note only http, file and ftp addresses are allowed)", "Invalid Web Address (URL)", 2, 3, null, options, options[0]);
                if (response != 1) continue;
                break;
            }
        }
        if (url != null) {
            this.loadPaneFromURL(url, useDefaultHandler);
        }
    }

    public void loadPaneFromObject(MobyContentInstance mci, boolean useDefaultHandler) throws Exception {
        File savedXMLFile = File.createTempFile("seahawk", ".xml");
        savedXMLFile.deleteOnExit();
        MobyDataUtils.toXMLDocument(new FileOutputStream(savedXMLFile), mci);
        this.loadPaneFromURL(savedXMLFile.toURI().toURL(), useDefaultHandler);
    }

    public void loadPaneFromURL(URL u, boolean useDefaultHandler) {
        logger.debug("Should load URL " + u);
        MobyContentPane currentPane = (MobyContentPane)this.tabbedPane.getSelectedComponent();
        if (useDefaultHandler || currentPane == null || currentPane.getDefaultHandler() == null) {
            currentPane = this.createTab("File Loading");
        }
        currentPane.setWaitScreen();
        currentPane.gotoURL(u, true);
        if (u != null) {
            currentPane.succeeded(this.urlToTitle(u));
        }
        this.tabbedPane.setSelectedComponent(currentPane);
    }

    protected String urlToTitle(URL u) {
        String shortName = u.toString();
        if (shortName.length() > 25) {
            shortName = u.getProtocol();
            String host = u.getHost();
            shortName = host != null && shortName.length() + host.length() <= 28 ? shortName + u.getHost() : shortName + "...";
            String path = u.getPath();
            if (path != null) {
                if (shortName.length() + path.length() <= 28) {
                    shortName = shortName + path;
                } else {
                    int allowableLen = 25 - shortName.length();
                    if (allowableLen > path.length()) {
                        allowableLen = path.length();
                    }
                    shortName = shortName + "..." + path.substring(path.length() - allowableLen);
                }
            }
        }
        return shortName;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.printButton) {
            this.printCurrentPane();
            return;
        }
        if (source == this.saveButton) {
            this.saveCurrentPane();
            return;
        }
        if (source == this.openButton) {
            this.openDocument();
            return;
        }
        if (source == this.backwardButton) {
            this.goBackward();
            return;
        }
        if (source == this.forwardButton) {
            this.goForward();
            return;
        }
        if (source == this.helpButton) {
            this.showHelpTab();
            return;
        }
        if (source == this.settingsButton) {
            this.settingsGUI.setVisible(true);
            return;
        }
        String cmd = e.getActionCommand();
        if (FILE_OPEN_OPTION.equals(cmd)) {
            MobySaveDialog.showFileOpenDialog(this, (e.getModifiers() & 1) != 0);
        } else if (WEB_OPEN_OPTION.equals(cmd)) {
            this.showWebDialog((e.getModifiers() & 1) != 0);
        } else if (CLOSE_TAB_OPTION.equals(cmd)) {
            if (this.activeTabIndex == -1 || this.activeTabIndex >= this.tabbedPane.getTabCount()) {
                logger.warn("Cannot process close tab event: tab " + this.activeTabIndex + " no longer exists");
                return;
            }
            if (!(this.tabbedPane.getComponentAt(this.activeTabIndex) instanceof MobyContentClipboard)) {
                this.tabbedPane.remove(this.activeTabIndex);
            }
        } else if ("Clear Clipboard".equals(cmd)) {
            this.clipboard.clearData();
        } else if (CLOSE_OTHERS_OPTION.equals(cmd)) {
            if (this.activeTabIndex == -1 || this.activeTabIndex >= this.tabbedPane.getTabCount()) {
                logger.warn("Cannot process close other tabs event: tab " + this.activeTabIndex + " no longer exists");
                return;
            }
            Component keeper = this.tabbedPane.getComponentAt(this.activeTabIndex);
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                Component comp = this.tabbedPane.getComponentAt(i);
                if (comp == keeper || comp == this.clipboard) continue;
                this.tabbedPane.remove(comp);
                --i;
            }
        } else {
            logger.warn(this.getClass().getName() + " ignoring unrecognized action command: " + cmd);
            return;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.lastClickX = e.getX();
        this.lastClickY = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public int getActiveTab() {
        return this.activeTabIndex;
    }

    public void setActiveTab(int index) {
        this.activeTabIndex = index;
    }

    public boolean removeFromClipboard(MobyDataInstance itemToDelete) {
        return this.clipboard != null && this.clipboard.removeCollectionData(itemToDelete);
    }

    public MobyDataObjectSet addToClipboard(MobyDataInstance itemToAdd) {
        if (this.clipboard == null) {
            return null;
        }
        if (itemToAdd != null) {
            this.clipboard.addCollectionData(itemToAdd);
        }
        return this.clipboard.getCollection();
    }

    public void clearClipboard() {
        if (this.clipboard != null) {
            this.clipboard.clearData();
        }
    }

    public static void setDefaultAppCloseOperation(int code) {
        defaultCloseOperation = code;
    }

    public static void main(String[] argv) {
        Locale.setDefault(Locale.ENGLISH);
        if (System.getProperty("javax.xml.parsers.DocumentBuilderFactory") == null) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        }
        if (System.getProperty("javax.xml.transform.TransformerFactory") == null) {
            System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        }
        if (System.getProperty("org.apache.xerces.xni.parser.XMLParserConfiguration") == null) {
            System.setProperty("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.StandardParserConfiguration");
        }
        try {
            SeahawkOptions.restoreSettings();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Using default settings, could not restore Seahawk settings from file " + SeahawkOptions.getDefaultsFile() + ": " + e);
        }
        MobyContentGUI.cacheOntologies();
        try {
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            System.err.println("Sleep interrupted");
        }
        MobyContentGUI gui = MobyUtils.getMobyContentGUI(new JLabel());
        gui.setDefaultCloseOperation(defaultCloseOperation);
        gui.setVisible(true);
        if (argv.length != 0 && argv[0] != null && argv[0].length() != 0) {
            try {
                gui.loadPaneFromURL(new URL(argv[0]), true);
            }
            catch (Exception e) {
                logger.error("Could not load " + argv[0] + " - loading help file instead");
                e.printStackTrace();
                gui.showHelpTab();
            }
        } else {
            URL startURL = gui.getClass().getClassLoader().getResource(DEFAULT_STARTUP_PAGE_RESOURCE);
            if (startURL == null) {
                logger.error("Could not load ca/ucalgary/seahawk/resources/startup.html - loading help file instead");
                gui.showHelpTab();
            } else {
                gui.loadPaneFromURL(startURL, true);
            }
        }
    }

    protected static void cacheOntologies() {
        final Registry preferredRegistry = SeahawkOptions.getRegistry();
        final long allowedAgeMillis = (long)SeahawkOptions.getCacheExpiry() * 60L * 60L * 1000L;
        RegistryCache.deleteExpiredCacheFiles(allowedAgeMillis);
        new Thread(){

            public void run() {
                try {
                    MobyNamespace.loadNamespaces(RegistryCache.cacheRegistryOntology(preferredRegistry, "Namespace", allowedAgeMillis).toURI().toURL(), preferredRegistry);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        new Thread(){

            public void run() {
                try {
                    MobyDataType.loadDataTypes(RegistryCache.cacheRegistryOntology(preferredRegistry, "Object", allowedAgeMillis).toURI().toURL(), preferredRegistry);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        new Thread(){

            public void run() {
                try {
                    MobyServiceType.loadServiceTypes(RegistryCache.cacheRegistryOntology(preferredRegistry, "Service", allowedAgeMillis).toURI().toURL(), preferredRegistry);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public static void destroy() {
        MobyUtils.destroyMobyGUI();
    }

    public JLabel getStatusComponent() {
        return this.status;
    }

    class OptionsTabbedPaneUI
    extends BasicTabbedPaneUI {
        MobyContentGUI parent;

        public OptionsTabbedPaneUI(MobyContentGUI gui) {
            this.parent = gui;
        }

        protected MouseListener createMouseListener() {
            return new OptionsMouseHandler(this.parent);
        }

        protected void setVisibleComponent(Component component) {
            super.setVisibleComponent(component);
            if (component instanceof MobyContentPane) {
                MobyContentGUI.this.updateHistoryButtons();
            }
        }

        class OptionsMouseHandler
        extends BasicTabbedPaneUI.MouseHandler {
            MobyContentGUI gui;

            public OptionsMouseHandler(MobyContentGUI g) {
                super(OptionsTabbedPaneUI.this);
                this.gui = g;
            }

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    int index = MobyContentGUI.this.tabbedPane.indexAtLocation(e.getX(), e.getY());
                    if (index == -1) {
                        return;
                    }
                    OptionsTabbedPaneUI.this.parent.setActiveTab(index);
                    JPopupMenu tabOptions = new JPopupMenu();
                    JMenuItem item = null;
                    if (MobyContentGUI.this.tabbedPane.getComponentAt(index) == MobyContentGUI.this.clipboard) {
                        item = new JMenuItem("Clear Clipboard");
                        item.setActionCommand("Clear Clipboard");
                        item.addActionListener(this.gui);
                        tabOptions.add(item);
                    } else if (MobyContentGUI.this.tabbedPane.getTabCount() > 1) {
                        item = new JMenuItem(MobyContentGUI.CLOSE_TAB_OPTION);
                        item.setActionCommand(MobyContentGUI.CLOSE_TAB_OPTION);
                        item.addActionListener(this.gui);
                        tabOptions.add(item);
                    }
                    if (MobyContentGUI.this.tabbedPane.getComponentAt(index) == MobyContentGUI.this.clipboard && MobyContentGUI.this.tabbedPane.getTabCount() > 1 || MobyContentGUI.this.tabbedPane.getTabCount() > 2 || MobyContentGUI.this.tabbedPane.indexOfComponent(MobyContentGUI.this.clipboard) == -1 && MobyContentGUI.this.tabbedPane.getTabCount() >= 2) {
                        item = new JMenuItem(MobyContentGUI.CLOSE_OTHERS_OPTION);
                        item.setActionCommand(MobyContentGUI.CLOSE_OTHERS_OPTION);
                        item.addActionListener(this.gui);
                        tabOptions.add(item);
                    }
                    tabOptions.show(this.gui, e.getX(), e.getY());
                } else {
                    super.mousePressed(e);
                }
            }
        }
    }
}

