/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.gui;

import ca.ucalgary.seahawk.gui.MobyContentProducer;
import ca.ucalgary.seahawk.gui.MobyObjectReceiver;
import ca.ucalgary.seahawk.gui.MobyObjectTransferHandler;
import ca.ucalgary.seahawk.services.MobyClient;
import ca.ucalgary.seahawk.util.HTMLUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.TransferHandler;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobyPrimaryDataSet;
import org.biomoby.shared.MobyPrimaryDataSimple;
import org.biomoby.shared.data.MobyContentInstance;
import org.biomoby.shared.data.MobyDataInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyDataObjectWidget
extends JLabel
implements MobyObjectReceiver,
MobyContentProducer {
    public static final int PARAM_TOOLTIP_WIDTH = 50;
    public static final Color INSTANTIATED_FG_COLOUR = Color.DARK_GRAY;
    public static final Color UNINSTANTIATED_FG_COLOUR = Color.RED;
    public static final String INSTANTIATED_ICON_RESOURCE = "ca/ucalgary/seahawk/resources/images/checkmark.gif";
    public static final String UNINSTANTIATED_ICON_RESOURCE = "ca/ucalgary/seahawk/resources/images/attention.gif";
    private static Icon attentionIcon;
    private static Icon okIcon;
    private MobyPrimaryData targetData;
    private MobyPrimaryData actualData;
    private String name;
    private Vector<ActionListener> listeners;

    public MobyDataObjectWidget(String articleName, MobyClient client, MobyDataInstance data, boolean editable) throws IllegalArgumentException {
        super("", 0);
        this.listeners = new Vector();
        this.name = articleName;
        if (!(data instanceof MobyPrimaryData)) {
            throw new IllegalArgumentException("The data passed to MobyDataObjectWidget's constructor was not a MobyPrimaryData & MobyDataInstance as expected, received " + data.getClass().getName());
        }
        this.targetData = (MobyPrimaryData)((Object)data);
        this.actualData = (MobyPrimaryData)((Object)data);
        this.setForeground(INSTANTIATED_FG_COLOUR);
        this.setIcon(this.getInstantiatedIcon());
        this.setLabelByData();
        if (editable) {
            System.err.println("Registering handler for the data");
            this.setTransferHandler(MobyObjectTransferHandler.getHandler(client));
        }
        this.addMouseListener(new DragMouseAdapter());
    }

    private Icon getInstantiatedIcon() {
        if (okIcon == null) {
            try {
                okIcon = new ImageIcon(this.getClass().getClassLoader().getResource(INSTANTIATED_ICON_RESOURCE));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Could not load the warning icon resource ca/ucalgary/seahawk/resources/images/checkmark.gif for MobyDataObjectWidget: " + e);
            }
        }
        return okIcon;
    }

    private Icon getUninstantiatedIcon() {
        if (attentionIcon == null) {
            try {
                attentionIcon = new ImageIcon(this.getClass().getClassLoader().getResource(UNINSTANTIATED_ICON_RESOURCE));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Could not load the attention icon resource ca/ucalgary/seahawk/resources/images/attention.gif for MobyDataObjectWidget: " + e);
            }
        }
        return attentionIcon;
    }

    public MobyDataObjectWidget(String articleName, MobyClient client, MobyPrimaryData data) throws IllegalArgumentException {
        this(articleName, client, data.getDataType(), data instanceof MobyPrimaryDataSet);
    }

    public MobyDataObjectWidget(String articleName, MobyClient client, MobyDataType dataType, boolean isaCollection) throws IllegalArgumentException {
        super("", 0);
        this.name = articleName;
        this.listeners = new Vector();
        if (isaCollection) {
            MobyPrimaryDataSet collection = new MobyPrimaryDataSet(articleName);
            collection.setDataType(dataType);
            this.targetData = collection;
        } else {
            MobyPrimaryDataSimple simple = new MobyPrimaryDataSimple(articleName);
            simple.setDataType(dataType);
            this.targetData = simple;
        }
        this.setLabelByData();
        this.setForeground(UNINSTANTIATED_FG_COLOUR);
        this.setIcon(this.getUninstantiatedIcon());
        this.setTransferHandler(MobyObjectTransferHandler.getHandler(client));
    }

    protected void setLabelByData() {
        String labelText = "[Uninitialized Object]";
        String tipText = "[No tip is currently available for this data]";
        if (this.actualData == null) {
            MobyDataType dataType = this.targetData.getDataType();
            labelText = this.targetData instanceof MobyPrimaryDataSet ? this.name + ": awaiting Collection(" + dataType.getName() + "), drop data here to continue" : this.name + ": awaiting " + dataType.getName() + ", drop data here to continue";
            tipText = "Please drop data of type " + dataType.getName() + " onto here: " + dataType.getDescription();
        } else {
            MobyDataType dataType = this.actualData.getDataType();
            labelText = this.targetData instanceof MobyPrimaryDataSet ? this.name + ": Collection(" + dataType.getName() + ") -- " + this.actualData.getName() : this.name + ": " + dataType.getName() + " -- " + this.actualData.getName();
            tipText = dataType.getDescription();
            if (tipText == null || tipText.length() == 0) {
                tipText = dataType.getComment();
            }
            if (tipText == null || tipText.length() == 0) {
                tipText = "[No description for the datatype " + dataType.getName() + " was available]";
            }
        }
        this.setText(labelText);
        this.setToolTipText(HTMLUtils.htmlifyToolTipText(tipText, 50));
    }

    public void addActionListener(ActionListener al) {
        if (!this.listeners.contains(al)) {
            this.listeners.add(al);
        }
    }

    public boolean removeActionListener(ActionListener al) {
        return this.listeners.remove(al);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public MobyPrimaryData getData() {
        if (this.actualData != null) {
            return this.actualData;
        }
        return this.targetData;
    }

    @Override
    public void consumeMobyObject(String incomingName, MobyDataInstance incomingData) {
        System.err.println("Received data " + incomingData);
        if (!(incomingData instanceof MobyPrimaryData)) {
            System.err.println("MobyDataObjectWidget received a data class it could not consume (ignoring): " + this.actualData.getClass().getName());
            return;
        }
        this.actualData = (MobyPrimaryData)((Object)incomingData);
        this.setForeground(INSTANTIATED_FG_COLOUR);
        this.setIcon(this.getInstantiatedIcon());
        this.setLabelByData();
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        this.repaint();
        ActionEvent actionEvent = new ActionEvent(this, 0, incomingName);
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(actionEvent);
        }
    }

    @Override
    public Map<String, MobyPrimaryData> getAcceptableData() {
        TreeMap<String, MobyPrimaryData> acceptableData = new TreeMap<String, MobyPrimaryData>();
        acceptableData.put(this.name, this.targetData);
        return acceptableData;
    }

    @Override
    public MobyContentInstance exportMobyContent() {
        return null;
    }

    private class DragMouseAdapter
    extends MouseAdapter {
        private DragMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            JComponent c = (JComponent)e.getSource();
            TransferHandler handler = c.getTransferHandler();
            handler.exportAsDrag(c, e, 1);
        }
    }
}

