/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.gui;

import ca.ucalgary.seahawk.gui.FileAndTextTransferHandler;
import ca.ucalgary.seahawk.gui.MobyContentGUI;
import ca.ucalgary.seahawk.gui.MobyContentProducer;
import ca.ucalgary.seahawk.gui.MobyObjectReceiver;
import ca.ucalgary.seahawk.services.MobyClient;
import ca.ucalgary.seahawk.util.HTMLUtils;
import ca.ucalgary.seahawk.util.MobyUtils;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobyPrimaryDataSet;
import org.biomoby.shared.MobyPrimaryDataSimple;
import org.biomoby.shared.data.MobyContentInstance;
import org.biomoby.shared.data.MobyDataInstance;
import org.biomoby.shared.data.MobyDataJob;
import org.biomoby.shared.data.MobyDataObject;
import org.biomoby.shared.data.MobyDataObjectSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyObjectTransferHandler
extends FileAndTextTransferHandler
implements ClipboardOwner {
    private MobyClient client;
    private static Map<MobyClient, MobyObjectTransferHandler> handlers;

    protected MobyObjectTransferHandler(MobyClient cl) {
        super((MobyContentGUI)null);
        this.client = cl;
    }

    public static MobyObjectTransferHandler getHandler(MobyClient cl) {
        if (handlers == null) {
            handlers = new HashMap<MobyClient, MobyObjectTransferHandler>();
        }
        if (!handlers.containsKey(cl)) {
            handlers.put(cl, new MobyObjectTransferHandler(cl));
        }
        System.err.println("Returning handler " + handlers.get(cl));
        return handlers.get(cl);
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        Map<String, MobyDataInstance> dataFound;
        Map<String, MobyPrimaryData> acceptableData;
        MobyObjectReceiver receiver;
        block13: {
            receiver = null;
            if (!(c instanceof MobyObjectReceiver)) {
                System.err.println("Cannot drop data onto Seahawk component (" + c + "), it is not a MobyObjectReceiver.  The component should not " + "have MobyObjectTransferHandler registered as its TransferHandler");
                return false;
            }
            receiver = (MobyObjectReceiver)((Object)c);
            System.err.println("Received drop event");
            acceptableData = receiver.getAcceptableData();
            if (acceptableData == null || acceptableData.isEmpty()) {
                return false;
            }
            if (!this.canImport(c, t.getTransferDataFlavors())) {
                System.err.println("Cannot drop data into Seahawk targeted type: " + t);
                return false;
            }
            dataFound = null;
            try {
                if (this.hasFileFlavor(t.getTransferDataFlavors())) {
                    dataFound = this.getDataFromFiles(acceptableData, (List)t.getTransferData(DataFlavor.javaFileListFlavor));
                    break block13;
                }
                if (this.hasTextFlavor(t.getTransferDataFlavors())) {
                    boolean PLAIN_TEXT = true;
                    String text = this.convertToString(t, PLAIN_TEXT);
                    MobyContentInstance content = HTMLUtils.checkForMobyXML(text);
                    if (content != null) {
                        System.err.println("Data appears to be moby XML...");
                        dataFound = this.getDataFromMobyContents(acceptableData, content);
                        return this.sendDataToReceiver(receiver, acceptableData, dataFound);
                    }
                    String linktext = HTMLUtils.checkForHyperlinkText(text);
                    URL u = null;
                    try {
                        u = new URL(linktext == null ? text : linktext);
                    }
                    catch (MalformedURLException murle) {
                        // empty catch block
                    }
                    if (u != null) {
                        System.err.println("Data appears to be a URL...");
                        dataFound = this.getDataFromURL(acceptableData, u);
                        this.mergeDataMaps(dataFound, this.getDataFromURLContents(acceptableData, u));
                        return this.sendDataToReceiver(receiver, acceptableData, dataFound);
                    }
                    System.err.println("Data appears to be text..." + text);
                    dataFound = this.getDataFromText(acceptableData, text);
                    break block13;
                }
                System.err.println("Cannot drop data into Seahawk targeted type, not a file or text");
            }
            catch (UnsupportedFlavorException ufe) {
                System.out.println("importMobyData: unsupported data flavor: " + ufe);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.out.println("importMobyData: I/O exception: " + ioe);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("importMobyData: General exception: " + e);
            }
        }
        return this.sendDataToReceiver(receiver, acceptableData, dataFound);
    }

    public boolean sendDataToReceiver(MobyObjectReceiver receiver, Map<String, MobyPrimaryData> acceptableData, Map<String, MobyDataInstance> dataFound) {
        if (dataFound == null || dataFound.isEmpty()) {
            System.err.println("Received data was blank, not sending to consumer");
            return false;
        }
        if (dataFound.size() == 1 && acceptableData.size() == 1) {
            MobyDataInstance newData = dataFound.values().iterator().next();
            MobyPrimaryData dataTemplate = acceptableData.values().iterator().next();
            String dataName = acceptableData.keySet().iterator().next();
            System.err.println("Received data match 1 to 1, forwarding to " + receiver + " the data" + newData.toString());
            if (newData instanceof MobyDataObject) {
                if (dataTemplate instanceof MobyPrimaryDataSimple) {
                    receiver.consumeMobyObject(dataName, newData);
                } else {
                    MobyDataObjectSet newDataCollection = new MobyDataObjectSet("");
                    newDataCollection.add((MobyDataObject)newData);
                    receiver.consumeMobyObject(dataName, newDataCollection);
                }
            } else if (dataTemplate instanceof MobyPrimaryDataSet) {
                receiver.consumeMobyObject(dataName, newData);
            } else if (((MobyDataObjectSet)newData).size() == 1) {
                receiver.consumeMobyObject(dataName, ((MobyDataObjectSet)newData).iterator().next());
            } else {
                System.err.println("TODO let user select one value from the bunch of data available");
            }
            return true;
        }
        System.err.println("Received data does not match 1 to 1, forwarding not yet implemented");
        return false;
    }

    public Map<String, MobyDataInstance> getDataFromMobyContents(Map<String, MobyPrimaryData> acceptableData, MobyContentInstance mci) {
        HashMap<String, MobyDataInstance> foundData = new HashMap<String, MobyDataInstance>();
        int itemCount = 1;
        for (MobyDataJob job : mci.values()) {
            for (MobyDataInstance mdi : job.values()) {
                if (!(mdi instanceof MobyDataObject)) continue;
                MobyDataObject object = (MobyDataObject)mdi;
                MobyDataType objectDataType = object.getDataType();
                for (String fieldName : acceptableData.keySet()) {
                    if (!objectDataType.inheritsFrom(acceptableData.get(fieldName).getDataType())) continue;
                    foundData.put(fieldName + "#" + itemCount++, object);
                }
            }
        }
        return foundData;
    }

    public Map<String, MobyDataInstance> getDataFromText(Map<String, MobyPrimaryData> acceptableData, String text) {
        HashMap<String, MobyDataInstance> foundData = new HashMap<String, MobyDataInstance>();
        for (String fieldName : acceptableData.keySet()) {
            int itemCount = 1;
            MobyDataType desiredDataType = acceptableData.get(fieldName).getDataType();
            System.err.println("Checking text for field " + fieldName + ", data type " + desiredDataType.getName());
            MobyDataObject[] textData = this.client.getMobyObjects(text, desiredDataType);
            if (textData == null) continue;
            System.err.println("Found " + textData.length + " matches");
            for (MobyDataObject object : textData) {
                foundData.put(fieldName + "#" + itemCount++, object);
            }
        }
        return foundData;
    }

    public Map<String, MobyDataInstance> getDataFromURL(Map<String, MobyPrimaryData> acceptableData, URL url) {
        HashMap<String, MobyDataInstance> foundData = new HashMap<String, MobyDataInstance>();
        for (String fieldName : acceptableData.keySet()) {
            int itemCount = 1;
            MobyDataType desiredDataType = acceptableData.get(fieldName).getDataType();
            MobyDataObject[] urlData = this.client.getMobyObjects(url, desiredDataType);
            if (urlData == null) continue;
            for (MobyDataObject object : urlData) {
                foundData.put(fieldName + "#" + itemCount++, object);
            }
        }
        return foundData;
    }

    public Map<String, MobyDataInstance> getDataFromURLContents(Map<String, MobyPrimaryData> acceptableData, URL u) throws Exception {
        HashMap<String, MobyDataInstance> foundData = new HashMap<String, MobyDataInstance>();
        if (u == null) {
            return foundData;
        }
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        InputStream inputStream = u.openStream();
        byte[] dataChunk = new byte[4096];
        int bytesRead = inputStream.read(dataChunk);
        while (bytesRead != -1) {
            byteBuffer.write(dataChunk, 0, bytesRead);
            bytesRead = inputStream.read(dataChunk);
        }
        for (String fieldName : acceptableData.keySet()) {
            int itemCount = 1;
            MobyDataType desiredDataType = acceptableData.get(fieldName).getDataType();
            MobyDataObject[] fileData = this.client.getMobyObjects(byteBuffer.toByteArray(), desiredDataType);
            if (fileData == null) continue;
            for (MobyDataObject object : fileData) {
                foundData.put(fieldName + "#" + itemCount++, object);
            }
        }
        return foundData;
    }

    public Map<String, MobyDataInstance> getDataFromFiles(Map<String, MobyPrimaryData> acceptableData, Iterable<File> files) throws Exception {
        Map<String, MobyDataInstance> foundData = new HashMap<String, MobyDataInstance>();
        for (File file : files) {
            URL u = HTMLUtils.checkForURLShortcut(file);
            if (u != null) {
                foundData = this.getDataFromURL(acceptableData, u);
            } else {
                try {
                    u = file.toURI().toURL();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mergeDataMaps(foundData, this.getDataFromURLContents(acceptableData, u));
        }
        return foundData;
    }

    public void mergeDataMaps(Map<String, MobyDataInstance> keeper, Map<String, MobyDataInstance> newData) {
        if (newData == null) {
            return;
        }
        for (Map.Entry<String, MobyDataInstance> entry : newData.entrySet()) {
            String key = entry.getKey();
            if (keeper.containsKey(key)) {
                // empty if block
            }
            keeper.put(key, entry.getValue());
        }
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
        Transferable createdData = null;
        try {
            if (!(comp instanceof MobyContentProducer)) {
                throw new IllegalStateException("Component calling exportToClipboard was not a MobyObjectProducer as expected, export aborted");
            }
            createdData = MobyUtils.createTransferable(((MobyContentProducer)((Object)comp)).exportMobyContent());
            clip.setContents(createdData, this);
        }
        catch (IllegalStateException e) {
            this.exportDone(comp, createdData, 0);
            throw e;
        }
        this.exportDone(comp, createdData, action);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

