/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.gui;

import ca.ucalgary.seahawk.gui.MobyContentGUI;
import ca.ucalgary.seahawk.gui.MobyContentPane;
import ca.ucalgary.seahawk.util.DescriptiveFileFilter;
import ca.ucalgary.seahawk.util.HTMLUtils;
import ca.ucalgary.seahawk.util.SeahawkOptions;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.AbstractOpenOfficeDocumentConverter;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import com.artofsolving.jodconverter.openoffice.converter.StreamOpenOfficeDocumentConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class MobySaveDialog {
    public static final String FILE_CHOOSER_SAVE_TITLE = "Save Current Tab To File";
    public static final String XML_DESC = "XML (MOBY data envelope format)";
    public static final String TXT_DESC = "TXT (Plain Text Format)";
    public static final String RTF_DESC = "RTF (Rich Text Format)";
    public static final String CSV_DESC = "CSV (Comma Separated Values)";
    public static final String TSV_DESC = "TSV (Tab Separated Values)";
    public static final String PPT_DESC = "PPT (Microsoft PowerPoint Format)";
    public static final String ODT_DESC = "ODT (Open Document Text)";
    public static final String WPD_DESC = "WPD (WordPerfect Format)";
    public static final String ODS_DESC = "ODS (Open Document Spreadsheet)";
    public static final String ODP_DESC = "ODP (Open Document Presentation)";
    public static final String DOC_DESC = "DOC (Microsoft Word Format)";
    public static final String XLS_DESC = "XLS (Microsoft Excel Format)";
    public static final String TEX_DESC = "TEX (TeX Typesetting File)";
    public static final String PDF_DESC = "PDF (Portable Document Format)";
    public static final String HTML_DESC = "HTML (Web Page)";
    public static final String SCUFL_DESC = "Workflow Macro (Taverna SCUFL format)";
    public static final String SCUFL_EXT = ".scufl";
    public static final String XML_EXT = ".xml";
    public static final String TXT_EXT = ".txt";
    public static final String CSV_EXT = ".csv";
    public static final String RTF_EXT = ".rtf";
    public static final String PPT_EXT = ".ppt";
    public static final String DOC_EXT = ".doc";
    public static final String XLS_EXT = ".xls";
    public static final String PDF_EXT = ".pdf";
    public static final String ODP_EXT = ".odp";
    public static final String ODS_EXT = ".ods";
    public static final String ODT_EXT = ".odt";
    public static final String TSV_EXT = ".tsv";
    public static final String TEX_EXT = ".tex";
    public static final String WPD_EXT = ".wpd";
    public static final String HTML_EXT = ".html";
    public static final String XLS_MIME = "application/msexcel";
    public static final String DOC_MIME = "application/msword";
    public static final String PPT_MIME = "application/mspowerpoint";
    public static final String XLS_MIME2 = "application/vnd.ms-excel";
    public static final String DOC_MIME2 = "application/vnd.ms-word";
    public static final String PPT_MIME2 = "application/vnd.ms-powerpoint";
    public static final String ODT_MIME = "application/vnd.oasis.opendocument.text";
    public static final String ODS_MIME = "application/vnd.oasis.opendocument.spreadsheet";
    public static final String ODP_MIME = "application/vnd.oasis.opendocument.presentation";
    public static final String CSV_MIME = "text/csv";
    public static final String CSV_MIME2 = "text/comma-separated-values";
    private static Logger logger = Logger.getLogger(MobySaveDialog.class);
    private static FileFilter lastFilterUsed = null;
    private static File lastDirOpened = null;

    public static void exportDocument(final MobyContentPane document) {
        if (document != null) {
            new Thread(){

                public void run() {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setDialogTitle(MobySaveDialog.FILE_CHOOSER_SAVE_TITLE);
                    fileChooser.setName(MobySaveDialog.FILE_CHOOSER_SAVE_TITLE);
                    fileChooser.setFileHidingEnabled(false);
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(MobySaveDialog.SCUFL_EXT, MobySaveDialog.SCUFL_DESC));
                    fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(MobySaveDialog.HTML_EXT, MobySaveDialog.HTML_DESC));
                    if (document.hasXMLSource()) {
                        fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(MobySaveDialog.XML_EXT, MobySaveDialog.XML_DESC));
                    }
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    int choice = fileChooser.showSaveDialog(null);
                    if (choice == 0) {
                        File f = fileChooser.getSelectedFile();
                        String filename = f.getName();
                        FileFilter filter = fileChooser.getFileFilter();
                        if (filename.indexOf(MobySaveDialog.XML_EXT) != -1 && filename.indexOf(MobySaveDialog.XML_EXT) == filename.length() - MobySaveDialog.XML_EXT.length()) {
                            MobySaveDialog.exportXML(document, f);
                        } else if (filename.indexOf(MobySaveDialog.HTML_EXT) != -1 && filename.indexOf(MobySaveDialog.HTML_EXT) == filename.length() - MobySaveDialog.HTML_EXT.length()) {
                            MobySaveDialog.exportHTML(document, f);
                        } else if (filename.indexOf(MobySaveDialog.SCUFL_EXT) != -1 && filename.indexOf(MobySaveDialog.SCUFL_EXT) == filename.length() - MobySaveDialog.SCUFL_EXT.length()) {
                            MobySaveDialog.exportSCUFL(document, f);
                        } else if (filter.getDescription().equals(MobySaveDialog.XML_DESC)) {
                            logger.debug("Adding xml suffix automatically to get " + new File(f.getParent(), filename + MobySaveDialog.XML_EXT));
                            MobySaveDialog.exportXML(document, new File(f.getParent(), filename + MobySaveDialog.XML_EXT));
                        } else if (filter.getDescription().equals(MobySaveDialog.HTML_DESC)) {
                            logger.debug("Adding html suffix automatically to get " + new File(f.getParent(), filename + MobySaveDialog.HTML_EXT));
                            MobySaveDialog.exportHTML(document, new File(f.getParent(), filename + MobySaveDialog.HTML_EXT));
                        } else if (filter.getDescription().equals(MobySaveDialog.SCUFL_DESC)) {
                            logger.debug("Adding html suffix automatically to get " + new File(f.getParent(), filename + MobySaveDialog.SCUFL_EXT));
                            MobySaveDialog.exportSCUFL(document, new File(f.getParent(), filename + MobySaveDialog.SCUFL_EXT));
                        } else {
                            logger.warn("Could not determine file type for " + filename);
                        }
                    }
                }
            }.start();
        }
    }

    public static void exportHTML(final MobyContentPane document, final File f) {
        new Thread(){

            public void run() {
                try {
                    FileOutputStream ostream = new FileOutputStream(f);
                    String html = document.getHTMLSource();
                    ((OutputStream)ostream).write(html.getBytes());
                    ostream.flush();
                    ((OutputStream)ostream).close();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Cannot save the MOBY document: " + ex, "Error saving", 0);
                }
            }
        }.start();
    }

    public static void exportSCUFL(MobyContentPane tab, File f) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public static void exportXML(final MobyContentPane document, final File f) {
        new Thread(){

            public void run() {
                try {
                    FileOutputStream ostream = new FileOutputStream(f);
                    String xml = document.getXMLSource();
                    ((OutputStream)ostream).write(xml.getBytes());
                    ostream.flush();
                    ((OutputStream)ostream).close();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Cannot save the MOBY document in XML format: " + ex, "Error saving", 0);
                }
            }
        }.start();
    }

    public static void showFileOpenDialog(MobyContentGUI mcg, boolean useDefaultHandler) {
        int choice;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Load data from file");
        fileChooser.setName("Load data from file");
        if (lastDirOpened != null) {
            fileChooser.setCurrentDirectory(lastDirOpened);
        }
        fileChooser.setFileSelectionMode(0);
        if (SeahawkOptions.getDocConverterHost() != null) {
            fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(CSV_EXT, CSV_DESC));
            fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(DOC_EXT, DOC_DESC));
            fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(ODP_EXT, ODP_DESC));
            fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(ODS_EXT, ODS_DESC));
            fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(ODT_EXT, ODT_DESC));
            fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(PPT_EXT, PPT_DESC));
            fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(TSV_EXT, TSV_DESC));
            fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(WPD_EXT, WPD_DESC));
            fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(XLS_EXT, XLS_DESC));
        }
        fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(HTML_EXT, HTML_DESC));
        fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(RTF_EXT, RTF_DESC));
        fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(TEX_EXT, TEX_DESC));
        fileChooser.addChoosableFileFilter(new DescriptiveFileFilter(TXT_EXT, TXT_DESC));
        DescriptiveFileFilter xmlFilter = new DescriptiveFileFilter(XML_EXT, XML_DESC);
        fileChooser.addChoosableFileFilter(xmlFilter);
        fileChooser.setAcceptAllFileFilterUsed(true);
        if (lastFilterUsed != null) {
            fileChooser.setFileFilter(lastFilterUsed);
        } else {
            fileChooser.setFileFilter(xmlFilter);
        }
        while ((choice = fileChooser.showOpenDialog(mcg)) == 0) {
            if (!fileChooser.getSelectedFile().exists()) {
                Object[] options = new Object[]{"Try again", "Cancel"};
                int response = JOptionPane.showOptionDialog(mcg, "Sorry, the specified file does not exist", "Invalid File Name", 2, 3, null, options, options[0]);
                if (response != 1) continue;
                return;
            }
            try {
                lastDirOpened = fileChooser.getCurrentDirectory();
                lastFilterUsed = fileChooser.getFileFilter();
                File fileToOpen = fileChooser.getSelectedFile();
                mcg.loadPaneFromURL(fileToOpen.toURI().toURL(), useDefaultHandler);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(mcg, "Could not load the data:\n" + e, "Error Loading Data From File", 0);
            }
        }
    }

    public static URL convertToDisplayable(URL u) throws Exception {
        URLConnection uc = MobySaveDialog.convertToDisplayable(u.openConnection());
        return uc == null ? null : uc.getURL();
    }

    public static URLConnection convertToDisplayable(URLConnection uc) throws Exception {
        String conversionHost = SeahawkOptions.getDocConverterHost();
        if (conversionHost == null) {
            return null;
        }
        URL u = uc.getURL();
        String filePrefix = u.getPath();
        if ((filePrefix = filePrefix.substring(0, filePrefix.length() - 4)).indexOf("/") != -1 && filePrefix.indexOf("/") < filePrefix.length() - 1) {
            filePrefix = filePrefix.substring(filePrefix.lastIndexOf("/") + 1);
        }
        File outputFile = File.createTempFile(filePrefix, MobySaveDialog.getPreferredExtension(uc), SeahawkOptions.getTempDir());
        outputFile.delete();
        outputFile.deleteOnExit();
        File fileToOpen = null;
        if (u.getProtocol().equals("file")) {
            try {
                fileToOpen = new File(u.toURI());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Could not convert the file URL into a system file path:\n" + e, "Error Converting URL to File", 0);
                throw e;
            }
        } else {
            fileToOpen = File.createTempFile(filePrefix, u.getFile().substring(u.getFile().length() - 4), SeahawkOptions.getTempDir());
            fileToOpen.deleteOnExit();
            FileOutputStream os = new FileOutputStream(fileToOpen);
            ((OutputStream)os).write(HTMLUtils.getURLContentBytes(u));
            ((OutputStream)os).close();
        }
        SocketOpenOfficeConnection connection = new SocketOpenOfficeConnection(conversionHost, SeahawkOptions.getDocConverterPort());
        connection.connect();
        AbstractOpenOfficeDocumentConverter converter = conversionHost.equals("localhost") ? new OpenOfficeDocumentConverter((OpenOfficeConnection)connection) : new StreamOpenOfficeDocumentConverter((OpenOfficeConnection)connection);
        converter.convert(fileToOpen, outputFile);
        connection.disconnect();
        return outputFile.toURI().toURL().openConnection();
    }

    public static String getPreferredExtension(URLConnection uc) {
        String fileName = uc.getURL().getPath().toLowerCase();
        String mimeType = uc.getContentType();
        if (fileName.endsWith(XLS_EXT) || mimeType.equals(XLS_MIME) || mimeType.equals(XLS_MIME2) || fileName.endsWith(ODS_EXT) || mimeType.equals(ODS_MIME) || fileName.endsWith(TSV_EXT) || mimeType.equals(CSV_MIME) || fileName.endsWith(CSV_EXT) || mimeType.equals(CSV_MIME2)) {
            return HTML_EXT;
        }
        if (fileName.endsWith(PPT_EXT) || mimeType.equals(PPT_MIME) || mimeType.equals(PPT_MIME2) || fileName.endsWith(ODP_EXT) || mimeType.equals(ODP_MIME)) {
            return HTML_EXT;
        }
        return HTML_EXT;
    }

    public static boolean isConvertible(URLConnection uc) {
        if (SeahawkOptions.getDocConverterHost() == null) {
            return false;
        }
        String fileName = uc.getURL().getPath().toLowerCase();
        String mimeType = uc.getContentType();
        return fileName.endsWith(XLS_EXT) || mimeType.equals(XLS_MIME) || mimeType.equals(XLS_MIME2) || fileName.endsWith(ODS_EXT) || fileName.endsWith(CSV_EXT) || fileName.endsWith(PPT_EXT) || mimeType.equals(PPT_MIME) || mimeType.equals(PPT_MIME2) || fileName.endsWith(ODP_EXT) || mimeType.equals(ODT_MIME) || mimeType.equals(ODP_MIME) || mimeType.equals(ODS_MIME) || fileName.endsWith(CSV_EXT) || mimeType.equals(CSV_MIME) || mimeType.equals(CSV_MIME2) || fileName.endsWith(DOC_EXT) || mimeType.equals(DOC_MIME) || mimeType.equals(DOC_MIME2) || fileName.endsWith(WPD_EXT) || fileName.endsWith(ODT_EXT) || fileName.endsWith(CSV_EXT);
    }
}

