/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.gui;

import ca.ucalgary.seahawk.gui.MobyDataObjectWidget;
import ca.ucalgary.seahawk.services.MobyClient;
import ca.ucalgary.seahawk.util.HTMLUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.biomoby.shared.MobyData;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.data.MobyDataInstance;
import org.biomoby.shared.data.MobyDataSecondaryInstance;

public class MobySecondaryInputGUI
extends JDialog
implements ActionListener,
Runnable {
    public static final int MAX_TOOLTIP_WIDTH = 40;
    public static final int INT_CHOICE_MAX = 100;
    public static final int DEFAULT_TEXT_SIZE = 12;
    public static final String UNBOUNDED_INT_RANGE_DESC = "[integer]";
    public static final String UNBOUNDED_FLOAT_RANGE_DESC = "[decimal number]";
    public static final String TITLE = "Secondary Inputs for MOBY Service";
    public static final String OK_BUTTON_NAME = "MSIGexecuteButton";
    private MobyPrimaryData[] inputsPrimary = null;
    private MobyDataSecondaryInstance[] inputs = null;
    private JButton cancelButton;
    private String cancelMessage = "Cancel";
    private JButton confirmButton;
    private String confirmMessage = "Execute Service";
    private JPanel optionsPanel;
    private Map<MobyDataSecondaryInstance, JComponent> data2widget;
    private ActionListener listener;
    private int handlerCode = 0;
    private boolean showingNew = false;
    private MobyClient mobyClient;
    private static Logger logger = Logger.getLogger(MobySecondaryInputGUI.class);

    public MobySecondaryInputGUI(ActionListener al, Frame owner, boolean modal, MobyClient client) {
        this(al, owner, modal, 0, client);
    }

    public MobySecondaryInputGUI(ActionListener al, Frame owner, boolean modal, int actionCommandID, MobyClient client) {
        super(owner, modal);
        this.setup();
        this.listener = al;
        this.handlerCode = actionCommandID;
        this.mobyClient = client;
        this.setVisible(false);
        this.showingNew = false;
        this.setName(TITLE);
    }

    public MobySecondaryInputGUI(ActionListener al, MobyClient client) {
        this(al, 0, client);
    }

    public MobySecondaryInputGUI(ActionListener al, int actionCommandID, MobyClient client) {
        this.setup();
        this.listener = al;
        this.mobyClient = client;
        this.handlerCode = actionCommandID;
        this.setVisible(false);
    }

    protected void setup() {
        this.setTitle(TITLE);
        this.setDefaultCloseOperation(2);
        this.data2widget = new HashMap<MobyDataSecondaryInstance, JComponent>();
        this.optionsPanel = new JPanel();
        this.optionsPanel.setLayout(new GridLayout(0, 1));
        Container mainPane = this.getContentPane();
        mainPane.setLayout(new BorderLayout());
        mainPane.add((Component)this.optionsPanel, "North");
        JPanel okCancelPanel = new JPanel();
        BoxLayout bl = new BoxLayout(okCancelPanel, 2);
        this.cancelButton = new JButton(this.cancelMessage);
        this.cancelButton.addActionListener(this);
        okCancelPanel.add(this.cancelButton);
        this.confirmButton = new JButton(this.confirmMessage);
        this.confirmButton.addActionListener(this);
        this.confirmButton.setName(OK_BUTTON_NAME);
        okCancelPanel.add(this.confirmButton);
        mainPane.add((Component)okCancelPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                MobySecondaryInputGUI.this.confirmButton.requestFocusInWindow();
            }
        });
        this.getRootPane().setDefaultButton(this.confirmButton);
    }

    public boolean defaultFillIn(MobyDataSecondaryInstance[] secondaryInputs) {
        this.fillIn(secondaryInputs, false);
        return this.populateDataInstances();
    }

    public void fillIn(MobyDataSecondaryInstance[] secondaryInputs) {
        this.fillIn(secondaryInputs, true);
    }

    public void fillIn(MobyDataSecondaryInstance[] secondaryInputs, boolean showGUI) {
        this.fillIn(null, secondaryInputs, showGUI);
    }

    public void fillIn(MobyPrimaryData[] primaryInputs, MobyDataSecondaryInstance[] secondaryInputs, boolean showGUI) {
        if (!this.setupPrimaryInput(primaryInputs) && secondaryInputs == null) {
            this.run();
            return;
        }
        this.inputs = secondaryInputs;
        WidgetCreatorThread widgetMaker = new WidgetCreatorThread(showGUI, true);
        if (!showGUI) {
            widgetMaker.run();
        } else {
            widgetMaker.start();
        }
    }

    protected boolean setupPrimaryInput(MobyPrimaryData[] primaryInputs) {
        this.confirmButton.setEnabled(true);
        if (primaryInputs != null) {
            for (MobyPrimaryData primary : this.inputsPrimary = primaryInputs) {
                if (primary instanceof MobyDataInstance) continue;
                this.confirmButton.setEnabled(false);
            }
        }
        return this.confirmButton.isEnabled();
    }

    public boolean isNewShowing() {
        boolean ret = this.showingNew;
        if (ret) {
            this.showingNew = false;
        }
        return ret;
    }

    public Component makeWidget(MobyPrimaryData data) {
        boolean DATA_EDITABLE = true;
        MobyDataObjectWidget primaryDataWidget = null;
        primaryDataWidget = data instanceof MobyDataInstance ? new MobyDataObjectWidget(data.getName(), this.mobyClient, (MobyDataInstance)((Object)data), DATA_EDITABLE) : new MobyDataObjectWidget(data.getName(), this.mobyClient, data);
        primaryDataWidget.addActionListener(this);
        return primaryDataWidget;
    }

    public Component makeWidget(MobyDataSecondaryInstance msdi) {
        String dataType = msdi.getDataType();
        String[] enumeratedValues = msdi.getAllowedValues();
        if (enumeratedValues != null && enumeratedValues.length != 0) {
            return this.makeEnumWidget(msdi);
        }
        if ("Integer".equals(dataType)) {
            return this.makeIntWidget(msdi);
        }
        if ("Float".equals(dataType)) {
            return this.makeFloatWidget(msdi);
        }
        if ("String".equals(dataType)) {
            return this.makeStringWidget(msdi);
        }
        if ("DateTime".equals(dataType)) {
            return this.makeDateTimeWidget(msdi);
        }
        if ("Boolean".equals(dataType)) {
            return this.makeBooleanWidget(msdi);
        }
        logger.warn("Unrecognized secondary input data type (" + dataType + ") in " + this.getClass());
        return null;
    }

    public Component makeEnumWidget(MobyDataSecondaryInstance msdi) {
        String defaultValue = msdi.getDefaultValue();
        if (defaultValue == null) {
            defaultValue = "";
        }
        JPanel widget = new JPanel();
        String[] values = msdi.getAllowedValues();
        widget.add(this.makeJLabel(msdi));
        JComboBox<String> options = new JComboBox<String>();
        options.setSelectedIndex(-1);
        for (int i = 0; i < values.length; ++i) {
            options.addItem(values[i]);
            if (!defaultValue.equals(values[i])) continue;
            options.setSelectedIndex(i);
        }
        this.data2widget.put(msdi, options);
        widget.add(options);
        return widget;
    }

    public Component makeBooleanWidget(MobyDataSecondaryInstance msdi) {
        String defaultValue = msdi.getDefaultValue();
        if (defaultValue == null) {
            defaultValue = "false";
        }
        JPanel widget = new JPanel();
        widget.add(this.makeJLabel(msdi));
        JCheckBox checkbox = new JCheckBox();
        checkbox.setSelected(defaultValue.toLowerCase().equals("true") || defaultValue.toLowerCase().equals("yes") || defaultValue.equals("1") || defaultValue.equals("T") || defaultValue.equals("Y"));
        this.data2widget.put(msdi, checkbox);
        widget.add(checkbox);
        return widget;
    }

    public Component makeStringWidget(MobyDataSecondaryInstance msdi) {
        String defaultValue = msdi.getDefaultValue();
        if (defaultValue == null) {
            defaultValue = "";
        }
        JPanel widget = new JPanel();
        widget.add(this.makeJLabel(msdi));
        JTextField stringGUI = new JTextField(defaultValue, defaultValue.length() > 0 ? defaultValue.length() : 12);
        this.data2widget.put(msdi, stringGUI);
        widget.add(stringGUI);
        return widget;
    }

    public Component makeIntWidget(MobyDataSecondaryInstance msdi) {
        String name = msdi.getName();
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;
        if (msdi.getMinValue() != null && msdi.getMinValue().length() != 0) {
            try {
                min = Integer.parseInt(msdi.getMinValue());
            }
            catch (NumberFormatException nfe) {
                logger.error("NumberFormatException: Warning: minimum value for secondary input " + name + " could not be parse into an integer as required, using " + Integer.MIN_VALUE);
            }
        }
        if (msdi.getMaxValue() != null && msdi.getMaxValue().length() != 0) {
            try {
                max = Integer.parseInt(msdi.getMaxValue());
            }
            catch (NumberFormatException nfe) {
                logger.error("NumberFormatException: Warning: maximum value for secondary input " + name + " could not be parse into an integer as required, using " + Integer.MAX_VALUE);
            }
        }
        int defaultValue = 0;
        if (msdi.getDefaultValue() == null || msdi.getDefaultValue().length() == 0) {
            logger.warn("Warning: default value for secondary input " + name + " was blank, which is not allowed by the MOBY API, using default of 0");
        }
        try {
            Integer.parseInt(msdi.getDefaultValue());
        }
        catch (NumberFormatException nfe) {
            logger.error("NumberFormatException: Warning: default value for secondary input " + name + " could not be parse into an integer as required, using default of 0");
        }
        if (min > max) {
            logger.warn("Warning: swapping min and max values for secondary input " + name + ", since the specified min (" + min + ") is larger than the specified max (" + max + ")");
            int tmp = min;
            min = max;
            max = tmp;
        }
        if (defaultValue < min || defaultValue > max) {
            logger.warn("Warning: ignoring default value " + defaultValue + " for secondary input " + name + ", it is outside the valid range of [" + min + "," + max + "]");
            if (defaultValue < min) {
                defaultValue = min;
            }
            if (defaultValue > max) {
                defaultValue = max;
            }
        }
        String rangedesc = "";
        rangedesc = min == Integer.MIN_VALUE && max == Integer.MAX_VALUE ? UNBOUNDED_INT_RANGE_DESC : "[" + min + "," + max + "]";
        JPanel widget = new JPanel();
        if (max - min > 100 || rangedesc.equals(UNBOUNDED_INT_RANGE_DESC)) {
            widget.add(this.makeJLabel(msdi, rangedesc));
            JTextField stringGUI = new JTextField("" + defaultValue, ("" + max).length());
            this.data2widget.put(msdi, stringGUI);
            widget.add(stringGUI);
        } else {
            widget.add(this.makeJLabel(msdi));
            JComboBox<Integer> options = new JComboBox<Integer>();
            for (int i = min; i <= max; ++i) {
                options.addItem(new Integer(i));
            }
            options.setSelectedIndex(defaultValue - min);
            this.data2widget.put(msdi, options);
            widget.add(options);
        }
        return widget;
    }

    public Component makeFloatWidget(MobyDataSecondaryInstance msdi) {
        String name = msdi.getName();
        double min = Double.MIN_VALUE;
        if (msdi.getMinValue() != null && msdi.getMinValue().length() > 0) {
            try {
                Double.parseDouble(msdi.getMinValue());
            }
            catch (NumberFormatException nfe) {
                logger.error("NumberFormatException: Minimum value (" + msdi.getMinValue() + ") for decimal-format MOBY Secondary Input '" + name + "' was not a decimal number, setting minimum to " + Double.MIN_VALUE + ". Error was: " + nfe);
            }
        }
        double max = Double.MAX_VALUE;
        if (msdi.getMaxValue() != null && msdi.getMaxValue().length() > 0) {
            try {
                Double.parseDouble(msdi.getMaxValue());
            }
            catch (NumberFormatException nfe) {
                logger.error("NumberFormatException: Maximum value (" + msdi.getMaxValue() + ") for decimal-format MOBY Secondary Input '" + name + "' was not a decimal number, setting minimum to " + Double.MAX_VALUE + ". Error was: " + nfe);
            }
        }
        String defaultValueString = msdi.getDefaultValue();
        double defaultValue = 0.0;
        if (defaultValueString != null) {
            try {
                defaultValue = Double.parseDouble(defaultValueString);
            }
            catch (NumberFormatException nfe) {
                logger.error("NumberFormatException: Default value (" + defaultValueString + ") for decimal-format MOBY Secondary Input '" + name + "' was not a decimal number, setting default initially to " + defaultValue + ". Error was: " + nfe);
            }
        }
        if (min > max) {
            logger.warn("Warning: swapping min and max values for secondary input " + name + ", since the specified min (" + min + ") is larger than the specified max (" + max + ")");
            double tmp = min;
            min = max;
            max = tmp;
        }
        if (defaultValue < min || defaultValue > max) {
            logger.warn("Warning: ignoring default value " + defaultValue + " for secondary input " + name + ", it is outside the valid range of [" + min + "," + max + "]");
            if (defaultValue < min) {
                defaultValue = min;
            }
            if (defaultValue > max) {
                defaultValue = max;
            }
        }
        String rangedesc = "";
        rangedesc = min == -2.147483648E9 && max == 2.147483647E9 ? UNBOUNDED_FLOAT_RANGE_DESC : "[" + min + "," + max + "]";
        JPanel widget = new JPanel();
        widget.add(this.makeJLabel(msdi, rangedesc));
        JTextField stringGUI = new JTextField("" + defaultValue, ("" + max).length());
        this.data2widget.put(msdi, stringGUI);
        widget.add(stringGUI);
        return widget;
    }

    public JLabel makeJLabel(MobyDataSecondaryInstance msdi) {
        return this.makeJLabel(msdi, null);
    }

    public JLabel makeJLabel(MobyDataSecondaryInstance msdi, String range) {
        JLabel label = new JLabel(msdi.getName() + (range == null ? "" : " " + range) + ":");
        String desc = msdi.getDescription();
        if (desc == null || desc.length() == 0) {
            desc = "Sorry, no description of this input is available from the service provider";
        }
        label.setToolTipText(HTMLUtils.htmlifyToolTipText(desc, 40));
        return label;
    }

    public Component makeDateTimeWidget(MobyDataSecondaryInstance msdi) {
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.confirmButton) {
            if (this.populateDataInstances()) {
                this.doCallback();
                this.dispose();
            } else {
                JOptionPane.showConfirmDialog(this, "Could not set parameters as is, please ensure correctness", "Warning", 0, 2);
            }
        } else if (source == this.cancelButton) {
            this.dispose();
        } else if (source instanceof MobyDataObjectWidget) {
            MobyPrimaryData newData = ((MobyDataObjectWidget)source).getData();
            String newDataName = ((MobyDataObjectWidget)source).getName();
            boolean enableSubmit = true;
            for (int i = 0; i < this.inputsPrimary.length; ++i) {
                if (this.inputsPrimary[i].getName().equals(newDataName)) {
                    newData.setName(newDataName);
                    this.inputsPrimary[i] = newData;
                }
                if (!enableSubmit || this.inputsPrimary[i] instanceof MobyDataInstance) continue;
                enableSubmit = false;
            }
            this.confirmButton.setEnabled(enableSubmit);
        } else {
            logger.warn("Unrecognized event source (" + source + ") in " + this.getClass());
        }
    }

    private boolean populateDataInstances() {
        for (MobyDataSecondaryInstance msdi : this.data2widget.keySet()) {
            Object newValue = null;
            try {
                JComponent widget = this.data2widget.get(msdi);
                if (widget instanceof JComboBox) {
                    newValue = ((JComboBox)widget).getSelectedItem();
                    msdi.setValue(newValue.toString());
                    continue;
                }
                if (widget instanceof JTextComponent) {
                    newValue = ((JTextComponent)widget).getText();
                    msdi.setValue(newValue.toString());
                    continue;
                }
                if (widget instanceof JCheckBox) {
                    msdi.setValue("" + ((JCheckBox)widget).isSelected());
                    continue;
                }
                logger.error("IllegalArgumentException: GUI Component for " + msdi.getName() + " was neither a JComboBox nor a " + "JTextComponent nor a JCheckBox as expected");
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException iae) {
                JOptionPane.showMessageDialog(null, "Could not set value of " + msdi.getName() + " to " + newValue + ": " + iae, "Parameter Error", 0);
                return false;
            }
        }
        return true;
    }

    private void doCallback() {
        if (this.listener != null) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void run() {
        this.listener.actionPerformed(new ActionEvent(this, 0, "" + this.handlerCode));
    }

    class WidgetCreatorThread
    extends Thread {
        private boolean showGUI;
        private boolean showSinglePrimaryInput;

        public WidgetCreatorThread(boolean gui, boolean single) {
            this.showGUI = gui;
            this.showSinglePrimaryInput = single;
        }

        public void run() {
            MobySecondaryInputGUI.this.optionsPanel.removeAll();
            if (this.showGUI) {
                MobySecondaryInputGUI.this.setVisible(true);
            }
            if (!MobySecondaryInputGUI.this.confirmButton.isEnabled() || this.showSinglePrimaryInput) {
                for (MobyData mobyData : MobySecondaryInputGUI.this.inputsPrimary) {
                    MobySecondaryInputGUI.this.optionsPanel.add(MobySecondaryInputGUI.this.makeWidget((MobyPrimaryData)mobyData));
                }
                MobySecondaryInputGUI.this.optionsPanel.add(new JSeparator());
            }
            Arrays.sort(MobySecondaryInputGUI.this.inputs);
            for (MobyData mobyData : MobySecondaryInputGUI.this.inputs) {
                MobySecondaryInputGUI.this.optionsPanel.add(MobySecondaryInputGUI.this.makeWidget((MobyDataSecondaryInstance)mobyData));
            }
            if (this.showGUI) {
                MobySecondaryInputGUI.this.pack();
                MobySecondaryInputGUI.this.toFront();
                MobySecondaryInputGUI.this.requestFocus();
                MobySecondaryInputGUI.this.showingNew = true;
                MobySecondaryInputGUI.this.confirmButton.requestFocusInWindow();
            }
        }
    }
}

