/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.gui.test;

import ca.ucalgary.seahawk.gui.MobyContentGUI;
import ca.ucalgary.seahawk.gui.MobyContentHelpPane;
import ca.ucalgary.seahawk.gui.MobySaveDialog;
import ca.ucalgary.seahawk.util.BrowserLauncher;
import ca.ucalgary.seahawk.util.MobyUtils;
import ca.ucalgary.seahawk.util.PrintableJEditorPane;
import ca.ucalgary.seahawk.util.SeahawkOptions;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.JFCTestHelper;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.eventdata.AbstractKeyEventData;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import junit.extensions.jfcunit.eventdata.KeyEventData;
import junit.extensions.jfcunit.eventdata.MouseEventData;
import junit.extensions.jfcunit.eventdata.StringEventData;
import junit.extensions.jfcunit.finder.DialogFinder;
import junit.extensions.jfcunit.finder.Finder;
import junit.extensions.jfcunit.finder.NamedComponentFinder;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.data.MobyContentInstance;
import org.biomoby.shared.data.MobyDataComposite;
import org.biomoby.shared.data.MobyDataObjectSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeahawkTestCase
extends JFCTestCase {
    private static final String TEST_MS_WORD_FILE = "ca/ucalgary/seahawk/gui/test/perlregex.doc";
    private static final String TEST_MS_EXCEL_FILE = "ca/ucalgary/seahawk/gui/test/twohybrid_uetz.xls";
    private static final String TEST_MOBYEX_XML = "ca/ucalgary/seahawk/gui/test/moby_exception.xml";
    private static final String TEST_MOBY_XML = "ca/ucalgary/seahawk/gui/test/allDataTypes.xml";
    private static final String TEST_EXTERNAL_URL = "http://www.google.com/";
    private static final String TEST_DNA_SEQ = "AAGCTTGGCCAACGTAAATCTTTCGGCGGCA";
    private static final String TEST_AA_SEQ = "MPGGFILAIDEGTTSARAIIYNQDLEVLGIGQYDFPQHYPSP";
    private JFCTestHelper helper = null;
    private MobyContentGUI contentGUI;
    private NamedComponentFinder finder;

    public SeahawkTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setHelper((TestHelper)new JFCTestHelper());
        this.contentGUI = MobyUtils.getMobyContentGUI(new JLabel());
        this.contentGUI.setDefaultCloseOperation(2);
        Finder.setDefaultWait((int)3);
        this.finder = new NamedComponentFinder(JComponent.class, "");
        this.contentGUI.setVisible(true);
    }

    protected void tearDown() throws Exception {
        this.contentGUI = null;
        MobyUtils.clearGUIs();
        this.getHelper();
        TestHelper.cleanUp((JFCTestCase)this);
        super.tearDown();
    }

    public void testHelpTab() {
        int helpTabIndex = this.contentGUI.showHelpTab();
        this.finder.setName("Help Page");
        Component foundObj = this.finder.find((Container)this.contentGUI, 0);
        SeahawkTestCase.assertNotNull((String)"The Help tab could not be programmatically loaded", (Object)foundObj);
        SeahawkTestCase.assertTrue((String)"Help tab found, but was not a MobyContentHelpPane as expected", (boolean)(foundObj instanceof MobyContentHelpPane));
        String contents = ((MobyContentHelpPane)foundObj).getHTMLSource();
        SeahawkTestCase.assertTrue((String)"Help tab (loaded programmatically) could not load any contents (text is null)", (contents != null ? 1 : 0) != 0);
        SeahawkTestCase.assertTrue((String)"Help tab (loaded programmatically) contents was zero-length, but we expected at least some help text", (contents.length() > 0 ? 1 : 0) != 0);
        this.contentGUI.setActiveTab(helpTabIndex);
        this.contentGUI.actionPerformed(new ActionEvent((Object)this, 0, "Close This Tab"));
        foundObj = this.finder.find((Container)this.contentGUI, 0);
        SeahawkTestCase.assertNull((String)"Could not close the help tab by sending MobyContentGUI a MobyContentGUI.CLOSE_TAB_OPTION ActionEvent command", (Object)foundObj);
    }

    public void testHelpButton() {
        this.finder.setName("MCGhelpButton");
        JButton helpButton = (JButton)this.finder.find((Container)this.contentGUI, 0);
        SeahawkTestCase.assertNotNull((String)"The help button is missing from the Seahawk interface", (Object)helpButton);
        this.getHelper().enterClickAndLeave((AbstractMouseEventData)new MouseEventData((JFCTestCase)this, (Component)helpButton));
        this.finder.setName("Help Page");
        Component foundObj = this.finder.find((Container)this.contentGUI, 0);
        SeahawkTestCase.assertNotNull((String)"The Help tab could not be loaded via the help button (but was okay when loaded programmatically)", (Object)foundObj);
        SeahawkTestCase.assertTrue((String)"Help tab loaded via help button, but was not a MobyContentHelpPane as expected (but was okay when loaded programmatically)", (boolean)(foundObj instanceof MobyContentHelpPane));
        String contents = ((MobyContentHelpPane)foundObj).getHTMLSource();
        SeahawkTestCase.assertTrue((String)"Help tab loaded via help button could not load any contents (text is null, but was okay when loaded programmatically)", (contents != null ? 1 : 0) != 0);
        SeahawkTestCase.assertTrue((String)"Help tab (loaded via help button) contents was zero-length, but we expected at least some help text (was okay when loaded programmatically)", (contents.length() > 0 ? 1 : 0) != 0);
    }

    public void testClipboardTab() {
        MobyDataObjectSet clipSet = this.contentGUI.addToClipboard(null);
        SeahawkTestCase.assertNotNull((String)"The clipboard is null, but should be initialized with the Seahawk display", (Object)clipSet);
        SeahawkTestCase.assertTrue((String)("The clipboard contains the wrong number (" + clipSet.size() + ") of items, expected 0 at the start"), (clipSet.size() == 0 ? 1 : 0) != 0);
        MobyDataComposite mobyObject = MobyUtils.createMobySequence(TEST_DNA_SEQ, "foo");
        clipSet = this.contentGUI.addToClipboard(mobyObject);
        SeahawkTestCase.assertNotNull((String)"The clipboard is null, but should be initialized, with one object", (Object)clipSet);
        SeahawkTestCase.assertTrue((String)("The clipboard contains the wrong number (" + clipSet.size() + ") of items, expected 1"), (clipSet.size() == 1 ? 1 : 0) != 0);
        MobyDataComposite mobyObject2 = MobyUtils.createMobySequence("catatcgagtcgttgtgca", "bar");
        clipSet = this.contentGUI.addToClipboard(mobyObject2);
        SeahawkTestCase.assertNotNull((String)"The clipboard is null, but should be initialized, with two objects", (Object)clipSet);
        SeahawkTestCase.assertTrue((String)("The clipboard contains the wrong number (" + clipSet.size() + ") of items, expected 2"), (clipSet.size() == 2 ? 1 : 0) != 0);
        MobyDataType dnaDataType = MobyDataType.getDataType("DNASequence");
        SeahawkTestCase.assertEquals((String)("Shared data type of the two items on clipboard (" + clipSet.getDataType().getName() + ") was not " + dnaDataType.getName() + " as expected"), (Object)dnaDataType, (Object)clipSet.getDataType());
        MobyDataComposite mobyObject3 = MobyUtils.createMobySequence(TEST_AA_SEQ, "baz");
        clipSet = this.contentGUI.addToClipboard(mobyObject3);
        SeahawkTestCase.assertNotNull((String)"The clipboard is null, but should be initialized, with two objects", (Object)clipSet);
        SeahawkTestCase.assertTrue((String)("The clipboard contains the wrong number (" + clipSet.size() + ") of items, expected 3"), (clipSet.size() == 3 ? 1 : 0) != 0);
        MobyDataType seqDataType = MobyDataType.getDataType("GenericSequence");
        SeahawkTestCase.assertEquals((String)("Shared data type of the three items on clipboard (" + clipSet.getDataType().getName() + ") was not " + seqDataType.getName() + " as expected"), (Object)seqDataType, (Object)clipSet.getDataType());
        SeahawkTestCase.assertTrue((String)"The third object in the clipboard could not be deleted programmatically", (boolean)this.contentGUI.removeFromClipboard(mobyObject3));
        SeahawkTestCase.assertEquals((String)("Shared data type of the two items on clipboard (" + clipSet.getDataType().getName() + ") was not " + dnaDataType.getName() + " as expected (restoration of data type after " + "item deletion failed)"), (Object)dnaDataType, (Object)clipSet.getDataType());
        this.contentGUI.clearClipboard();
        clipSet = this.contentGUI.addToClipboard(null);
        SeahawkTestCase.assertNotNull((String)"The clipboard is null, but should be initialized with the Seahawk display", (Object)clipSet);
        SeahawkTestCase.assertTrue((String)("The clipboard contains the wrong number (" + clipSet.size() + ") of items, expected 0 at the start"), (clipSet.size() == 0 ? 1 : 0) != 0);
        clipSet = this.contentGUI.addToClipboard(mobyObject2);
        SeahawkTestCase.assertNotNull((String)"The clipboard is null, but should be initialized, with one object", (Object)clipSet);
        SeahawkTestCase.assertTrue((String)("The clipboard contains the wrong number (" + clipSet.size() + ") of items, expected 1"), (clipSet.size() == 1 ? 1 : 0) != 0);
        SeahawkTestCase.assertEquals((String)("Shared data type of the item on clipboard (" + clipSet.getDataType().getName() + ") was not " + dnaDataType.getName() + " as expected (restoration of data type after " + "clipboard clearing failed)"), (Object)dnaDataType, (Object)clipSet.getDataType());
    }

    public void testSave() throws Exception {
        this.finder.setName("MCGsaveButton");
        final JButton save = (JButton)this.finder.find((Container)this.contentGUI, 0);
        SeahawkTestCase.assertNotNull((String)"The save button is missing from the Seahawk interface", (Object)save);
        MobyDataComposite mobyObject = MobyUtils.createMobySequence(TEST_DNA_SEQ, "foo");
        this.contentGUI.loadPaneFromObject(new MobyContentInstance(mobyObject, "save-test"), true);
        new Thread(){

            public void run() {
                save.doClick();
            }
        }.start();
        this.sleep(2000L);
        this.finder.setName("Save Current Tab To File");
        List showingDialogs = this.finder.findAll();
        SeahawkTestCase.assertTrue((String)("Number of file choosers with name \"Save Current Tab To File\" showing is wrong: " + showingDialogs.size() + " (should be 1)"), (showingDialogs.size() == 1 ? 1 : 0) != 0);
        JFileChooser fc = (JFileChooser)showingDialogs.get(0);
        File testFile = null;
        try {
            testFile = File.createTempFile("test-seahawk", "");
            testFile.deleteOnExit();
            fc.setSelectedFile(testFile);
            this.sleep(2000L);
            fc.approveSelection();
            SeahawkTestCase.assertTrue((String)("File (" + testFile + ") was not saved"), (boolean)testFile.exists());
        }
        catch (IOException ioe) {
            System.err.println("Warning: Skipping save-to-disk test, could not write a temporary file:" + ioe);
            fc.cancelSelection();
        }
        SeahawkTestCase.assertNull((String)"File chooser for open operation did not disappear after approval", (Object)this.finder.find());
        if (testFile == null) {
            return;
        }
        this.sleep(2000L);
        MobySaveDialog.exportXML(this.contentGUI.getCurrentPane(), testFile);
        this.sleep(2000L);
        SeahawkTestCase.assertTrue((String)"The XML saved data file was empty", (testFile.length() != 0L ? 1 : 0) != 0);
        MobySaveDialog.exportHTML(this.contentGUI.getCurrentPane(), testFile);
        this.sleep(2000L);
        SeahawkTestCase.assertTrue((String)"The HTML saved data file was empty", (testFile.length() != 0L ? 1 : 0) != 0);
    }

    public void testPrint() {
        DialogFinder dfinder = new DialogFinder(".*");
        List showingDialogs = dfinder.findAll();
        int numInitialDialogs = showingDialogs.size();
        this.finder.setName("MCGprintButton");
        final JButton print = (JButton)this.finder.find((Container)this.contentGUI, 0);
        SeahawkTestCase.assertNotNull((String)"The print button is missing from the Seahawk interface", (Object)print);
        this.contentGUI.showHelpTab();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        new Thread(){

            public void run() {
                print.doClick();
            }
        }.start();
        this.sleep(2000L);
        showingDialogs = dfinder.findAll();
        SeahawkTestCase.assertTrue((String)"No dialog appeared when the print button was pressed", (showingDialogs.size() == numInitialDialogs + 1 ? 1 : 0) != 0);
        this.getHelper();
        TestHelper.disposeWindow((Window)((Dialog)showingDialogs.get(showingDialogs.size() - 1)), (JFCTestCase)this);
        Thread.currentThread().setContextClassLoader(oldClassLoader);
    }

    public void testNavigationButtons() throws Exception {
        this.finder.setName("MCGbackButton");
        JButton back = (JButton)this.finder.find((Container)this.contentGUI, 0);
        SeahawkTestCase.assertNotNull((String)"The back button is missing from the Seahawk interface", (Object)back);
        this.finder.setName("MCGforwardButton");
        JButton forward = (JButton)this.finder.find((Container)this.contentGUI, 0);
        SeahawkTestCase.assertNotNull((String)"The forward button is missing from the Seahawk interface", (Object)forward);
        SeahawkTestCase.assertFalse((String)"The back button is enabled, but there is no history for the tab", (boolean)back.isEnabled());
        SeahawkTestCase.assertFalse((String)"The forward button is enabled, but there is no history for the tab", (boolean)forward.isEnabled());
        URL testMobyURL = ((Object)((Object)this)).getClass().getClassLoader().getResource(TEST_MOBY_XML);
        SeahawkTestCase.assertNotNull((String)"Could not find the MOBY test XML document for Seahawk (ca/ucalgary/seahawk/gui/test/allDataTypes.xml)", (Object)testMobyURL);
        this.contentGUI.loadPaneFromURL(testMobyURL, true);
        SeahawkTestCase.assertFalse((String)"The back button is enabled, but there is only one (initial) document in the history for the tab", (boolean)back.isEnabled());
        SeahawkTestCase.assertFalse((String)"The forward button is enabled, but there is only one (initial) document in the history for the tab", (boolean)forward.isEnabled());
        SeahawkTestCase.assertEquals((String)("URL loaded (" + testMobyURL + ") and current URL of Seahawk display (" + this.contentGUI.getCurrentURL() + ") are not the same"), (Object)testMobyURL, (Object)this.contentGUI.getCurrentURL());
        this.sleep(2000L);
        URL testMobyURL2 = new URL(TEST_EXTERNAL_URL);
        SeahawkTestCase.assertNotNull((String)"Could not find the MOBY test XML document for Seahawk (http://www.google.com/)", (Object)testMobyURL2);
        this.contentGUI.loadPaneFromURL(testMobyURL2, false);
        this.sleep(2000L);
        SeahawkTestCase.assertTrue((String)"The back button is not enabled, but there is a previous document in the history for the tab", (boolean)back.isEnabled());
        SeahawkTestCase.assertFalse((String)"The forward button is enabled, but there is no forward document in the history for the tab", (boolean)forward.isEnabled());
        SeahawkTestCase.assertEquals((String)("URL loaded (" + testMobyURL2 + ") and current URL of Seahawk display (" + this.contentGUI.getCurrentURL() + ") are not the same"), (Object)testMobyURL2, (Object)this.contentGUI.getCurrentURL());
        back.doClick();
        this.sleep(2000L);
        SeahawkTestCase.assertFalse((String)"The back button is enabled, but there is no previous document in the history for the tab", (boolean)back.isEnabled());
        SeahawkTestCase.assertTrue((String)"The forward button is dinabled, but there is a forward document in the history for the tab", (boolean)forward.isEnabled());
        SeahawkTestCase.assertEquals((String)("URL to be reloaded via back button (" + testMobyURL + ") and current URL of Seahawk display (" + this.contentGUI.getCurrentURL() + ") are not the same"), (Object)testMobyURL, (Object)this.contentGUI.getCurrentURL());
        forward.doClick();
        this.sleep(2000L);
        SeahawkTestCase.assertTrue((String)"The back button is not enabled, but there is a previous document in the history for the tab", (boolean)back.isEnabled());
        SeahawkTestCase.assertFalse((String)"The forward button is enabled, but there is no forward document in the history for the tab", (boolean)forward.isEnabled());
        SeahawkTestCase.assertEquals((String)("URL loaded (" + testMobyURL2 + ") and current URL of Seahawk display (" + this.contentGUI.getCurrentURL() + ") are not the same"), (Object)testMobyURL2, (Object)this.contentGUI.getCurrentURL());
        URL testMobyURL3 = ((Object)((Object)this)).getClass().getClassLoader().getResource(TEST_MOBYEX_XML);
        SeahawkTestCase.assertNotNull((String)"Could not find the MOBY test XML document for Seahawk (ca/ucalgary/seahawk/gui/test/moby_exception.xml)", (Object)testMobyURL3);
        this.contentGUI.loadPaneFromURL(testMobyURL3, false);
        this.sleep(2000L);
        SeahawkTestCase.assertTrue((String)"The back button is not enabled, but there is a previous document in the history for the tab", (boolean)back.isEnabled());
        SeahawkTestCase.assertFalse((String)"The forward button is enabled, but there is no forward document in the history for the tab", (boolean)forward.isEnabled());
        SeahawkTestCase.assertEquals((String)("URL to be reloaded via back button (" + testMobyURL3 + ") and current URL of Seahawk display (" + this.contentGUI.getCurrentURL() + ") are not the same"), (Object)testMobyURL3, (Object)this.contentGUI.getCurrentURL());
        back.doClick();
        this.sleep(2000L);
        SeahawkTestCase.assertTrue((String)"The back button is not enabled, but we are in the middle of the history for the tab", (boolean)back.isEnabled());
        SeahawkTestCase.assertTrue((String)"The forward button is not enabled, but we are in the middle of the history for the tab", (boolean)forward.isEnabled());
        SeahawkTestCase.assertEquals((String)("URL loaded (" + testMobyURL2 + ") and current URL of Seahawk display (" + this.contentGUI.getCurrentURL() + ") are not the same"), (Object)testMobyURL2, (Object)this.contentGUI.getCurrentURL());
        forward.doClick();
        this.sleep(2000L);
        SeahawkTestCase.assertTrue((String)"The back button is not enabled, but there is a previous document in the history for the tab", (boolean)back.isEnabled());
        SeahawkTestCase.assertFalse((String)"The forward button is enabled, but there is no forward document in the history for the tab", (boolean)forward.isEnabled());
        SeahawkTestCase.assertEquals((String)("URL loaded (" + testMobyURL3 + ") and current URL of Seahawk display (" + this.contentGUI.getCurrentURL() + ") are not the same"), (Object)testMobyURL3, (Object)this.contentGUI.getCurrentURL());
        back.doClick();
        this.sleep(2000L);
        back.doClick();
        this.sleep(2000L);
        SeahawkTestCase.assertFalse((String)"The back button is enabled, but there is no previous document in the history for the tab", (boolean)back.isEnabled());
        SeahawkTestCase.assertTrue((String)"The forward button is disabled, but there is a forward document in the history for the tab", (boolean)forward.isEnabled());
        SeahawkTestCase.assertEquals((String)("URL to be reloaded via back button (" + testMobyURL + ") and current URL of Seahawk display (" + this.contentGUI.getCurrentURL() + ") are not the same"), (Object)testMobyURL, (Object)this.contentGUI.getCurrentURL());
        forward.doClick();
        this.sleep(2000L);
        SeahawkTestCase.assertTrue((String)"The back button is not enabled, but we are in the middle of the history for the tab", (boolean)back.isEnabled());
        SeahawkTestCase.assertTrue((String)"The forward button is not enabled, but we are in the middle of the history for the tab", (boolean)forward.isEnabled());
        SeahawkTestCase.assertEquals((String)("URL loaded (" + testMobyURL2 + ") and current URL of Seahawk display (" + this.contentGUI.getCurrentURL() + ") are not the same"), (Object)testMobyURL2, (Object)this.contentGUI.getCurrentURL());
        this.contentGUI.loadPaneFromURL(testMobyURL, false);
        this.sleep(2000L);
        SeahawkTestCase.assertTrue((String)"The back button is not enabled, but should be in truncated history for the tab", (boolean)back.isEnabled());
        SeahawkTestCase.assertFalse((String)"The forward button is enabled, but should not be in truncated history for the tab", (boolean)forward.isEnabled());
        SeahawkTestCase.assertEquals((String)("URL to be reloaded via back button (" + testMobyURL + ") and current URL of Seahawk display (" + this.contentGUI.getCurrentURL() + ") are not the same"), (Object)testMobyURL, (Object)this.contentGUI.getCurrentURL());
    }

    public void testOpenButton() throws Exception {
        this.finder.setName("MCGopenButton");
        JButton openButton = (JButton)this.finder.find((Container)this.contentGUI, 0);
        SeahawkTestCase.assertNotNull((String)"The file/URL open button is missing from the Seahawk interface", (Object)openButton);
        openButton.doClick();
        this.sleep(500L);
        this.finder.setName("MCGopenPopup");
        Component openPopup = this.finder.find();
        SeahawkTestCase.assertNotNull((String)"Clicking the file/URL open button did not open the options popup (was null)", (Object)openPopup);
        SeahawkTestCase.assertTrue((String)("Component launched by clicking open button was not a JPopupMenu as expected (was a " + openPopup.getClass().getName()), (boolean)(openPopup instanceof JPopupMenu));
        this.finder.setName("MCGopenPopupFileOption");
        final Component openFileItem = this.getSubComponentByName((JPopupMenu)openPopup, "MCGopenPopupFileOption");
        SeahawkTestCase.assertNotNull((String)"The document open popup menu did not contain the file open option (was null)", (Object)openFileItem);
        SeahawkTestCase.assertTrue((String)("File Option in 'Open Document' JPopupMenu was not a JMenuItem as expected (was a " + openFileItem.getClass().getName() + ")"), (boolean)(openFileItem instanceof JMenuItem));
        new Thread(){

            public void run() {
                ((JMenuItem)openFileItem).doClick();
            }
        }.start();
        this.sleep(2000L);
        this.finder.setName("Load data from file");
        List showingDialogs = this.finder.findAll();
        SeahawkTestCase.assertTrue((String)("Number of file choosers with title \"Load data from file\" showing is wrong: " + showingDialogs.size() + " (should be 1)"), (showingDialogs.size() == 1 ? 1 : 0) != 0);
        JFileChooser fc = (JFileChooser)showingDialogs.get(0);
        URL testMobyURL = ((Object)((Object)this)).getClass().getClassLoader().getResource(TEST_MOBY_XML);
        SeahawkTestCase.assertNotNull((String)"Could not find the MOBY test XML document for Seahawk (ca/ucalgary/seahawk/gui/test/allDataTypes.xml)", (Object)testMobyURL);
        this.finder.setName("MCGtabbedPane");
        JTabbedPane tabbedPane = (JTabbedPane)this.finder.find((Container)this.contentGUI, 0);
        SeahawkTestCase.assertNotNull((String)"Could not find the tabbed pane for displaying documents in Seahawk (was null)", (Object)tabbedPane);
        int startingTabCount = tabbedPane.getTabCount();
        if ("file".equals(testMobyURL.getProtocol())) {
            fc.setSelectedFile(new File(testMobyURL.toURI()));
            fc.approveSelection();
        } else {
            System.err.println("Skipping file open dialog test because sample resource is not a local file (" + testMobyURL + ")");
            this.contentGUI.loadPaneFromURL(testMobyURL, true);
            fc.cancelSelection();
        }
        this.finder.setName("Load data from file");
        SeahawkTestCase.assertNull((String)"File chooser for open operation did not disappear after cancellation", (Object)this.finder.find());
        SeahawkTestCase.assertTrue((String)"New tab was not opened for loaded URL", (tabbedPane.getTabCount() == startingTabCount + 1 ? 1 : 0) != 0);
        this.contentGUI.loadPaneFromURL(new URL("file:///nonsense-should-fail-dont-worry"), false);
        SeahawkTestCase.assertTrue((String)"New tab was not opened for loaded URL", (tabbedPane.getTabCount() == startingTabCount + 1 ? 1 : 0) != 0);
        this.contentGUI.loadPaneFromURL(testMobyURL, true);
        SeahawkTestCase.assertTrue((String)"New tab was not opened for loaded URL", (tabbedPane.getTabCount() == startingTabCount + 2 ? 1 : 0) != 0);
        this.finder.setName("MCGopenPopupWebOption");
        final Component webFileItem = this.getSubComponentByName((JPopupMenu)openPopup, "MCGopenPopupWebOption");
        SeahawkTestCase.assertNotNull((String)"The document open popup menu did not contain the file open option (was null)", (Object)webFileItem);
        SeahawkTestCase.assertTrue((String)("File Option in 'Open Document' JPopupMenu was not a JMenuItem as expected (was a " + webFileItem.getClass().getName()), (boolean)(webFileItem instanceof JMenuItem));
        new Thread(){

            public void run() {
                ((JMenuItem)webFileItem).doClick();
            }
        }.start();
        DialogFinder dfinder = new DialogFinder(".*");
        showingDialogs = dfinder.findAll();
        SeahawkTestCase.assertTrue((String)("Number of dialogs with title \"Load Data From A Web Address (URL)\" showing is wrong: " + showingDialogs.size() + " (should be 1)"), (showingDialogs.size() == 1 ? 1 : 0) != 0);
        JDialog dialog = (JDialog)showingDialogs.get(0);
        SeahawkTestCase.assertTrue((String)("Dialogs title was not \"Load Data From A Web Address (URL)\", but rather : " + dialog.getTitle()), (boolean)"Load Data From A Web Address (URL)".equals(dialog.getTitle()));
        JTextField urlField = (JTextField)this.getSubComponentByClass(dialog.getContentPane(), ((Object)((Object)this)).getClass().getClassLoader().loadClass("javax.swing.JTextField"));
        SeahawkTestCase.assertNotNull((String)"The Web open dialog did not contain a JTextField as expected (was null)", (Object)urlField);
        this.getHelper().sendString((AbstractKeyEventData)new StringEventData((JFCTestCase)this, (Component)urlField, TEST_EXTERNAL_URL));
        this.getHelper().sendKeyAction(new KeyEventData((JFCTestCase)this, (Component)urlField, 10));
        SeahawkTestCase.assertNull((String)"Dialog for Web open operation did not disappear after cancellation", (Object)this.finder.find());
    }

    private Component getSubComponentByClass(Container container, Class clazz) {
        if (clazz == null) {
            return null;
        }
        Component[] subcomponents = container.getComponents();
        for (int i = 0; i < subcomponents.length; ++i) {
            Component subAnswer;
            if (subcomponents[i] != null && clazz.isInstance(subcomponents[i])) {
                return subcomponents[i];
            }
            if (!(subcomponents[i] instanceof Container) || (subAnswer = this.getSubComponentByClass((Container)subcomponents[i], clazz)) == null) continue;
            return subAnswer;
        }
        return null;
    }

    private Component getSubComponentByName(Container container, String subName) {
        if (subName == null) {
            return null;
        }
        Component[] subcomponents = container.getComponents();
        for (int i = 0; i < subcomponents.length; ++i) {
            Component subAnswer;
            String name = subcomponents[i].getName();
            if (subName.equals(name)) {
                return subcomponents[i];
            }
            if (!(subcomponents[i] instanceof Container) || (subAnswer = this.getSubComponentByName((Container)subcomponents[i], subName)) == null) continue;
            return subAnswer;
        }
        return null;
    }

    public void testExternalLinks() {
    }

    public void testCloseTab() {
    }

    public void testCloseOtherTabs() {
    }

    public String findService(String sequenceData, String targetMenuText, String targetServiceLabelText) throws Exception {
        MobyDataComposite mobyObject = MobyUtils.createMobySequence(sequenceData, "foo");
        this.contentGUI.loadPaneFromObject(new MobyContentInstance(mobyObject, "hyperlink-test"), true);
        this.sleep(2000L);
        PrintableJEditorPane pane = this.contentGUI.getCurrentPane().getDisplay();
        Point screenPos = pane.getLocationOnScreen();
        String text = pane.getDocument().getText(0, pane.getDocument().getLength());
        String dataType = mobyObject.getDataType().getName();
        int hyperlinkModelIndex = text.indexOf(dataType);
        SeahawkTestCase.assertFalse((String)("Could not find a MOBY link in the " + dataType + " representation"), (hyperlinkModelIndex == -1 ? 1 : 0) != 0);
        try {
            Rectangle linkPos = pane.modelToView(hyperlinkModelIndex + 4);
            screenPos.x += linkPos.x;
            screenPos.y += linkPos.y;
        }
        catch (BadLocationException ble) {
            System.err.println(text);
            SeahawkTestCase.fail((String)("The pattern to find a hyperlink in the document doesn't find a visible part of the HTML (retooling of test required), index found was " + hyperlinkModelIndex));
        }
        Robot robot = new Robot();
        robot.mouseMove(screenPos.x, screenPos.y + 10);
        this.sleep(2000L);
        robot.mouseMove(screenPos.x - 10, screenPos.y + 10);
        this.sleep(2000L);
        robot.mouseMove(screenPos.x + 10, screenPos.y + 10);
        this.sleep(2000L);
        robot.mousePress(16);
        robot.mouseRelease(16);
        this.sleep(2000L);
        this.finder.setName("seahawkServicePopup");
        Component openPopup = this.finder.find();
        SeahawkTestCase.assertNotNull((String)"Clicking the hyperlink did not open the service options popup (was null)", (Object)openPopup);
        SeahawkTestCase.assertTrue((String)("Component launched by clicking hyperlink was not a JPopupMenu as expected (was a " + openPopup.getClass().getName()), (boolean)(openPopup instanceof JPopupMenu));
        robot.mouseMove(screenPos.x + 10, screenPos.y + 10);
        Component serviceTypeChoices = this.getSubComponentByName((JPopupMenu)openPopup, "seahawkPopupSubMenuName");
        SeahawkTestCase.assertNotNull((String)"The service options popup (spawned by a hyperlink) did not create any service submenus", (Object)serviceTypeChoices);
        SeahawkTestCase.assertTrue((String)("Component launched by clicking hyperlink was not a JMenu as expected (was a " + serviceTypeChoices.getClass().getName()), (boolean)(serviceTypeChoices instanceof JMenu));
        while (((JMenu)serviceTypeChoices).getItemCount() == 2) {
            this.sleep(1000L);
        }
        this.sleep(500L);
        JMenuItem serviceTypeChosen = ((JMenu)serviceTypeChoices).getItem(1);
        for (int i = 2; serviceTypeChosen.getText().indexOf(targetMenuText) == -1 && i <= ((JMenu)serviceTypeChoices).getItemCount(); ++i) {
            if (i == ((JMenu)serviceTypeChoices).getItemCount()) {
                serviceTypeChosen = null;
                break;
            }
            serviceTypeChosen = ((JMenu)serviceTypeChoices).getItem(i);
        }
        SeahawkTestCase.assertNotNull((String)"Could not find Analysis services submenu required to test service execution", (Object)serviceTypeChosen);
        Point submenuPos = serviceTypeChosen.getLocationOnScreen();
        robot.mouseMove(submenuPos.x, submenuPos.y);
        this.sleep(1000L);
        serviceTypeChoices = serviceTypeChosen;
        Vector<JMenuItem> servicePathChosen = this.findMenuItem((JMenu)serviceTypeChosen, targetServiceLabelText);
        if (servicePathChosen == null || servicePathChosen.size() == 0) {
            throw new Exception("Cannot find a target service, none were found ending in '" + targetServiceLabelText + "'");
        }
        this.showMenuItem((JMenu)serviceTypeChosen, servicePathChosen, robot);
        Point serviceMenuItemLoc = servicePathChosen.lastElement().getLocationOnScreen();
        robot.mouseMove(serviceMenuItemLoc.x + 2, serviceMenuItemLoc.y + 2);
        robot.keyPress(16);
        robot.mousePress(16);
        robot.mouseRelease(16);
        robot.keyRelease(16);
        this.sleep(2000L);
        return servicePathChosen.elementAt(servicePathChosen.size() - 1).getText();
    }

    public void testRunAsynchronousService() throws Exception {
        String serviceLabel = null;
        try {
            serviceLabel = this.findService(TEST_AA_SEQ, "Bioinformatics", "(async)");
        }
        catch (Exception e) {
            e.printStackTrace();
            SeahawkTestCase.fail((String)"Error while finding a service ending with \"(async)\" (asynchronous execution) under \"Bioinformatics\" in the popup");
        }
        if (serviceLabel.indexOf("...") != 0) {
            this.fillInSecondariesAndExecute();
        }
        while (this.contentGUI.getCurrentURL() == null) {
            this.sleep(1000L);
            if (!this.contentGUI.isShowingFailure()) continue;
        }
        this.sleep(2000L);
    }

    public void testRunServiceSecondariesAndSCUFL() throws Exception {
        try {
            this.findService(TEST_DNA_SEQ, "Analysis", "...");
        }
        catch (Exception e) {
            e.printStackTrace();
            SeahawkTestCase.fail((String)"Error while a finding service ending with \"...\" (secondary input) under \"Analysis\" in the popup");
        }
        this.fillInSecondariesAndExecute();
        while (this.contentGUI.getCurrentURL() == null) {
            this.sleep(1000L);
            if (!this.contentGUI.isShowingFailure()) continue;
        }
        this.sleep(2000L);
        File testFile = File.createTempFile("test-seahawk", "");
        testFile.deleteOnExit();
        MobySaveDialog.exportSCUFL(this.contentGUI.getCurrentPane(), testFile);
        this.sleep(1000L);
        SeahawkTestCase.assertTrue((String)"The SCUFL saved data file was empty", (testFile.length() != 0L ? 1 : 0) != 0);
    }

    public void fillInSecondariesAndExecute() throws Exception {
        Robot robot = new Robot();
        Object secondaryParamsDialog = null;
        this.sleep(10000L);
        DialogFinder dfinder = new DialogFinder(".*");
        List showingDialogs = dfinder.findAll();
        for (int i = 0; i < showingDialogs.size(); ++i) {
            JDialog dialog = (JDialog)showingDialogs.get(i);
            if (!"Secondary Inputs for MOBY Service".equals(dialog.getTitle())) continue;
            secondaryParamsDialog = dialog;
            break;
        }
        SeahawkTestCase.assertNotNull((String)"Requesting a service with secondary parameters did not launch a secondary parameter input component (was null)", secondaryParamsDialog);
        SeahawkTestCase.assertTrue((String)("Secondary parameter input component was not a JDialog as expected (was a " + secondaryParamsDialog.getClass().getName()), (boolean)(secondaryParamsDialog instanceof JDialog));
        Component okButton = this.getSubComponentByName(((JDialog)secondaryParamsDialog).getContentPane(), "MSIGexecuteButton");
        SeahawkTestCase.assertNotNull((String)"Could not find the OK button in the secondary input GUI dialog", (Object)okButton);
        Point okLoc = okButton.getLocationOnScreen();
        robot.mouseMove(okLoc.x + 2, okLoc.y + 2);
        robot.mousePress(16);
        robot.mouseRelease(16);
        this.sleep(2000L);
        showingDialogs = dfinder.findAll();
        for (int i = 0; i < showingDialogs.size(); ++i) {
            JDialog dialog = (JDialog)showingDialogs.get(i);
            if (!dialog.isVisible()) continue;
            SeahawkTestCase.assertFalse((String)"The secondary parameter window did not disappear when enter was pressed (either the approval button does not have the default focus, or there is an internal problem with the dialog validation)", (boolean)"Secondary Inputs for MOBY Service".equals(dialog.getTitle()));
        }
    }

    public void testHighlightOptions() throws Exception {
        MobyDataComposite mobyObject = MobyUtils.createMobySequence(TEST_DNA_SEQ, "foo");
        this.contentGUI.loadPaneFromObject(new MobyContentInstance(mobyObject, "highlight-test"), true);
        this.sleep(1000L);
        PrintableJEditorPane pane = this.contentGUI.getCurrentPane().getDisplay();
        Point screenStartPos = pane.getLocationOnScreen();
        Point screenEndPos = pane.getLocationOnScreen();
        String text = pane.getDocument().getText(0, pane.getDocument().getLength());
        int dnaSeqModelIndex = text.indexOf(TEST_DNA_SEQ);
        SeahawkTestCase.assertFalse((String)"Could not find the actual sequence in the DNASequence representation", (dnaSeqModelIndex == -1 ? 1 : 0) != 0);
        try {
            Rectangle startPos = pane.modelToView(dnaSeqModelIndex + TEST_DNA_SEQ.length());
            screenStartPos.x += startPos.x;
            screenStartPos.y += startPos.y;
            Rectangle endPos = pane.modelToView(dnaSeqModelIndex);
            screenEndPos.x += endPos.x;
            screenEndPos.y += endPos.y;
        }
        catch (BadLocationException ble) {
            System.err.println(text);
            SeahawkTestCase.fail((String)("The pattern to find the sequence start in the document doesn't find a visible part of the HTML (retooling of test required), index found was " + dnaSeqModelIndex));
        }
        Robot robot = new Robot();
        robot.mouseMove(screenStartPos.x, screenStartPos.y);
        robot.mousePress(16);
        this.sleep(400L);
        robot.mouseMove(screenEndPos.x, screenEndPos.y);
        robot.mouseRelease(16);
        this.sleep(1000L);
        robot.mouseMove(screenEndPos.x + 2, screenEndPos.y + 2);
        robot.mousePress(16);
        robot.mouseRelease(16);
        this.sleep(3000L);
        this.finder.setName("seahawkServicePopup");
        Component servicePopup = this.finder.find();
        SeahawkTestCase.assertNotNull((String)"Clicking the highlighted region did not open the service options popup (was null)", (Object)servicePopup);
        SeahawkTestCase.assertTrue((String)("Component launched by clicking highighlighted region was not a JPopupMenu as expected (was a " + servicePopup.getClass().getName()), (boolean)(servicePopup instanceof JPopupMenu));
        robot.mouseMove(screenEndPos.x + 10, screenEndPos.y);
        this.sleep(1000L);
        Component serviceTypeChoices = this.getSubComponentByName((JPopupMenu)servicePopup, "seahawkPopupSubMenuName");
        SeahawkTestCase.assertNotNull((String)"The service options popup (spawned by a highlight selection) did not create any service submenus", (Object)serviceTypeChoices);
        SeahawkTestCase.assertTrue((String)("Component launched by clicking highlighted region was not a JMenu as expected (was a " + serviceTypeChoices.getClass().getName()), (boolean)(serviceTypeChoices instanceof JMenu));
        SeahawkTestCase.assertTrue((String)"The services popup did not have at least two submenus (should have DNASequence and String options)", (((JPopupMenu)servicePopup).getSubElements() != null && ((JPopupMenu)servicePopup).getSubElements().length > 1 ? 1 : 0) != 0);
        while (((JMenu)serviceTypeChoices).getItemCount() == 2) {
            this.sleep(1000L);
        }
        this.sleep(500L);
        Vector<JMenuItem> servicePathChosen = this.findMenuItem((JMenu)serviceTypeChoices, "ExplodeOutCrossReferences");
        if (servicePathChosen == null || servicePathChosen.size() == 0) {
            System.err.println("WARNING: Skipping test of service run, no 'ExplodeOutCrossReferences' service was found");
            return;
        }
        this.showMenuItem((JMenu)serviceTypeChoices, servicePathChosen, robot);
        servicePathChosen.lastElement().doClick(300);
        this.sleep(10000L);
        DialogFinder dfinder = new DialogFinder(".*");
        List showingDialogs = dfinder.findAll();
        for (int i = 0; i < showingDialogs.size(); ++i) {
            JDialog dialog = (JDialog)showingDialogs.get(i);
            SeahawkTestCase.assertFalse((String)"Dialogs with title \"Secondary Inputs for MOBY Service\" was found, but service launched had no secondary params", (boolean)"Secondary Inputs for MOBY Service".equals(dialog.getTitle()));
        }
        while (this.contentGUI.getCurrentURL() == null) {
            this.sleep(1000L);
            if (!this.contentGUI.isShowingFailure()) continue;
        }
        this.sleep(2000L);
    }

    public void testExternalBrowser() throws Exception {
        SeahawkTestCase.assertNotNull((String)"Could not find an external browser", (Object)BrowserLauncher.locateBrowser());
    }

    public void testMain() throws Exception {
        MobyContentGUI.setDefaultAppCloseOperation(2);
        MobyContentGUI.main(new String[0]);
    }

    public void testUserPreferences() throws Exception {
        File tempFile = File.createTempFile("test-seahawk", "");
        try {
            FileOutputStream tempFileOS = new FileOutputStream(tempFile);
            tempFileOS.write("junk".getBytes());
            tempFileOS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            SeahawkTestCase.fail((String)("Could not write to temporary file " + tempFile + ": " + e));
        }
        boolean failedAsShould = false;
        try {
            SeahawkOptions.restoreSettings(tempFile.toURI().toURL());
        }
        catch (Exception e) {
            failedAsShould = true;
        }
        SeahawkTestCase.assertTrue((String)"No exception was thrown, despite a poorly formatted preference file", (boolean)failedAsShould);
        SeahawkOptions.setCacheExpiry(10.0);
        SeahawkTestCase.assertTrue((String)("Setting the cache expiry preference did not work, expected current value of 10, but found " + SeahawkOptions.getCacheExpiry()), (SeahawkOptions.getCacheExpiry() == 10.0 ? 1 : 0) != 0);
        try {
            FileOutputStream tempFileOS = new FileOutputStream(tempFile);
            SeahawkOptions.saveSettings(tempFileOS);
            tempFileOS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            SeahawkTestCase.fail((String)("Could not save Seahawk settings to file " + tempFile + ": " + e));
        }
        SeahawkOptions.setCacheExpiry(20.0);
        try {
            SeahawkOptions.restoreSettings(tempFile.toURI().toURL());
        }
        catch (Exception e) {
            e.printStackTrace();
            SeahawkTestCase.fail((String)("Could not restore Seahawk settings from file " + tempFile + ": " + e));
        }
        SeahawkTestCase.assertTrue((String)"The settings were not saved/restored properly, expected cache expiry of 10, but got 20", (SeahawkOptions.getCacheExpiry() == 10.0 ? 1 : 0) != 0);
        tempFile.delete();
    }

    public void testWordFileConversion() throws Exception {
    }

    public void testExcelFileConversion() throws Exception {
    }

    public void testTeXFileConversion() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new SeahawkTestCase("testMain"));
        suite.addTest((Test)new SeahawkTestCase("testHelpTab"));
        suite.addTest((Test)new SeahawkTestCase("testHelpButton"));
        suite.addTest((Test)new SeahawkTestCase("testClipboardTab"));
        suite.addTest((Test)new SeahawkTestCase("testOpenButton"));
        suite.addTest((Test)new SeahawkTestCase("testSave"));
        suite.addTest((Test)new SeahawkTestCase("testPrint"));
        suite.addTest((Test)new SeahawkTestCase("testNavigationButtons"));
        suite.addTest((Test)new SeahawkTestCase("testRunAsynchronousService"));
        suite.addTest((Test)new SeahawkTestCase("testRunServiceSecondariesAndSCUFL"));
        suite.addTest((Test)new SeahawkTestCase("testHighlightOptions"));
        suite.addTest((Test)new SeahawkTestCase("testUserPreferences"));
        suite.addTest((Test)new SeahawkTestCase("testExternalBrowser"));
        suite.addTest((Test)new SeahawkTestCase("testWordFileConversion"));
        suite.addTest((Test)new SeahawkTestCase("testExcelFileConversion"));
        suite.addTest((Test)new SeahawkTestCase("testTeXFileConversion"));
        return suite;
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run((Test)SeahawkTestCase.suite());
    }

    public void showMenuItem(JMenu menu, Vector<JMenuItem> path, Robot robot) throws Exception {
        block0: for (int i = 0; i < path.size(); ++i) {
            JMenuItem pathItem = path.elementAt(i);
            for (int j = 0; j < menu.getItemCount(); ++j) {
                if (!pathItem.equals(menu.getItem(j))) continue;
                Point serviceMenuItemLoc = pathItem.getLocationOnScreen();
                robot.mouseMove(serviceMenuItemLoc.x + 2, serviceMenuItemLoc.y + 2);
                if (pathItem instanceof JMenu) {
                    menu = (JMenu)pathItem;
                } else {
                    i = path.size();
                }
                Thread.sleep(1000L);
                continue block0;
            }
        }
    }

    public Vector<JMenuItem> findMenuItem(JMenu menu, String pattern) {
        Vector<JMenuItem> result = new Vector<JMenuItem>();
        this.findMenuItem(menu, pattern, result);
        return result;
    }

    public boolean findMenuItem(JMenu menu, String pattern, Vector<JMenuItem> result) {
        JMenuItem serviceChosen = null;
        for (int i = 0; i <= menu.getItemCount(); ++i) {
            if (i == menu.getItemCount()) {
                return false;
            }
            serviceChosen = menu.getItem(i);
            if (serviceChosen.getText().indexOf(pattern) != -1 || serviceChosen instanceof JMenu && this.findMenuItem((JMenu)serviceChosen, pattern, result)) break;
        }
        result.insertElementAt(serviceChosen, 0);
        return true;
    }
}

