/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.services;

import ca.ucalgary.seahawk.services.MobyComplexBuilder;
import ca.ucalgary.seahawk.services.RegexParser;
import ca.ucalgary.seahawk.util.NamespaceContextImpl;
import ca.ucalgary.seahawk.util.SeahawkOptions;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.biomoby.client.CentralCachedCallsImpl;
import org.biomoby.client.CentralImpl;
import org.biomoby.registry.meta.Registry;
import org.biomoby.registry.meta.RegistryCache;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobyPrimaryDataSimple;
import org.biomoby.shared.MobyRelationship;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.MobyServiceType;
import org.biomoby.shared.data.MobyDataInstance;
import org.biomoby.shared.data.MobyDataObject;
import org.biomoby.shared.data.MobyDataObjectSAI;
import org.biomoby.shared.data.MobyDataObjectSet;
import org.biomoby.shared.data.MobyDataObjectSetSAI;
import org.biomoby.shared.data.MobyDataServiceAssocInstance;
import org.biomoby.shared.data.MobyServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyClient {
    public static final String DATA_MAPPING_XML_RESOURCE = "ca/ucalgary/seahawk/resources/mobyBuilderRules.xml";
    public static final String RESOURCE_SYSTEM_PROPERTY = "seahawk.rules";
    public static final String RULE_SET_TAG = "object";
    public static final String RULE_NAME_ATTR = "name";
    public static final String PREFIX_TAG = "prefix";
    public static final String PREFIX_ATTR = "value";
    public static final String ARTICLENAME_RULE_TAG = "articlename";
    public static final String NAMESPACE_RULE_TAG = "namespace";
    public static final String NAMESPACE_VALUE_TAG = "ns";
    public static final String NAMESPACE_VALUE_ATTR = "value";
    public static final String DATATYPE_RULE_TAG = "datatype";
    public static final String DATATYPE_RULE_ATTR = "value";
    public static final String MEMBER_RULE_TAG = "member";
    public static final String MEMBER_RULE_ATTR = "value";
    public static final String MEMBERS_RULE_TAG = "inheritMembers";
    public static final String MEMBERS_RULE_ATTR = "rule";
    public static final String URL_REGEX_TAG = "url_regex";
    public static final String REGEX_TAG = "regex";
    public static final String XPATH_TAG = "xpath";
    public static final String WHITESPACE_ATTR = "whitespace";
    public static final String WHITESPACE_ATTR_STRIP_VAL = "strip";
    public static final String WHITESPACE_ATTR_NORMALIZE_VAL = "normalize";
    public static final String WHITESPACE_ATTR_STRIP_FLANKING_VAL = "flanking";
    public static final String WHITESPACE_ATTR_KEEP_VAL = "keep";
    public static final String DATATYPE_ATTR = "datatype";
    public static final String ENCODING_ATTR = "encoding";
    public static final String ENCODING_ATTR_BASE64_VAL = "Base64";
    public static final String ENCODING_ATTR_NONE_VAL = "none";
    public static final String SINGLE_RETURNED_VALUE_KEY = "_no_acd_param_should_have_this_name";
    public static final String IS_ALIVE_SERVICE_URL = "http://moby.ucalgary.ca/moby/ValidateService";
    private NamespaceContextImpl nsContext;
    private CentralImpl c;
    private Map<String, String> isDeadMap;
    private Map<XPath, MobyComplexBuilder> xpathMap;
    private Map<Pattern, MobyComplexBuilder> urlRegexMap;
    private Map<Pattern, MobyComplexBuilder> regexMap;
    private Map<String, MobyComplexBuilder> builderNameMap;
    private Map<String, Pattern> patternNameMap;
    private Registry registry;
    private URL dataMappingXMLURL;
    private DocumentBuilder docBuilder;
    private static Logger logger = Logger.getLogger(MobyClient.class);
    private int serviceLevel = 0;

    public MobyClient() throws MobyException {
        this(SeahawkOptions.getRegistry() == null ? RegistryCache.getDefaultRegistry() : SeahawkOptions.getRegistry());
    }

    public MobyClient(Registry reg) throws MobyException {
        String rulesResource;
        this.registry = reg;
        this.c = reg != null && reg.getEndpoint() != null ? new CentralCachedCallsImpl(reg.getEndpoint()) : new CentralCachedCallsImpl();
        this.xpathMap = new HashMap<XPath, MobyComplexBuilder>();
        this.urlRegexMap = new HashMap<Pattern, MobyComplexBuilder>();
        this.regexMap = new HashMap<Pattern, MobyComplexBuilder>();
        this.builderNameMap = new HashMap<String, MobyComplexBuilder>();
        this.patternNameMap = new HashMap<String, Pattern>();
        this.nsContext = new NamespaceContextImpl();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            this.docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            System.err.println("Error: Could not find an XML parser, will not be able to use MOBY xpath and regex mapper default behaviors: " + pce);
        }
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if ((rulesResource = System.getProperty(RESOURCE_SYSTEM_PROPERTY)) == null) {
            this.dataMappingXMLURL = cl.getResource(DATA_MAPPING_XML_RESOURCE);
        } else {
            try {
                this.dataMappingXMLURL = new URL(rulesResource);
            }
            catch (Exception e) {
                this.dataMappingXMLURL = cl.getResource(rulesResource);
            }
        }
        if (this.dataMappingXMLURL == null) {
            System.err.println("Could not find MOBY data mapping resource '" + rulesResource + "'");
        } else {
            try {
                this.addMappingsFromURL(this.dataMappingXMLURL);
            }
            catch (Exception e) {
                System.err.println("Error loading default data mapping rules (" + this.dataMappingXMLURL + "):" + e);
                e.printStackTrace();
            }
        }
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void addMappingsFromURL(URL u) throws Exception {
        if (this.docBuilder == null) {
            System.err.println("Asked to add data mappings from file, but no XML parser is available");
            return;
        }
        Document d = this.docBuilder.parse(u.openStream());
        this.addMappingsFromDOM(d);
    }

    public void addNamespaceContext(String prefix, String nsURI) {
        this.nsContext.setPrefix(nsURI, prefix);
    }

    protected void addPrefixMapping(Element e) throws Exception {
        if (!this.isPrefixRule(e)) {
            throw new Exception("Element provided to addPrefixMapping (" + (e == null ? null : e.getLocalName()) + ") was not a prefix rule element");
        }
        String prefix = e.getAttribute("value");
        if (prefix == null) {
            throw new Exception("Element provided to addPrefixMapping did not have a value attribute as required");
        }
        if (this.nsContext.getNamespaceURI(prefix) != null) {
            System.err.println("Prefix definition for " + prefix + " already exists, ignoring new definition");
            return;
        }
        String nsURI = e.getTextContent();
        if (nsURI == null || nsURI.length() == 0) {
            System.err.println("Prefix definition for " + prefix + " has a blank URI rule, ignoring");
            return;
        }
        this.nsContext.setPrefix(nsURI, prefix);
    }

    protected void addMappingsFromDOM(Document d) throws Exception {
        Element root = d.getDocumentElement();
        NodeList ruleSets = root.getChildNodes();
        for (int i = 0; i < ruleSets.getLength(); ++i) {
            int j;
            Node node = ruleSets.item(i);
            if (node == null || !(node instanceof Element)) continue;
            Element ruleSet = (Element)node;
            if (this.isPrefixRule(ruleSet)) {
                this.addPrefixMapping(ruleSet);
                continue;
            }
            if (!RULE_SET_TAG.equals(ruleSet.getLocalName())) {
                System.err.println("Skipping unexpected top level tag " + ruleSet.getLocalName());
                continue;
            }
            String ruleName = ruleSet.getAttribute(RULE_NAME_ATTR);
            Vector<String> regexStrings = new Vector<String>();
            Vector<String> urlRegexStrings = new Vector<String>();
            Vector<String> xpathStrings = new Vector<String>();
            HashMap<String, String> namespaceMap = new HashMap<String, String>();
            HashMap<String, String[]> memberMap = new HashMap<String, String[]>();
            String dataTypeString = null;
            String articleNameString = null;
            NodeList ruleMembers = ruleSet.getChildNodes();
            for (j = 0; j < ruleMembers.getLength(); ++j) {
                Node memNode = ruleMembers.item(j);
                if (memNode == null || !(memNode instanceof Element)) continue;
                Element ruleMember = (Element)memNode;
                if (this.isRegex(ruleMember)) {
                    this.addRegexString(ruleMember, regexStrings);
                    continue;
                }
                if (this.isURLRegex(ruleMember)) {
                    this.addURLRegexString(ruleMember, urlRegexStrings);
                    continue;
                }
                if (this.isXPath(ruleMember)) {
                    this.addXPathString(ruleMember, xpathStrings);
                    continue;
                }
                if (this.isNamespaceRule(ruleMember)) {
                    this.addNamespaceMapping(ruleMember, namespaceMap);
                    continue;
                }
                if (this.isArticleNameRule(ruleMember)) {
                    if (articleNameString != null && articleNameString.length() != 0) {
                        System.err.println("Skipping unexpected article name definition node, a valid article name rule has already been created for this ruleset");
                        continue;
                    }
                    articleNameString = ruleMember.getTextContent();
                    continue;
                }
                if (this.isDataTypeRule(ruleMember)) {
                    if (dataTypeString != null && dataTypeString.length() != 0) {
                        System.err.println("Skipping unexpected datatype definition node, a valid datatype rule has already been created for this ruleset");
                        continue;
                    }
                    dataTypeString = this.getDataType(ruleMember);
                    continue;
                }
                if (this.isMemberRule(ruleMember)) {
                    this.addMemberMapping(ruleMember, memberMap, dataTypeString);
                    continue;
                }
                System.err.println("Skipping unexpected object child node " + ruleMember.getLocalName());
            }
            if (xpathStrings.size() == 0 && regexStrings.size() == 0 && urlRegexStrings.size() == 0) {
                System.err.println("Skipping namespace rule that has no xpath url_regex or regex specs associated with it");
                continue;
            }
            if (dataTypeString == null || dataTypeString.length() == 0) {
                if (memberMap.size() != 0) {
                    System.err.println("Warning: ignoring member rules, since no datatype was defined for the ruleset (base Obejct will be created)");
                }
                for (j = 0; j < xpathStrings.size(); ++j) {
                    this.addXPathMapping((String)xpathStrings.elementAt(j), namespaceMap, articleNameString);
                }
                for (j = 0; j < regexStrings.size(); ++j) {
                    this.addRegexMapping(regexStrings.elementAt(j), namespaceMap, articleNameString, ruleName);
                }
                for (j = 0; j < urlRegexStrings.size(); ++j) {
                    this.addURLRegexMapping(urlRegexStrings.elementAt(j), namespaceMap, articleNameString);
                }
                continue;
            }
            if (memberMap.size() == 0) {
                System.err.println("Complex datatype (" + dataTypeString + " was defined " + " in the ruleset, but no members were defined");
            }
            for (j = 0; j < xpathStrings.size(); ++j) {
                this.addXPathMapping((String)xpathStrings.elementAt(j), namespaceMap, dataTypeString, memberMap, articleNameString);
            }
            for (j = 0; j < regexStrings.size(); ++j) {
                this.addRegexMapping(regexStrings.elementAt(j), namespaceMap, dataTypeString, memberMap, articleNameString, ruleName);
            }
            for (j = 0; j < urlRegexStrings.size(); ++j) {
                this.addURLRegexMapping(urlRegexStrings.elementAt(j), namespaceMap, dataTypeString, memberMap, articleNameString);
            }
        }
    }

    public boolean isPrefixRule(Element e) {
        return e != null && PREFIX_TAG.equals(e.getLocalName());
    }

    public boolean isRegex(Element e) {
        return e != null && REGEX_TAG.equals(e.getLocalName());
    }

    public boolean isURLRegex(Element e) {
        return e != null && URL_REGEX_TAG.equals(e.getLocalName());
    }

    public boolean isXPath(Element e) {
        return e != null && XPATH_TAG.equals(e.getLocalName());
    }

    public boolean isDataTypeRule(Element e) {
        return e != null && "datatype".equals(e.getLocalName());
    }

    public boolean isArticleNameRule(Element e) {
        return e != null && ARTICLENAME_RULE_TAG.equals(e.getLocalName());
    }

    public boolean isMemberRule(Element e) {
        return e != null && (MEMBER_RULE_TAG.equals(e.getLocalName()) || MEMBERS_RULE_TAG.equals(e.getLocalName()));
    }

    public boolean isMembersRule(Element e) {
        return e != null && MEMBERS_RULE_TAG.equals(e.getLocalName());
    }

    public boolean isNamespaceRule(Element e) {
        return e != null && NAMESPACE_RULE_TAG.equals(e.getLocalName());
    }

    protected String getDataType(Element dtTag) throws Exception {
        if (!this.isDataTypeRule(dtTag)) {
            throw new Exception("Element provided to getDataType (" + (dtTag == null ? null : dtTag.getLocalName()) + ") was not a datatype rule element");
        }
        return dtTag.getAttribute("value");
    }

    protected String addRegexString(Element regexTag, Vector<String> regexStrings) throws Exception {
        if (!this.isRegex(regexTag)) {
            throw new Exception("Element provided to addRegexString (" + (regexTag == null ? null : regexTag.getLocalName()) + ") was not a regex rule element");
        }
        String str = regexTag.getTextContent().trim();
        if (str != null || str.length() != 0) {
            regexStrings.add(str);
        } else {
            System.err.println("Skipping blank regex rule");
        }
        return str;
    }

    protected String addURLRegexString(Element urlRegexTag, Vector<String> urlRegexStrings) throws Exception {
        if (!this.isRegex(urlRegexTag)) {
            throw new Exception("Element provided to addURLRegexString (" + (urlRegexTag == null ? null : urlRegexTag.getLocalName()) + ") was not a url_regex rule element");
        }
        String str = urlRegexTag.getTextContent().trim();
        if (str != null || str.length() != 0) {
            urlRegexStrings.add(str);
        } else {
            System.err.println("Skipping blank url_regex rule");
        }
        return str;
    }

    protected String addXPathString(Element xPathTag, Vector<String> xPathStrings) throws Exception {
        if (!this.isXPath(xPathTag)) {
            throw new Exception("Element provided to addXPathString (" + (xPathTag == null ? null : xPathTag.getLocalName()) + ") was not an XPath rule element");
        }
        String str = xPathTag.getTextContent().trim();
        if (str != null || str.length() != 0) {
            xPathStrings.add(str);
        } else {
            System.err.println("Skipping blank XPath rule");
        }
        return str;
    }

    protected void addMemberMapping(Element memTag, Map<String, String[]> membersMap, String dataTypeName) throws Exception {
        if (!this.isMemberRule(memTag)) {
            throw new Exception("Element provided to addMemberMapping (" + (memTag == null ? null : memTag.getLocalName()) + ") was not a member rule element");
        }
        String ruleValue = memTag.getTextContent();
        String memberNameKey = memTag.getAttribute("value");
        if (ruleValue == null || ruleValue.length() == 0) {
            System.err.println("Object member " + memberNameKey + " has a blank value rule");
        }
        String memberDataTypeSetting = memTag.getAttribute("datatype");
        if (this.isMembersRule(memTag)) {
            String membersRuleName = memTag.getAttribute(MEMBERS_RULE_ATTR);
            if (membersRuleName == null || membersRuleName.length() == 0) {
                throw new Exception("Attribute rule is missing from the member rule tag '" + memTag.getNodeName() + "'");
            }
            MobyComplexBuilder membersBuilder = this.builderNameMap.get(membersRuleName);
            if (membersBuilder == null) {
                throw new Exception("Attribute rule refers to a rule (" + membersRuleName + ") that does not exist");
            }
            MobyDataType dataType = MobyDataType.getDataType(dataTypeName);
            if (!dataType.inheritsFrom(membersBuilder.getDataType())) {
                throw new Exception("Data type produced by inherited rule (" + membersRuleName + ") is not a subtype of the current rule (" + dataType.getName() + ")");
            }
            if (membersMap.containsKey("_seahawk_member_inheritance")) {
                throw new Exception("More than one member inheritance tag was given, which is illegal");
            }
            String[] inheritanceRuleSpecs = new String[]{membersRuleName, ruleValue};
            membersMap.put("_seahawk_member_inheritance", inheritanceRuleSpecs);
            return;
        }
        if (memberNameKey == null || memberNameKey.length() == 0) {
            throw new Exception("Element provided to addMemberMapping did not have a non-blank value attribute as required");
        }
        String memberWhitespaceSetting = memTag.getAttribute(WHITESPACE_ATTR);
        if (memberWhitespaceSetting == null || memberWhitespaceSetting.length() == 0) {
            memberWhitespaceSetting = WHITESPACE_ATTR_KEEP_VAL;
        } else if (!(memberWhitespaceSetting.equals(WHITESPACE_ATTR_KEEP_VAL) || memberWhitespaceSetting.equals(WHITESPACE_ATTR_NORMALIZE_VAL) || memberWhitespaceSetting.equals(WHITESPACE_ATTR_STRIP_FLANKING_VAL) || memberWhitespaceSetting.equals(WHITESPACE_ATTR_STRIP_VAL))) {
            System.err.println("Object member " + memberNameKey + " has an unrecognized value for the " + WHITESPACE_ATTR + " attribute (" + memberWhitespaceSetting + "), overriding with default of " + WHITESPACE_ATTR_KEEP_VAL);
            memberWhitespaceSetting = WHITESPACE_ATTR_KEEP_VAL;
        }
        String memberEncodingSetting = memTag.getAttribute(ENCODING_ATTR);
        if (memberEncodingSetting == null || memberEncodingSetting.length() == 0) {
            memberEncodingSetting = ENCODING_ATTR_NONE_VAL;
        } else if (!memberEncodingSetting.equals(ENCODING_ATTR_NONE_VAL) && !memberEncodingSetting.equals(ENCODING_ATTR_BASE64_VAL)) {
            System.err.println("Object member " + memberNameKey + " has an unrecognized value for the " + ENCODING_ATTR + " attribute, overriding with default of " + ENCODING_ATTR_NONE_VAL);
            memberWhitespaceSetting = ENCODING_ATTR_NONE_VAL;
        }
        if (membersMap.containsKey(memberNameKey)) {
            System.err.println("Object member " + memberNameKey + " already exists, ignoring new definition");
            return;
        }
        String memberRuleName = memTag.getAttribute(MEMBERS_RULE_ATTR);
        membersMap.put(memberNameKey, new String[]{ruleValue, memberDataTypeSetting, memberWhitespaceSetting, memberEncodingSetting, memberRuleName});
    }

    protected void addNamespaceMapping(Element nsTag, Map<String, String> namespaceStrings) throws Exception {
        if (!this.isNamespaceRule(nsTag)) {
            throw new Exception("Element provided to createNamespaceMapping (" + (nsTag == null ? null : nsTag.getLocalName()) + ") was not a namespace rule element");
        }
        NodeList ruleSpecs = nsTag.getChildNodes();
        for (int i = 0; i < ruleSpecs.getLength(); ++i) {
            Node specNode = ruleSpecs.item(i);
            if (specNode == null || !(specNode instanceof Element)) continue;
            Element ruleSpec = (Element)specNode;
            String specName = ruleSpec.getLocalName();
            if (NAMESPACE_VALUE_TAG.equals(specName)) {
                String keyName = ruleSpec.getAttribute("value");
                String valueRule = ruleSpec.getTextContent();
                if (valueRule == null || valueRule.length() == 0) {
                    throw new Exception("Element ns cannot have empty children");
                }
                if (namespaceStrings.containsKey(keyName)) {
                    System.err.println("Ignoring duplicate namespace value rule for namespace '" + keyName + "'");
                    continue;
                }
                namespaceStrings.put(keyName, valueRule);
                continue;
            }
            System.err.println("Skipping unexpected namespace child node " + specName);
        }
        if (namespaceStrings.size() == 0) {
            throw new Exception("Namespace mapping rule did not have any namespaces associated with it!");
        }
    }

    public CentralImpl getMobyCentralImpl() {
        return this.c;
    }

    public MobyDataServiceAssocInstance[] getServices(Node n) throws MobyException {
        return this.getServices(this.getMobyObjects(n));
    }

    public MobyDataServiceAssocInstance[] getServices(String s) throws MobyException {
        return this.getServices(this.getMobyObjects(s));
    }

    public MobyDataServiceAssocInstance[] getServices(URL u) throws MobyException {
        return this.getServices(this.getMobyObjects(u));
    }

    public MobyDataObject[] getMobyObjects(String textData, MobyDataType targetDataType) {
        Vector<MobyDataObject> objectVector = new Vector<MobyDataObject>();
        for (Pattern pattern : this.regexMap.keySet()) {
            MobyComplexBuilder rule = this.regexMap.get(pattern);
            if (targetDataType != null && !rule.getDataType().inheritsFrom(targetDataType)) continue;
            Matcher matcher = pattern.matcher(textData);
            while (matcher.find()) {
                try {
                    MobyDataObject mobyObj = rule.apply(matcher);
                    if (mobyObj == null) continue;
                    objectVector.add(mobyObj);
                }
                catch (MobyException me) {
                    System.err.println("Could not build Moby object from match:" + me);
                    me.printStackTrace();
                }
            }
        }
        return objectVector.toArray(new MobyDataObject[objectVector.size()]);
    }

    public MobyDataInstance getMobyObject(Map<String, byte[]> resultParts, MobyPrimaryData dataTemplate) throws Exception, MobyServiceException {
        MobyDataObjectSet resultSet;
        Vector<MobyDataObject> results = new Vector<MobyDataObject>();
        for (String resultPartName : resultParts.keySet()) {
            for (MobyDataObject resultPart : this.getMobyObjects(resultParts.get(resultPartName), dataTemplate.getDataType())) {
                if (!resultPartName.equals(SINGLE_RETURNED_VALUE_KEY)) {
                    resultPart.setName(resultPartName);
                }
                results.add(resultPart);
            }
        }
        if (results.size() == 0) {
            if (dataTemplate instanceof MobyPrimaryDataSimple) {
                if (resultParts != null && resultParts.size() > 0) {
                    if (resultParts.containsKey(SINGLE_RETURNED_VALUE_KEY)) {
                        if (resultParts.get(SINGLE_RETURNED_VALUE_KEY).length != 0) {
                            throw new MobyServiceException(2, 600, null, dataTemplate.getName(), "The non-blank data provided did not match any MOBY Object rules, therefore a blank response is being returned.  Contact  the service provider to fix the MOBY Object rules.");
                        }
                    } else {
                        for (String partName : resultParts.keySet()) {
                            if (resultParts.get(partName).length == 0) continue;
                            throw new MobyServiceException(2, 600, null, dataTemplate.getName(), "The non-blank data provided (" + partName + ") did not match any MOBY Object rules, " + "therefore a blank response is being returned.  Contact " + " the service provider to fix the MOBY Object rules.");
                        }
                    }
                }
                return null;
            }
            return new MobyDataObjectSet(dataTemplate.getName());
        }
        if (results.size() > 1) {
            if (dataTemplate instanceof MobyPrimaryDataSimple) {
                System.err.println("Multiple Moby objects were found in the text data, but the request was to return a simple. Only the first value in the collection has been returned.");
                for (MobyDataObject result : results) {
                    System.err.println("Found object: " + result.getDataType().getName());
                }
                return (MobyDataInstance)results.elementAt(0);
            }
            resultSet = new MobyDataObjectSet(dataTemplate.getName());
            resultSet.addAll((Collection<? extends MobyDataObject>)results);
            return resultSet;
        }
        if (dataTemplate instanceof MobyPrimaryDataSimple) {
            return (MobyDataInstance)results.elementAt(0);
        }
        resultSet = new MobyDataObjectSet(dataTemplate.getName());
        resultSet.add((MobyDataObject)results.elementAt(0));
        return resultSet;
    }

    public MobyDataObject[] getMobyObjects(byte[] rawData, MobyDataType targetDataType) {
        if (!targetDataType.inheritsFrom(MobyDataType.getDataType("text-base64", targetDataType.getRegistry()))) {
            return this.getMobyObjects(new String(rawData), targetDataType);
        }
        String rawDataAsString = null;
        Vector<MobyDataObject> objectVector = new Vector<MobyDataObject>();
        for (Pattern pattern : this.regexMap.keySet()) {
            MobyComplexBuilder rule = this.regexMap.get(pattern);
            if (!rule.getDataType().inheritsFrom(targetDataType)) continue;
            if (rawDataAsString == null) {
                rawDataAsString = this.bytesToString(rawData);
            }
            Matcher matcher = pattern.matcher(rawDataAsString);
            while (matcher.find()) {
                try {
                    MobyDataObject mobyObj = rule.apply(matcher, rawData);
                    if (mobyObj == null) continue;
                    objectVector.add(mobyObj);
                }
                catch (MobyException me) {
                    System.err.println("Could not build Moby object from match:" + me);
                    me.printStackTrace();
                }
            }
        }
        if (objectVector.size() != 0) {
            return objectVector.toArray(new MobyDataObject[objectVector.size()]);
        }
        return new MobyDataObject[0];
    }

    private String bytesToString(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            stringBuffer.append((char)bytes[i]);
        }
        return stringBuffer.toString();
    }

    public MobyDataObject[] getMobyObjects(String textData) {
        return this.getMobyObjects(textData, (byte[])null);
    }

    public MobyDataObject[] getMobyObjects(String textData, byte[] bytes) {
        if (this.regexMap.isEmpty()) {
            System.out.println("The MOBY Client has not been provided any regex->moby data mappings!");
            return new MobyDataObject[0];
        }
        Vector<MobyDataObject> objectVector = new Vector<MobyDataObject>();
        for (Pattern pattern : this.regexMap.keySet()) {
            Matcher matcher = pattern.matcher(textData);
            while (matcher.find()) {
                MobyComplexBuilder rule = this.regexMap.get(pattern);
                try {
                    MobyDataObject mobyObj = rule.apply(matcher, bytes);
                    if (mobyObj == null) continue;
                    objectVector.add(mobyObj);
                }
                catch (MobyException me) {
                    System.err.println("Could not build Moby object from match:" + me);
                    me.printStackTrace();
                }
            }
        }
        return objectVector.toArray(new MobyDataObject[objectVector.size()]);
    }

    public MobyDataObject[] getMobyObjects(URL url) {
        return this.getMobyObjects(url, null, null);
    }

    public MobyDataObject[] getMobyObjects(URL url, String linkText) {
        return this.getMobyObjects(url, linkText, null);
    }

    public MobyDataObject[] getMobyObjects(URL url, MobyDataType targetDataType) {
        return this.getMobyObjects(url, null, targetDataType);
    }

    public MobyDataObject[] getMobyObjects(URL url, String linkText, MobyDataType targetDataType) {
        if (this.urlRegexMap.isEmpty()) {
            System.out.println("The MOBY Client has not been provided any url regex->moby data mappings!");
            return new MobyDataObject[0];
        }
        Vector<MobyDataObject> objectVector = new Vector<MobyDataObject>();
        String urlString = url.toString();
        for (Pattern pattern : this.urlRegexMap.keySet()) {
            MobyComplexBuilder rule = this.urlRegexMap.get(pattern);
            if (targetDataType != null && !rule.getDataType().inheritsFrom(targetDataType)) continue;
            Matcher matcher = pattern.matcher(urlString);
            while (matcher.find()) {
                try {
                    MobyDataObject mobyObj = rule.apply(matcher);
                    if (mobyObj == null) continue;
                    objectVector.add(mobyObj);
                }
                catch (MobyException me) {
                    System.err.println("Could not build Moby object from url regex match:" + me);
                    me.printStackTrace();
                }
            }
        }
        return objectVector.toArray(new MobyDataObject[objectVector.size()]);
    }

    public MobyDataObject[] getMobyObjects(Node n) {
        if (this.xpathMap.isEmpty()) {
            System.out.println("The MOBY Client has not been provided any xpath->moby data mappings!");
            return new MobyDataObject[0];
        }
        XPathContext xpath_context = new XPathContext();
        Node current_node = n;
        PrefixResolverDefault doc_prefix_resolver = new PrefixResolverDefault(current_node);
        Vector<MobyDataObject> objectVector = new Vector<MobyDataObject>();
        for (XPath xpath : this.xpathMap.keySet()) {
            XObject result = null;
            try {
                MobyComplexBuilder rule = this.xpathMap.get(xpath);
                result = xpath.execute(xpath_context, current_node, (PrefixResolver)doc_prefix_resolver);
                if (result instanceof XNodeSet) {
                    try {
                        NodeList node_list = ((XNodeSet)result).nodelist();
                        if (node_list == null || node_list.getLength() == 0) continue;
                        for (int i = 0; i < node_list.getLength(); ++i) {
                            MobyDataObject mobyObj = rule.applyXPath(node_list.item(i), this.nsContext);
                            if (mobyObj == null) continue;
                            objectVector.add(mobyObj);
                        }
                        continue;
                    }
                    catch (TransformerException te) {
                        System.err.println("Warning: Cannot access resulting node list due to exception in its retrieval: " + te);
                        return new MobyDataObject[0];
                    }
                }
                if (result instanceof XString) {
                    MobyDataObject mobyObj;
                    if (((XString)result).str() == null || ((XString)result).str().equals("") || (mobyObj = rule.applyXPath(result, this.nsContext)) == null) continue;
                    objectVector.add(mobyObj);
                    continue;
                }
                System.out.println("Warning: the XPath expression (" + xpath.getPatternString() + ") did not return a node set, cannot select document elements." + " The returned object was of type " + result.getClass().getName());
            }
            catch (TransformerException te) {
                logger.warn("Warning: Cannot select nodes due to exception while executing XPath statement (" + xpath.getPatternString() + "):" + te.getMessage());
                System.err.println("Warning: Cannot select nodes due to exception while executing XPath statement (" + xpath.getPatternString() + "):" + te);
                return new MobyDataObject[0];
            }
            catch (XPathExpressionException xpe) {
                System.err.println("Warning: Cannot select nodes due to exception in XPath expression:" + xpe);
                return new MobyDataObject[0];
            }
            catch (MobyException me) {
                System.err.println("Warning: Cannot create objects from select nodes due  to exception in MOBY logic:" + me);
                return new MobyDataObject[0];
            }
        }
        return objectVector.toArray(new MobyDataObject[objectVector.size()]);
    }

    public void setRequiredServiceLevel(int level) {
        this.serviceLevel = level;
    }

    public MobyDataServiceAssocInstance getServices(MobyDataObjectSet mdos) throws MobyException {
        return this.getServices(new MobyDataObjectSet[]{mdos})[0];
    }

    public MobyDataServiceAssocInstance getServices(MobyDataObject mdo) throws MobyException {
        return this.getServices(new MobyDataObject[]{mdo})[0];
    }

    public MobyDataServiceAssocInstance[] getServices(MobyDataObjectSet[] mdoss) throws MobyException {
        return this.getServices((MobyPrimaryData[])mdoss);
    }

    public MobyDataServiceAssocInstance[] getServices(MobyDataObject[] mdos) throws MobyException {
        return this.getServices((MobyPrimaryData[])mdos);
    }

    protected MobyDataServiceAssocInstance[] getServices(MobyPrimaryData[] mdos) throws MobyException {
        MobyDataServiceAssocInstance[] mobyDataServiceAssocInstances = new MobyDataServiceAssocInstance[mdos.length];
        for (int i = 0; i < mdos.length; ++i) {
            MobyService templateServices = new MobyService("");
            templateServices.addInput(mdos[i]);
            templateServices.setCategory("");
            MobyService[] mService = this.c.findService(templateServices);
            Vector<MobyService> filteredServices = new Vector<MobyService>();
            for (int j = 0; j < mService.length; ++j) {
                int serviceStatus;
                mService[j].setStatus(2, this.isServiceAlive(mService[j]));
                mService[j].setServiceType(MobyServiceType.getServiceType(mService[j].getServiceType().getName(), this.getRegistry()));
                if (this.serviceLevel == 0 || ((serviceStatus = mService[j].getStatus()) & this.serviceLevel) < this.serviceLevel) continue;
                filteredServices.add(mService[j]);
            }
            if (this.serviceLevel != 0) {
                mService = filteredServices.toArray(new MobyService[filteredServices.size()]);
            }
            if (mdos[i] instanceof MobyDataObject) {
                mobyDataServiceAssocInstances[i] = new MobyDataObjectSAI((MobyDataObject)mdos[i], mService);
                continue;
            }
            if (mdos[i] instanceof MobyDataObjectSet) {
                mobyDataServiceAssocInstances[i] = new MobyDataObjectSetSAI((MobyDataObjectSet)mdos[i], mService);
                continue;
            }
            logger.warn("MobyClient could not handle service-associating an instance of " + mdos[i].getClass());
            System.err.println("MobyClient could not handle service-associating an instance of " + mdos[i].getClass());
        }
        return mobyDataServiceAssocInstances;
    }

    public boolean isMapped(Node n) {
        return true;
    }

    public void addRegexMapping(String regexp, String[] mobyObj) {
        this.addRegexMapping(regexp, mobyObj, null);
    }

    public void addRegexMapping(String regexp, String[] mobyObj, String articleName) {
        if (mobyObj == null) {
            System.err.println("Ignoring empty namespace-only regex rule mappings");
            return;
        }
        HashMap<String, String> nsRules = new HashMap<String, String>();
        for (int i = 0; i < mobyObj.length; ++i) {
            nsRules.put(mobyObj[i], "$0");
        }
        this.addRegexMapping(regexp, nsRules, articleName, (String)null);
    }

    public void addURLRegexMapping(String url_regexp, String[] mobyObj, String articleName) {
        if (mobyObj == null) {
            System.err.println("Ignoring empty namespace-only url regex rule mappings");
            return;
        }
        HashMap<String, String> url_nsRules = new HashMap<String, String>();
        for (int i = 0; i < mobyObj.length; ++i) {
            url_nsRules.put(mobyObj[i], "$1");
        }
        this.addURLRegexMapping(url_regexp, url_nsRules, articleName);
    }

    protected String processRegExp(String regex, Map<String, String[]> membersMap) throws Exception {
        String returnValue = regex.replaceAll("\\\\N", "[acgtunxACGTUNX]").replaceAll("\\\\P", "[ARNDCQEGHILKMFPSTWYVBZXarndcqeghilkmfpstwyvbz*]");
        Pattern charClassPattern = Pattern.compile("\\\\p\\{([A-Za-z0-9]+)\\}");
        Matcher charClassMatcher = charClassPattern.matcher(returnValue);
        HashMap<Integer, String> capGroup2RuleReference = new HashMap<Integer, String>();
        while (charClassMatcher.find()) {
            String reference = charClassMatcher.group(1);
            if (RegexParser.isPosixCharacterClass(reference)) continue;
            if (!this.patternNameMap.containsKey(reference)) {
                throw new Exception("\\p{" + reference + "} in regex does not refer " + "to a known Seahawk rule, cannot build the regex");
            }
            int capGroup = RegexParser.locationToCaptureGroupNumber(regex, charClassMatcher.start(1));
            if (capGroup > 0) {
                capGroup2RuleReference.put(capGroup, reference);
            }
            returnValue = returnValue.replaceFirst("\\\\p\\{" + reference + "\\}", this.patternNameMap.get(reference).pattern().replaceAll("\\\\", "\\\\\\\\").replaceAll("\\((?!\\?)", "(?:"));
        }
        if (!capGroup2RuleReference.isEmpty()) {
            block1: for (String[] rule : membersMap.values()) {
                for (Integer capGroupNum : capGroup2RuleReference.keySet()) {
                    if (!rule[0].matches("^\\s*\\$" + capGroupNum + "\\s*$")) continue;
                    if (rule[4] != null && rule[4].length() != 0) continue block1;
                    rule[4] = (String)capGroup2RuleReference.get(capGroupNum);
                    continue block1;
                }
            }
        }
        return returnValue;
    }

    protected String processURLRegExp(String url_regex) throws MalformedURLException {
        String exampleURL = url_regex.replaceAll("\\\\d\\+?", "1");
        exampleURL = exampleURL.replaceAll("\\[.*?\\]", "foo");
        URL urlTest = new URL(exampleURL);
        String url_regex_flexible = url_regex.replaceAll("", "");
        return url_regex_flexible;
    }

    protected void addRegexMapping(String regexp, Map<String, String> nsRules, String articleName, String ruleName) {
        if (nsRules == null || nsRules.size() == 0) {
            System.err.println("Ignoring empty namespace-only regex rule mappings");
            return;
        }
        this.addRegexMapping(regexp, nsRules, null, null, articleName, null);
    }

    protected void addURLRegexMapping(String url_regexp, Map<String, String> url_nsRules, String articleName) {
        if (url_nsRules == null || url_nsRules.size() == 0) {
            System.err.println("Ignoring empty namespace-only url regex rule mappings");
            return;
        }
        this.addURLRegexMapping(url_regexp, url_nsRules, null, null, articleName);
    }

    public void addRegexMapping(String regexp, Map<String, String> nsRules, String mobyDataType, Map<String, String[]> membersMap) {
        this.addRegexMapping(regexp, nsRules, mobyDataType, membersMap, null, null);
    }

    private String handleHASMembers(String regexp, Map<String, String> nsRules, String mobyDataType, Map<String, String[]> membersMap, StringBuffer articleName) throws Exception {
        if (mobyDataType == null) {
            return regexp;
        }
        MobyDataType dataType = MobyDataType.getDataType(mobyDataType, this.getRegistry());
        if (dataType == null) {
            throw new Exception("Cannot find definition of data type " + mobyDataType + " in the ontology, therefore the rule cannot be properly parsed");
        }
        MobyRelationship[] memberRelationships = dataType.getAllChildren();
        String newRegexp = this.processRegExp(regexp, membersMap);
        HashMap<Integer, Boolean> captured = new HashMap<Integer, Boolean>();
        for (MobyRelationship memberRelationship : memberRelationships) {
            if (memberRelationship.getRelationshipType() != 3) continue;
            String[] rule = membersMap.get(memberRelationship.getName());
            if (rule == null) {
                System.err.println("Skipping HAS member " + memberRelationship.getName() + " without an explicit rule (may be defined by inheritance?)");
                continue;
            }
            Pattern pattern = Pattern.compile(newRegexp, 36);
            int groupCount = RegexParser.groupCount(pattern);
            for (int i = 0; i < groupCount; ++i) {
                int j;
                if (captured.containsKey(i)) {
                    System.err.println("Skipping processing of capture group " + i + ", it's already been processed by another member in this rule");
                    continue;
                }
                if (!rule[0].matches("^.*\\$" + i + "(?=\\D.*|\\z)")) continue;
                boolean INCL_QUANTIFIER = true;
                int[] capGroupRange = RegexParser.getCaptureGroupRange(pattern, i, INCL_QUANTIFIER);
                newRegexp = newRegexp.substring(0, capGroupRange[0]) + "(" + newRegexp.substring(capGroupRange[0], capGroupRange[1] + 1) + ")" + (capGroupRange[1] + 1 < newRegexp.length() ? newRegexp.substring(capGroupRange[1] + 1) : "");
                for (j = i; j < groupCount; ++j) {
                    for (String memberName : membersMap.keySet()) {
                        String[] memberRule = membersMap.get(memberName);
                        memberRule[0] = memberRule[0].replaceAll("\\$" + i + "(?=\\D.*|\\z)", "\\$" + (i + 1));
                    }
                    for (String nsName : nsRules.keySet()) {
                        String nsRule = nsRules.get(nsName);
                        nsRules.put(nsName, nsRule.replaceAll("\\$" + i + "(?=\\D.*|\\z)", "\\$" + (i + 1)));
                    }
                    articleName.replace(0, articleName.length(), articleName.toString().replaceAll("\\$" + i + "(?=\\D.*|\\z)", "\\$" + (i + 1)));
                }
                captured.put(i, true);
                for (j = groupCount; j >= i; --j) {
                    captured.remove(j);
                    captured.put(j + 1, true);
                }
            }
        }
        return newRegexp;
    }

    public void addRegexMapping(String regexp, Map<String, String> nsRules, String mobyDataType, Map<String, String[]> membersMap, String articleName, String ruleName) {
        try {
            StringBuffer articleNameBuffer = new StringBuffer(articleName == null ? "" : articleName);
            regexp = this.handleHASMembers(regexp, nsRules, mobyDataType, membersMap, articleNameBuffer);
            Pattern pattern = Pattern.compile(this.processRegExp(regexp, membersMap), 36);
            if (mobyDataType == null || mobyDataType.length() == 0) {
                this.regexMap.put(pattern, new MobyComplexBuilder("Object", membersMap, nsRules, this, articleNameBuffer.toString()));
            } else {
                this.regexMap.put(pattern, new MobyComplexBuilder(mobyDataType, membersMap, nsRules, this, articleNameBuffer.toString()));
            }
            if (ruleName != null && ruleName.length() != 0) {
                this.patternNameMap.put(ruleName, pattern);
                this.builderNameMap.put(ruleName, this.regexMap.get(pattern));
            }
        }
        catch (Exception e) {
            System.err.println("Could not create regular expression statement from '" + regexp + "': " + e);
            e.printStackTrace();
        }
    }

    public void addURLRegexMapping(String url_regexp, Map<String, String> url_nsRules, String mobyDataType, Map<String, String[]> membersMap, String articleName) {
        try {
            Pattern pattern = Pattern.compile(this.processURLRegExp(url_regexp));
            if (mobyDataType == null || mobyDataType.length() == 0) {
                this.urlRegexMap.put(pattern, new MobyComplexBuilder("Object", membersMap, url_nsRules, this, articleName));
                return;
            }
            this.urlRegexMap.put(pattern, new MobyComplexBuilder(mobyDataType, membersMap, url_nsRules, this, articleName));
        }
        catch (Exception e) {
            System.err.println("Could not create URL regular expression statement from '" + url_regexp + "': " + e);
            e.printStackTrace();
        }
    }

    public void addXPathMapping(String xpath, String[] mobyObj) {
        if (mobyObj == null) {
            System.err.println("Ignoring empty namespace-only regex rule mappings");
            return;
        }
        HashMap<String, String> nsRules = new HashMap<String, String>();
        for (int i = 0; i < mobyObj.length; ++i) {
            nsRules.put(mobyObj[i], ".");
        }
        this.addXPathMapping(xpath, nsRules, null);
    }

    public void addXPathMapping(String xpath_exp, Map<String, String> nsRules, String articleName) {
        this.addXPathMapping(xpath_exp, nsRules, null, null, articleName);
    }

    public void addXPathMapping(String xpath_exp, Map<String, String> nsRules, String mobyDataType, Map<String, String[]> membersMap, String articleName) {
        try {
            XPath xpath = new XPath(xpath_exp, null, this.nsContext, 0);
            if (mobyDataType == null || mobyDataType.length() == 0) {
                this.xpathMap.put(xpath, new MobyComplexBuilder("Object", membersMap, nsRules, this, articleName));
                return;
            }
            this.xpathMap.put(xpath, new MobyComplexBuilder(mobyDataType, membersMap, nsRules, this, articleName));
        }
        catch (Exception e) {
            logger.warn("Could not create XPath select statement from '" + xpath_exp + "': " + e.getMessage());
            System.err.println("Could not create XPath select statement from '" + xpath_exp + "': " + e);
        }
    }

    public void clear() {
        this.xpathMap.clear();
        this.regexMap.clear();
        new Exception().printStackTrace();
    }

    public void clearXPaths() {
        this.xpathMap.clear();
    }

    public void clearRegexs() {
        this.regexMap.clear();
        new Exception().printStackTrace();
    }

    public void clearURLRegexs() {
        this.urlRegexMap.clear();
    }

    public void deleteXPathMapping(String xpath_exp) {
        Set<XPath> keys = this.xpathMap.keySet();
        for (XPath xpath : keys) {
            if (!xpath.getPatternString().equals(xpath_exp)) continue;
            this.xpathMap.remove(xpath);
        }
    }

    public boolean canProduceDataTypeFromString(MobyDataType targetDataType) {
        for (MobyComplexBuilder rule : this.regexMap.values()) {
            if (!rule.getDataType().inheritsFrom(targetDataType)) continue;
            return true;
        }
        return false;
    }

    private boolean isServiceAlive(MobyService service) {
        if (this.isDeadMap == null) {
            this.isDeadMap = new HashMap<String, String>();
            try {
                URL u = new URL(IS_ALIVE_SERVICE_URL);
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(u.openStream()));
                String currentAuthority = null;
                String line = reader.readLine();
                while (line != null) {
                    if (line.indexOf("  ") == 0) {
                        currentAuthority = line.trim();
                    } else if (line.indexOf("\t") == 0) {
                        String[] fields = line.trim().split(",");
                        if (fields.length != 2) {
                            System.err.println("Unrecognized line (not 2 comma delimited fields) from ValidateService: " + line.trim());
                        } else if (!fields[1].equals("true")) {
                            if (fields[1].equals("false")) {
                                this.isDeadMap.put(currentAuthority + ":" + fields[0], "dead");
                            } else {
                                System.err.println("Unrecognized line (second field not 'true' or 'false') from ValidateService: " + line.trim());
                            }
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        return !this.isDeadMap.containsKey(service.getAuthority() + ":" + service.getName());
    }

    public MobyComplexBuilder getBuilder(String ruleName) {
        return this.builderNameMap.get(ruleName);
    }

    public Pattern getPattern(String ruleName) {
        return this.patternNameMap.get(ruleName);
    }
}

