/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.util;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class CombinedIcon
implements Icon {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int orientation;
    private int spacer;
    private Icon icon1;
    private Icon icon2;

    public CombinedIcon(Icon firstIcon, Icon secondIcon) {
        this(firstIcon, secondIcon, 0);
    }

    public CombinedIcon(Icon firstIcon, Icon secondIcon, int spacer) {
        this(firstIcon, secondIcon, spacer, 0);
    }

    public CombinedIcon(Icon firstIcon, Icon secondIcon, int spacerPixels, int orient) throws IllegalArgumentException {
        if (this.orientation != 0 && this.orientation != 1) {
            throw new IllegalArgumentException("Invalid orientation parameter, must be HORIZONTAL or VERTICAL");
        }
        if (firstIcon == null) {
            throw new IllegalArgumentException("The first Icon passed in was null");
        }
        if (secondIcon == null) {
            throw new IllegalArgumentException("The second Icon passed in was null");
        }
        this.icon1 = firstIcon;
        this.icon2 = secondIcon;
        this.orientation = orient;
        this.spacer = spacerPixels;
    }

    public Icon getFirstIcon() {
        return this.icon1;
    }

    public Icon getSecondIcon() {
        return this.icon2;
    }

    public int getIconHeight() {
        if (this.orientation == 1) {
            return this.icon1.getIconHeight() + this.icon2.getIconHeight() + this.spacer;
        }
        return Math.max(this.icon1.getIconHeight(), this.icon2.getIconHeight());
    }

    public int getIconWidth() {
        if (this.orientation == 1) {
            return Math.max(this.icon1.getIconWidth(), this.icon2.getIconWidth());
        }
        return this.icon1.getIconWidth() + this.icon2.getIconWidth() + this.spacer;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.orientation == 1) {
            int heightOfFirst = this.icon1.getIconHeight();
            int maxWidth = this.getIconWidth();
            this.icon1.paintIcon(c, g, x + (maxWidth - this.icon1.getIconWidth()) / 2, y);
            this.icon2.paintIcon(c, g, x + (maxWidth - this.icon2.getIconWidth()) / 2, y + heightOfFirst + this.spacer);
        } else {
            int widthOfFirst = this.icon1.getIconWidth();
            int maxHeight = this.getIconHeight();
            this.icon1.paintIcon(c, g, x, y + (maxHeight - this.icon1.getIconHeight()) / 2);
            this.icon2.paintIcon(c, g, x + widthOfFirst + this.spacer, y + (maxHeight - this.icon2.getIconHeight()) / 2);
        }
    }
}

