/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biomoby.client.MobyRequestEvent;
import org.biomoby.shared.Central;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.data.MobyContentInstance;
import org.biomoby.shared.data.MobyDataSecondaryInstance;
import org.biomoby.shared.data.MobyDataUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class DataRecorder {
    public static final int TAVERNA15 = 167;
    public static final String PI_TARGET = "seahawk";
    public static final String TEMP_FILE_PREFIX = "seahawk";
    public static final String SERVICEID_ATTR = "service";
    private static final String OUTPUT_SUFFIX = ".out.xml";
    private static final String INPUT_SUFFIX = ".in.xml";
    private Central mobyCentral;
    private Map<URL, URL> outputURL2InputURL;
    private Map<Integer, URL> requestID2InputURL;
    private DocumentBuilder docBuilder;

    public DataRecorder(Central mobyCtr) throws Exception {
        if (mobyCtr == null) {
            throw new IllegalArgumentException("Moby Central object passed to DataRecorder was null");
        }
        this.mobyCentral = mobyCtr;
        this.docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.outputURL2InputURL = new HashMap<URL, URL>();
        this.requestID2InputURL = new HashMap<Integer, URL>();
    }

    public URL saveInputData(MobyRequestEvent mre) throws Exception {
        File temp = File.createTempFile("seahawk" + mre.getID() + ":", INPUT_SUFFIX);
        temp.deleteOnExit();
        FileWriter out = new FileWriter(temp);
        out.write(mre.getContentsXML());
        out.close();
        this.requestID2InputURL.put(mre.getID(), temp.toURI().toURL());
        return temp.toURI().toURL();
    }

    public URL saveOutputData(MobyRequestEvent mre) throws Exception {
        File temp = File.createTempFile("seahawk" + mre.getID() + ":", OUTPUT_SUFFIX);
        temp.deleteOnExit();
        String contents = mre.getContentsXML().toString().replaceFirst("\\?>", "?>\n<?seahawk service=\"" + mre.getService().getLSID() + "\"?>\n");
        FileWriter out = new FileWriter(temp);
        out.write(contents);
        out.close();
        this.outputURL2InputURL.put(temp.toURI().toURL(), this.requestID2InputURL.get(mre.getID()));
        return temp.toURI().toURL();
    }

    public void exportWorkflow(URL endpointDocument, OutputStream outputStream, int format) throws Exception {
        if (format != 167) {
            throw new IllegalArgumentException("The export format for the workflow was not DataRecorder.TAVERNA15 as expected, found " + format);
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("The output stream for workflow exporting was null, aborting export");
        }
        if (endpointDocument == null) {
            throw new IllegalArgumentException("The URL endpoint to export was null, aborting workflow export");
        }
        InputStream inputStream = null;
        try {
            inputStream = endpointDocument.openStream();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IOException("Could not open workflow endpoint document provided as input to workflow exporter: " + ioe);
        }
        this.outputSCUFLHeader(outputStream);
        this.outputSCUFLFooter(outputStream);
    }

    public void exportWorkflow(URL[] documentHistory, OutputStream outputStream, int format) throws Exception {
        if (format != 167) {
            throw new IllegalArgumentException("The export format for the workflow was not DataRecorder.TAVERNA15 as expected, found " + format);
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("The output stream for workflow exporting was null, aborting export");
        }
        if (documentHistory == null) {
            throw new IllegalArgumentException("The URL endpoint to export was null, aborting workflow export");
        }
        this.outputSCUFLHeader(outputStream);
        int i = 0;
        MobyService firstService = this.getService(documentHistory[i]);
        while (firstService == null) {
            firstService = this.getService(documentHistory[++i]);
        }
        MobyPrimaryData[] inputData = firstService.getPrimaryInputs();
        if (inputData != null && inputData.length != 0) {
            outputStream.write(("  <s:processor name=\"Create_moby_data\">\n    <s:description>Generates " + inputData[0].getDataType().getDescription() + "</s:description>\n" + "    <s:biomobyobject>\n" + "      <s:mobyEndpoint>" + this.mobyCentral.getRegistryEndpoint() + "</s:mobyEndpoint>\n" + "      <s:serviceName>" + inputData[0].getDataType().getName() + "</s:serviceName>\n" + "      <s:authorityName />\n" + "    </s:biomobyobject>\n" + "  </s:processor>\n").getBytes());
            MobyNamespace[] inputNS = inputData[0].getNamespaces();
            String nsNames = "Object";
            if (inputNS != null && inputNS.length != 0) {
                String firstNS;
                nsNames = firstNS = inputNS[0].getName().replaceAll("urn:lsid:biomoby.org:namespacetype:(.*?):.*", "$1");
                for (int j = 1; j < inputNS.length; ++j) {
                    nsNames = nsNames + "_or_" + inputNS[j].getName().replaceAll("[^A-Za-z0-9_]", "_");
                }
                nsNames = nsNames.replaceAll("[^A-Za-z0-9_]", "_");
                nsNames = nsNames + "_";
                outputStream.write(("<s:processor name=\"" + nsNames + "namespace\" boring=\"true\"><s:stringconstant>" + firstNS + "</s:stringconstant></s:processor>\n").getBytes());
            } else {
                outputStream.write(("<s:source name=\"" + nsNames + "namespace\" />\n").getBytes());
            }
            outputStream.write(("<s:source name=\"" + nsNames + "id\"><s:metadata><s:mimeTypes>\n" + "  <s:mimeType>text/plain</s:mimeType>\n" + "</s:mimeTypes></s:metadata></s:source>\n").getBytes());
            outputStream.write(this.getScuflProcessor(documentHistory[i]).getBytes());
            outputStream.write(("<s:link source=\"" + nsNames + "id\" sink=\"Create_moby_data:id\" />\n" + "<s:link source=\"" + nsNames + "namespace:value\" sink=\"Create_moby_data:namespace\" />\n" + "<s:link source=\"Create_moby_data:mobydata\" sink=\"" + firstService.getName() + ":input\"/>").getBytes());
        } else {
            outputStream.write(this.getScuflProcessor(documentHistory[i]).getBytes());
        }
        while (i < documentHistory.length - 1) {
            outputStream.write(this.getScuflProcessor(documentHistory[i + 1]).getBytes());
            outputStream.write(("<s:link source=\"" + this.getService(documentHistory[i]).getName() + ":output\" sink=\"" + this.getService(documentHistory[i + 1]).getName() + ":input\" />\n").getBytes());
            ++i;
        }
        outputStream.write(("<s:link source=\"" + this.getService(documentHistory[i]).getName() + ":output\" sink=\"FinalDisplay\" />\n").getBytes());
        this.outputSCUFLFooter(outputStream);
    }

    private void outputSCUFLHeader(OutputStream output) throws Exception {
        output.write(("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<s:scufl xmlns:s=\"http://org.embl.ebi.escience/xscufl/0.1alpha\" version=\"0.2\" log=\"0\">\n  <s:workflowdescription lsid=\"urn:lsid:seahawk.ucalgary.ca:macro:" + System.currentTimeMillis() + "\" author=\"Seahawk\" title=\"Browsing Macro Saved By Seahawk User\" />\n").getBytes());
    }

    private void outputSCUFLFooter(OutputStream output) throws Exception {
        output.write("<s:sink name=\"FinalDisplay\"><s:metadata><s:mimeTypes><s:mimeType>text/xml</s:mimeType></s:mimeTypes></s:metadata></s:sink>\n</s:scufl>\n".getBytes());
    }

    public MobyDataSecondaryInstance[] getSecondaries(URL dataURL) throws Exception {
        MobyContentInstance contents;
        Iterator<String> i$;
        if (this.outputURL2InputURL.containsKey(dataURL)) {
            dataURL = this.outputURL2InputURL.get(dataURL);
        }
        if ((i$ = (contents = MobyDataUtils.fromXMLDocument(dataURL)).keySet().iterator()).hasNext()) {
            String jobKey = i$.next();
            return contents.get(jobKey).getSecondaryData();
        }
        return new MobyDataSecondaryInstance[0];
    }

    public MobyService getService(URL responseURL) throws Exception {
        Document domDoc = null;
        try {
            domDoc = this.docBuilder.parse(responseURL.openStream());
        }
        catch (SAXException saxe) {
            throw new Exception("The XML data could not be parsed (not well-formed): " + saxe);
        }
        catch (IOException ioe) {
            throw new Exception("The XML data could not be loaded (I/O problem): " + ioe);
        }
        NodeList topLevelChildren = domDoc.getChildNodes();
        String serviceLSID = null;
        for (int i = 0; i < topLevelChildren.getLength(); ++i) {
            String[] attr_val;
            ProcessingInstruction pi;
            if (!(topLevelChildren.item(i) instanceof ProcessingInstruction) || !(pi = (ProcessingInstruction)topLevelChildren.item(i)).getTarget().equals("seahawk") || (attr_val = pi.getData().split("=")).length != 2 || !attr_val[0].equals(SERVICEID_ATTR)) continue;
            serviceLSID = attr_val[1].replaceFirst("\\s*\"(.*)\"\\s*", "$1");
            break;
        }
        if (serviceLSID == null) {
            return null;
        }
        return MobyService.getService(serviceLSID);
    }

    private String getScuflProcessor(URL resultURL) throws Exception {
        MobyService service = this.getService(resultURL);
        if (service == null) {
            return "";
        }
        MobyDataSecondaryInstance[] secondaryParams = this.getSecondaries(resultURL);
        String secondaryParamsString = "";
        for (MobyDataSecondaryInstance secondaryInstance : secondaryParams) {
            secondaryParamsString = secondaryParamsString + "<s:Parameter s:name=\"" + secondaryInstance.getName() + "\">" + secondaryInstance.getValue().replaceAll("&", "&amp;").replaceAll("<", "&lt;") + "</s:Parameter>\n";
        }
        return "  <s:processor name=\"" + service.getName() + "\">\n" + "    <s:description>" + service.getDescription() + "</s:description>\n" + "    <s:biomobywsdl>\n" + "      <s:mobyEndpoint>" + this.mobyCentral.getRegistryEndpoint() + "</s:mobyEndpoint>\n" + "      <s:serviceName>" + service.getName() + "</s:serviceName>\n" + "      <s:authorityName>" + service.getAuthority() + "</s:authorityName>\n" + secondaryParamsString + "    </s:biomobywsdl>\n" + "  </s:processor>\n";
    }
}

