/*
 * Decompiled with CFR 0.152.
 */
package com.artofsolving.jodconverter.openoffice.converter;

import com.artofsolving.jodconverter.DocumentFormat;
import com.artofsolving.jodconverter.DocumentFormatRegistry;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeException;
import com.artofsolving.jodconverter.openoffice.converter.AbstractOpenOfficeDocumentConverter;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lib.uno.adapter.ByteArrayToXInputStreamAdapter;
import com.sun.star.lib.uno.adapter.OutputStreamToXOutputStreamAdapter;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class StreamOpenOfficeDocumentConverter
extends AbstractOpenOfficeDocumentConverter {
    static /* synthetic */ Class class$0;

    public StreamOpenOfficeDocumentConverter(OpenOfficeConnection connection) {
        super(connection);
    }

    public StreamOpenOfficeDocumentConverter(OpenOfficeConnection connection, DocumentFormatRegistry formatRegistry) {
        super(connection, formatRegistry);
    }

    protected void convertInternal(File inputFile, DocumentFormat inputFormat, File outputFile, DocumentFormat outputFormat) {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            try {
                inputStream = new FileInputStream(inputFile);
                outputStream = new FileOutputStream(outputFile);
                this.convert(inputStream, inputFormat, outputStream, outputFormat);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException(fileNotFoundException.getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertInternal(InputStream inputStream, DocumentFormat inputFormat, OutputStream outputStream, DocumentFormat outputFormat) {
        Map exportOptions = outputFormat.getExportOptions(inputFormat.getFamily());
        try {
            OpenOfficeConnection openOfficeConnection = this.openOfficeConnection;
            synchronized (openOfficeConnection) {
                this.loadAndExport(inputStream, inputFormat.getImportOptions(), outputStream, exportOptions);
            }
        }
        catch (OpenOfficeException openOfficeException) {
            throw openOfficeException;
        }
        catch (Throwable throwable) {
            throw new OpenOfficeException("conversion failed", throwable);
        }
    }

    private void loadAndExport(InputStream inputStream, Map importOptions, OutputStream outputStream, Map exportOptions) throws Exception {
        XComponentLoader desktop = this.openOfficeConnection.getDesktop();
        HashMap<String, ByteArrayToXInputStreamAdapter> loadProperties = new HashMap<String, ByteArrayToXInputStreamAdapter>();
        loadProperties.putAll(this.getDefaultLoadProperties());
        loadProperties.putAll(importOptions);
        loadProperties.put("InputStream", new ByteArrayToXInputStreamAdapter(IOUtils.toByteArray((InputStream)inputStream)));
        XComponent document = desktop.loadComponentFromURL("private:stream", "_blank", 0, StreamOpenOfficeDocumentConverter.toPropertyValues(loadProperties));
        if (document == null) {
            throw new OpenOfficeException("conversion failed: input document is null after loading");
        }
        this.refreshDocument(document);
        HashMap<String, OutputStreamToXOutputStreamAdapter> storeProperties = new HashMap<String, OutputStreamToXOutputStreamAdapter>();
        storeProperties.putAll(exportOptions);
        storeProperties.put("OutputStream", new OutputStreamToXOutputStreamAdapter(outputStream));
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sun.star.frame.XStorable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            XStorable storable = (XStorable)UnoRuntime.queryInterface((Class)clazz, (Object)document);
            storable.storeToURL("private:stream", StreamOpenOfficeDocumentConverter.toPropertyValues(storeProperties));
        }
        finally {
            document.dispose();
        }
    }
}

