/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.transform.Source;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMAxisIteratorBase;
import org.apache.xml.dtm.ref.DTMDefaultBaseIterators;
import org.apache.xml.dtm.ref.DTMDefaultBaseTraversers;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.XMLStringFactory;

public abstract class DTMDefaultBaseIterators
extends DTMDefaultBaseTraversers {
    public DTMDefaultBaseIterators(DTMManager mgr, Source source, int dtmIdentity, DTMWSFilter whiteSpaceFilter, XMLStringFactory xstringfactory, boolean doIndexing) {
        super(mgr, source, dtmIdentity, whiteSpaceFilter, xstringfactory, doIndexing);
    }

    public DTMDefaultBaseIterators(DTMManager mgr, Source source, int dtmIdentity, DTMWSFilter whiteSpaceFilter, XMLStringFactory xstringfactory, boolean doIndexing, int blocksize, boolean usePrevsib, boolean newNameTable) {
        super(mgr, source, dtmIdentity, whiteSpaceFilter, xstringfactory, doIndexing, blocksize, usePrevsib, newNameTable);
    }

    public DTMAxisIterator getTypedAxisIterator(int axis, int type) {
        DTMAxisIterator iterator = null;
        switch (axis) {
            case 13: {
                iterator = new TypedSingletonIterator(type);
                break;
            }
            case 3: {
                iterator = new TypedChildrenIterator(type);
                break;
            }
            case 10: {
                return new ParentIterator().setNodeType(type);
            }
            case 0: {
                return new TypedAncestorIterator(type);
            }
            case 1: {
                return new TypedAncestorIterator(type).includeSelf();
            }
            case 2: {
                return new TypedAttributeIterator(this, type);
            }
            case 4: {
                iterator = new TypedDescendantIterator(type);
                break;
            }
            case 5: {
                iterator = new TypedDescendantIterator(type).includeSelf();
                break;
            }
            case 6: {
                iterator = new TypedFollowingIterator(this, type);
                break;
            }
            case 11: {
                iterator = new TypedPrecedingIterator(this, type);
                break;
            }
            case 7: {
                iterator = new TypedFollowingSiblingIterator(this, type);
                break;
            }
            case 12: {
                iterator = new TypedPrecedingSiblingIterator(this, type);
                break;
            }
            case 9: {
                iterator = new TypedNamespaceIterator(this, type);
                break;
            }
            case 19: {
                iterator = new TypedRootIterator(this, type);
                break;
            }
            default: {
                throw new DTMException(XMLMessages.createXMLMessage("ER_TYPED_ITERATOR_AXIS_NOT_IMPLEMENTED", new Object[]{Axis.names[axis]}));
            }
        }
        return iterator;
    }

    public DTMAxisIterator getAxisIterator(int axis) {
        DTMAxisIterator iterator = null;
        switch (axis) {
            case 13: {
                iterator = new SingletonIterator();
                break;
            }
            case 3: {
                iterator = new ChildrenIterator();
                break;
            }
            case 10: {
                return new ParentIterator();
            }
            case 0: {
                return new AncestorIterator();
            }
            case 1: {
                return new AncestorIterator().includeSelf();
            }
            case 2: {
                return new AttributeIterator(this);
            }
            case 4: {
                iterator = new DescendantIterator();
                break;
            }
            case 5: {
                iterator = new DescendantIterator().includeSelf();
                break;
            }
            case 6: {
                iterator = new FollowingIterator(this);
                break;
            }
            case 11: {
                iterator = new PrecedingIterator(this);
                break;
            }
            case 7: {
                iterator = new FollowingSiblingIterator(this);
                break;
            }
            case 12: {
                iterator = new PrecedingSiblingIterator(this);
                break;
            }
            case 9: {
                iterator = new NamespaceIterator(this);
                break;
            }
            case 19: {
                iterator = new RootIterator();
                break;
            }
            default: {
                throw new DTMException(XMLMessages.createXMLMessage("ER_ITERATOR_AXIS_NOT_IMPLEMENTED", new Object[]{Axis.names[axis]}));
            }
        }
        return iterator;
    }

    public final class TypedSingletonIterator
    extends SingletonIterator {
        private final int _nodeType;

        public TypedSingletonIterator(int nodeType) {
            this._nodeType = nodeType;
        }

        public int next() {
            int result = this._currentNode;
            int nodeType = this._nodeType;
            this._currentNode = -1;
            if (nodeType >= 14 ? DTMDefaultBaseIterators.this.getExpandedTypeID(result) == nodeType : DTMDefaultBaseIterators.this.getNodeType(result) == nodeType) {
                return this.returnNode(result);
            }
            return -1;
        }
    }

    public class SingletonIterator
    extends InternalAxisIteratorBase {
        private boolean _isConstant;

        public SingletonIterator() {
            this(Integer.MIN_VALUE, false);
        }

        public SingletonIterator(int node) {
            this(node, false);
        }

        public SingletonIterator(int node, boolean constant) {
            this._currentNode = this._startNode = node;
            this._isConstant = constant;
        }

        public DTMAxisIterator setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isConstant) {
                this._currentNode = this._startNode;
                return this.resetPosition();
            }
            if (this._isRestartable) {
                if (this._currentNode == Integer.MIN_VALUE) {
                    this._currentNode = this._startNode = node;
                }
                return this.resetPosition();
            }
            return this;
        }

        public DTMAxisIterator reset() {
            if (this._isConstant) {
                this._currentNode = this._startNode;
                return this.resetPosition();
            }
            boolean temp = this._isRestartable;
            this._isRestartable = true;
            this.setStartNode(this._startNode);
            this._isRestartable = temp;
            return this;
        }

        public int next() {
            int result = this._currentNode;
            this._currentNode = -1;
            return this.returnNode(result);
        }
    }

    public final class TypedDescendantIterator
    extends DescendantIterator {
        private final int _nodeType;

        public TypedDescendantIterator(int nodeType) {
            this._nodeType = nodeType;
        }

        public int next() {
            short type;
            if (this._startNode == -1) {
                return -1;
            }
            int node = this._currentNode;
            do {
                if (-1 != (type = DTMDefaultBaseIterators.this._type(++node)) && this.isDescendant(node)) continue;
                this._currentNode = -1;
                return -1;
            } while (type != this._nodeType && DTMDefaultBaseIterators.this._exptype(node) != this._nodeType);
            this._currentNode = node;
            return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(node));
        }
    }

    public class DescendantIterator
    extends InternalAxisIteratorBase {
        public DTMAxisIterator setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                node = DTMDefaultBaseIterators.this.makeNodeIdentity(node);
                this._startNode = node--;
                if (this._includeSelf) {
                    // empty if block
                }
                this._currentNode = node;
                return this.resetPosition();
            }
            return this;
        }

        protected boolean isDescendant(int identity) {
            return DTMDefaultBaseIterators.this._parent(identity) >= this._startNode || this._startNode == identity;
        }

        public int next() {
            short type;
            if (this._startNode == -1) {
                return -1;
            }
            if (this._includeSelf && this._currentNode + 1 == this._startNode) {
                return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(++this._currentNode));
            }
            int node = this._currentNode;
            do {
                if (-1 != (type = DTMDefaultBaseIterators.this._type(++node)) && this.isDescendant(node)) continue;
                this._currentNode = -1;
                return -1;
            } while (2 == type || 3 == type || 13 == type);
            this._currentNode = node;
            return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(node));
        }

        public DTMAxisIterator reset() {
            boolean temp = this._isRestartable;
            this._isRestartable = true;
            this.setStartNode(DTMDefaultBaseIterators.this.makeNodeHandle(this._startNode));
            this._isRestartable = temp;
            return this;
        }
    }

    public final class TypedAncestorIterator
    extends AncestorIterator {
        private final int _nodeType;

        public TypedAncestorIterator(int type) {
            this._nodeType = type;
        }

        /*
         * Unable to fully structure code
         */
        public DTMAxisIterator setStartNode(int node) {
            block6: {
                block7: {
                    if (node == 0) {
                        node = DTMDefaultBaseIterators.this.getDocument();
                    }
                    this.m_realStartNode = node;
                    if (!this._isRestartable) break block6;
                    nodeID = DTMDefaultBaseIterators.this.makeNodeIdentity(node);
                    nodeType = this._nodeType;
                    if (!this._includeSelf && node != -1) {
                        nodeID = DTMDefaultBaseIterators.this._parent(nodeID);
                    }
                    this._startNode = node;
                    if (nodeType < 14) ** GOTO lbl22
                    while (nodeID != -1) {
                        eType = DTMDefaultBaseIterators.this._exptype(nodeID);
                        if (eType == nodeType) {
                            this.m_ancestors.addElement(DTMDefaultBaseIterators.this.makeNodeHandle(nodeID));
                        }
                        nodeID = DTMDefaultBaseIterators.this._parent(nodeID);
                    }
                    break block7;
lbl-1000:
                    // 1 sources

                    {
                        eType = DTMDefaultBaseIterators.this._exptype(nodeID);
                        if (eType >= 14 && DTMDefaultBaseIterators.this.m_expandedNameTable.getType(eType) == nodeType || eType < 14 && eType == nodeType) {
                            this.m_ancestors.addElement(DTMDefaultBaseIterators.this.makeNodeHandle(nodeID));
                        }
                        nodeID = DTMDefaultBaseIterators.this._parent(nodeID);
lbl22:
                        // 2 sources

                        ** while (nodeID != -1)
                    }
                }
                this.m_ancestorsPos = this.m_ancestors.size() - 1;
                this._currentNode = this.m_ancestorsPos >= 0 ? this.m_ancestors.elementAt(this.m_ancestorsPos) : -1;
                return this.resetPosition();
            }
            return this;
        }
    }

    public class AncestorIterator
    extends InternalAxisIteratorBase {
        NodeVector m_ancestors = new NodeVector();
        int m_ancestorsPos;
        int m_markedPos;
        int m_realStartNode;

        public int getStartNode() {
            return this.m_realStartNode;
        }

        public final boolean isReverse() {
            return true;
        }

        public DTMAxisIterator cloneIterator() {
            this._isRestartable = false;
            try {
                AncestorIterator clone = (AncestorIterator)super.clone();
                clone._startNode = this._startNode;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new DTMException(XMLMessages.createXMLMessage("ER_ITERATOR_CLONE_NOT_SUPPORTED", null));
            }
        }

        public DTMAxisIterator setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            this.m_realStartNode = node;
            if (this._isRestartable) {
                int nodeID = DTMDefaultBaseIterators.this.makeNodeIdentity(node);
                if (!this._includeSelf && node != -1) {
                    nodeID = DTMDefaultBaseIterators.this._parent(nodeID);
                    node = DTMDefaultBaseIterators.this.makeNodeHandle(nodeID);
                }
                this._startNode = node;
                while (nodeID != -1) {
                    this.m_ancestors.addElement(node);
                    nodeID = DTMDefaultBaseIterators.this._parent(nodeID);
                    node = DTMDefaultBaseIterators.this.makeNodeHandle(nodeID);
                }
                this.m_ancestorsPos = this.m_ancestors.size() - 1;
                this._currentNode = this.m_ancestorsPos >= 0 ? this.m_ancestors.elementAt(this.m_ancestorsPos) : -1;
                return this.resetPosition();
            }
            return this;
        }

        public DTMAxisIterator reset() {
            this.m_ancestorsPos = this.m_ancestors.size() - 1;
            this._currentNode = this.m_ancestorsPos >= 0 ? this.m_ancestors.elementAt(this.m_ancestorsPos) : -1;
            return this.resetPosition();
        }

        public int next() {
            int pos;
            int next = this._currentNode;
            this._currentNode = (pos = --this.m_ancestorsPos) >= 0 ? this.m_ancestors.elementAt(this.m_ancestorsPos) : -1;
            return this.returnNode(next);
        }

        public void setMark() {
            this.m_markedPos = this.m_ancestorsPos;
        }

        public void gotoMark() {
            this.m_ancestorsPos = this.m_markedPos;
            this._currentNode = this.m_ancestorsPos >= 0 ? this.m_ancestors.elementAt(this.m_ancestorsPos) : -1;
        }
    }

    public class RootIterator
    extends InternalAxisIteratorBase {
        public DTMAxisIterator setStartNode(int node) {
            if (this._isRestartable) {
                this._startNode = DTMDefaultBaseIterators.this.getDocumentRoot(node);
                this._currentNode = -1;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            if (this._startNode == this._currentNode) {
                return -1;
            }
            this._currentNode = this._startNode;
            return this.returnNode(this._startNode);
        }
    }

    public final class TypedChildrenIterator
    extends InternalAxisIteratorBase {
        private final int _nodeType;

        public TypedChildrenIterator(int nodeType) {
            this._nodeType = nodeType;
        }

        public DTMAxisIterator setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = node == -1 ? -1 : DTMDefaultBaseIterators.this._firstch(DTMDefaultBaseIterators.this.makeNodeIdentity(this._startNode));
                return this.resetPosition();
            }
            return this;
        }

        /*
         * Unable to fully structure code
         */
        public int next() {
            block3: {
                node = this._currentNode;
                nodeType = this._nodeType;
                if (nodeType < 14) ** GOTO lbl10
                while (node != -1 && DTMDefaultBaseIterators.this._exptype(node) != nodeType) {
                    node = DTMDefaultBaseIterators.this._nextsib(node);
                }
                break block3;
                while (!((eType = DTMDefaultBaseIterators.this._exptype(node)) < 14 ? eType == nodeType : DTMDefaultBaseIterators.this.m_expandedNameTable.getType(eType) == nodeType)) {
                    node = DTMDefaultBaseIterators.this._nextsib(node);
lbl10:
                    // 2 sources

                    if (node != -1) continue;
                }
            }
            if (node == -1) {
                this._currentNode = -1;
                return -1;
            }
            this._currentNode = DTMDefaultBaseIterators.this._nextsib(node);
            return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(node));
        }
    }

    public final class ParentIterator
    extends InternalAxisIteratorBase {
        private int _nodeType = -1;

        public DTMAxisIterator setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = DTMDefaultBaseIterators.this.getParent(node);
                return this.resetPosition();
            }
            return this;
        }

        public DTMAxisIterator setNodeType(int type) {
            this._nodeType = type;
            return this;
        }

        public int next() {
            int result = this._currentNode;
            if (this._nodeType >= 14) {
                if (this._nodeType != DTMDefaultBaseIterators.this.getExpandedTypeID(this._currentNode)) {
                    result = -1;
                }
            } else if (this._nodeType != -1 && this._nodeType != DTMDefaultBaseIterators.this.getNodeType(this._currentNode)) {
                result = -1;
            }
            this._currentNode = -1;
            return this.returnNode(result);
        }
    }

    public final class ChildrenIterator
    extends InternalAxisIteratorBase {
        public DTMAxisIterator setStartNode(int node) {
            if (node == 0) {
                node = DTMDefaultBaseIterators.this.getDocument();
            }
            if (this._isRestartable) {
                this._startNode = node;
                this._currentNode = node == -1 ? -1 : DTMDefaultBaseIterators.this._firstch(DTMDefaultBaseIterators.this.makeNodeIdentity(node));
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            if (this._currentNode != -1) {
                int node = this._currentNode;
                this._currentNode = DTMDefaultBaseIterators.this._nextsib(node);
                return this.returnNode(DTMDefaultBaseIterators.this.makeNodeHandle(node));
            }
            return -1;
        }
    }

    public abstract class InternalAxisIteratorBase
    extends DTMAxisIteratorBase {
        protected int _currentNode;

        public void setMark() {
            this._markedNode = this._currentNode;
        }

        public void gotoMark() {
            this._currentNode = this._markedNode;
        }
    }
}

