/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.client;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.data.MobyContentInstance;
import org.biomoby.shared.data.MobyDataUtils;
import org.biomoby.shared.parser.MobyPackage;
import org.biomoby.w3c.addressing.EndpointReference;
import org.omg.lsae.notifications.AnalysisEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncClient {
    public static final String USER_AGENT = "jBioMOBY_async_client/0.5";
    public static final String CONTENT_TYPE = "text/xml; charset=UTF-8";
    public static final String WS_ADDRESSING_TO_TAG_NAME = "To";
    public static final String WSRP_MULTI_PROPERTY_TAG_NAME = "GetMultipleResourceProperties";
    public static final String WSRP_PROPERTY_TAG_NAME = "ResourceProperty";
    public static final String MOBY_SERVICE_INVOC_ID_TAG_NAME = "ServiceInvocationId";
    public static final String MOBY_RESULT_PROPERTY_PREFIX = "result_";

    public static EndpointReference sendRequest(MobyService service, MobyContentInstance contents) throws Exception {
        StringWriter xmlWriter = new StringWriter();
        boolean DONT_INCL_XML_DECLARATION = false;
        MobyDataUtils.toXMLDocument(xmlWriter, contents, false);
        return AsyncClient.sendRequest(service.getURL().toString(), xmlWriter.toString(), service.getName());
    }

    public static EndpointReference sendRequest(MobyService service, String xml) throws Exception {
        return AsyncClient.sendRequest(service.getURL().toString(), xml, service.getName());
    }

    public static EndpointReference sendRequest(String serviceURL, String xml, String servicename) throws Exception {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage message = messageFactory.createMessage();
        SOAPPart soapPart = message.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        SOAPBody body = envelope.getBody();
        SOAPElement bodyElement = body.addChildElement(envelope.createName(servicename + "_submit", "mobyt", "http://biomoby.org/"));
        bodyElement.addChildElement("data").addTextNode(xml);
        message.saveChanges();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        message.writeTo(bytes);
        bytes.close();
        HttpURLConnection httpConn = (HttpURLConnection)new URL(serviceURL).openConnection();
        byte[] buf = bytes.toByteArray();
        httpConn.setRequestProperty("Content-Length", String.valueOf(buf.length));
        httpConn.setRequestProperty("Content-Type", CONTENT_TYPE);
        httpConn.setRequestProperty("User-agent", USER_AGENT);
        httpConn.setRequestProperty("SOAPAction", "http://biomoby.org/#" + servicename + "_submit");
        httpConn.setRequestMethod("POST");
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        OutputStream out = httpConn.getOutputStream();
        out.write(buf);
        out.close();
        InputStream inStream = httpConn.getResponseCode() < 400 ? httpConn.getInputStream() : httpConn.getErrorStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        String line = null;
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line + "\n");
        }
        reader.close();
        return EndpointReference.createFromXML(buffer.toString());
    }

    public static AnalysisEvent poll(EndpointReference epr, String queryId) throws Exception {
        AnalysisEvent[] events = AsyncClient.poll(epr, new String[]{queryId});
        if (events != null && events.length > 0) {
            return events[0];
        }
        return null;
    }

    public static AnalysisEvent[] poll(EndpointReference epr, Collection<String> queryIds) throws Exception {
        return AsyncClient.poll(epr, queryIds.toArray(new String[queryIds.size()]));
    }

    public static AnalysisEvent[] poll(EndpointReference epr, String[] queryIds) throws Exception {
        if (epr == null) {
            throw new NullPointerException("AsyncClient was given a null EndpointReference to poll");
        }
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage message = messageFactory.createMessage();
        SOAPPart soapPart = message.getSOAPPart();
        SOAPHeader header = message.getSOAPHeader();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        SOAPBody body = envelope.getBody();
        header.addChildElement(envelope.createName(WS_ADDRESSING_TO_TAG_NAME, "wsa", "http://schemas.xmlsoap.org/ws/2004/03/addressing")).addTextNode(epr.getAddress());
        header.addChildElement(envelope.createName(MOBY_SERVICE_INVOC_ID_TAG_NAME, "mobyt", "http://biomoby.org/")).addTextNode(epr.getServiceInvocationId());
        SOAPElement bodyElement = body.addChildElement(envelope.createName(WSRP_MULTI_PROPERTY_TAG_NAME, "wsrp", "http://docs.oasis-open.org/wsrf/rp-2"));
        for (String queryId : queryIds) {
            bodyElement.addChildElement("wsrp:ResourceProperty").addTextNode("status_" + queryId);
        }
        message.saveChanges();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        message.writeTo(bytes);
        bytes.close();
        HttpURLConnection httpConn = (HttpURLConnection)new URL(epr.getAddress()).openConnection();
        byte[] buf = bytes.toByteArray();
        httpConn.setRequestProperty("Content-Length", String.valueOf(buf.length));
        httpConn.setRequestProperty("Content-Type", CONTENT_TYPE);
        httpConn.setRequestProperty("User-agent", USER_AGENT);
        httpConn.setRequestProperty("SOAPAction", "http://docs.oasis-open.org/wsrf/rp-2#GetMultipleResourceProperties");
        httpConn.setRequestMethod("POST");
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        OutputStream out = httpConn.getOutputStream();
        out.write(buf);
        out.close();
        InputStream inStream = httpConn.getResponseCode() < 400 ? httpConn.getInputStream() : httpConn.getErrorStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        String line = null;
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line + "\n");
        }
        reader.close();
        return AnalysisEvent.createFromXML(buffer.toString());
    }

    public static void destroy(EndpointReference epr) throws Exception {
        if (epr == null) {
            return;
        }
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage message = messageFactory.createMessage();
        SOAPPart soapPart = message.getSOAPPart();
        SOAPHeader header = message.getSOAPHeader();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        SOAPBody body = envelope.getBody();
        header.addChildElement(envelope.createName(WS_ADDRESSING_TO_TAG_NAME, "wsa", "http://schemas.xmlsoap.org/ws/2004/03/addressing")).addTextNode(epr.getAddress());
        header.addChildElement(envelope.createName(MOBY_SERVICE_INVOC_ID_TAG_NAME, "mobyt", "http://biomoby.org/")).addTextNode(epr.getServiceInvocationId());
        body.addChildElement(envelope.createName("Destroy", "wsrp", "http://docs.oasis-open.org/wsrf/rp-2"));
        message.saveChanges();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        message.writeTo(bytes);
        bytes.close();
        HttpURLConnection httpConn = (HttpURLConnection)new URL(epr.getAddress()).openConnection();
        byte[] buf = bytes.toByteArray();
        httpConn.setRequestProperty("Content-Length", String.valueOf(buf.length));
        httpConn.setRequestProperty("Content-Type", CONTENT_TYPE);
        httpConn.setRequestProperty("User-agent", USER_AGENT);
        httpConn.setRequestProperty("SOAPAction", "http://docs.oasis-open.org/wsrf/rp-2#Destroy");
        httpConn.setRequestMethod("POST");
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        OutputStream out = httpConn.getOutputStream();
        out.write(buf);
        out.close();
        InputStream inStream = httpConn.getResponseCode() < 400 ? httpConn.getInputStream() : httpConn.getErrorStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        String line = null;
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line + "\n");
        }
        reader.close();
    }

    public static MobyPackage getResultPackage(EndpointReference epr, String queryId) throws Exception {
        return MobyPackage.createFromXML((Object)AsyncClient.getResultText(epr, queryId));
    }

    public static InputStream getResultStream(EndpointReference epr, String queryId) throws Exception {
        return AsyncClient.getResultStream(epr, new String[]{queryId});
    }

    public static InputStream getResultStream(EndpointReference epr, Collection<String> queryIds) throws Exception {
        return AsyncClient.getResultStream(epr, queryIds.toArray(new String[queryIds.size()]));
    }

    public static InputStream getResultStream(EndpointReference epr, String[] queryIds) throws Exception {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage message = messageFactory.createMessage();
        SOAPPart soapPart = message.getSOAPPart();
        SOAPHeader header = message.getSOAPHeader();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        SOAPBody body = envelope.getBody();
        header.addChildElement(envelope.createName(WS_ADDRESSING_TO_TAG_NAME, "wsa", "http://schemas.xmlsoap.org/ws/2004/03/addressing")).addTextNode(epr.getAddress());
        header.addChildElement(envelope.createName(MOBY_SERVICE_INVOC_ID_TAG_NAME, "mobyt", "http://biomoby.org/")).addTextNode(epr.getServiceInvocationId());
        SOAPElement bodyElement = body.addChildElement(envelope.createName(WSRP_MULTI_PROPERTY_TAG_NAME, "wsrp", "http://docs.oasis-open.org/wsrf/rp-2"));
        for (String queryId : queryIds) {
            bodyElement.addChildElement("wsrp:ResourceProperty").addTextNode(MOBY_RESULT_PROPERTY_PREFIX + queryId);
        }
        message.saveChanges();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        message.writeTo(bytes);
        bytes.close();
        HttpURLConnection httpConn = (HttpURLConnection)new URL(epr.getAddress()).openConnection();
        byte[] buf = bytes.toByteArray();
        httpConn.setRequestProperty("Content-Length", String.valueOf(buf.length));
        httpConn.setRequestProperty("Content-Type", CONTENT_TYPE);
        httpConn.setRequestProperty("User-agent", USER_AGENT);
        httpConn.setRequestProperty("SOAPAction", "http://docs.oasis-open.org/wsrf/rp-2#GetMultipleResourceProperties");
        httpConn.setRequestMethod("POST");
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        OutputStream out = httpConn.getOutputStream();
        out.write(buf);
        out.close();
        if (httpConn.getResponseCode() < 400) {
            return httpConn.getInputStream();
        }
        return httpConn.getErrorStream();
    }

    public static String getResultText(EndpointReference epr, String queryId) throws Exception {
        return AsyncClient.getResultText(epr, new String[]{queryId});
    }

    public static String getResultText(EndpointReference epr, Collection<String> queryIds) throws Exception {
        return AsyncClient.getResultText(epr, queryIds.toArray(new String[queryIds.size()]));
    }

    public static String getResultText(EndpointReference epr, String[] queryIds) throws Exception {
        InputStream inStream = AsyncClient.getResultStream(epr, queryIds);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        String line = null;
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line + "\n");
        }
        reader.close();
        return buffer.toString();
    }
}

